/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateSessionRequest;
import com.google.cloud.dataproc.v1.DeleteSessionRequest;
import com.google.cloud.dataproc.v1.GetSessionRequest;
import com.google.cloud.dataproc.v1.ListSessionsRequest;
import com.google.cloud.dataproc.v1.ListSessionsResponse;
import com.google.cloud.dataproc.v1.LocationName;
import com.google.cloud.dataproc.v1.Session;
import com.google.cloud.dataproc.v1.SessionControllerSettings;
import com.google.cloud.dataproc.v1.SessionName;
import com.google.cloud.dataproc.v1.SessionOperationMetadata;
import com.google.cloud.dataproc.v1.TerminateSessionRequest;
import com.google.cloud.dataproc.v1.stub.SessionControllerStub;
import com.google.cloud.dataproc.v1.stub.SessionControllerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SessionControllerClient
implements BackgroundResource {
    private final SessionControllerSettings settings;
    private final SessionControllerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SessionControllerClient create() throws IOException {
        return SessionControllerClient.create(SessionControllerSettings.newBuilder().build());
    }

    public static final SessionControllerClient create(SessionControllerSettings settings) throws IOException {
        return new SessionControllerClient(settings);
    }

    public static final SessionControllerClient create(SessionControllerStub stub) {
        return new SessionControllerClient(stub);
    }

    protected SessionControllerClient(SessionControllerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SessionControllerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SessionControllerClient(SessionControllerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SessionControllerSettings getSettings() {
        return this.settings;
    }

    public SessionControllerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Session, SessionOperationMetadata> createSessionAsync(LocationName parent, Session session, String sessionId) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSession(session).setSessionId(sessionId).build();
        return this.createSessionAsync(request);
    }

    public final OperationFuture<Session, SessionOperationMetadata> createSessionAsync(String parent, Session session, String sessionId) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setParent(parent).setSession(session).setSessionId(sessionId).build();
        return this.createSessionAsync(request);
    }

    public final OperationFuture<Session, SessionOperationMetadata> createSessionAsync(CreateSessionRequest request) {
        return this.createSessionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationCallable() {
        return this.stub.createSessionOperationCallable();
    }

    public final UnaryCallable<CreateSessionRequest, Operation> createSessionCallable() {
        return this.stub.createSessionCallable();
    }

    public final Session getSession(SessionName name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSession(request);
    }

    public final Session getSession(String name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name).build();
        return this.getSession(request);
    }

    public final Session getSession(GetSessionRequest request) {
        return (Session)this.getSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.stub.getSessionCallable();
    }

    public final ListSessionsPagedResponse listSessions(LocationName parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(String parent) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setParent(parent).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(ListSessionsRequest request) {
        return (ListSessionsPagedResponse)((Object)this.listSessionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.stub.listSessionsPagedCallable();
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.stub.listSessionsCallable();
    }

    public final OperationFuture<Session, SessionOperationMetadata> terminateSessionAsync(SessionName name) {
        TerminateSessionRequest request = TerminateSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.terminateSessionAsync(request);
    }

    public final OperationFuture<Session, SessionOperationMetadata> terminateSessionAsync(String name) {
        TerminateSessionRequest request = TerminateSessionRequest.newBuilder().setName(name).build();
        return this.terminateSessionAsync(request);
    }

    public final OperationFuture<Session, SessionOperationMetadata> terminateSessionAsync(TerminateSessionRequest request) {
        return this.terminateSessionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationCallable() {
        return this.stub.terminateSessionOperationCallable();
    }

    public final UnaryCallable<TerminateSessionRequest, Operation> terminateSessionCallable() {
        return this.stub.terminateSessionCallable();
    }

    public final OperationFuture<Session, SessionOperationMetadata> deleteSessionAsync(SessionName name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSessionAsync(request);
    }

    public final OperationFuture<Session, SessionOperationMetadata> deleteSessionAsync(String name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name).build();
        return this.deleteSessionAsync(request);
    }

    public final OperationFuture<Session, SessionOperationMetadata> deleteSessionAsync(DeleteSessionRequest request) {
        return this.deleteSessionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationCallable() {
        return this.stub.deleteSessionOperationCallable();
    }

    public final UnaryCallable<DeleteSessionRequest, Operation> deleteSessionCallable() {
        return this.stub.deleteSessionCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSessionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        private ListSessionsFixedSizeCollection(List<ListSessionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSessionsFixedSizeCollection createEmptyCollection() {
            return new ListSessionsFixedSizeCollection(null, 0);
        }

        protected ListSessionsFixedSizeCollection createCollection(List<ListSessionsPage> pages, int collectionSize) {
            return new ListSessionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSessionsPage
    extends AbstractPage<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage> {
        private ListSessionsPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSessionsPage createEmptyPage() {
            return new ListSessionsPage(null, null);
        }

        protected ListSessionsPage createPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            return new ListSessionsPage(context, response);
        }

        public ApiFuture<ListSessionsPage> createPageAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSessionsPagedResponse
    extends AbstractPagedListResponse<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        public static ApiFuture<ListSessionsPagedResponse> createAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            ApiFuture<ListSessionsPage> futurePage = ListSessionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSessionsPagedResponse((ListSessionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSessionsPagedResponse(ListSessionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSessionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

