/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.DirectRetryingExecutor;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.cloud.RetryHelper;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryRetryAlgorithm;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BigQueryRetryHelper
extends RetryHelper {
    private static final Logger LOG = Logger.getLogger(BigQueryRetryHelper.class.getName());

    public static <V> V runWithRetries(Callable<V> callable, RetrySettings retrySettings, ResultRetryAlgorithm<?> resultRetryAlgorithm, ApiClock clock, BigQueryRetryConfig bigQueryRetryConfig, boolean isOpenTelemetryEnabled, Tracer openTelemetryTracer) throws RetryHelper.RetryHelperException {
        Span runWithRetries = null;
        if (isOpenTelemetryEnabled && openTelemetryTracer != null) {
            runWithRetries = openTelemetryTracer.spanBuilder("com.google.cloud.bigquery.BigQueryRetryHelper.runWithRetries").startSpan();
        }
        try {
            V v;
            block14: {
                Scope runWithRetriesScope = runWithRetries != null ? runWithRetries.makeCurrent() : null;
                try {
                    ResultRetryAlgorithm<?> algorithm = resultRetryAlgorithm;
                    v = BigQueryRetryHelper.run(callable, (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(retrySettings, clock), algorithm, bigQueryRetryConfig);
                    if (runWithRetriesScope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (runWithRetriesScope != null) {
                            try {
                                runWithRetriesScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof IOException) {
                            throw new BigQueryRetryHelperException((Throwable)((Object)new BigQueryException((IOException)e.getCause())));
                        }
                        throw new BigQueryRetryHelperException(e.getCause());
                    }
                }
                runWithRetriesScope.close();
            }
            return v;
        }
        finally {
            if (runWithRetries != null) {
                runWithRetries.end();
            }
        }
    }

    private static <V> V run(Callable<V> callable, TimedRetryAlgorithm timedAlgorithm, ResultRetryAlgorithm<V> resultAlgorithm, BigQueryRetryConfig bigQueryRetryConfig) throws ExecutionException, InterruptedException {
        BigQueryRetryAlgorithm<V> retryAlgorithm = new BigQueryRetryAlgorithm<V>(resultAlgorithm, timedAlgorithm, bigQueryRetryConfig);
        DirectRetryingExecutor executor = new DirectRetryingExecutor(retryAlgorithm);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Retrying with:\n{0}\n{1}", new Object[]{"BigQuery retried method: " + callable.getClass().getEnclosingMethod().getName(), "BigQuery retry settings: " + timedAlgorithm.createFirstAttempt().getGlobalSettings()});
        }
        RetryingFuture retryingFuture = executor.createFuture(callable);
        executor.submit(retryingFuture);
        return (V)retryingFuture.get();
    }

    public static class BigQueryRetryHelperException
    extends RuntimeException {
        private static final long serialVersionUID = -8519852520090965314L;

        BigQueryRetryHelperException(Throwable cause) {
            super(cause);
        }
    }
}

