/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.AddTrialMeasurementRequest;
import com.google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateMetatdata;
import com.google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateRequest;
import com.google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateResponse;
import com.google.cloud.aiplatform.v1beta1.CompleteTrialRequest;
import com.google.cloud.aiplatform.v1beta1.CreateStudyRequest;
import com.google.cloud.aiplatform.v1beta1.CreateTrialRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteStudyRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteTrialRequest;
import com.google.cloud.aiplatform.v1beta1.GetStudyRequest;
import com.google.cloud.aiplatform.v1beta1.GetTrialRequest;
import com.google.cloud.aiplatform.v1beta1.ListOptimalTrialsRequest;
import com.google.cloud.aiplatform.v1beta1.ListOptimalTrialsResponse;
import com.google.cloud.aiplatform.v1beta1.ListStudiesRequest;
import com.google.cloud.aiplatform.v1beta1.ListStudiesResponse;
import com.google.cloud.aiplatform.v1beta1.ListTrialsRequest;
import com.google.cloud.aiplatform.v1beta1.ListTrialsResponse;
import com.google.cloud.aiplatform.v1beta1.LookupStudyRequest;
import com.google.cloud.aiplatform.v1beta1.StopTrialRequest;
import com.google.cloud.aiplatform.v1beta1.Study;
import com.google.cloud.aiplatform.v1beta1.SuggestTrialsMetadata;
import com.google.cloud.aiplatform.v1beta1.SuggestTrialsRequest;
import com.google.cloud.aiplatform.v1beta1.SuggestTrialsResponse;
import com.google.cloud.aiplatform.v1beta1.Trial;
import com.google.cloud.aiplatform.v1beta1.VizierServiceClient;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcVizierServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.VizierServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class VizierServiceStubSettings
extends StubSettings<VizierServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateStudyRequest, Study> createStudySettings;
    private final UnaryCallSettings<GetStudyRequest, Study> getStudySettings;
    private final PagedCallSettings<ListStudiesRequest, ListStudiesResponse, VizierServiceClient.ListStudiesPagedResponse> listStudiesSettings;
    private final UnaryCallSettings<DeleteStudyRequest, Empty> deleteStudySettings;
    private final UnaryCallSettings<LookupStudyRequest, Study> lookupStudySettings;
    private final UnaryCallSettings<SuggestTrialsRequest, Operation> suggestTrialsSettings;
    private final OperationCallSettings<SuggestTrialsRequest, SuggestTrialsResponse, SuggestTrialsMetadata> suggestTrialsOperationSettings;
    private final UnaryCallSettings<CreateTrialRequest, Trial> createTrialSettings;
    private final UnaryCallSettings<GetTrialRequest, Trial> getTrialSettings;
    private final PagedCallSettings<ListTrialsRequest, ListTrialsResponse, VizierServiceClient.ListTrialsPagedResponse> listTrialsSettings;
    private final UnaryCallSettings<AddTrialMeasurementRequest, Trial> addTrialMeasurementSettings;
    private final UnaryCallSettings<CompleteTrialRequest, Trial> completeTrialSettings;
    private final UnaryCallSettings<DeleteTrialRequest, Empty> deleteTrialSettings;
    private final UnaryCallSettings<CheckTrialEarlyStoppingStateRequest, Operation> checkTrialEarlyStoppingStateSettings;
    private final OperationCallSettings<CheckTrialEarlyStoppingStateRequest, CheckTrialEarlyStoppingStateResponse, CheckTrialEarlyStoppingStateMetatdata> checkTrialEarlyStoppingStateOperationSettings;
    private final UnaryCallSettings<StopTrialRequest, Trial> stopTrialSettings;
    private final UnaryCallSettings<ListOptimalTrialsRequest, ListOptimalTrialsResponse> listOptimalTrialsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, VizierServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListStudiesRequest, ListStudiesResponse, Study> LIST_STUDIES_PAGE_STR_DESC = new PagedListDescriptor<ListStudiesRequest, ListStudiesResponse, Study>(){

        public String emptyToken() {
            return "";
        }

        public ListStudiesRequest injectToken(ListStudiesRequest payload, String token) {
            return ListStudiesRequest.newBuilder((ListStudiesRequest)payload).setPageToken(token).build();
        }

        public ListStudiesRequest injectPageSize(ListStudiesRequest payload, int pageSize) {
            return ListStudiesRequest.newBuilder((ListStudiesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListStudiesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListStudiesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Study> extractResources(ListStudiesResponse payload) {
            return payload.getStudiesList();
        }
    };
    private static final PagedListDescriptor<ListTrialsRequest, ListTrialsResponse, Trial> LIST_TRIALS_PAGE_STR_DESC = new PagedListDescriptor<ListTrialsRequest, ListTrialsResponse, Trial>(){

        public String emptyToken() {
            return "";
        }

        public ListTrialsRequest injectToken(ListTrialsRequest payload, String token) {
            return ListTrialsRequest.newBuilder((ListTrialsRequest)payload).setPageToken(token).build();
        }

        public ListTrialsRequest injectPageSize(ListTrialsRequest payload, int pageSize) {
            return ListTrialsRequest.newBuilder((ListTrialsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTrialsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTrialsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Trial> extractResources(ListTrialsResponse payload) {
            return payload.getTrialsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListStudiesRequest, ListStudiesResponse, VizierServiceClient.ListStudiesPagedResponse> LIST_STUDIES_PAGE_STR_FACT = new PagedListResponseFactory<ListStudiesRequest, ListStudiesResponse, VizierServiceClient.ListStudiesPagedResponse>(){

        public ApiFuture<VizierServiceClient.ListStudiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListStudiesRequest, ListStudiesResponse> callable, ListStudiesRequest request, ApiCallContext context, ApiFuture<ListStudiesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_STUDIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VizierServiceClient.ListStudiesPagedResponse.createAsync((PageContext<ListStudiesRequest, ListStudiesResponse, Study>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTrialsRequest, ListTrialsResponse, VizierServiceClient.ListTrialsPagedResponse> LIST_TRIALS_PAGE_STR_FACT = new PagedListResponseFactory<ListTrialsRequest, ListTrialsResponse, VizierServiceClient.ListTrialsPagedResponse>(){

        public ApiFuture<VizierServiceClient.ListTrialsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTrialsRequest, ListTrialsResponse> callable, ListTrialsRequest request, ApiCallContext context, ApiFuture<ListTrialsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRIALS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VizierServiceClient.ListTrialsPagedResponse.createAsync((PageContext<ListTrialsRequest, ListTrialsResponse, Trial>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, VizierServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, VizierServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<VizierServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VizierServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateStudyRequest, Study> createStudySettings() {
        return this.createStudySettings;
    }

    public UnaryCallSettings<GetStudyRequest, Study> getStudySettings() {
        return this.getStudySettings;
    }

    public PagedCallSettings<ListStudiesRequest, ListStudiesResponse, VizierServiceClient.ListStudiesPagedResponse> listStudiesSettings() {
        return this.listStudiesSettings;
    }

    public UnaryCallSettings<DeleteStudyRequest, Empty> deleteStudySettings() {
        return this.deleteStudySettings;
    }

    public UnaryCallSettings<LookupStudyRequest, Study> lookupStudySettings() {
        return this.lookupStudySettings;
    }

    public UnaryCallSettings<SuggestTrialsRequest, Operation> suggestTrialsSettings() {
        return this.suggestTrialsSettings;
    }

    public OperationCallSettings<SuggestTrialsRequest, SuggestTrialsResponse, SuggestTrialsMetadata> suggestTrialsOperationSettings() {
        return this.suggestTrialsOperationSettings;
    }

    public UnaryCallSettings<CreateTrialRequest, Trial> createTrialSettings() {
        return this.createTrialSettings;
    }

    public UnaryCallSettings<GetTrialRequest, Trial> getTrialSettings() {
        return this.getTrialSettings;
    }

    public PagedCallSettings<ListTrialsRequest, ListTrialsResponse, VizierServiceClient.ListTrialsPagedResponse> listTrialsSettings() {
        return this.listTrialsSettings;
    }

    public UnaryCallSettings<AddTrialMeasurementRequest, Trial> addTrialMeasurementSettings() {
        return this.addTrialMeasurementSettings;
    }

    public UnaryCallSettings<CompleteTrialRequest, Trial> completeTrialSettings() {
        return this.completeTrialSettings;
    }

    public UnaryCallSettings<DeleteTrialRequest, Empty> deleteTrialSettings() {
        return this.deleteTrialSettings;
    }

    public UnaryCallSettings<CheckTrialEarlyStoppingStateRequest, Operation> checkTrialEarlyStoppingStateSettings() {
        return this.checkTrialEarlyStoppingStateSettings;
    }

    public OperationCallSettings<CheckTrialEarlyStoppingStateRequest, CheckTrialEarlyStoppingStateResponse, CheckTrialEarlyStoppingStateMetatdata> checkTrialEarlyStoppingStateOperationSettings() {
        return this.checkTrialEarlyStoppingStateOperationSettings;
    }

    public UnaryCallSettings<StopTrialRequest, Trial> stopTrialSettings() {
        return this.stopTrialSettings;
    }

    public UnaryCallSettings<ListOptimalTrialsRequest, ListOptimalTrialsResponse> listOptimalTrialsSettings() {
        return this.listOptimalTrialsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, VizierServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public VizierServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcVizierServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VizierServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VizierServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected VizierServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createStudySettings = settingsBuilder.createStudySettings().build();
        this.getStudySettings = settingsBuilder.getStudySettings().build();
        this.listStudiesSettings = settingsBuilder.listStudiesSettings().build();
        this.deleteStudySettings = settingsBuilder.deleteStudySettings().build();
        this.lookupStudySettings = settingsBuilder.lookupStudySettings().build();
        this.suggestTrialsSettings = settingsBuilder.suggestTrialsSettings().build();
        this.suggestTrialsOperationSettings = settingsBuilder.suggestTrialsOperationSettings().build();
        this.createTrialSettings = settingsBuilder.createTrialSettings().build();
        this.getTrialSettings = settingsBuilder.getTrialSettings().build();
        this.listTrialsSettings = settingsBuilder.listTrialsSettings().build();
        this.addTrialMeasurementSettings = settingsBuilder.addTrialMeasurementSettings().build();
        this.completeTrialSettings = settingsBuilder.completeTrialSettings().build();
        this.deleteTrialSettings = settingsBuilder.deleteTrialSettings().build();
        this.checkTrialEarlyStoppingStateSettings = settingsBuilder.checkTrialEarlyStoppingStateSettings().build();
        this.checkTrialEarlyStoppingStateOperationSettings = settingsBuilder.checkTrialEarlyStoppingStateOperationSettings().build();
        this.stopTrialSettings = settingsBuilder.stopTrialSettings().build();
        this.listOptimalTrialsSettings = settingsBuilder.listOptimalTrialsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<VizierServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateStudyRequest, Study> createStudySettings;
        private final UnaryCallSettings.Builder<GetStudyRequest, Study> getStudySettings;
        private final PagedCallSettings.Builder<ListStudiesRequest, ListStudiesResponse, VizierServiceClient.ListStudiesPagedResponse> listStudiesSettings;
        private final UnaryCallSettings.Builder<DeleteStudyRequest, Empty> deleteStudySettings;
        private final UnaryCallSettings.Builder<LookupStudyRequest, Study> lookupStudySettings;
        private final UnaryCallSettings.Builder<SuggestTrialsRequest, Operation> suggestTrialsSettings;
        private final OperationCallSettings.Builder<SuggestTrialsRequest, SuggestTrialsResponse, SuggestTrialsMetadata> suggestTrialsOperationSettings;
        private final UnaryCallSettings.Builder<CreateTrialRequest, Trial> createTrialSettings;
        private final UnaryCallSettings.Builder<GetTrialRequest, Trial> getTrialSettings;
        private final PagedCallSettings.Builder<ListTrialsRequest, ListTrialsResponse, VizierServiceClient.ListTrialsPagedResponse> listTrialsSettings;
        private final UnaryCallSettings.Builder<AddTrialMeasurementRequest, Trial> addTrialMeasurementSettings;
        private final UnaryCallSettings.Builder<CompleteTrialRequest, Trial> completeTrialSettings;
        private final UnaryCallSettings.Builder<DeleteTrialRequest, Empty> deleteTrialSettings;
        private final UnaryCallSettings.Builder<CheckTrialEarlyStoppingStateRequest, Operation> checkTrialEarlyStoppingStateSettings;
        private final OperationCallSettings.Builder<CheckTrialEarlyStoppingStateRequest, CheckTrialEarlyStoppingStateResponse, CheckTrialEarlyStoppingStateMetatdata> checkTrialEarlyStoppingStateOperationSettings;
        private final UnaryCallSettings.Builder<StopTrialRequest, Trial> stopTrialSettings;
        private final UnaryCallSettings.Builder<ListOptimalTrialsRequest, ListOptimalTrialsResponse> listOptimalTrialsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, VizierServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createStudySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getStudySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listStudiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_STUDIES_PAGE_STR_FACT);
            this.deleteStudySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupStudySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suggestTrialsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suggestTrialsOperationSettings = OperationCallSettings.newBuilder();
            this.createTrialSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTrialSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTrialsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRIALS_PAGE_STR_FACT);
            this.addTrialMeasurementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.completeTrialSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTrialSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.checkTrialEarlyStoppingStateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.checkTrialEarlyStoppingStateOperationSettings = OperationCallSettings.newBuilder();
            this.stopTrialSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOptimalTrialsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createStudySettings, this.getStudySettings, this.listStudiesSettings, this.deleteStudySettings, this.lookupStudySettings, this.suggestTrialsSettings, this.createTrialSettings, this.getTrialSettings, this.listTrialsSettings, this.addTrialMeasurementSettings, this.completeTrialSettings, this.deleteTrialSettings, (Object[])new UnaryCallSettings.Builder[]{this.checkTrialEarlyStoppingStateSettings, this.stopTrialSettings, this.listOptimalTrialsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(VizierServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createStudySettings = settings.createStudySettings.toBuilder();
            this.getStudySettings = settings.getStudySettings.toBuilder();
            this.listStudiesSettings = settings.listStudiesSettings.toBuilder();
            this.deleteStudySettings = settings.deleteStudySettings.toBuilder();
            this.lookupStudySettings = settings.lookupStudySettings.toBuilder();
            this.suggestTrialsSettings = settings.suggestTrialsSettings.toBuilder();
            this.suggestTrialsOperationSettings = settings.suggestTrialsOperationSettings.toBuilder();
            this.createTrialSettings = settings.createTrialSettings.toBuilder();
            this.getTrialSettings = settings.getTrialSettings.toBuilder();
            this.listTrialsSettings = settings.listTrialsSettings.toBuilder();
            this.addTrialMeasurementSettings = settings.addTrialMeasurementSettings.toBuilder();
            this.completeTrialSettings = settings.completeTrialSettings.toBuilder();
            this.deleteTrialSettings = settings.deleteTrialSettings.toBuilder();
            this.checkTrialEarlyStoppingStateSettings = settings.checkTrialEarlyStoppingStateSettings.toBuilder();
            this.checkTrialEarlyStoppingStateOperationSettings = settings.checkTrialEarlyStoppingStateOperationSettings.toBuilder();
            this.stopTrialSettings = settings.stopTrialSettings.toBuilder();
            this.listOptimalTrialsSettings = settings.listOptimalTrialsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createStudySettings, this.getStudySettings, this.listStudiesSettings, this.deleteStudySettings, this.lookupStudySettings, this.suggestTrialsSettings, this.createTrialSettings, this.getTrialSettings, this.listTrialsSettings, this.addTrialMeasurementSettings, this.completeTrialSettings, this.deleteTrialSettings, (Object[])new UnaryCallSettings.Builder[]{this.checkTrialEarlyStoppingStateSettings, this.stopTrialSettings, this.listOptimalTrialsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VizierServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VizierServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VizierServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(VizierServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createStudySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.getStudySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.listStudiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.deleteStudySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.lookupStudySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.suggestTrialsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.createTrialSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.getTrialSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.listTrialsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.addTrialMeasurementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.completeTrialSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.deleteTrialSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.checkTrialEarlyStoppingStateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.stopTrialSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.listOptimalTrialsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.suggestTrialsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SuggestTrialsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SuggestTrialsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.checkTrialEarlyStoppingStateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_11_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_11_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CheckTrialEarlyStoppingStateResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CheckTrialEarlyStoppingStateMetatdata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateStudyRequest, Study> createStudySettings() {
            return this.createStudySettings;
        }

        public UnaryCallSettings.Builder<GetStudyRequest, Study> getStudySettings() {
            return this.getStudySettings;
        }

        public PagedCallSettings.Builder<ListStudiesRequest, ListStudiesResponse, VizierServiceClient.ListStudiesPagedResponse> listStudiesSettings() {
            return this.listStudiesSettings;
        }

        public UnaryCallSettings.Builder<DeleteStudyRequest, Empty> deleteStudySettings() {
            return this.deleteStudySettings;
        }

        public UnaryCallSettings.Builder<LookupStudyRequest, Study> lookupStudySettings() {
            return this.lookupStudySettings;
        }

        public UnaryCallSettings.Builder<SuggestTrialsRequest, Operation> suggestTrialsSettings() {
            return this.suggestTrialsSettings;
        }

        public OperationCallSettings.Builder<SuggestTrialsRequest, SuggestTrialsResponse, SuggestTrialsMetadata> suggestTrialsOperationSettings() {
            return this.suggestTrialsOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateTrialRequest, Trial> createTrialSettings() {
            return this.createTrialSettings;
        }

        public UnaryCallSettings.Builder<GetTrialRequest, Trial> getTrialSettings() {
            return this.getTrialSettings;
        }

        public PagedCallSettings.Builder<ListTrialsRequest, ListTrialsResponse, VizierServiceClient.ListTrialsPagedResponse> listTrialsSettings() {
            return this.listTrialsSettings;
        }

        public UnaryCallSettings.Builder<AddTrialMeasurementRequest, Trial> addTrialMeasurementSettings() {
            return this.addTrialMeasurementSettings;
        }

        public UnaryCallSettings.Builder<CompleteTrialRequest, Trial> completeTrialSettings() {
            return this.completeTrialSettings;
        }

        public UnaryCallSettings.Builder<DeleteTrialRequest, Empty> deleteTrialSettings() {
            return this.deleteTrialSettings;
        }

        public UnaryCallSettings.Builder<CheckTrialEarlyStoppingStateRequest, Operation> checkTrialEarlyStoppingStateSettings() {
            return this.checkTrialEarlyStoppingStateSettings;
        }

        public OperationCallSettings.Builder<CheckTrialEarlyStoppingStateRequest, CheckTrialEarlyStoppingStateResponse, CheckTrialEarlyStoppingStateMetatdata> checkTrialEarlyStoppingStateOperationSettings() {
            return this.checkTrialEarlyStoppingStateOperationSettings;
        }

        public UnaryCallSettings.Builder<StopTrialRequest, Trial> stopTrialSettings() {
            return this.stopTrialSettings;
        }

        public UnaryCallSettings.Builder<ListOptimalTrialsRequest, ListOptimalTrialsResponse> listOptimalTrialsSettings() {
            return this.listOptimalTrialsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, VizierServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public VizierServiceStubSettings build() throws IOException {
            return new VizierServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_11_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(5000L)).setTotalTimeoutDuration(Duration.ofMillis(5000L)).build();
            definitions.put((Object)"no_retry_11_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

