/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.BatchImportEvaluatedAnnotationsRequest;
import com.google.cloud.aiplatform.v1beta1.BatchImportEvaluatedAnnotationsResponse;
import com.google.cloud.aiplatform.v1beta1.BatchImportModelEvaluationSlicesRequest;
import com.google.cloud.aiplatform.v1beta1.BatchImportModelEvaluationSlicesResponse;
import com.google.cloud.aiplatform.v1beta1.CopyModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CopyModelRequest;
import com.google.cloud.aiplatform.v1beta1.CopyModelResponse;
import com.google.cloud.aiplatform.v1beta1.DeleteModelRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteModelVersionRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.EvaluatedAnnotation;
import com.google.cloud.aiplatform.v1beta1.ExportModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportModelRequest;
import com.google.cloud.aiplatform.v1beta1.ExportModelResponse;
import com.google.cloud.aiplatform.v1beta1.GetModelEvaluationRequest;
import com.google.cloud.aiplatform.v1beta1.GetModelEvaluationSliceRequest;
import com.google.cloud.aiplatform.v1beta1.GetModelRequest;
import com.google.cloud.aiplatform.v1beta1.ImportModelEvaluationRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelEvaluationSlicesRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelEvaluationSlicesResponse;
import com.google.cloud.aiplatform.v1beta1.ListModelEvaluationsRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelEvaluationsResponse;
import com.google.cloud.aiplatform.v1beta1.ListModelVersionsRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelVersionsResponse;
import com.google.cloud.aiplatform.v1beta1.ListModelsRequest;
import com.google.cloud.aiplatform.v1beta1.ListModelsResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.MergeVersionAliasesRequest;
import com.google.cloud.aiplatform.v1beta1.Model;
import com.google.cloud.aiplatform.v1beta1.ModelEvaluation;
import com.google.cloud.aiplatform.v1beta1.ModelEvaluationName;
import com.google.cloud.aiplatform.v1beta1.ModelEvaluationSlice;
import com.google.cloud.aiplatform.v1beta1.ModelEvaluationSliceName;
import com.google.cloud.aiplatform.v1beta1.ModelName;
import com.google.cloud.aiplatform.v1beta1.ModelServiceSettings;
import com.google.cloud.aiplatform.v1beta1.UpdateExplanationDatasetOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateExplanationDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.UpdateExplanationDatasetResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateModelRequest;
import com.google.cloud.aiplatform.v1beta1.UploadModelOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UploadModelRequest;
import com.google.cloud.aiplatform.v1beta1.UploadModelResponse;
import com.google.cloud.aiplatform.v1beta1.stub.ModelServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ModelServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ModelServiceClient
implements BackgroundResource {
    private final ModelServiceSettings settings;
    private final ModelServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ModelServiceClient create() throws IOException {
        return ModelServiceClient.create(ModelServiceSettings.newBuilder().build());
    }

    public static final ModelServiceClient create(ModelServiceSettings settings) throws IOException {
        return new ModelServiceClient(settings);
    }

    public static final ModelServiceClient create(ModelServiceStub stub) {
        return new ModelServiceClient(stub);
    }

    protected ModelServiceClient(ModelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ModelServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ModelServiceClient(ModelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ModelServiceSettings getSettings() {
        return this.settings;
    }

    public ModelServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<UploadModelResponse, UploadModelOperationMetadata> uploadModelAsync(LocationName parent, Model model) {
        UploadModelRequest request = UploadModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).build();
        return this.uploadModelAsync(request);
    }

    public final OperationFuture<UploadModelResponse, UploadModelOperationMetadata> uploadModelAsync(String parent, Model model) {
        UploadModelRequest request = UploadModelRequest.newBuilder().setParent(parent).setModel(model).build();
        return this.uploadModelAsync(request);
    }

    public final OperationFuture<UploadModelResponse, UploadModelOperationMetadata> uploadModelAsync(UploadModelRequest request) {
        return this.uploadModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UploadModelRequest, UploadModelResponse, UploadModelOperationMetadata> uploadModelOperationCallable() {
        return this.stub.uploadModelOperationCallable();
    }

    public final UnaryCallable<UploadModelRequest, Operation> uploadModelCallable() {
        return this.stub.uploadModelCallable();
    }

    public final Model getModel(ModelName name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModel(request);
    }

    public final Model getModel(String name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name).build();
        return this.getModel(request);
    }

    public final Model getModel(GetModelRequest request) {
        return (Model)this.getModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.stub.getModelCallable();
    }

    public final ListModelsPagedResponse listModels(LocationName parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(String parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(ListModelsRequest request) {
        return (ListModelsPagedResponse)((Object)this.listModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelsRequest, ListModelsPagedResponse> listModelsPagedCallable() {
        return this.stub.listModelsPagedCallable();
    }

    public final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.stub.listModelsCallable();
    }

    public final ListModelVersionsPagedResponse listModelVersions(ModelName name) {
        ListModelVersionsRequest request = ListModelVersionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listModelVersions(request);
    }

    public final ListModelVersionsPagedResponse listModelVersions(String name) {
        ListModelVersionsRequest request = ListModelVersionsRequest.newBuilder().setName(name).build();
        return this.listModelVersions(request);
    }

    public final ListModelVersionsPagedResponse listModelVersions(ListModelVersionsRequest request) {
        return (ListModelVersionsPagedResponse)((Object)this.listModelVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelVersionsRequest, ListModelVersionsPagedResponse> listModelVersionsPagedCallable() {
        return this.stub.listModelVersionsPagedCallable();
    }

    public final UnaryCallable<ListModelVersionsRequest, ListModelVersionsResponse> listModelVersionsCallable() {
        return this.stub.listModelVersionsCallable();
    }

    public final Model updateModel(Model model, FieldMask updateMask) {
        UpdateModelRequest request = UpdateModelRequest.newBuilder().setModel(model).setUpdateMask(updateMask).build();
        return this.updateModel(request);
    }

    public final Model updateModel(UpdateModelRequest request) {
        return (Model)this.updateModelCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.stub.updateModelCallable();
    }

    public final OperationFuture<UpdateExplanationDatasetResponse, UpdateExplanationDatasetOperationMetadata> updateExplanationDatasetAsync(ModelName model) {
        UpdateExplanationDatasetRequest request = UpdateExplanationDatasetRequest.newBuilder().setModel(model == null ? null : model.toString()).build();
        return this.updateExplanationDatasetAsync(request);
    }

    public final OperationFuture<UpdateExplanationDatasetResponse, UpdateExplanationDatasetOperationMetadata> updateExplanationDatasetAsync(String model) {
        UpdateExplanationDatasetRequest request = UpdateExplanationDatasetRequest.newBuilder().setModel(model).build();
        return this.updateExplanationDatasetAsync(request);
    }

    public final OperationFuture<UpdateExplanationDatasetResponse, UpdateExplanationDatasetOperationMetadata> updateExplanationDatasetAsync(UpdateExplanationDatasetRequest request) {
        return this.updateExplanationDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateExplanationDatasetRequest, UpdateExplanationDatasetResponse, UpdateExplanationDatasetOperationMetadata> updateExplanationDatasetOperationCallable() {
        return this.stub.updateExplanationDatasetOperationCallable();
    }

    public final UnaryCallable<UpdateExplanationDatasetRequest, Operation> updateExplanationDatasetCallable() {
        return this.stub.updateExplanationDatasetCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelAsync(ModelName name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelAsync(String name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelAsync(DeleteModelRequest request) {
        return this.deleteModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelRequest, Empty, DeleteOperationMetadata> deleteModelOperationCallable() {
        return this.stub.deleteModelOperationCallable();
    }

    public final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.stub.deleteModelCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelVersionAsync(ModelName name) {
        DeleteModelVersionRequest request = DeleteModelVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelVersionAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelVersionAsync(String name) {
        DeleteModelVersionRequest request = DeleteModelVersionRequest.newBuilder().setName(name).build();
        return this.deleteModelVersionAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteModelVersionAsync(DeleteModelVersionRequest request) {
        return this.deleteModelVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelVersionRequest, Empty, DeleteOperationMetadata> deleteModelVersionOperationCallable() {
        return this.stub.deleteModelVersionOperationCallable();
    }

    public final UnaryCallable<DeleteModelVersionRequest, Operation> deleteModelVersionCallable() {
        return this.stub.deleteModelVersionCallable();
    }

    public final Model mergeVersionAliases(ModelName name, List<String> versionAliases) {
        MergeVersionAliasesRequest request = MergeVersionAliasesRequest.newBuilder().setName(name == null ? null : name.toString()).addAllVersionAliases(versionAliases).build();
        return this.mergeVersionAliases(request);
    }

    public final Model mergeVersionAliases(String name, List<String> versionAliases) {
        MergeVersionAliasesRequest request = MergeVersionAliasesRequest.newBuilder().setName(name).addAllVersionAliases(versionAliases).build();
        return this.mergeVersionAliases(request);
    }

    public final Model mergeVersionAliases(MergeVersionAliasesRequest request) {
        return (Model)this.mergeVersionAliasesCallable().call((Object)request);
    }

    public final UnaryCallable<MergeVersionAliasesRequest, Model> mergeVersionAliasesCallable() {
        return this.stub.mergeVersionAliasesCallable();
    }

    public final OperationFuture<ExportModelResponse, ExportModelOperationMetadata> exportModelAsync(ModelName name, ExportModelRequest.OutputConfig outputConfig) {
        ExportModelRequest request = ExportModelRequest.newBuilder().setName(name == null ? null : name.toString()).setOutputConfig(outputConfig).build();
        return this.exportModelAsync(request);
    }

    public final OperationFuture<ExportModelResponse, ExportModelOperationMetadata> exportModelAsync(String name, ExportModelRequest.OutputConfig outputConfig) {
        ExportModelRequest request = ExportModelRequest.newBuilder().setName(name).setOutputConfig(outputConfig).build();
        return this.exportModelAsync(request);
    }

    public final OperationFuture<ExportModelResponse, ExportModelOperationMetadata> exportModelAsync(ExportModelRequest request) {
        return this.exportModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportModelRequest, ExportModelResponse, ExportModelOperationMetadata> exportModelOperationCallable() {
        return this.stub.exportModelOperationCallable();
    }

    public final UnaryCallable<ExportModelRequest, Operation> exportModelCallable() {
        return this.stub.exportModelCallable();
    }

    public final OperationFuture<CopyModelResponse, CopyModelOperationMetadata> copyModelAsync(LocationName parent, ModelName sourceModel) {
        CopyModelRequest request = CopyModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSourceModel(sourceModel == null ? null : sourceModel.toString()).build();
        return this.copyModelAsync(request);
    }

    public final OperationFuture<CopyModelResponse, CopyModelOperationMetadata> copyModelAsync(LocationName parent, String sourceModel) {
        CopyModelRequest request = CopyModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSourceModel(sourceModel).build();
        return this.copyModelAsync(request);
    }

    public final OperationFuture<CopyModelResponse, CopyModelOperationMetadata> copyModelAsync(String parent, ModelName sourceModel) {
        CopyModelRequest request = CopyModelRequest.newBuilder().setParent(parent).setSourceModel(sourceModel == null ? null : sourceModel.toString()).build();
        return this.copyModelAsync(request);
    }

    public final OperationFuture<CopyModelResponse, CopyModelOperationMetadata> copyModelAsync(String parent, String sourceModel) {
        CopyModelRequest request = CopyModelRequest.newBuilder().setParent(parent).setSourceModel(sourceModel).build();
        return this.copyModelAsync(request);
    }

    public final OperationFuture<CopyModelResponse, CopyModelOperationMetadata> copyModelAsync(CopyModelRequest request) {
        return this.copyModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CopyModelRequest, CopyModelResponse, CopyModelOperationMetadata> copyModelOperationCallable() {
        return this.stub.copyModelOperationCallable();
    }

    public final UnaryCallable<CopyModelRequest, Operation> copyModelCallable() {
        return this.stub.copyModelCallable();
    }

    public final ModelEvaluation importModelEvaluation(ModelName parent, ModelEvaluation modelEvaluation) {
        ImportModelEvaluationRequest request = ImportModelEvaluationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModelEvaluation(modelEvaluation).build();
        return this.importModelEvaluation(request);
    }

    public final ModelEvaluation importModelEvaluation(String parent, ModelEvaluation modelEvaluation) {
        ImportModelEvaluationRequest request = ImportModelEvaluationRequest.newBuilder().setParent(parent).setModelEvaluation(modelEvaluation).build();
        return this.importModelEvaluation(request);
    }

    public final ModelEvaluation importModelEvaluation(ImportModelEvaluationRequest request) {
        return (ModelEvaluation)this.importModelEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<ImportModelEvaluationRequest, ModelEvaluation> importModelEvaluationCallable() {
        return this.stub.importModelEvaluationCallable();
    }

    public final BatchImportModelEvaluationSlicesResponse batchImportModelEvaluationSlices(ModelEvaluationName parent, List<ModelEvaluationSlice> modelEvaluationSlices) {
        BatchImportModelEvaluationSlicesRequest request = BatchImportModelEvaluationSlicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllModelEvaluationSlices(modelEvaluationSlices).build();
        return this.batchImportModelEvaluationSlices(request);
    }

    public final BatchImportModelEvaluationSlicesResponse batchImportModelEvaluationSlices(String parent, List<ModelEvaluationSlice> modelEvaluationSlices) {
        BatchImportModelEvaluationSlicesRequest request = BatchImportModelEvaluationSlicesRequest.newBuilder().setParent(parent).addAllModelEvaluationSlices(modelEvaluationSlices).build();
        return this.batchImportModelEvaluationSlices(request);
    }

    public final BatchImportModelEvaluationSlicesResponse batchImportModelEvaluationSlices(BatchImportModelEvaluationSlicesRequest request) {
        return (BatchImportModelEvaluationSlicesResponse)this.batchImportModelEvaluationSlicesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchImportModelEvaluationSlicesRequest, BatchImportModelEvaluationSlicesResponse> batchImportModelEvaluationSlicesCallable() {
        return this.stub.batchImportModelEvaluationSlicesCallable();
    }

    public final BatchImportEvaluatedAnnotationsResponse batchImportEvaluatedAnnotations(ModelEvaluationSliceName parent, List<EvaluatedAnnotation> evaluatedAnnotations) {
        BatchImportEvaluatedAnnotationsRequest request = BatchImportEvaluatedAnnotationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllEvaluatedAnnotations(evaluatedAnnotations).build();
        return this.batchImportEvaluatedAnnotations(request);
    }

    public final BatchImportEvaluatedAnnotationsResponse batchImportEvaluatedAnnotations(String parent, List<EvaluatedAnnotation> evaluatedAnnotations) {
        BatchImportEvaluatedAnnotationsRequest request = BatchImportEvaluatedAnnotationsRequest.newBuilder().setParent(parent).addAllEvaluatedAnnotations(evaluatedAnnotations).build();
        return this.batchImportEvaluatedAnnotations(request);
    }

    public final BatchImportEvaluatedAnnotationsResponse batchImportEvaluatedAnnotations(BatchImportEvaluatedAnnotationsRequest request) {
        return (BatchImportEvaluatedAnnotationsResponse)this.batchImportEvaluatedAnnotationsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchImportEvaluatedAnnotationsRequest, BatchImportEvaluatedAnnotationsResponse> batchImportEvaluatedAnnotationsCallable() {
        return this.stub.batchImportEvaluatedAnnotationsCallable();
    }

    public final ModelEvaluation getModelEvaluation(ModelEvaluationName name) {
        GetModelEvaluationRequest request = GetModelEvaluationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelEvaluation(request);
    }

    public final ModelEvaluation getModelEvaluation(String name) {
        GetModelEvaluationRequest request = GetModelEvaluationRequest.newBuilder().setName(name).build();
        return this.getModelEvaluation(request);
    }

    public final ModelEvaluation getModelEvaluation(GetModelEvaluationRequest request) {
        return (ModelEvaluation)this.getModelEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelEvaluationRequest, ModelEvaluation> getModelEvaluationCallable() {
        return this.stub.getModelEvaluationCallable();
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(ModelName parent) {
        ListModelEvaluationsRequest request = ListModelEvaluationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModelEvaluations(request);
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(String parent) {
        ListModelEvaluationsRequest request = ListModelEvaluationsRequest.newBuilder().setParent(parent).build();
        return this.listModelEvaluations(request);
    }

    public final ListModelEvaluationsPagedResponse listModelEvaluations(ListModelEvaluationsRequest request) {
        return (ListModelEvaluationsPagedResponse)((Object)this.listModelEvaluationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsPagedResponse> listModelEvaluationsPagedCallable() {
        return this.stub.listModelEvaluationsPagedCallable();
    }

    public final UnaryCallable<ListModelEvaluationsRequest, ListModelEvaluationsResponse> listModelEvaluationsCallable() {
        return this.stub.listModelEvaluationsCallable();
    }

    public final ModelEvaluationSlice getModelEvaluationSlice(ModelEvaluationSliceName name) {
        GetModelEvaluationSliceRequest request = GetModelEvaluationSliceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModelEvaluationSlice(request);
    }

    public final ModelEvaluationSlice getModelEvaluationSlice(String name) {
        GetModelEvaluationSliceRequest request = GetModelEvaluationSliceRequest.newBuilder().setName(name).build();
        return this.getModelEvaluationSlice(request);
    }

    public final ModelEvaluationSlice getModelEvaluationSlice(GetModelEvaluationSliceRequest request) {
        return (ModelEvaluationSlice)this.getModelEvaluationSliceCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelEvaluationSliceRequest, ModelEvaluationSlice> getModelEvaluationSliceCallable() {
        return this.stub.getModelEvaluationSliceCallable();
    }

    public final ListModelEvaluationSlicesPagedResponse listModelEvaluationSlices(ModelEvaluationName parent) {
        ListModelEvaluationSlicesRequest request = ListModelEvaluationSlicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModelEvaluationSlices(request);
    }

    public final ListModelEvaluationSlicesPagedResponse listModelEvaluationSlices(String parent) {
        ListModelEvaluationSlicesRequest request = ListModelEvaluationSlicesRequest.newBuilder().setParent(parent).build();
        return this.listModelEvaluationSlices(request);
    }

    public final ListModelEvaluationSlicesPagedResponse listModelEvaluationSlices(ListModelEvaluationSlicesRequest request) {
        return (ListModelEvaluationSlicesPagedResponse)((Object)this.listModelEvaluationSlicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesPagedResponse> listModelEvaluationSlicesPagedCallable() {
        return this.stub.listModelEvaluationSlicesPagedCallable();
    }

    public final UnaryCallable<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse> listModelEvaluationSlicesCallable() {
        return this.stub.listModelEvaluationSlicesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelEvaluationSlicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice, ListModelEvaluationSlicesPage, ListModelEvaluationSlicesFixedSizeCollection> {
        private ListModelEvaluationSlicesFixedSizeCollection(List<ListModelEvaluationSlicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelEvaluationSlicesFixedSizeCollection createEmptyCollection() {
            return new ListModelEvaluationSlicesFixedSizeCollection(null, 0);
        }

        protected ListModelEvaluationSlicesFixedSizeCollection createCollection(List<ListModelEvaluationSlicesPage> pages, int collectionSize) {
            return new ListModelEvaluationSlicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelEvaluationSlicesPage
    extends AbstractPage<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice, ListModelEvaluationSlicesPage> {
        private ListModelEvaluationSlicesPage(PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> context, ListModelEvaluationSlicesResponse response) {
            super(context, (Object)response);
        }

        private static ListModelEvaluationSlicesPage createEmptyPage() {
            return new ListModelEvaluationSlicesPage(null, null);
        }

        protected ListModelEvaluationSlicesPage createPage(PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> context, ListModelEvaluationSlicesResponse response) {
            return new ListModelEvaluationSlicesPage(context, response);
        }

        public ApiFuture<ListModelEvaluationSlicesPage> createPageAsync(PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> context, ApiFuture<ListModelEvaluationSlicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelEvaluationSlicesPagedResponse
    extends AbstractPagedListResponse<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice, ListModelEvaluationSlicesPage, ListModelEvaluationSlicesFixedSizeCollection> {
        public static ApiFuture<ListModelEvaluationSlicesPagedResponse> createAsync(PageContext<ListModelEvaluationSlicesRequest, ListModelEvaluationSlicesResponse, ModelEvaluationSlice> context, ApiFuture<ListModelEvaluationSlicesResponse> futureResponse) {
            ApiFuture<ListModelEvaluationSlicesPage> futurePage = ListModelEvaluationSlicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelEvaluationSlicesPagedResponse((ListModelEvaluationSlicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelEvaluationSlicesPagedResponse(ListModelEvaluationSlicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelEvaluationSlicesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelEvaluationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage, ListModelEvaluationsFixedSizeCollection> {
        private ListModelEvaluationsFixedSizeCollection(List<ListModelEvaluationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelEvaluationsFixedSizeCollection createEmptyCollection() {
            return new ListModelEvaluationsFixedSizeCollection(null, 0);
        }

        protected ListModelEvaluationsFixedSizeCollection createCollection(List<ListModelEvaluationsPage> pages, int collectionSize) {
            return new ListModelEvaluationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelEvaluationsPage
    extends AbstractPage<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage> {
        private ListModelEvaluationsPage(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ListModelEvaluationsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelEvaluationsPage createEmptyPage() {
            return new ListModelEvaluationsPage(null, null);
        }

        protected ListModelEvaluationsPage createPage(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ListModelEvaluationsResponse response) {
            return new ListModelEvaluationsPage(context, response);
        }

        public ApiFuture<ListModelEvaluationsPage> createPageAsync(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelEvaluationsPagedResponse
    extends AbstractPagedListResponse<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation, ListModelEvaluationsPage, ListModelEvaluationsFixedSizeCollection> {
        public static ApiFuture<ListModelEvaluationsPagedResponse> createAsync(PageContext<ListModelEvaluationsRequest, ListModelEvaluationsResponse, ModelEvaluation> context, ApiFuture<ListModelEvaluationsResponse> futureResponse) {
            ApiFuture<ListModelEvaluationsPage> futurePage = ListModelEvaluationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelEvaluationsPagedResponse((ListModelEvaluationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelEvaluationsPagedResponse(ListModelEvaluationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelEvaluationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelVersionsRequest, ListModelVersionsResponse, Model, ListModelVersionsPage, ListModelVersionsFixedSizeCollection> {
        private ListModelVersionsFixedSizeCollection(List<ListModelVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelVersionsFixedSizeCollection createEmptyCollection() {
            return new ListModelVersionsFixedSizeCollection(null, 0);
        }

        protected ListModelVersionsFixedSizeCollection createCollection(List<ListModelVersionsPage> pages, int collectionSize) {
            return new ListModelVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelVersionsPage
    extends AbstractPage<ListModelVersionsRequest, ListModelVersionsResponse, Model, ListModelVersionsPage> {
        private ListModelVersionsPage(PageContext<ListModelVersionsRequest, ListModelVersionsResponse, Model> context, ListModelVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelVersionsPage createEmptyPage() {
            return new ListModelVersionsPage(null, null);
        }

        protected ListModelVersionsPage createPage(PageContext<ListModelVersionsRequest, ListModelVersionsResponse, Model> context, ListModelVersionsResponse response) {
            return new ListModelVersionsPage(context, response);
        }

        public ApiFuture<ListModelVersionsPage> createPageAsync(PageContext<ListModelVersionsRequest, ListModelVersionsResponse, Model> context, ApiFuture<ListModelVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelVersionsPagedResponse
    extends AbstractPagedListResponse<ListModelVersionsRequest, ListModelVersionsResponse, Model, ListModelVersionsPage, ListModelVersionsFixedSizeCollection> {
        public static ApiFuture<ListModelVersionsPagedResponse> createAsync(PageContext<ListModelVersionsRequest, ListModelVersionsResponse, Model> context, ApiFuture<ListModelVersionsResponse> futureResponse) {
            ApiFuture<ListModelVersionsPage> futurePage = ListModelVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelVersionsPagedResponse((ListModelVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelVersionsPagedResponse(ListModelVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        private ListModelsFixedSizeCollection(List<ListModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelsFixedSizeCollection createEmptyCollection() {
            return new ListModelsFixedSizeCollection(null, 0);
        }

        protected ListModelsFixedSizeCollection createCollection(List<ListModelsPage> pages, int collectionSize) {
            return new ListModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelsPage
    extends AbstractPage<ListModelsRequest, ListModelsResponse, Model, ListModelsPage> {
        private ListModelsPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelsPage createEmptyPage() {
            return new ListModelsPage(null, null);
        }

        protected ListModelsPage createPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            return new ListModelsPage(context, response);
        }

        public ApiFuture<ListModelsPage> createPageAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelsPagedResponse
    extends AbstractPagedListResponse<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        public static ApiFuture<ListModelsPagedResponse> createAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            ApiFuture<ListModelsPage> futurePage = ListModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelsPagedResponse((ListModelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelsPagedResponse(ListModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

