/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.GetScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.ListSchedulesRequest;
import com.google.cloud.aiplatform.v1beta1.ListSchedulesResponse;
import com.google.cloud.aiplatform.v1beta1.PauseScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.ResumeScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.Schedule;
import com.google.cloud.aiplatform.v1beta1.ScheduleServiceClient;
import com.google.cloud.aiplatform.v1beta1.UpdateScheduleRequest;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcScheduleServiceCallableFactory;
import com.google.cloud.aiplatform.v1beta1.stub.ScheduleServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ScheduleServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcScheduleServiceStub
extends ScheduleServiceStub {
    private static final MethodDescriptor<CreateScheduleRequest, Schedule> createScheduleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ScheduleService/CreateSchedule").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateScheduleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schedule.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteScheduleRequest, Operation> deleteScheduleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ScheduleService/DeleteSchedule").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteScheduleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetScheduleRequest, Schedule> getScheduleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ScheduleService/GetSchedule").setRequestMarshaller(ProtoUtils.marshaller((Message)GetScheduleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schedule.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSchedulesRequest, ListSchedulesResponse> listSchedulesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ScheduleService/ListSchedules").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSchedulesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSchedulesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PauseScheduleRequest, Empty> pauseScheduleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ScheduleService/PauseSchedule").setRequestMarshaller(ProtoUtils.marshaller((Message)PauseScheduleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ResumeScheduleRequest, Empty> resumeScheduleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ScheduleService/ResumeSchedule").setRequestMarshaller(ProtoUtils.marshaller((Message)ResumeScheduleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateScheduleRequest, Schedule> updateScheduleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.ScheduleService/UpdateSchedule").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateScheduleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schedule.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateScheduleRequest, Schedule> createScheduleCallable;
    private final UnaryCallable<DeleteScheduleRequest, Operation> deleteScheduleCallable;
    private final OperationCallable<DeleteScheduleRequest, Empty, DeleteOperationMetadata> deleteScheduleOperationCallable;
    private final UnaryCallable<GetScheduleRequest, Schedule> getScheduleCallable;
    private final UnaryCallable<ListSchedulesRequest, ListSchedulesResponse> listSchedulesCallable;
    private final UnaryCallable<ListSchedulesRequest, ScheduleServiceClient.ListSchedulesPagedResponse> listSchedulesPagedCallable;
    private final UnaryCallable<PauseScheduleRequest, Empty> pauseScheduleCallable;
    private final UnaryCallable<ResumeScheduleRequest, Empty> resumeScheduleCallable;
    private final UnaryCallable<UpdateScheduleRequest, Schedule> updateScheduleCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ScheduleServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcScheduleServiceStub create(ScheduleServiceStubSettings settings) throws IOException {
        return new GrpcScheduleServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcScheduleServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcScheduleServiceStub(ScheduleServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcScheduleServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcScheduleServiceStub(ScheduleServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcScheduleServiceStub(ScheduleServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcScheduleServiceCallableFactory());
    }

    protected GrpcScheduleServiceStub(ScheduleServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createScheduleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createScheduleMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteScheduleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteScheduleMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getScheduleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getScheduleMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSchedulesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSchedulesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings pauseScheduleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(pauseScheduleMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings resumeScheduleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resumeScheduleMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateScheduleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateScheduleMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("schedule.name", String.valueOf(request.getSchedule().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createScheduleCallable = callableFactory.createUnaryCallable(createScheduleTransportSettings, settings.createScheduleSettings(), clientContext);
        this.deleteScheduleCallable = callableFactory.createUnaryCallable(deleteScheduleTransportSettings, settings.deleteScheduleSettings(), clientContext);
        this.deleteScheduleOperationCallable = callableFactory.createOperationCallable(deleteScheduleTransportSettings, settings.deleteScheduleOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getScheduleCallable = callableFactory.createUnaryCallable(getScheduleTransportSettings, settings.getScheduleSettings(), clientContext);
        this.listSchedulesCallable = callableFactory.createUnaryCallable(listSchedulesTransportSettings, settings.listSchedulesSettings(), clientContext);
        this.listSchedulesPagedCallable = callableFactory.createPagedCallable(listSchedulesTransportSettings, settings.listSchedulesSettings(), clientContext);
        this.pauseScheduleCallable = callableFactory.createUnaryCallable(pauseScheduleTransportSettings, settings.pauseScheduleSettings(), clientContext);
        this.resumeScheduleCallable = callableFactory.createUnaryCallable(resumeScheduleTransportSettings, settings.resumeScheduleSettings(), clientContext);
        this.updateScheduleCallable = callableFactory.createUnaryCallable(updateScheduleTransportSettings, settings.updateScheduleSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateScheduleRequest, Schedule> createScheduleCallable() {
        return this.createScheduleCallable;
    }

    @Override
    public UnaryCallable<DeleteScheduleRequest, Operation> deleteScheduleCallable() {
        return this.deleteScheduleCallable;
    }

    @Override
    public OperationCallable<DeleteScheduleRequest, Empty, DeleteOperationMetadata> deleteScheduleOperationCallable() {
        return this.deleteScheduleOperationCallable;
    }

    @Override
    public UnaryCallable<GetScheduleRequest, Schedule> getScheduleCallable() {
        return this.getScheduleCallable;
    }

    @Override
    public UnaryCallable<ListSchedulesRequest, ListSchedulesResponse> listSchedulesCallable() {
        return this.listSchedulesCallable;
    }

    @Override
    public UnaryCallable<ListSchedulesRequest, ScheduleServiceClient.ListSchedulesPagedResponse> listSchedulesPagedCallable() {
        return this.listSchedulesPagedCallable;
    }

    @Override
    public UnaryCallable<PauseScheduleRequest, Empty> pauseScheduleCallable() {
        return this.pauseScheduleCallable;
    }

    @Override
    public UnaryCallable<ResumeScheduleRequest, Empty> resumeScheduleCallable() {
        return this.resumeScheduleCallable;
    }

    @Override
    public UnaryCallable<UpdateScheduleRequest, Schedule> updateScheduleCallable() {
        return this.updateScheduleCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ScheduleServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

