/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.ComputeTokensRequest;
import com.google.cloud.aiplatform.v1beta1.ComputeTokensResponse;
import com.google.cloud.aiplatform.v1beta1.CountTokensRequest;
import com.google.cloud.aiplatform.v1beta1.CountTokensResponse;
import com.google.cloud.aiplatform.v1beta1.EndpointName;
import com.google.cloud.aiplatform.v1beta1.LlmUtilityServiceSettings;
import com.google.cloud.aiplatform.v1beta1.stub.LlmUtilityServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.LlmUtilityServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Value;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class LlmUtilityServiceClient
implements BackgroundResource {
    private final LlmUtilityServiceSettings settings;
    private final LlmUtilityServiceStub stub;

    public static final LlmUtilityServiceClient create() throws IOException {
        return LlmUtilityServiceClient.create(LlmUtilityServiceSettings.newBuilder().build());
    }

    public static final LlmUtilityServiceClient create(LlmUtilityServiceSettings settings) throws IOException {
        return new LlmUtilityServiceClient(settings);
    }

    public static final LlmUtilityServiceClient create(LlmUtilityServiceStub stub) {
        return new LlmUtilityServiceClient(stub);
    }

    protected LlmUtilityServiceClient(LlmUtilityServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LlmUtilityServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected LlmUtilityServiceClient(LlmUtilityServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LlmUtilityServiceSettings getSettings() {
        return this.settings;
    }

    public LlmUtilityServiceStub getStub() {
        return this.stub;
    }

    public final CountTokensResponse countTokens(EndpointName endpoint, List<Value> instances) {
        CountTokensRequest request = CountTokensRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).addAllInstances(instances).build();
        return this.countTokens(request);
    }

    public final CountTokensResponse countTokens(String endpoint, List<Value> instances) {
        CountTokensRequest request = CountTokensRequest.newBuilder().setEndpoint(endpoint).addAllInstances(instances).build();
        return this.countTokens(request);
    }

    public final CountTokensResponse countTokens(CountTokensRequest request) {
        return (CountTokensResponse)this.countTokensCallable().call((Object)request);
    }

    public final UnaryCallable<CountTokensRequest, CountTokensResponse> countTokensCallable() {
        return this.stub.countTokensCallable();
    }

    public final ComputeTokensResponse computeTokens(EndpointName endpoint, List<Value> instances) {
        ComputeTokensRequest request = ComputeTokensRequest.newBuilder().setEndpoint(endpoint == null ? null : endpoint.toString()).addAllInstances(instances).build();
        return this.computeTokens(request);
    }

    public final ComputeTokensResponse computeTokens(String endpoint, List<Value> instances) {
        ComputeTokensRequest request = ComputeTokensRequest.newBuilder().setEndpoint(endpoint).addAllInstances(instances).build();
        return this.computeTokens(request);
    }

    public final ComputeTokensResponse computeTokens(ComputeTokensRequest request) {
        return (ComputeTokensResponse)this.computeTokensCallable().call((Object)request);
    }

    public final UnaryCallable<ComputeTokensRequest, ComputeTokensResponse> computeTokensCallable() {
        return this.stub.computeTokensCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

