/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Describes original video file properties, including technical details about audio and video
 * streams, but also metadata information like content length, digitization time, or geotagging
 * information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoFileDetails extends com.google.api.client.json.GenericJson {

  /**
   * A list of audio streams contained in the uploaded video file. Each item in the list contains
   * detailed metadata about an audio stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<VideoFileDetailsAudioStream> audioStreams;

  /**
   * The uploaded video file's combined (video and audio) bitrate in bits per second.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger bitrateBps;

  /**
   * The uploaded video file's container format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String container;

  /**
   * The date and time when the uploaded video file was created. The value is specified in ISO 8601
   * format. Currently, the following ISO 8601 formats are supported: - Date only: YYYY-MM-DD  -
   * Naive time: YYYY-MM-DDTHH:MM:SS  - Time with timezone: YYYY-MM-DDTHH:MM:SS+HH:MM
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTime;

  /**
   * The length of the uploaded video in milliseconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger durationMs;

  /**
   * The uploaded file's name. This field is present whether a video file or another type of file
   * was uploaded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileName;

  /**
   * The uploaded file's size in bytes. This field is present whether a video file or another type
   * of file was uploaded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger fileSize;

  /**
   * The uploaded file's type as detected by YouTube's video processing engine. Currently, YouTube
   * only processes video files, but this field is present whether a video file or another type of
   * file was uploaded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileType;

  /**
   * Geographic coordinates that identify the place where the uploaded video was recorded.
   * Coordinates are defined using WGS 84.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GeoPoint recordingLocation;

  /**
   * A list of video streams contained in the uploaded video file. Each item in the list contains
   * detailed metadata about a video stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<VideoFileDetailsVideoStream> videoStreams;

  /**
   * A list of audio streams contained in the uploaded video file. Each item in the list contains
   * detailed metadata about an audio stream.
   * @return value or {@code null} for none
   */
  public java.util.List<VideoFileDetailsAudioStream> getAudioStreams() {
    return audioStreams;
  }

  /**
   * A list of audio streams contained in the uploaded video file. Each item in the list contains
   * detailed metadata about an audio stream.
   * @param audioStreams audioStreams or {@code null} for none
   */
  public VideoFileDetails setAudioStreams(java.util.List<VideoFileDetailsAudioStream> audioStreams) {
    this.audioStreams = audioStreams;
    return this;
  }

  /**
   * The uploaded video file's combined (video and audio) bitrate in bits per second.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getBitrateBps() {
    return bitrateBps;
  }

  /**
   * The uploaded video file's combined (video and audio) bitrate in bits per second.
   * @param bitrateBps bitrateBps or {@code null} for none
   */
  public VideoFileDetails setBitrateBps(java.math.BigInteger bitrateBps) {
    this.bitrateBps = bitrateBps;
    return this;
  }

  /**
   * The uploaded video file's container format.
   * @return value or {@code null} for none
   */
  public java.lang.String getContainer() {
    return container;
  }

  /**
   * The uploaded video file's container format.
   * @param container container or {@code null} for none
   */
  public VideoFileDetails setContainer(java.lang.String container) {
    this.container = container;
    return this;
  }

  /**
   * The date and time when the uploaded video file was created. The value is specified in ISO 8601
   * format. Currently, the following ISO 8601 formats are supported: - Date only: YYYY-MM-DD  -
   * Naive time: YYYY-MM-DDTHH:MM:SS  - Time with timezone: YYYY-MM-DDTHH:MM:SS+HH:MM
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTime() {
    return creationTime;
  }

  /**
   * The date and time when the uploaded video file was created. The value is specified in ISO 8601
   * format. Currently, the following ISO 8601 formats are supported: - Date only: YYYY-MM-DD  -
   * Naive time: YYYY-MM-DDTHH:MM:SS  - Time with timezone: YYYY-MM-DDTHH:MM:SS+HH:MM
   * @param creationTime creationTime or {@code null} for none
   */
  public VideoFileDetails setCreationTime(java.lang.String creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The length of the uploaded video in milliseconds.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getDurationMs() {
    return durationMs;
  }

  /**
   * The length of the uploaded video in milliseconds.
   * @param durationMs durationMs or {@code null} for none
   */
  public VideoFileDetails setDurationMs(java.math.BigInteger durationMs) {
    this.durationMs = durationMs;
    return this;
  }

  /**
   * The uploaded file's name. This field is present whether a video file or another type of file
   * was uploaded.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileName() {
    return fileName;
  }

  /**
   * The uploaded file's name. This field is present whether a video file or another type of file
   * was uploaded.
   * @param fileName fileName or {@code null} for none
   */
  public VideoFileDetails setFileName(java.lang.String fileName) {
    this.fileName = fileName;
    return this;
  }

  /**
   * The uploaded file's size in bytes. This field is present whether a video file or another type
   * of file was uploaded.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getFileSize() {
    return fileSize;
  }

  /**
   * The uploaded file's size in bytes. This field is present whether a video file or another type
   * of file was uploaded.
   * @param fileSize fileSize or {@code null} for none
   */
  public VideoFileDetails setFileSize(java.math.BigInteger fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * The uploaded file's type as detected by YouTube's video processing engine. Currently, YouTube
   * only processes video files, but this field is present whether a video file or another type of
   * file was uploaded.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileType() {
    return fileType;
  }

  /**
   * The uploaded file's type as detected by YouTube's video processing engine. Currently, YouTube
   * only processes video files, but this field is present whether a video file or another type of
   * file was uploaded.
   * @param fileType fileType or {@code null} for none
   */
  public VideoFileDetails setFileType(java.lang.String fileType) {
    this.fileType = fileType;
    return this;
  }

  /**
   * Geographic coordinates that identify the place where the uploaded video was recorded.
   * Coordinates are defined using WGS 84.
   * @return value or {@code null} for none
   */
  public GeoPoint getRecordingLocation() {
    return recordingLocation;
  }

  /**
   * Geographic coordinates that identify the place where the uploaded video was recorded.
   * Coordinates are defined using WGS 84.
   * @param recordingLocation recordingLocation or {@code null} for none
   */
  public VideoFileDetails setRecordingLocation(GeoPoint recordingLocation) {
    this.recordingLocation = recordingLocation;
    return this;
  }

  /**
   * A list of video streams contained in the uploaded video file. Each item in the list contains
   * detailed metadata about a video stream.
   * @return value or {@code null} for none
   */
  public java.util.List<VideoFileDetailsVideoStream> getVideoStreams() {
    return videoStreams;
  }

  /**
   * A list of video streams contained in the uploaded video file. Each item in the list contains
   * detailed metadata about a video stream.
   * @param videoStreams videoStreams or {@code null} for none
   */
  public VideoFileDetails setVideoStreams(java.util.List<VideoFileDetailsVideoStream> videoStreams) {
    this.videoStreams = videoStreams;
    return this;
  }

  @Override
  public VideoFileDetails set(String fieldName, Object value) {
    return (VideoFileDetails) super.set(fieldName, value);
  }

  @Override
  public VideoFileDetails clone() {
    return (VideoFileDetails) super.clone();
  }

}
