/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A live stream describes a live ingestion point.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveStream extends com.google.api.client.json.GenericJson {

  /**
   * The cdn object defines the live stream's content delivery network (CDN) settings. These
   * settings provide details about the manner in which you stream your content to YouTube.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CdnSettings cdn;

  /**
   * The content_details object contains information about the stream, including the closed captions
   * ingestion URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveStreamContentDetails contentDetails;

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID that YouTube assigns to uniquely identify the stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveStream".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the stream, including its channel, title, and
   * description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveStreamSnippet snippet;

  /**
   * The status object contains information about live stream's status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveStreamStatus status;

  /**
   * The cdn object defines the live stream's content delivery network (CDN) settings. These
   * settings provide details about the manner in which you stream your content to YouTube.
   * @return value or {@code null} for none
   */
  public CdnSettings getCdn() {
    return cdn;
  }

  /**
   * The cdn object defines the live stream's content delivery network (CDN) settings. These
   * settings provide details about the manner in which you stream your content to YouTube.
   * @param cdn cdn or {@code null} for none
   */
  public LiveStream setCdn(CdnSettings cdn) {
    this.cdn = cdn;
    return this;
  }

  /**
   * The content_details object contains information about the stream, including the closed captions
   * ingestion URL.
   * @return value or {@code null} for none
   */
  public LiveStreamContentDetails getContentDetails() {
    return contentDetails;
  }

  /**
   * The content_details object contains information about the stream, including the closed captions
   * ingestion URL.
   * @param contentDetails contentDetails or {@code null} for none
   */
  public LiveStream setContentDetails(LiveStreamContentDetails contentDetails) {
    this.contentDetails = contentDetails;
    return this;
  }

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public LiveStream setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID that YouTube assigns to uniquely identify the stream.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube assigns to uniquely identify the stream.
   * @param id id or {@code null} for none
   */
  public LiveStream setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveStream".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveStream".
   * @param kind kind or {@code null} for none
   */
  public LiveStream setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the stream, including its channel, title, and
   * description.
   * @return value or {@code null} for none
   */
  public LiveStreamSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the stream, including its channel, title, and
   * description.
   * @param snippet snippet or {@code null} for none
   */
  public LiveStream setSnippet(LiveStreamSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The status object contains information about live stream's status.
   * @return value or {@code null} for none
   */
  public LiveStreamStatus getStatus() {
    return status;
  }

  /**
   * The status object contains information about live stream's status.
   * @param status status or {@code null} for none
   */
  public LiveStream setStatus(LiveStreamStatus status) {
    this.status = status;
    return this;
  }

  @Override
  public LiveStream set(String fieldName, Object value) {
    return (LiveStream) super.set(fieldName, value);
  }

  @Override
  public LiveStream clone() {
    return (LiveStream) super.clone();
  }

}
