/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveChatUserBannedMessageDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveChatUserBannedMessageDetails extends com.google.api.client.json.GenericJson {

  /**
   * The duration of the ban. This property is only present if the banType is temporary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger banDurationSeconds;

  /**
   * The type of ban.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String banType;

  /**
   * The details of the user that was banned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelProfileDetails bannedUserDetails;

  /**
   * The duration of the ban. This property is only present if the banType is temporary.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getBanDurationSeconds() {
    return banDurationSeconds;
  }

  /**
   * The duration of the ban. This property is only present if the banType is temporary.
   * @param banDurationSeconds banDurationSeconds or {@code null} for none
   */
  public LiveChatUserBannedMessageDetails setBanDurationSeconds(java.math.BigInteger banDurationSeconds) {
    this.banDurationSeconds = banDurationSeconds;
    return this;
  }

  /**
   * The type of ban.
   * @return value or {@code null} for none
   */
  public java.lang.String getBanType() {
    return banType;
  }

  /**
   * The type of ban.
   * @param banType banType or {@code null} for none
   */
  public LiveChatUserBannedMessageDetails setBanType(java.lang.String banType) {
    this.banType = banType;
    return this;
  }

  /**
   * The details of the user that was banned.
   * @return value or {@code null} for none
   */
  public ChannelProfileDetails getBannedUserDetails() {
    return bannedUserDetails;
  }

  /**
   * The details of the user that was banned.
   * @param bannedUserDetails bannedUserDetails or {@code null} for none
   */
  public LiveChatUserBannedMessageDetails setBannedUserDetails(ChannelProfileDetails bannedUserDetails) {
    this.bannedUserDetails = bannedUserDetails;
    return this;
  }

  @Override
  public LiveChatUserBannedMessageDetails set(String fieldName, Object value) {
    return (LiveChatUserBannedMessageDetails) super.set(fieldName, value);
  }

  @Override
  public LiveChatUserBannedMessageDetails clone() {
    return (LiveChatUserBannedMessageDetails) super.clone();
  }

}
