/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveChatModeratorSnippet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveChatModeratorSnippet extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the live chat this moderator can act on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String liveChatId;

  /**
   * Details about the moderator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChannelProfileDetails moderatorDetails;

  /**
   * The ID of the live chat this moderator can act on.
   * @return value or {@code null} for none
   */
  public java.lang.String getLiveChatId() {
    return liveChatId;
  }

  /**
   * The ID of the live chat this moderator can act on.
   * @param liveChatId liveChatId or {@code null} for none
   */
  public LiveChatModeratorSnippet setLiveChatId(java.lang.String liveChatId) {
    this.liveChatId = liveChatId;
    return this;
  }

  /**
   * Details about the moderator.
   * @return value or {@code null} for none
   */
  public ChannelProfileDetails getModeratorDetails() {
    return moderatorDetails;
  }

  /**
   * Details about the moderator.
   * @param moderatorDetails moderatorDetails or {@code null} for none
   */
  public LiveChatModeratorSnippet setModeratorDetails(ChannelProfileDetails moderatorDetails) {
    this.moderatorDetails = moderatorDetails;
    return this;
  }

  @Override
  public LiveChatModeratorSnippet set(String fieldName, Object value) {
    return (LiveChatModeratorSnippet) super.set(fieldName, value);
  }

  @Override
  public LiveChatModeratorSnippet clone() {
    return (LiveChatModeratorSnippet) super.clone();
  }

}
