/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A liveChatMessage resource represents a chat message in a YouTube Live Chat.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveChatMessage extends com.google.api.client.json.GenericJson {

  /**
   * The authorDetails object contains basic details about the user that posted this message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveChatMessageAuthorDetails authorDetails;

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID that YouTube assigns to uniquely identify the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveChatMessage".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiveChatMessageSnippet snippet;

  /**
   * The authorDetails object contains basic details about the user that posted this message.
   * @return value or {@code null} for none
   */
  public LiveChatMessageAuthorDetails getAuthorDetails() {
    return authorDetails;
  }

  /**
   * The authorDetails object contains basic details about the user that posted this message.
   * @param authorDetails authorDetails or {@code null} for none
   */
  public LiveChatMessage setAuthorDetails(LiveChatMessageAuthorDetails authorDetails) {
    this.authorDetails = authorDetails;
    return this;
  }

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public LiveChatMessage setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID that YouTube assigns to uniquely identify the message.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube assigns to uniquely identify the message.
   * @param id id or {@code null} for none
   */
  public LiveChatMessage setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveChatMessage".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#liveChatMessage".
   * @param kind kind or {@code null} for none
   */
  public LiveChatMessage setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the message.
   * @return value or {@code null} for none
   */
  public LiveChatMessageSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the message.
   * @param snippet snippet or {@code null} for none
   */
  public LiveChatMessage setSnippet(LiveChatMessageSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  @Override
  public LiveChatMessage set(String fieldName, Object value) {
    return (LiveChatMessage) super.set(fieldName, value);
  }

  @Override
  public LiveChatMessage clone() {
    return (LiveChatMessage) super.clone();
  }

}
