/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-08 at 20:10:40 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Ratings schemes. The country-specific ratings are mostly for movies and shows. NEXT_ID: 68
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ContentRating extends com.google.api.client.json.GenericJson {

  /**
   * The video's Australian Classification Board (ACB) or Australian Communications and Media
   * Authority (ACMA) rating. ACMA ratings are used to classify children's television programming.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String acbRating;

  /**
   * The video's rating from Italy's Autorità per le Garanzie nelle Comunicazioni (AGCOM).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String agcomRating;

  /**
   * The video's Anatel (Asociación Nacional de Televisión) rating for Chilean television.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String anatelRating;

  /**
   * The video's British Board of Film Classification (BBFC) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bbfcRating;

  /**
   * The video's rating from Thailand's Board of Film and Video Censors.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bfvcRating;

  /**
   * The video's rating from the Austrian Board of Media Classification (Bundesministerium für
   * Unterricht, Kunst und Kultur).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bmukkRating;

  /**
   * Rating system for Canadian TV - Canadian TV Classification System The video's rating from the
   * Canadian Radio-Television and Telecommunications Commission (CRTC) for Canadian English-
   * language broadcasts. For more information, see the Canadian Broadcast Standards Council
   * website.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String catvRating;

  /**
   * The video's rating from the Canadian Radio-Television and Telecommunications Commission (CRTC)
   * for Canadian French-language broadcasts. For more information, see the Canadian Broadcast
   * Standards Council website.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String catvfrRating;

  /**
   * The video's Central Board of Film Certification (CBFC - India) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cbfcRating;

  /**
   * The video's Consejo de Calificación Cinematográfica (Chile) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cccRating;

  /**
   * The video's rating from Portugal's Comissão de Classificação de Espect´culos.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cceRating;

  /**
   * The video's rating in Switzerland.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String chfilmRating;

  /**
   * The video's Canadian Home Video Rating System (CHVRS) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String chvrsRating;

  /**
   * The video's rating from the Commission de Contrôle des Films (Belgium).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cicfRating;

  /**
   * The video's rating from Romania's CONSILIUL NATIONAL AL AUDIOVIZUALULUI (CNA).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cnaRating;

  /**
   * Rating system in France - Commission de classification cinematographique
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cncRating;

  /**
   * The video's rating from France's Conseil supérieur de l?audiovisuel, which rates broadcast
   * content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String csaRating;

  /**
   * The video's rating from Luxembourg's Commission de surveillance de la classification des films
   * (CSCF).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cscfRating;

  /**
   * The video's rating in the Czech Republic.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String czfilmRating;

  /**
   * The video's Departamento de Justiça, Classificação, Qualificação e Títulos (DJCQT - Brazil)
   * rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String djctqRating;

  /**
   * Reasons that explain why the video received its DJCQT (Brazil) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> djctqRatingReasons;

  /**
   * Rating system in Turkey - Evaluation and Classification Board of the Ministry of Culture and
   * Tourism
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ecbmctRating;

  /**
   * The video's rating in Estonia.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eefilmRating;

  /**
   * The video's rating in Egypt.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String egfilmRating;

  /**
   * The video's Eirin (映倫) rating. Eirin is the Japanese rating system.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eirinRating;

  /**
   * The video's rating from Malaysia's Film Censorship Board.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fcbmRating;

  /**
   * The video's rating from Hong Kong's Office for Film, Newspaper and Article Administration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fcoRating;

  /**
   * This property has been deprecated. Use the contentDetails.contentRating.cncRating instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fmocRating;

  /**
   * The video's rating from South Africa's Film and Publication Board.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fpbRating;

  /**
   * Reasons that explain why the video received its FPB (South Africa) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> fpbRatingReasons;

  /**
   * The video's Freiwillige Selbstkontrolle der Filmwirtschaft (FSK - Germany) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fskRating;

  /**
   * The video's rating in Greece.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String grfilmRating;

  /**
   * The video's Instituto de la Cinematografía y de las Artes Audiovisuales (ICAA - Spain) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String icaaRating;

  /**
   * The video's Irish Film Classification Office (IFCO - Ireland) rating. See the IFCO website for
   * more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ifcoRating;

  /**
   * The video's rating in Israel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ilfilmRating;

  /**
   * The video's INCAA (Instituto Nacional de Cine y Artes Audiovisuales - Argentina) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String incaaRating;

  /**
   * The video's rating from the Kenya Film Classification Board.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kfcbRating;

  /**
   * voor de Classificatie van Audiovisuele Media (Netherlands).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kijkwijzerRating;

  /**
   * The video's Korea Media Rating Board (영상물등급위원회) rating. The KMRB rates videos in South Korea.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kmrbRating;

  /**
   * The video's rating from Indonesia's Lembaga Sensor Film.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lsfRating;

  /**
   * The video's rating from Malta's Film Age-Classification Board.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mccaaRating;

  /**
   * The video's rating from the Danish Film Institute's (Det Danske Filminstitut) Media Council for
   * Children and Young People.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mccypRating;

  /**
   * The video's rating from Singapore's Media Development Authority (MDA) and, specifically, it's
   * Board of Film Censors (BFC).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mdaRating;

  /**
   * The video's rating from Medietilsynet, the Norwegian Media Authority.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String medietilsynetRating;

  /**
   * The video's rating from Finland's Kansallinen Audiovisuaalinen Instituutti (National
   * Audiovisual Institute).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mekuRating;

  /**
   * The video's rating from the Ministero dei Beni e delle Attività Culturali e del Turismo
   * (Italy).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mibacRating;

  /**
   * The video's Ministerio de Cultura (Colombia) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mocRating;

  /**
   * The video's rating from Taiwan's Ministry of Culture (文化部).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String moctwRating;

  /**
   * The video's Motion Picture Association of America (MPAA) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mpaaRating;

  /**
   * The video's rating from the Movie and Television Review and Classification Board (Philippines).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mtrcbRating;

  /**
   * The video's rating from the Maldives National Bureau of Classification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nbcRating;

  /**
   * The video's rating in Poland.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nbcplRating;

  /**
   * The video's rating from the Bulgarian National Film Center.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nfrcRating;

  /**
   * The video's rating from Nigeria's National Film and Video Censors Board.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nfvcbRating;

  /**
   * The video's rating from the Nacionãlais Kino centrs (National Film Centre of Latvia).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nkclvRating;

  /**
   * The video's Office of Film and Literature Classification (OFLC - New Zealand) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oflcRating;

  /**
   * The video's rating in Peru.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pefilmRating;

  /**
   * The video's rating from the Hungarian Nemzeti Filmiroda, the Rating Committee of the National
   * Office of Film.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rcnofRating;

  /**
   * The video's rating in Venezuela.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resorteviolenciaRating;

  /**
   * The video's General Directorate of Radio, Television and Cinematography (Mexico) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rtcRating;

  /**
   * The video's rating from Ireland's Raidió Teilifís Éireann.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rteRating;

  /**
   * The video's National Film Registry of the Russian Federation (MKRF - Russia) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String russiaRating;

  /**
   * The video's rating in Slovakia.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String skfilmRating;

  /**
   * The video's rating in Iceland.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String smaisRating;

  /**
   * The video's rating from Statens medieråd (Sweden's National Media Council).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String smsaRating;

  /**
   * The video's TV Parental Guidelines (TVPG) rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tvpgRating;

  /**
   * A rating that YouTube uses to identify age-restricted content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ytRating;

  /**
   * The video's Australian Classification Board (ACB) or Australian Communications and Media
   * Authority (ACMA) rating. ACMA ratings are used to classify children's television programming.
   * @return value or {@code null} for none
   */
  public java.lang.String getAcbRating() {
    return acbRating;
  }

  /**
   * The video's Australian Classification Board (ACB) or Australian Communications and Media
   * Authority (ACMA) rating. ACMA ratings are used to classify children's television programming.
   * @param acbRating acbRating or {@code null} for none
   */
  public ContentRating setAcbRating(java.lang.String acbRating) {
    this.acbRating = acbRating;
    return this;
  }

  /**
   * The video's rating from Italy's Autorità per le Garanzie nelle Comunicazioni (AGCOM).
   * @return value or {@code null} for none
   */
  public java.lang.String getAgcomRating() {
    return agcomRating;
  }

  /**
   * The video's rating from Italy's Autorità per le Garanzie nelle Comunicazioni (AGCOM).
   * @param agcomRating agcomRating or {@code null} for none
   */
  public ContentRating setAgcomRating(java.lang.String agcomRating) {
    this.agcomRating = agcomRating;
    return this;
  }

  /**
   * The video's Anatel (Asociación Nacional de Televisión) rating for Chilean television.
   * @return value or {@code null} for none
   */
  public java.lang.String getAnatelRating() {
    return anatelRating;
  }

  /**
   * The video's Anatel (Asociación Nacional de Televisión) rating for Chilean television.
   * @param anatelRating anatelRating or {@code null} for none
   */
  public ContentRating setAnatelRating(java.lang.String anatelRating) {
    this.anatelRating = anatelRating;
    return this;
  }

  /**
   * The video's British Board of Film Classification (BBFC) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getBbfcRating() {
    return bbfcRating;
  }

  /**
   * The video's British Board of Film Classification (BBFC) rating.
   * @param bbfcRating bbfcRating or {@code null} for none
   */
  public ContentRating setBbfcRating(java.lang.String bbfcRating) {
    this.bbfcRating = bbfcRating;
    return this;
  }

  /**
   * The video's rating from Thailand's Board of Film and Video Censors.
   * @return value or {@code null} for none
   */
  public java.lang.String getBfvcRating() {
    return bfvcRating;
  }

  /**
   * The video's rating from Thailand's Board of Film and Video Censors.
   * @param bfvcRating bfvcRating or {@code null} for none
   */
  public ContentRating setBfvcRating(java.lang.String bfvcRating) {
    this.bfvcRating = bfvcRating;
    return this;
  }

  /**
   * The video's rating from the Austrian Board of Media Classification (Bundesministerium für
   * Unterricht, Kunst und Kultur).
   * @return value or {@code null} for none
   */
  public java.lang.String getBmukkRating() {
    return bmukkRating;
  }

  /**
   * The video's rating from the Austrian Board of Media Classification (Bundesministerium für
   * Unterricht, Kunst und Kultur).
   * @param bmukkRating bmukkRating or {@code null} for none
   */
  public ContentRating setBmukkRating(java.lang.String bmukkRating) {
    this.bmukkRating = bmukkRating;
    return this;
  }

  /**
   * Rating system for Canadian TV - Canadian TV Classification System The video's rating from the
   * Canadian Radio-Television and Telecommunications Commission (CRTC) for Canadian English-
   * language broadcasts. For more information, see the Canadian Broadcast Standards Council
   * website.
   * @return value or {@code null} for none
   */
  public java.lang.String getCatvRating() {
    return catvRating;
  }

  /**
   * Rating system for Canadian TV - Canadian TV Classification System The video's rating from the
   * Canadian Radio-Television and Telecommunications Commission (CRTC) for Canadian English-
   * language broadcasts. For more information, see the Canadian Broadcast Standards Council
   * website.
   * @param catvRating catvRating or {@code null} for none
   */
  public ContentRating setCatvRating(java.lang.String catvRating) {
    this.catvRating = catvRating;
    return this;
  }

  /**
   * The video's rating from the Canadian Radio-Television and Telecommunications Commission (CRTC)
   * for Canadian French-language broadcasts. For more information, see the Canadian Broadcast
   * Standards Council website.
   * @return value or {@code null} for none
   */
  public java.lang.String getCatvfrRating() {
    return catvfrRating;
  }

  /**
   * The video's rating from the Canadian Radio-Television and Telecommunications Commission (CRTC)
   * for Canadian French-language broadcasts. For more information, see the Canadian Broadcast
   * Standards Council website.
   * @param catvfrRating catvfrRating or {@code null} for none
   */
  public ContentRating setCatvfrRating(java.lang.String catvfrRating) {
    this.catvfrRating = catvfrRating;
    return this;
  }

  /**
   * The video's Central Board of Film Certification (CBFC - India) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getCbfcRating() {
    return cbfcRating;
  }

  /**
   * The video's Central Board of Film Certification (CBFC - India) rating.
   * @param cbfcRating cbfcRating or {@code null} for none
   */
  public ContentRating setCbfcRating(java.lang.String cbfcRating) {
    this.cbfcRating = cbfcRating;
    return this;
  }

  /**
   * The video's Consejo de Calificación Cinematográfica (Chile) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getCccRating() {
    return cccRating;
  }

  /**
   * The video's Consejo de Calificación Cinematográfica (Chile) rating.
   * @param cccRating cccRating or {@code null} for none
   */
  public ContentRating setCccRating(java.lang.String cccRating) {
    this.cccRating = cccRating;
    return this;
  }

  /**
   * The video's rating from Portugal's Comissão de Classificação de Espect´culos.
   * @return value or {@code null} for none
   */
  public java.lang.String getCceRating() {
    return cceRating;
  }

  /**
   * The video's rating from Portugal's Comissão de Classificação de Espect´culos.
   * @param cceRating cceRating or {@code null} for none
   */
  public ContentRating setCceRating(java.lang.String cceRating) {
    this.cceRating = cceRating;
    return this;
  }

  /**
   * The video's rating in Switzerland.
   * @return value or {@code null} for none
   */
  public java.lang.String getChfilmRating() {
    return chfilmRating;
  }

  /**
   * The video's rating in Switzerland.
   * @param chfilmRating chfilmRating or {@code null} for none
   */
  public ContentRating setChfilmRating(java.lang.String chfilmRating) {
    this.chfilmRating = chfilmRating;
    return this;
  }

  /**
   * The video's Canadian Home Video Rating System (CHVRS) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getChvrsRating() {
    return chvrsRating;
  }

  /**
   * The video's Canadian Home Video Rating System (CHVRS) rating.
   * @param chvrsRating chvrsRating or {@code null} for none
   */
  public ContentRating setChvrsRating(java.lang.String chvrsRating) {
    this.chvrsRating = chvrsRating;
    return this;
  }

  /**
   * The video's rating from the Commission de Contrôle des Films (Belgium).
   * @return value or {@code null} for none
   */
  public java.lang.String getCicfRating() {
    return cicfRating;
  }

  /**
   * The video's rating from the Commission de Contrôle des Films (Belgium).
   * @param cicfRating cicfRating or {@code null} for none
   */
  public ContentRating setCicfRating(java.lang.String cicfRating) {
    this.cicfRating = cicfRating;
    return this;
  }

  /**
   * The video's rating from Romania's CONSILIUL NATIONAL AL AUDIOVIZUALULUI (CNA).
   * @return value or {@code null} for none
   */
  public java.lang.String getCnaRating() {
    return cnaRating;
  }

  /**
   * The video's rating from Romania's CONSILIUL NATIONAL AL AUDIOVIZUALULUI (CNA).
   * @param cnaRating cnaRating or {@code null} for none
   */
  public ContentRating setCnaRating(java.lang.String cnaRating) {
    this.cnaRating = cnaRating;
    return this;
  }

  /**
   * Rating system in France - Commission de classification cinematographique
   * @return value or {@code null} for none
   */
  public java.lang.String getCncRating() {
    return cncRating;
  }

  /**
   * Rating system in France - Commission de classification cinematographique
   * @param cncRating cncRating or {@code null} for none
   */
  public ContentRating setCncRating(java.lang.String cncRating) {
    this.cncRating = cncRating;
    return this;
  }

  /**
   * The video's rating from France's Conseil supérieur de l?audiovisuel, which rates broadcast
   * content.
   * @return value or {@code null} for none
   */
  public java.lang.String getCsaRating() {
    return csaRating;
  }

  /**
   * The video's rating from France's Conseil supérieur de l?audiovisuel, which rates broadcast
   * content.
   * @param csaRating csaRating or {@code null} for none
   */
  public ContentRating setCsaRating(java.lang.String csaRating) {
    this.csaRating = csaRating;
    return this;
  }

  /**
   * The video's rating from Luxembourg's Commission de surveillance de la classification des films
   * (CSCF).
   * @return value or {@code null} for none
   */
  public java.lang.String getCscfRating() {
    return cscfRating;
  }

  /**
   * The video's rating from Luxembourg's Commission de surveillance de la classification des films
   * (CSCF).
   * @param cscfRating cscfRating or {@code null} for none
   */
  public ContentRating setCscfRating(java.lang.String cscfRating) {
    this.cscfRating = cscfRating;
    return this;
  }

  /**
   * The video's rating in the Czech Republic.
   * @return value or {@code null} for none
   */
  public java.lang.String getCzfilmRating() {
    return czfilmRating;
  }

  /**
   * The video's rating in the Czech Republic.
   * @param czfilmRating czfilmRating or {@code null} for none
   */
  public ContentRating setCzfilmRating(java.lang.String czfilmRating) {
    this.czfilmRating = czfilmRating;
    return this;
  }

  /**
   * The video's Departamento de Justiça, Classificação, Qualificação e Títulos (DJCQT - Brazil)
   * rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getDjctqRating() {
    return djctqRating;
  }

  /**
   * The video's Departamento de Justiça, Classificação, Qualificação e Títulos (DJCQT - Brazil)
   * rating.
   * @param djctqRating djctqRating or {@code null} for none
   */
  public ContentRating setDjctqRating(java.lang.String djctqRating) {
    this.djctqRating = djctqRating;
    return this;
  }

  /**
   * Reasons that explain why the video received its DJCQT (Brazil) rating.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDjctqRatingReasons() {
    return djctqRatingReasons;
  }

  /**
   * Reasons that explain why the video received its DJCQT (Brazil) rating.
   * @param djctqRatingReasons djctqRatingReasons or {@code null} for none
   */
  public ContentRating setDjctqRatingReasons(java.util.List<java.lang.String> djctqRatingReasons) {
    this.djctqRatingReasons = djctqRatingReasons;
    return this;
  }

  /**
   * Rating system in Turkey - Evaluation and Classification Board of the Ministry of Culture and
   * Tourism
   * @return value or {@code null} for none
   */
  public java.lang.String getEcbmctRating() {
    return ecbmctRating;
  }

  /**
   * Rating system in Turkey - Evaluation and Classification Board of the Ministry of Culture and
   * Tourism
   * @param ecbmctRating ecbmctRating or {@code null} for none
   */
  public ContentRating setEcbmctRating(java.lang.String ecbmctRating) {
    this.ecbmctRating = ecbmctRating;
    return this;
  }

  /**
   * The video's rating in Estonia.
   * @return value or {@code null} for none
   */
  public java.lang.String getEefilmRating() {
    return eefilmRating;
  }

  /**
   * The video's rating in Estonia.
   * @param eefilmRating eefilmRating or {@code null} for none
   */
  public ContentRating setEefilmRating(java.lang.String eefilmRating) {
    this.eefilmRating = eefilmRating;
    return this;
  }

  /**
   * The video's rating in Egypt.
   * @return value or {@code null} for none
   */
  public java.lang.String getEgfilmRating() {
    return egfilmRating;
  }

  /**
   * The video's rating in Egypt.
   * @param egfilmRating egfilmRating or {@code null} for none
   */
  public ContentRating setEgfilmRating(java.lang.String egfilmRating) {
    this.egfilmRating = egfilmRating;
    return this;
  }

  /**
   * The video's Eirin (映倫) rating. Eirin is the Japanese rating system.
   * @return value or {@code null} for none
   */
  public java.lang.String getEirinRating() {
    return eirinRating;
  }

  /**
   * The video's Eirin (映倫) rating. Eirin is the Japanese rating system.
   * @param eirinRating eirinRating or {@code null} for none
   */
  public ContentRating setEirinRating(java.lang.String eirinRating) {
    this.eirinRating = eirinRating;
    return this;
  }

  /**
   * The video's rating from Malaysia's Film Censorship Board.
   * @return value or {@code null} for none
   */
  public java.lang.String getFcbmRating() {
    return fcbmRating;
  }

  /**
   * The video's rating from Malaysia's Film Censorship Board.
   * @param fcbmRating fcbmRating or {@code null} for none
   */
  public ContentRating setFcbmRating(java.lang.String fcbmRating) {
    this.fcbmRating = fcbmRating;
    return this;
  }

  /**
   * The video's rating from Hong Kong's Office for Film, Newspaper and Article Administration.
   * @return value or {@code null} for none
   */
  public java.lang.String getFcoRating() {
    return fcoRating;
  }

  /**
   * The video's rating from Hong Kong's Office for Film, Newspaper and Article Administration.
   * @param fcoRating fcoRating or {@code null} for none
   */
  public ContentRating setFcoRating(java.lang.String fcoRating) {
    this.fcoRating = fcoRating;
    return this;
  }

  /**
   * This property has been deprecated. Use the contentDetails.contentRating.cncRating instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getFmocRating() {
    return fmocRating;
  }

  /**
   * This property has been deprecated. Use the contentDetails.contentRating.cncRating instead.
   * @param fmocRating fmocRating or {@code null} for none
   */
  public ContentRating setFmocRating(java.lang.String fmocRating) {
    this.fmocRating = fmocRating;
    return this;
  }

  /**
   * The video's rating from South Africa's Film and Publication Board.
   * @return value or {@code null} for none
   */
  public java.lang.String getFpbRating() {
    return fpbRating;
  }

  /**
   * The video's rating from South Africa's Film and Publication Board.
   * @param fpbRating fpbRating or {@code null} for none
   */
  public ContentRating setFpbRating(java.lang.String fpbRating) {
    this.fpbRating = fpbRating;
    return this;
  }

  /**
   * Reasons that explain why the video received its FPB (South Africa) rating.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getFpbRatingReasons() {
    return fpbRatingReasons;
  }

  /**
   * Reasons that explain why the video received its FPB (South Africa) rating.
   * @param fpbRatingReasons fpbRatingReasons or {@code null} for none
   */
  public ContentRating setFpbRatingReasons(java.util.List<java.lang.String> fpbRatingReasons) {
    this.fpbRatingReasons = fpbRatingReasons;
    return this;
  }

  /**
   * The video's Freiwillige Selbstkontrolle der Filmwirtschaft (FSK - Germany) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getFskRating() {
    return fskRating;
  }

  /**
   * The video's Freiwillige Selbstkontrolle der Filmwirtschaft (FSK - Germany) rating.
   * @param fskRating fskRating or {@code null} for none
   */
  public ContentRating setFskRating(java.lang.String fskRating) {
    this.fskRating = fskRating;
    return this;
  }

  /**
   * The video's rating in Greece.
   * @return value or {@code null} for none
   */
  public java.lang.String getGrfilmRating() {
    return grfilmRating;
  }

  /**
   * The video's rating in Greece.
   * @param grfilmRating grfilmRating or {@code null} for none
   */
  public ContentRating setGrfilmRating(java.lang.String grfilmRating) {
    this.grfilmRating = grfilmRating;
    return this;
  }

  /**
   * The video's Instituto de la Cinematografía y de las Artes Audiovisuales (ICAA - Spain) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getIcaaRating() {
    return icaaRating;
  }

  /**
   * The video's Instituto de la Cinematografía y de las Artes Audiovisuales (ICAA - Spain) rating.
   * @param icaaRating icaaRating or {@code null} for none
   */
  public ContentRating setIcaaRating(java.lang.String icaaRating) {
    this.icaaRating = icaaRating;
    return this;
  }

  /**
   * The video's Irish Film Classification Office (IFCO - Ireland) rating. See the IFCO website for
   * more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getIfcoRating() {
    return ifcoRating;
  }

  /**
   * The video's Irish Film Classification Office (IFCO - Ireland) rating. See the IFCO website for
   * more information.
   * @param ifcoRating ifcoRating or {@code null} for none
   */
  public ContentRating setIfcoRating(java.lang.String ifcoRating) {
    this.ifcoRating = ifcoRating;
    return this;
  }

  /**
   * The video's rating in Israel.
   * @return value or {@code null} for none
   */
  public java.lang.String getIlfilmRating() {
    return ilfilmRating;
  }

  /**
   * The video's rating in Israel.
   * @param ilfilmRating ilfilmRating or {@code null} for none
   */
  public ContentRating setIlfilmRating(java.lang.String ilfilmRating) {
    this.ilfilmRating = ilfilmRating;
    return this;
  }

  /**
   * The video's INCAA (Instituto Nacional de Cine y Artes Audiovisuales - Argentina) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getIncaaRating() {
    return incaaRating;
  }

  /**
   * The video's INCAA (Instituto Nacional de Cine y Artes Audiovisuales - Argentina) rating.
   * @param incaaRating incaaRating or {@code null} for none
   */
  public ContentRating setIncaaRating(java.lang.String incaaRating) {
    this.incaaRating = incaaRating;
    return this;
  }

  /**
   * The video's rating from the Kenya Film Classification Board.
   * @return value or {@code null} for none
   */
  public java.lang.String getKfcbRating() {
    return kfcbRating;
  }

  /**
   * The video's rating from the Kenya Film Classification Board.
   * @param kfcbRating kfcbRating or {@code null} for none
   */
  public ContentRating setKfcbRating(java.lang.String kfcbRating) {
    this.kfcbRating = kfcbRating;
    return this;
  }

  /**
   * voor de Classificatie van Audiovisuele Media (Netherlands).
   * @return value or {@code null} for none
   */
  public java.lang.String getKijkwijzerRating() {
    return kijkwijzerRating;
  }

  /**
   * voor de Classificatie van Audiovisuele Media (Netherlands).
   * @param kijkwijzerRating kijkwijzerRating or {@code null} for none
   */
  public ContentRating setKijkwijzerRating(java.lang.String kijkwijzerRating) {
    this.kijkwijzerRating = kijkwijzerRating;
    return this;
  }

  /**
   * The video's Korea Media Rating Board (영상물등급위원회) rating. The KMRB rates videos in South Korea.
   * @return value or {@code null} for none
   */
  public java.lang.String getKmrbRating() {
    return kmrbRating;
  }

  /**
   * The video's Korea Media Rating Board (영상물등급위원회) rating. The KMRB rates videos in South Korea.
   * @param kmrbRating kmrbRating or {@code null} for none
   */
  public ContentRating setKmrbRating(java.lang.String kmrbRating) {
    this.kmrbRating = kmrbRating;
    return this;
  }

  /**
   * The video's rating from Indonesia's Lembaga Sensor Film.
   * @return value or {@code null} for none
   */
  public java.lang.String getLsfRating() {
    return lsfRating;
  }

  /**
   * The video's rating from Indonesia's Lembaga Sensor Film.
   * @param lsfRating lsfRating or {@code null} for none
   */
  public ContentRating setLsfRating(java.lang.String lsfRating) {
    this.lsfRating = lsfRating;
    return this;
  }

  /**
   * The video's rating from Malta's Film Age-Classification Board.
   * @return value or {@code null} for none
   */
  public java.lang.String getMccaaRating() {
    return mccaaRating;
  }

  /**
   * The video's rating from Malta's Film Age-Classification Board.
   * @param mccaaRating mccaaRating or {@code null} for none
   */
  public ContentRating setMccaaRating(java.lang.String mccaaRating) {
    this.mccaaRating = mccaaRating;
    return this;
  }

  /**
   * The video's rating from the Danish Film Institute's (Det Danske Filminstitut) Media Council for
   * Children and Young People.
   * @return value or {@code null} for none
   */
  public java.lang.String getMccypRating() {
    return mccypRating;
  }

  /**
   * The video's rating from the Danish Film Institute's (Det Danske Filminstitut) Media Council for
   * Children and Young People.
   * @param mccypRating mccypRating or {@code null} for none
   */
  public ContentRating setMccypRating(java.lang.String mccypRating) {
    this.mccypRating = mccypRating;
    return this;
  }

  /**
   * The video's rating from Singapore's Media Development Authority (MDA) and, specifically, it's
   * Board of Film Censors (BFC).
   * @return value or {@code null} for none
   */
  public java.lang.String getMdaRating() {
    return mdaRating;
  }

  /**
   * The video's rating from Singapore's Media Development Authority (MDA) and, specifically, it's
   * Board of Film Censors (BFC).
   * @param mdaRating mdaRating or {@code null} for none
   */
  public ContentRating setMdaRating(java.lang.String mdaRating) {
    this.mdaRating = mdaRating;
    return this;
  }

  /**
   * The video's rating from Medietilsynet, the Norwegian Media Authority.
   * @return value or {@code null} for none
   */
  public java.lang.String getMedietilsynetRating() {
    return medietilsynetRating;
  }

  /**
   * The video's rating from Medietilsynet, the Norwegian Media Authority.
   * @param medietilsynetRating medietilsynetRating or {@code null} for none
   */
  public ContentRating setMedietilsynetRating(java.lang.String medietilsynetRating) {
    this.medietilsynetRating = medietilsynetRating;
    return this;
  }

  /**
   * The video's rating from Finland's Kansallinen Audiovisuaalinen Instituutti (National
   * Audiovisual Institute).
   * @return value or {@code null} for none
   */
  public java.lang.String getMekuRating() {
    return mekuRating;
  }

  /**
   * The video's rating from Finland's Kansallinen Audiovisuaalinen Instituutti (National
   * Audiovisual Institute).
   * @param mekuRating mekuRating or {@code null} for none
   */
  public ContentRating setMekuRating(java.lang.String mekuRating) {
    this.mekuRating = mekuRating;
    return this;
  }

  /**
   * The video's rating from the Ministero dei Beni e delle Attività Culturali e del Turismo
   * (Italy).
   * @return value or {@code null} for none
   */
  public java.lang.String getMibacRating() {
    return mibacRating;
  }

  /**
   * The video's rating from the Ministero dei Beni e delle Attività Culturali e del Turismo
   * (Italy).
   * @param mibacRating mibacRating or {@code null} for none
   */
  public ContentRating setMibacRating(java.lang.String mibacRating) {
    this.mibacRating = mibacRating;
    return this;
  }

  /**
   * The video's Ministerio de Cultura (Colombia) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getMocRating() {
    return mocRating;
  }

  /**
   * The video's Ministerio de Cultura (Colombia) rating.
   * @param mocRating mocRating or {@code null} for none
   */
  public ContentRating setMocRating(java.lang.String mocRating) {
    this.mocRating = mocRating;
    return this;
  }

  /**
   * The video's rating from Taiwan's Ministry of Culture (文化部).
   * @return value or {@code null} for none
   */
  public java.lang.String getMoctwRating() {
    return moctwRating;
  }

  /**
   * The video's rating from Taiwan's Ministry of Culture (文化部).
   * @param moctwRating moctwRating or {@code null} for none
   */
  public ContentRating setMoctwRating(java.lang.String moctwRating) {
    this.moctwRating = moctwRating;
    return this;
  }

  /**
   * The video's Motion Picture Association of America (MPAA) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getMpaaRating() {
    return mpaaRating;
  }

  /**
   * The video's Motion Picture Association of America (MPAA) rating.
   * @param mpaaRating mpaaRating or {@code null} for none
   */
  public ContentRating setMpaaRating(java.lang.String mpaaRating) {
    this.mpaaRating = mpaaRating;
    return this;
  }

  /**
   * The video's rating from the Movie and Television Review and Classification Board (Philippines).
   * @return value or {@code null} for none
   */
  public java.lang.String getMtrcbRating() {
    return mtrcbRating;
  }

  /**
   * The video's rating from the Movie and Television Review and Classification Board (Philippines).
   * @param mtrcbRating mtrcbRating or {@code null} for none
   */
  public ContentRating setMtrcbRating(java.lang.String mtrcbRating) {
    this.mtrcbRating = mtrcbRating;
    return this;
  }

  /**
   * The video's rating from the Maldives National Bureau of Classification.
   * @return value or {@code null} for none
   */
  public java.lang.String getNbcRating() {
    return nbcRating;
  }

  /**
   * The video's rating from the Maldives National Bureau of Classification.
   * @param nbcRating nbcRating or {@code null} for none
   */
  public ContentRating setNbcRating(java.lang.String nbcRating) {
    this.nbcRating = nbcRating;
    return this;
  }

  /**
   * The video's rating in Poland.
   * @return value or {@code null} for none
   */
  public java.lang.String getNbcplRating() {
    return nbcplRating;
  }

  /**
   * The video's rating in Poland.
   * @param nbcplRating nbcplRating or {@code null} for none
   */
  public ContentRating setNbcplRating(java.lang.String nbcplRating) {
    this.nbcplRating = nbcplRating;
    return this;
  }

  /**
   * The video's rating from the Bulgarian National Film Center.
   * @return value or {@code null} for none
   */
  public java.lang.String getNfrcRating() {
    return nfrcRating;
  }

  /**
   * The video's rating from the Bulgarian National Film Center.
   * @param nfrcRating nfrcRating or {@code null} for none
   */
  public ContentRating setNfrcRating(java.lang.String nfrcRating) {
    this.nfrcRating = nfrcRating;
    return this;
  }

  /**
   * The video's rating from Nigeria's National Film and Video Censors Board.
   * @return value or {@code null} for none
   */
  public java.lang.String getNfvcbRating() {
    return nfvcbRating;
  }

  /**
   * The video's rating from Nigeria's National Film and Video Censors Board.
   * @param nfvcbRating nfvcbRating or {@code null} for none
   */
  public ContentRating setNfvcbRating(java.lang.String nfvcbRating) {
    this.nfvcbRating = nfvcbRating;
    return this;
  }

  /**
   * The video's rating from the Nacionãlais Kino centrs (National Film Centre of Latvia).
   * @return value or {@code null} for none
   */
  public java.lang.String getNkclvRating() {
    return nkclvRating;
  }

  /**
   * The video's rating from the Nacionãlais Kino centrs (National Film Centre of Latvia).
   * @param nkclvRating nkclvRating or {@code null} for none
   */
  public ContentRating setNkclvRating(java.lang.String nkclvRating) {
    this.nkclvRating = nkclvRating;
    return this;
  }

  /**
   * The video's Office of Film and Literature Classification (OFLC - New Zealand) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getOflcRating() {
    return oflcRating;
  }

  /**
   * The video's Office of Film and Literature Classification (OFLC - New Zealand) rating.
   * @param oflcRating oflcRating or {@code null} for none
   */
  public ContentRating setOflcRating(java.lang.String oflcRating) {
    this.oflcRating = oflcRating;
    return this;
  }

  /**
   * The video's rating in Peru.
   * @return value or {@code null} for none
   */
  public java.lang.String getPefilmRating() {
    return pefilmRating;
  }

  /**
   * The video's rating in Peru.
   * @param pefilmRating pefilmRating or {@code null} for none
   */
  public ContentRating setPefilmRating(java.lang.String pefilmRating) {
    this.pefilmRating = pefilmRating;
    return this;
  }

  /**
   * The video's rating from the Hungarian Nemzeti Filmiroda, the Rating Committee of the National
   * Office of Film.
   * @return value or {@code null} for none
   */
  public java.lang.String getRcnofRating() {
    return rcnofRating;
  }

  /**
   * The video's rating from the Hungarian Nemzeti Filmiroda, the Rating Committee of the National
   * Office of Film.
   * @param rcnofRating rcnofRating or {@code null} for none
   */
  public ContentRating setRcnofRating(java.lang.String rcnofRating) {
    this.rcnofRating = rcnofRating;
    return this;
  }

  /**
   * The video's rating in Venezuela.
   * @return value or {@code null} for none
   */
  public java.lang.String getResorteviolenciaRating() {
    return resorteviolenciaRating;
  }

  /**
   * The video's rating in Venezuela.
   * @param resorteviolenciaRating resorteviolenciaRating or {@code null} for none
   */
  public ContentRating setResorteviolenciaRating(java.lang.String resorteviolenciaRating) {
    this.resorteviolenciaRating = resorteviolenciaRating;
    return this;
  }

  /**
   * The video's General Directorate of Radio, Television and Cinematography (Mexico) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getRtcRating() {
    return rtcRating;
  }

  /**
   * The video's General Directorate of Radio, Television and Cinematography (Mexico) rating.
   * @param rtcRating rtcRating or {@code null} for none
   */
  public ContentRating setRtcRating(java.lang.String rtcRating) {
    this.rtcRating = rtcRating;
    return this;
  }

  /**
   * The video's rating from Ireland's Raidió Teilifís Éireann.
   * @return value or {@code null} for none
   */
  public java.lang.String getRteRating() {
    return rteRating;
  }

  /**
   * The video's rating from Ireland's Raidió Teilifís Éireann.
   * @param rteRating rteRating or {@code null} for none
   */
  public ContentRating setRteRating(java.lang.String rteRating) {
    this.rteRating = rteRating;
    return this;
  }

  /**
   * The video's National Film Registry of the Russian Federation (MKRF - Russia) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getRussiaRating() {
    return russiaRating;
  }

  /**
   * The video's National Film Registry of the Russian Federation (MKRF - Russia) rating.
   * @param russiaRating russiaRating or {@code null} for none
   */
  public ContentRating setRussiaRating(java.lang.String russiaRating) {
    this.russiaRating = russiaRating;
    return this;
  }

  /**
   * The video's rating in Slovakia.
   * @return value or {@code null} for none
   */
  public java.lang.String getSkfilmRating() {
    return skfilmRating;
  }

  /**
   * The video's rating in Slovakia.
   * @param skfilmRating skfilmRating or {@code null} for none
   */
  public ContentRating setSkfilmRating(java.lang.String skfilmRating) {
    this.skfilmRating = skfilmRating;
    return this;
  }

  /**
   * The video's rating in Iceland.
   * @return value or {@code null} for none
   */
  public java.lang.String getSmaisRating() {
    return smaisRating;
  }

  /**
   * The video's rating in Iceland.
   * @param smaisRating smaisRating or {@code null} for none
   */
  public ContentRating setSmaisRating(java.lang.String smaisRating) {
    this.smaisRating = smaisRating;
    return this;
  }

  /**
   * The video's rating from Statens medieråd (Sweden's National Media Council).
   * @return value or {@code null} for none
   */
  public java.lang.String getSmsaRating() {
    return smsaRating;
  }

  /**
   * The video's rating from Statens medieråd (Sweden's National Media Council).
   * @param smsaRating smsaRating or {@code null} for none
   */
  public ContentRating setSmsaRating(java.lang.String smsaRating) {
    this.smsaRating = smsaRating;
    return this;
  }

  /**
   * The video's TV Parental Guidelines (TVPG) rating.
   * @return value or {@code null} for none
   */
  public java.lang.String getTvpgRating() {
    return tvpgRating;
  }

  /**
   * The video's TV Parental Guidelines (TVPG) rating.
   * @param tvpgRating tvpgRating or {@code null} for none
   */
  public ContentRating setTvpgRating(java.lang.String tvpgRating) {
    this.tvpgRating = tvpgRating;
    return this;
  }

  /**
   * A rating that YouTube uses to identify age-restricted content.
   * @return value or {@code null} for none
   */
  public java.lang.String getYtRating() {
    return ytRating;
  }

  /**
   * A rating that YouTube uses to identify age-restricted content.
   * @param ytRating ytRating or {@code null} for none
   */
  public ContentRating setYtRating(java.lang.String ytRating) {
    this.ytRating = ytRating;
    return this;
  }

  @Override
  public ContentRating set(String fieldName, Object value) {
    return (ContentRating) super.set(fieldName, value);
  }

  @Override
  public ContentRating clone() {
    return (ContentRating) super.clone();
  }

}
