/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-01-14 17:53:03 UTC)
 * on 2015-03-18 at 21:12:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.tasks.model;

/**
 * Model definition for Tasks.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Tasks API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Tasks extends com.google.api.client.json.GenericJson {

  /**
   * ETag of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Collection of tasks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Task> items;

  static {
    // hack to force ProGuard to consider Task used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Task.class);
  }

  /**
   * Type of the resource. This is always "tasks#tasks".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Token used to access the next page of this result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * ETag of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the resource.
   * @param etag etag or {@code null} for none
   */
  public Tasks setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Collection of tasks.
   * @return value or {@code null} for none
   */
  public java.util.List<Task> getItems() {
    return items;
  }

  /**
   * Collection of tasks.
   * @param items items or {@code null} for none
   */
  public Tasks setItems(java.util.List<Task> items) {
    this.items = items;
    return this;
  }

  /**
   * Type of the resource. This is always "tasks#tasks".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource. This is always "tasks#tasks".
   * @param kind kind or {@code null} for none
   */
  public Tasks setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Token used to access the next page of this result.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token used to access the next page of this result.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public Tasks setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public Tasks set(String fieldName, Object value) {
    return (Tasks) super.set(fieldName, value);
  }

  @Override
  public Tasks clone() {
    return (Tasks) super.clone();
  }

}
