/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-01-14 17:53:03 UTC)
 * on 2015-03-18 at 21:12:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.tasks;

/**
 * Service definition for Tasks (v1).
 *
 * <p>
 * Lets you manage your tasks and task lists.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/google-apps/tasks/firstapp" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link TasksRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Tasks extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.20.0 of the Tasks API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "tasks/v1/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Tasks(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Tasks(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Tasklists collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Tasks tasks = new Tasks(...);}
   *   {@code Tasks.Tasklists.List request = tasks.tasklists().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tasklists tasklists() {
    return new Tasklists();
  }

  /**
   * The "tasklists" collection of methods.
   */
  public class Tasklists {

    /**
     * Deletes the authenticated user's specified task list.
     *
     * Create a request for the method "tasklists.delete".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @return the request
     */
    public Delete delete(java.lang.String tasklist) throws java.io.IOException {
      Delete result = new Delete(tasklist);
      initialize(result);
      return result;
    }

    public class Delete extends TasksRequest<Void> {

      private static final String REST_PATH = "users/@me/lists/{tasklist}";

      /**
       * Deletes the authenticated user's specified task list.
       *
       * Create a request for the method "tasklists.delete".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @since 1.13
       */
      protected Delete(java.lang.String tasklist) {
        super(Tasks.this, "DELETE", REST_PATH, null, Void.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Delete setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the authenticated user's specified task list.
     *
     * Create a request for the method "tasklists.get".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @return the request
     */
    public Get get(java.lang.String tasklist) throws java.io.IOException {
      Get result = new Get(tasklist);
      initialize(result);
      return result;
    }

    public class Get extends TasksRequest<com.google.api.services.tasks.model.TaskList> {

      private static final String REST_PATH = "users/@me/lists/{tasklist}";

      /**
       * Returns the authenticated user's specified task list.
       *
       * Create a request for the method "tasklists.get".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @since 1.13
       */
      protected Get(java.lang.String tasklist) {
        super(Tasks.this, "GET", REST_PATH, null, com.google.api.services.tasks.model.TaskList.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Get setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new task list and adds it to the authenticated user's task lists.
     *
     * Create a request for the method "tasklists.insert".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.tasks.model.TaskList}
     * @return the request
     */
    public Insert insert(com.google.api.services.tasks.model.TaskList content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends TasksRequest<com.google.api.services.tasks.model.TaskList> {

      private static final String REST_PATH = "users/@me/lists";

      /**
       * Creates a new task list and adds it to the authenticated user's task lists.
       *
       * Create a request for the method "tasklists.insert".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.tasks.model.TaskList}
       * @since 1.13
       */
      protected Insert(com.google.api.services.tasks.model.TaskList content) {
        super(Tasks.this, "POST", REST_PATH, content, com.google.api.services.tasks.model.TaskList.class);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns all the authenticated user's task lists.
     *
     * Create a request for the method "tasklists.list".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends TasksRequest<com.google.api.services.tasks.model.TaskLists> {

      private static final String REST_PATH = "users/@me/lists";

      /**
       * Returns all the authenticated user's task lists.
       *
       * Create a request for the method "tasklists.list".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Tasks.this, "GET", REST_PATH, null, com.google.api.services.tasks.model.TaskLists.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Token specifying the result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying the result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying the result page to return. Optional. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum number of task lists returned on one page. Optional. The default is 100. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of task lists returned on one page. Optional. The default is 100.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of task lists returned on one page. Optional. The default is 100. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the authenticated user's specified task list. This method supports patch semantics.
     *
     * Create a request for the method "tasklists.patch".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param content the {@link com.google.api.services.tasks.model.TaskList}
     * @return the request
     */
    public Patch patch(java.lang.String tasklist, com.google.api.services.tasks.model.TaskList content) throws java.io.IOException {
      Patch result = new Patch(tasklist, content);
      initialize(result);
      return result;
    }

    public class Patch extends TasksRequest<com.google.api.services.tasks.model.TaskList> {

      private static final String REST_PATH = "users/@me/lists/{tasklist}";

      /**
       * Updates the authenticated user's specified task list. This method supports patch semantics.
       *
       * Create a request for the method "tasklists.patch".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @param content the {@link com.google.api.services.tasks.model.TaskList}
       * @since 1.13
       */
      protected Patch(java.lang.String tasklist, com.google.api.services.tasks.model.TaskList content) {
        super(Tasks.this, "PATCH", REST_PATH, content, com.google.api.services.tasks.model.TaskList.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Patch setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the authenticated user's specified task list.
     *
     * Create a request for the method "tasklists.update".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param content the {@link com.google.api.services.tasks.model.TaskList}
     * @return the request
     */
    public Update update(java.lang.String tasklist, com.google.api.services.tasks.model.TaskList content) throws java.io.IOException {
      Update result = new Update(tasklist, content);
      initialize(result);
      return result;
    }

    public class Update extends TasksRequest<com.google.api.services.tasks.model.TaskList> {

      private static final String REST_PATH = "users/@me/lists/{tasklist}";

      /**
       * Updates the authenticated user's specified task list.
       *
       * Create a request for the method "tasklists.update".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @param content the {@link com.google.api.services.tasks.model.TaskList}
       * @since 1.13
       */
      protected Update(java.lang.String tasklist, com.google.api.services.tasks.model.TaskList content) {
        super(Tasks.this, "PUT", REST_PATH, content, com.google.api.services.tasks.model.TaskList.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Update setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the TasksOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Tasks tasks = new Tasks(...);}
   *   {@code Tasks.TasksOperations.List request = tasks.tasks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TasksOperations tasks() {
    return new TasksOperations();
  }

  /**
   * The "tasks" collection of methods.
   */
  public class TasksOperations {

    /**
     * Clears all completed tasks from the specified task list. The affected tasks will be marked as
     * 'hidden' and no longer be returned by default when retrieving all tasks for a task list.
     *
     * Create a request for the method "tasks.clear".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Clear#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @return the request
     */
    public Clear clear(java.lang.String tasklist) throws java.io.IOException {
      Clear result = new Clear(tasklist);
      initialize(result);
      return result;
    }

    public class Clear extends TasksRequest<Void> {

      private static final String REST_PATH = "lists/{tasklist}/clear";

      /**
       * Clears all completed tasks from the specified task list. The affected tasks will be marked as
       * 'hidden' and no longer be returned by default when retrieving all tasks for a task list.
       *
       * Create a request for the method "tasks.clear".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Clear#execute()} method to invoke the remote operation. <p> {@link
       * Clear#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @since 1.13
       */
      protected Clear(java.lang.String tasklist) {
        super(Tasks.this, "POST", REST_PATH, null, Void.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
      }

      @Override
      public Clear setAlt(java.lang.String alt) {
        return (Clear) super.setAlt(alt);
      }

      @Override
      public Clear setFields(java.lang.String fields) {
        return (Clear) super.setFields(fields);
      }

      @Override
      public Clear setKey(java.lang.String key) {
        return (Clear) super.setKey(key);
      }

      @Override
      public Clear setOauthToken(java.lang.String oauthToken) {
        return (Clear) super.setOauthToken(oauthToken);
      }

      @Override
      public Clear setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Clear) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Clear setQuotaUser(java.lang.String quotaUser) {
        return (Clear) super.setQuotaUser(quotaUser);
      }

      @Override
      public Clear setUserIp(java.lang.String userIp) {
        return (Clear) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Clear setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      @Override
      public Clear set(String parameterName, Object value) {
        return (Clear) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified task from the task list.
     *
     * Create a request for the method "tasks.delete".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @return the request
     */
    public Delete delete(java.lang.String tasklist, java.lang.String task) throws java.io.IOException {
      Delete result = new Delete(tasklist, task);
      initialize(result);
      return result;
    }

    public class Delete extends TasksRequest<Void> {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";

      /**
       * Deletes the specified task from the task list.
       *
       * Create a request for the method "tasks.delete".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @param task Task identifier.
       * @since 1.13
       */
      protected Delete(java.lang.String tasklist, java.lang.String task) {
        super(Tasks.this, "DELETE", REST_PATH, null, Void.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
        this.task = com.google.api.client.util.Preconditions.checkNotNull(task, "Required parameter task must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Delete setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @com.google.api.client.util.Key
      private java.lang.String task;

      /** Task identifier.
       */
      public java.lang.String getTask() {
        return task;
      }

      /** Task identifier. */
      public Delete setTask(java.lang.String task) {
        this.task = task;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified task.
     *
     * Create a request for the method "tasks.get".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @return the request
     */
    public Get get(java.lang.String tasklist, java.lang.String task) throws java.io.IOException {
      Get result = new Get(tasklist, task);
      initialize(result);
      return result;
    }

    public class Get extends TasksRequest<com.google.api.services.tasks.model.Task> {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";

      /**
       * Returns the specified task.
       *
       * Create a request for the method "tasks.get".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @param task Task identifier.
       * @since 1.13
       */
      protected Get(java.lang.String tasklist, java.lang.String task) {
        super(Tasks.this, "GET", REST_PATH, null, com.google.api.services.tasks.model.Task.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
        this.task = com.google.api.client.util.Preconditions.checkNotNull(task, "Required parameter task must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Get setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @com.google.api.client.util.Key
      private java.lang.String task;

      /** Task identifier.
       */
      public java.lang.String getTask() {
        return task;
      }

      /** Task identifier. */
      public Get setTask(java.lang.String task) {
        this.task = task;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new task on the specified task list.
     *
     * Create a request for the method "tasks.insert".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param content the {@link com.google.api.services.tasks.model.Task}
     * @return the request
     */
    public Insert insert(java.lang.String tasklist, com.google.api.services.tasks.model.Task content) throws java.io.IOException {
      Insert result = new Insert(tasklist, content);
      initialize(result);
      return result;
    }

    public class Insert extends TasksRequest<com.google.api.services.tasks.model.Task> {

      private static final String REST_PATH = "lists/{tasklist}/tasks";

      /**
       * Creates a new task on the specified task list.
       *
       * Create a request for the method "tasks.insert".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @param content the {@link com.google.api.services.tasks.model.Task}
       * @since 1.13
       */
      protected Insert(java.lang.String tasklist, com.google.api.services.tasks.model.Task content) {
        super(Tasks.this, "POST", REST_PATH, content, com.google.api.services.tasks.model.Task.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Insert setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /**
       * Parent task identifier. If the task is created at the top level, this parameter is omitted.
       * Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Parent task identifier. If the task is created at the top level, this parameter is omitted.
     Optional.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Parent task identifier. If the task is created at the top level, this parameter is omitted.
       * Optional.
       */
      public Insert setParent(java.lang.String parent) {
        this.parent = parent;
        return this;
      }

      /**
       * Previous sibling task identifier. If the task is created at the first position among its
       * siblings, this parameter is omitted. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String previous;

      /** Previous sibling task identifier. If the task is created at the first position among its siblings,
     this parameter is omitted. Optional.
       */
      public java.lang.String getPrevious() {
        return previous;
      }

      /**
       * Previous sibling task identifier. If the task is created at the first position among its
       * siblings, this parameter is omitted. Optional.
       */
      public Insert setPrevious(java.lang.String previous) {
        this.previous = previous;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns all tasks in the specified task list.
     *
     * Create a request for the method "tasks.list".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @return the request
     */
    public List list(java.lang.String tasklist) throws java.io.IOException {
      List result = new List(tasklist);
      initialize(result);
      return result;
    }

    public class List extends TasksRequest<com.google.api.services.tasks.model.Tasks> {

      private static final String REST_PATH = "lists/{tasklist}/tasks";

      /**
       * Returns all tasks in the specified task list.
       *
       * Create a request for the method "tasks.list".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @since 1.13
       */
      protected List(java.lang.String tasklist) {
        super(Tasks.this, "GET", REST_PATH, null, com.google.api.services.tasks.model.Tasks.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public List setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /**
       * Upper bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The
       * default is not to filter by due date.
       */
      @com.google.api.client.util.Key
      private java.lang.String dueMax;

      /** Upper bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The default is
     not to filter by due date.
       */
      public java.lang.String getDueMax() {
        return dueMax;
      }

      /**
       * Upper bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The
       * default is not to filter by due date.
       */
      public List setDueMax(java.lang.String dueMax) {
        this.dueMax = dueMax;
        return this;
      }

      /**
       * Flag indicating whether deleted tasks are returned in the result. Optional. The default is
       * False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Flag indicating whether deleted tasks are returned in the result. Optional. The default is False.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Flag indicating whether deleted tasks are returned in the result. Optional. The default is
       * False.
       */
      public List setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /**
       * Lower bound for a task's last modification time (as a RFC 3339 timestamp) to filter by.
       * Optional. The default is not to filter by last modification time.
       */
      @com.google.api.client.util.Key
      private java.lang.String updatedMin;

      /** Lower bound for a task's last modification time (as a RFC 3339 timestamp) to filter by. Optional.
     The default is not to filter by last modification time.
       */
      public java.lang.String getUpdatedMin() {
        return updatedMin;
      }

      /**
       * Lower bound for a task's last modification time (as a RFC 3339 timestamp) to filter by.
       * Optional. The default is not to filter by last modification time.
       */
      public List setUpdatedMin(java.lang.String updatedMin) {
        this.updatedMin = updatedMin;
        return this;
      }

      /**
       * Lower bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional.
       * The default is not to filter by completion date.
       */
      @com.google.api.client.util.Key
      private java.lang.String completedMin;

      /** Lower bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional. The
     default is not to filter by completion date.
       */
      public java.lang.String getCompletedMin() {
        return completedMin;
      }

      /**
       * Lower bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional.
       * The default is not to filter by completion date.
       */
      public List setCompletedMin(java.lang.String completedMin) {
        this.completedMin = completedMin;
        return this;
      }

      /** Maximum number of task lists returned on one page. Optional. The default is 100. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of task lists returned on one page. Optional. The default is 100.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of task lists returned on one page. Optional. The default is 100. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Flag indicating whether completed tasks are returned in the result. Optional. The default
       * is True.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showCompleted;

      /** Flag indicating whether completed tasks are returned in the result. Optional. The default is True.
       */
      public java.lang.Boolean getShowCompleted() {
        return showCompleted;
      }

      /**
       * Flag indicating whether completed tasks are returned in the result. Optional. The default
       * is True.
       */
      public List setShowCompleted(java.lang.Boolean showCompleted) {
        this.showCompleted = showCompleted;
        return this;
      }

      /** Token specifying the result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying the result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying the result page to return. Optional. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Upper bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional.
       * The default is not to filter by completion date.
       */
      @com.google.api.client.util.Key
      private java.lang.String completedMax;

      /** Upper bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional. The
     default is not to filter by completion date.
       */
      public java.lang.String getCompletedMax() {
        return completedMax;
      }

      /**
       * Upper bound for a task's completion date (as a RFC 3339 timestamp) to filter by. Optional.
       * The default is not to filter by completion date.
       */
      public List setCompletedMax(java.lang.String completedMax) {
        this.completedMax = completedMax;
        return this;
      }

      /**
       * Flag indicating whether hidden tasks are returned in the result. Optional. The default is
       * False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showHidden;

      /** Flag indicating whether hidden tasks are returned in the result. Optional. The default is False.
       */
      public java.lang.Boolean getShowHidden() {
        return showHidden;
      }

      /**
       * Flag indicating whether hidden tasks are returned in the result. Optional. The default is
       * False.
       */
      public List setShowHidden(java.lang.Boolean showHidden) {
        this.showHidden = showHidden;
        return this;
      }

      /**
       * Lower bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The
       * default is not to filter by due date.
       */
      @com.google.api.client.util.Key
      private java.lang.String dueMin;

      /** Lower bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The default is
     not to filter by due date.
       */
      public java.lang.String getDueMin() {
        return dueMin;
      }

      /**
       * Lower bound for a task's due date (as a RFC 3339 timestamp) to filter by. Optional. The
       * default is not to filter by due date.
       */
      public List setDueMin(java.lang.String dueMin) {
        this.dueMin = dueMin;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Moves the specified task to another position in the task list. This can include putting it as a
     * child task under a new parent and/or move it to a different position among its sibling tasks.
     *
     * Create a request for the method "tasks.move".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Move#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @return the request
     */
    public Move move(java.lang.String tasklist, java.lang.String task) throws java.io.IOException {
      Move result = new Move(tasklist, task);
      initialize(result);
      return result;
    }

    public class Move extends TasksRequest<com.google.api.services.tasks.model.Task> {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}/move";

      /**
       * Moves the specified task to another position in the task list. This can include putting it as a
       * child task under a new parent and/or move it to a different position among its sibling tasks.
       *
       * Create a request for the method "tasks.move".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Move#execute()} method to invoke the remote operation. <p> {@link
       * Move#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @param task Task identifier.
       * @since 1.13
       */
      protected Move(java.lang.String tasklist, java.lang.String task) {
        super(Tasks.this, "POST", REST_PATH, null, com.google.api.services.tasks.model.Task.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
        this.task = com.google.api.client.util.Preconditions.checkNotNull(task, "Required parameter task must be specified.");
      }

      @Override
      public Move setAlt(java.lang.String alt) {
        return (Move) super.setAlt(alt);
      }

      @Override
      public Move setFields(java.lang.String fields) {
        return (Move) super.setFields(fields);
      }

      @Override
      public Move setKey(java.lang.String key) {
        return (Move) super.setKey(key);
      }

      @Override
      public Move setOauthToken(java.lang.String oauthToken) {
        return (Move) super.setOauthToken(oauthToken);
      }

      @Override
      public Move setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Move) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Move setQuotaUser(java.lang.String quotaUser) {
        return (Move) super.setQuotaUser(quotaUser);
      }

      @Override
      public Move setUserIp(java.lang.String userIp) {
        return (Move) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Move setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @com.google.api.client.util.Key
      private java.lang.String task;

      /** Task identifier.
       */
      public java.lang.String getTask() {
        return task;
      }

      /** Task identifier. */
      public Move setTask(java.lang.String task) {
        this.task = task;
        return this;
      }

      /**
       * New parent task identifier. If the task is moved to the top level, this parameter is
       * omitted. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** New parent task identifier. If the task is moved to the top level, this parameter is omitted.
     Optional.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * New parent task identifier. If the task is moved to the top level, this parameter is
       * omitted. Optional.
       */
      public Move setParent(java.lang.String parent) {
        this.parent = parent;
        return this;
      }

      /**
       * New previous sibling task identifier. If the task is moved to the first position among its
       * siblings, this parameter is omitted. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String previous;

      /** New previous sibling task identifier. If the task is moved to the first position among its
     siblings, this parameter is omitted. Optional.
       */
      public java.lang.String getPrevious() {
        return previous;
      }

      /**
       * New previous sibling task identifier. If the task is moved to the first position among its
       * siblings, this parameter is omitted. Optional.
       */
      public Move setPrevious(java.lang.String previous) {
        this.previous = previous;
        return this;
      }

      @Override
      public Move set(String parameterName, Object value) {
        return (Move) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified task. This method supports patch semantics.
     *
     * Create a request for the method "tasks.patch".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @param content the {@link com.google.api.services.tasks.model.Task}
     * @return the request
     */
    public Patch patch(java.lang.String tasklist, java.lang.String task, com.google.api.services.tasks.model.Task content) throws java.io.IOException {
      Patch result = new Patch(tasklist, task, content);
      initialize(result);
      return result;
    }

    public class Patch extends TasksRequest<com.google.api.services.tasks.model.Task> {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";

      /**
       * Updates the specified task. This method supports patch semantics.
       *
       * Create a request for the method "tasks.patch".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @param task Task identifier.
       * @param content the {@link com.google.api.services.tasks.model.Task}
       * @since 1.13
       */
      protected Patch(java.lang.String tasklist, java.lang.String task, com.google.api.services.tasks.model.Task content) {
        super(Tasks.this, "PATCH", REST_PATH, content, com.google.api.services.tasks.model.Task.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
        this.task = com.google.api.client.util.Preconditions.checkNotNull(task, "Required parameter task must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Patch setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @com.google.api.client.util.Key
      private java.lang.String task;

      /** Task identifier.
       */
      public java.lang.String getTask() {
        return task;
      }

      /** Task identifier. */
      public Patch setTask(java.lang.String task) {
        this.task = task;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified task.
     *
     * Create a request for the method "tasks.update".
     *
     * This request holds the parameters needed by the tasks server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param tasklist Task list identifier.
     * @param task Task identifier.
     * @param content the {@link com.google.api.services.tasks.model.Task}
     * @return the request
     */
    public Update update(java.lang.String tasklist, java.lang.String task, com.google.api.services.tasks.model.Task content) throws java.io.IOException {
      Update result = new Update(tasklist, task, content);
      initialize(result);
      return result;
    }

    public class Update extends TasksRequest<com.google.api.services.tasks.model.Task> {

      private static final String REST_PATH = "lists/{tasklist}/tasks/{task}";

      /**
       * Updates the specified task.
       *
       * Create a request for the method "tasks.update".
       *
       * This request holds the parameters needed by the the tasks server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param tasklist Task list identifier.
       * @param task Task identifier.
       * @param content the {@link com.google.api.services.tasks.model.Task}
       * @since 1.13
       */
      protected Update(java.lang.String tasklist, java.lang.String task, com.google.api.services.tasks.model.Task content) {
        super(Tasks.this, "PUT", REST_PATH, content, com.google.api.services.tasks.model.Task.class);
        this.tasklist = com.google.api.client.util.Preconditions.checkNotNull(tasklist, "Required parameter tasklist must be specified.");
        this.task = com.google.api.client.util.Preconditions.checkNotNull(task, "Required parameter task must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Task list identifier. */
      @com.google.api.client.util.Key
      private java.lang.String tasklist;

      /** Task list identifier.
       */
      public java.lang.String getTasklist() {
        return tasklist;
      }

      /** Task list identifier. */
      public Update setTasklist(java.lang.String tasklist) {
        this.tasklist = tasklist;
        return this;
      }

      /** Task identifier. */
      @com.google.api.client.util.Key
      private java.lang.String task;

      /** Task identifier.
       */
      public java.lang.String getTask() {
        return task;
      }

      /** Task identifier. */
      public Update setTask(java.lang.String task) {
        this.task = task;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Tasks}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Tasks}. */
    @Override
    public Tasks build() {
      return new Tasks(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link TasksRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setTasksRequestInitializer(
        TasksRequestInitializer tasksRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(tasksRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
