/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-16 at 01:09:00 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.storage;

/**
 * Service definition for Storage (v1).
 *
 * <p>
 * Lets you store and retrieve potentially-large, immutable data objects.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/storage/docs/json_api/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link StorageRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Storage extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.19.0 of the Cloud Storage API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "storage/v1/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Storage(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Storage(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the BucketAccessControls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.BucketAccessControls.List request = storage.bucketAccessControls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BucketAccessControls bucketAccessControls() {
    return new BucketAccessControls();
  }

  /**
   * The "bucketAccessControls" collection of methods.
   */
  public class BucketAccessControls {

    /**
     * Permanently deletes the ACL entry for the specified entity on the specified bucket.
     *
     * Create a request for the method "bucketAccessControls.delete".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Delete delete(java.lang.String bucket, java.lang.String entity) throws java.io.IOException {
      Delete result = new Delete(bucket, entity);
      initialize(result);
      return result;
    }

    public class Delete extends StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/acl/{entity}";

      /**
       * Permanently deletes the ACL entry for the specified entity on the specified bucket.
       *
       * Create a request for the method "bucketAccessControls.delete".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Delete(java.lang.String bucket, java.lang.String entity) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Delete setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Delete setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the ACL entry for the specified entity on the specified bucket.
     *
     * Create a request for the method "bucketAccessControls.get".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Get get(java.lang.String bucket, java.lang.String entity) throws java.io.IOException {
      Get result = new Get(bucket, entity);
      initialize(result);
      return result;
    }

    public class Get extends StorageRequest<com.google.api.services.storage.model.BucketAccessControl> {

      private static final String REST_PATH = "b/{bucket}/acl/{entity}";

      /**
       * Returns the ACL entry for the specified entity on the specified bucket.
       *
       * Create a request for the method "bucketAccessControls.get".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Get(java.lang.String bucket, java.lang.String entity) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.BucketAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Get setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Get setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new ACL entry on the specified bucket.
     *
     * Create a request for the method "bucketAccessControls.insert".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
     * @return the request
     */
    public Insert insert(java.lang.String bucket, com.google.api.services.storage.model.BucketAccessControl content) throws java.io.IOException {
      Insert result = new Insert(bucket, content);
      initialize(result);
      return result;
    }

    public class Insert extends StorageRequest<com.google.api.services.storage.model.BucketAccessControl> {

      private static final String REST_PATH = "b/{bucket}/acl";

      /**
       * Creates a new ACL entry on the specified bucket.
       *
       * Create a request for the method "bucketAccessControls.insert".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
       * @since 1.13
       */
      protected Insert(java.lang.String bucket, com.google.api.services.storage.model.BucketAccessControl content) {
        super(Storage.this, "POST", REST_PATH, content, com.google.api.services.storage.model.BucketAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getEntity(), "BucketAccessControl.getEntity()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getRole(), "BucketAccessControl.getRole()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Insert setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves ACL entries on the specified bucket.
     *
     * Create a request for the method "bucketAccessControls.list".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public List list(java.lang.String bucket) throws java.io.IOException {
      List result = new List(bucket);
      initialize(result);
      return result;
    }

    public class List extends StorageRequest<com.google.api.services.storage.model.BucketAccessControls> {

      private static final String REST_PATH = "b/{bucket}/acl";

      /**
       * Retrieves ACL entries on the specified bucket.
       *
       * Create a request for the method "bucketAccessControls.list".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected List(java.lang.String bucket) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.BucketAccessControls.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public List setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an ACL entry on the specified bucket. This method supports patch semantics.
     *
     * Create a request for the method "bucketAccessControls.patch".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
     * @return the request
     */
    public Patch patch(java.lang.String bucket, java.lang.String entity, com.google.api.services.storage.model.BucketAccessControl content) throws java.io.IOException {
      Patch result = new Patch(bucket, entity, content);
      initialize(result);
      return result;
    }

    public class Patch extends StorageRequest<com.google.api.services.storage.model.BucketAccessControl> {

      private static final String REST_PATH = "b/{bucket}/acl/{entity}";

      /**
       * Updates an ACL entry on the specified bucket. This method supports patch semantics.
       *
       * Create a request for the method "bucketAccessControls.patch".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
       * @since 1.13
       */
      protected Patch(java.lang.String bucket, java.lang.String entity, com.google.api.services.storage.model.BucketAccessControl content) {
        super(Storage.this, "PATCH", REST_PATH, content, com.google.api.services.storage.model.BucketAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Patch setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Patch setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an ACL entry on the specified bucket.
     *
     * Create a request for the method "bucketAccessControls.update".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
     * @return the request
     */
    public Update update(java.lang.String bucket, java.lang.String entity, com.google.api.services.storage.model.BucketAccessControl content) throws java.io.IOException {
      Update result = new Update(bucket, entity, content);
      initialize(result);
      return result;
    }

    public class Update extends StorageRequest<com.google.api.services.storage.model.BucketAccessControl> {

      private static final String REST_PATH = "b/{bucket}/acl/{entity}";

      /**
       * Updates an ACL entry on the specified bucket.
       *
       * Create a request for the method "bucketAccessControls.update".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
       * @since 1.13
       */
      protected Update(java.lang.String bucket, java.lang.String entity, com.google.api.services.storage.model.BucketAccessControl content) {
        super(Storage.this, "PUT", REST_PATH, content, com.google.api.services.storage.model.BucketAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Update setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Update setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Buckets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Buckets.List request = storage.buckets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Buckets buckets() {
    return new Buckets();
  }

  /**
   * The "buckets" collection of methods.
   */
  public class Buckets {

    /**
     * Permanently deletes an empty bucket.
     *
     * Create a request for the method "buckets.delete".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public Delete delete(java.lang.String bucket) throws java.io.IOException {
      Delete result = new Delete(bucket);
      initialize(result);
      return result;
    }

    public class Delete extends StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}";

      /**
       * Permanently deletes an empty bucket.
       *
       * Create a request for the method "buckets.delete".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected Delete(java.lang.String bucket) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Delete setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** If set, only deletes the bucket if its metageneration matches this value. */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** If set, only deletes the bucket if its metageneration matches this value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /** If set, only deletes the bucket if its metageneration matches this value. */
      public Delete setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /** If set, only deletes the bucket if its metageneration does not match this value. */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** If set, only deletes the bucket if its metageneration does not match this value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /** If set, only deletes the bucket if its metageneration does not match this value. */
      public Delete setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns metadata for the specified bucket.
     *
     * Create a request for the method "buckets.get".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public Get get(java.lang.String bucket) throws java.io.IOException {
      Get result = new Get(bucket);
      initialize(result);
      return result;
    }

    public class Get extends StorageRequest<com.google.api.services.storage.model.Bucket> {

      private static final String REST_PATH = "b/{bucket}";

      /**
       * Returns metadata for the specified bucket.
       *
       * Create a request for the method "buckets.get".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected Get(java.lang.String bucket) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Bucket.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Get setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the return of the bucket metadata conditional on whether the bucket's current metageneration
     matches the given value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Get setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the return of the bucket metadata conditional on whether the bucket's current metageneration
     does not match the given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Get setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to noAcl.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public Get setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new bucket.
     *
     * Create a request for the method "buckets.insert".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project A valid API project identifier.
     * @param content the {@link com.google.api.services.storage.model.Bucket}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.storage.model.Bucket content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends StorageRequest<com.google.api.services.storage.model.Bucket> {

      private static final String REST_PATH = "b";

      /**
       * Creates a new bucket.
       *
       * Create a request for the method "buckets.insert".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project A valid API project identifier.
       * @param content the {@link com.google.api.services.storage.model.Bucket}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.storage.model.Bucket content) {
        super(Storage.this, "POST", REST_PATH, content, com.google.api.services.storage.model.Bucket.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getName(), "Bucket.getName()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** A valid API project identifier. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** A valid API project identifier.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** A valid API project identifier. */
      public Insert setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /** Apply a predefined set of access controls to this bucket. */
      @com.google.api.client.util.Key
      private java.lang.String predefinedAcl;

      /** Apply a predefined set of access controls to this bucket.
       */
      public java.lang.String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this bucket. */
      public Insert setPredefinedAcl(java.lang.String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the bucket resource specifies acl or
       * defaultObjectAcl properties, when it defaults to full.
       */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to noAcl, unless the bucket resource specifies acl or
     defaultObjectAcl properties, when it defaults to full.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the bucket resource specifies acl or
       * defaultObjectAcl properties, when it defaults to full.
       */
      public Insert setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of buckets for a given project.
     *
     * Create a request for the method "buckets.list".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project A valid API project identifier.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends StorageRequest<com.google.api.services.storage.model.Buckets> {

      private static final String REST_PATH = "b";

      /**
       * Retrieves a list of buckets for a given project.
       *
       * Create a request for the method "buckets.list".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project A valid API project identifier.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Buckets.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** A valid API project identifier. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** A valid API project identifier.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** A valid API project identifier. */
      public List setProject(java.lang.String project) {
        this.project = project;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A previously-returned page token representing part of the larger set of results to view.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to noAcl.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public List setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      /** Maximum number of buckets to return. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of buckets to return.

     [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of buckets to return. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a bucket. This method supports patch semantics.
     *
     * Create a request for the method "buckets.patch".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.Bucket}
     * @return the request
     */
    public Patch patch(java.lang.String bucket, com.google.api.services.storage.model.Bucket content) throws java.io.IOException {
      Patch result = new Patch(bucket, content);
      initialize(result);
      return result;
    }

    public class Patch extends StorageRequest<com.google.api.services.storage.model.Bucket> {

      private static final String REST_PATH = "b/{bucket}";

      /**
       * Updates a bucket. This method supports patch semantics.
       *
       * Create a request for the method "buckets.patch".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.Bucket}
       * @since 1.13
       */
      protected Patch(java.lang.String bucket, com.google.api.services.storage.model.Bucket content) {
        super(Storage.this, "PATCH", REST_PATH, content, com.google.api.services.storage.model.Bucket.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Patch setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the return of the bucket metadata conditional on whether the bucket's current metageneration
     matches the given value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Patch setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /** Apply a predefined set of access controls to this bucket. */
      @com.google.api.client.util.Key
      private java.lang.String predefinedAcl;

      /** Apply a predefined set of access controls to this bucket.
       */
      public java.lang.String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this bucket. */
      public Patch setPredefinedAcl(java.lang.String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the return of the bucket metadata conditional on whether the bucket's current metageneration
     does not match the given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Patch setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Set of properties to return. Defaults to full. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to full.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to full. */
      public Patch setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a bucket.
     *
     * Create a request for the method "buckets.update".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.Bucket}
     * @return the request
     */
    public Update update(java.lang.String bucket, com.google.api.services.storage.model.Bucket content) throws java.io.IOException {
      Update result = new Update(bucket, content);
      initialize(result);
      return result;
    }

    public class Update extends StorageRequest<com.google.api.services.storage.model.Bucket> {

      private static final String REST_PATH = "b/{bucket}";

      /**
       * Updates a bucket.
       *
       * Create a request for the method "buckets.update".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.Bucket}
       * @since 1.13
       */
      protected Update(java.lang.String bucket, com.google.api.services.storage.model.Bucket content) {
        super(Storage.this, "PUT", REST_PATH, content, com.google.api.services.storage.model.Bucket.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Update setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the return of the bucket metadata conditional on whether the bucket's current metageneration
     matches the given value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Update setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /** Apply a predefined set of access controls to this bucket. */
      @com.google.api.client.util.Key
      private java.lang.String predefinedAcl;

      /** Apply a predefined set of access controls to this bucket.
       */
      public java.lang.String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this bucket. */
      public Update setPredefinedAcl(java.lang.String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the return of the bucket metadata conditional on whether the bucket's current metageneration
     does not match the given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Update setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Set of properties to return. Defaults to full. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to full.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to full. */
      public Update setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Channels.List request = storage.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /**
   * The "channels" collection of methods.
   */
  public class Channels {

    /**
     * Stop watching resources through this channel
     *
     * Create a request for the method "channels.stop".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.storage.model.Channel}
     * @return the request
     */
    public Stop stop(com.google.api.services.storage.model.Channel content) throws java.io.IOException {
      Stop result = new Stop(content);
      initialize(result);
      return result;
    }

    public class Stop extends StorageRequest<Void> {

      private static final String REST_PATH = "channels/stop";

      /**
       * Stop watching resources through this channel
       *
       * Create a request for the method "channels.stop".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p> {@link
       * Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.storage.model.Channel}
       * @since 1.13
       */
      protected Stop(com.google.api.services.storage.model.Channel content) {
        super(Storage.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public Stop setAlt(java.lang.String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setFields(java.lang.String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(java.lang.String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(java.lang.String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(java.lang.String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUserIp(java.lang.String userIp) {
        return (Stop) super.setUserIp(userIp);
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the DefaultObjectAccessControls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.DefaultObjectAccessControls.List request = storage.defaultObjectAccessControls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public DefaultObjectAccessControls defaultObjectAccessControls() {
    return new DefaultObjectAccessControls();
  }

  /**
   * The "defaultObjectAccessControls" collection of methods.
   */
  public class DefaultObjectAccessControls {

    /**
     * Permanently deletes the default object ACL entry for the specified entity on the specified
     * bucket.
     *
     * Create a request for the method "defaultObjectAccessControls.delete".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Delete delete(java.lang.String bucket, java.lang.String entity) throws java.io.IOException {
      Delete result = new Delete(bucket, entity);
      initialize(result);
      return result;
    }

    public class Delete extends StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";

      /**
       * Permanently deletes the default object ACL entry for the specified entity on the specified
       * bucket.
       *
       * Create a request for the method "defaultObjectAccessControls.delete".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Delete(java.lang.String bucket, java.lang.String entity) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Delete setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Delete setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the default object ACL entry for the specified entity on the specified bucket.
     *
     * Create a request for the method "defaultObjectAccessControls.get".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Get get(java.lang.String bucket, java.lang.String entity) throws java.io.IOException {
      Get result = new Get(bucket, entity);
      initialize(result);
      return result;
    }

    public class Get extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";

      /**
       * Returns the default object ACL entry for the specified entity on the specified bucket.
       *
       * Create a request for the method "defaultObjectAccessControls.get".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Get(java.lang.String bucket, java.lang.String entity) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Get setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Get setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new default object ACL entry on the specified bucket.
     *
     * Create a request for the method "defaultObjectAccessControls.insert".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Insert insert(java.lang.String bucket, com.google.api.services.storage.model.ObjectAccessControl content) throws java.io.IOException {
      Insert result = new Insert(bucket, content);
      initialize(result);
      return result;
    }

    public class Insert extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";

      /**
       * Creates a new default object ACL entry on the specified bucket.
       *
       * Create a request for the method "defaultObjectAccessControls.insert".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Insert(java.lang.String bucket, com.google.api.services.storage.model.ObjectAccessControl content) {
        super(Storage.this, "POST", REST_PATH, content, com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Insert setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves default object ACL entries on the specified bucket.
     *
     * Create a request for the method "defaultObjectAccessControls.list".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public List list(java.lang.String bucket) throws java.io.IOException {
      List result = new List(bucket);
      initialize(result);
      return result;
    }

    public class List extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControls> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";

      /**
       * Retrieves default object ACL entries on the specified bucket.
       *
       * Create a request for the method "defaultObjectAccessControls.list".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected List(java.lang.String bucket) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControls.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public List setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * If present, only return default ACL listing if the bucket's current metageneration matches
       * this value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** If present, only return default ACL listing if the bucket's current metageneration matches this
     value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * If present, only return default ACL listing if the bucket's current metageneration matches
       * this value.
       */
      public List setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * If present, only return default ACL listing if the bucket's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** If present, only return default ACL listing if the bucket's current metageneration does not match
     the given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * If present, only return default ACL listing if the bucket's current metageneration does not
       * match the given value.
       */
      public List setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a default object ACL entry on the specified bucket. This method supports patch semantics.
     *
     * Create a request for the method "defaultObjectAccessControls.patch".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Patch patch(java.lang.String bucket, java.lang.String entity, com.google.api.services.storage.model.ObjectAccessControl content) throws java.io.IOException {
      Patch result = new Patch(bucket, entity, content);
      initialize(result);
      return result;
    }

    public class Patch extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";

      /**
       * Updates a default object ACL entry on the specified bucket. This method supports patch
       * semantics.
       *
       * Create a request for the method "defaultObjectAccessControls.patch".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Patch(java.lang.String bucket, java.lang.String entity, com.google.api.services.storage.model.ObjectAccessControl content) {
        super(Storage.this, "PATCH", REST_PATH, content, com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Patch setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Patch setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a default object ACL entry on the specified bucket.
     *
     * Create a request for the method "defaultObjectAccessControls.update".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Update update(java.lang.String bucket, java.lang.String entity, com.google.api.services.storage.model.ObjectAccessControl content) throws java.io.IOException {
      Update result = new Update(bucket, entity, content);
      initialize(result);
      return result;
    }

    public class Update extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";

      /**
       * Updates a default object ACL entry on the specified bucket.
       *
       * Create a request for the method "defaultObjectAccessControls.update".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Update(java.lang.String bucket, java.lang.String entity, com.google.api.services.storage.model.ObjectAccessControl content) {
        super(Storage.this, "PUT", REST_PATH, content, com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Update setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Update setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ObjectAccessControls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.ObjectAccessControls.List request = storage.objectAccessControls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ObjectAccessControls objectAccessControls() {
    return new ObjectAccessControls();
  }

  /**
   * The "objectAccessControls" collection of methods.
   */
  public class ObjectAccessControls {

    /**
     * Permanently deletes the ACL entry for the specified entity on the specified object.
     *
     * Create a request for the method "objectAccessControls.delete".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Delete delete(java.lang.String bucket, java.lang.String object__, java.lang.String entity) throws java.io.IOException {
      Delete result = new Delete(bucket, object__, entity);
      initialize(result);
      return result;
    }

    public class Delete extends StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";

      /**
       * Permanently deletes the ACL entry for the specified entity on the specified object.
       *
       * Create a request for the method "objectAccessControls.delete".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Delete(java.lang.String bucket, java.lang.String object__, java.lang.String entity) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Delete setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Delete setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Delete setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Delete setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the ACL entry for the specified entity on the specified object.
     *
     * Create a request for the method "objectAccessControls.get".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Get get(java.lang.String bucket, java.lang.String object__, java.lang.String entity) throws java.io.IOException {
      Get result = new Get(bucket, object__, entity);
      initialize(result);
      return result;
    }

    public class Get extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";

      /**
       * Returns the ACL entry for the specified entity on the specified object.
       *
       * Create a request for the method "objectAccessControls.get".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Get(java.lang.String bucket, java.lang.String object__, java.lang.String entity) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Get setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Get setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Get setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Get setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new ACL entry on the specified object.
     *
     * Create a request for the method "objectAccessControls.insert".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Insert insert(java.lang.String bucket, java.lang.String object__, com.google.api.services.storage.model.ObjectAccessControl content) throws java.io.IOException {
      Insert result = new Insert(bucket, object__, content);
      initialize(result);
      return result;
    }

    public class Insert extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl";

      /**
       * Creates a new ACL entry on the specified object.
       *
       * Create a request for the method "objectAccessControls.insert".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Insert(java.lang.String bucket, java.lang.String object__, com.google.api.services.storage.model.ObjectAccessControl content) {
        super(Storage.this, "POST", REST_PATH, content, com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Insert setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Insert setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Insert setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves ACL entries on the specified object.
     *
     * Create a request for the method "objectAccessControls.list".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object.
     * @return the request
     */
    public List list(java.lang.String bucket, java.lang.String object__) throws java.io.IOException {
      List result = new List(bucket, object__);
      initialize(result);
      return result;
    }

    public class List extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControls> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl";

      /**
       * Retrieves ACL entries on the specified object.
       *
       * Create a request for the method "objectAccessControls.list".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object.
       * @since 1.13
       */
      protected List(java.lang.String bucket, java.lang.String object__) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.ObjectAccessControls.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public List setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public List setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public List setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an ACL entry on the specified object. This method supports patch semantics.
     *
     * Create a request for the method "objectAccessControls.patch".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Patch patch(java.lang.String bucket, java.lang.String object__, java.lang.String entity, com.google.api.services.storage.model.ObjectAccessControl content) throws java.io.IOException {
      Patch result = new Patch(bucket, object__, entity, content);
      initialize(result);
      return result;
    }

    public class Patch extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";

      /**
       * Updates an ACL entry on the specified object. This method supports patch semantics.
       *
       * Create a request for the method "objectAccessControls.patch".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Patch(java.lang.String bucket, java.lang.String object__, java.lang.String entity, com.google.api.services.storage.model.ObjectAccessControl content) {
        super(Storage.this, "PATCH", REST_PATH, content, com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Patch setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Patch setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Patch setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Patch setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an ACL entry on the specified object.
     *
     * Create a request for the method "objectAccessControls.update".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Update update(java.lang.String bucket, java.lang.String object__, java.lang.String entity, com.google.api.services.storage.model.ObjectAccessControl content) throws java.io.IOException {
      Update result = new Update(bucket, object__, entity, content);
      initialize(result);
      return result;
    }

    public class Update extends StorageRequest<com.google.api.services.storage.model.ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";

      /**
       * Updates an ACL entry on the specified object.
       *
       * Create a request for the method "objectAccessControls.update".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     *        emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Update(java.lang.String bucket, java.lang.String object__, java.lang.String entity, com.google.api.services.storage.model.ObjectAccessControl content) {
        super(Storage.this, "PUT", REST_PATH, content, com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
        this.entity = com.google.api.client.util.Preconditions.checkNotNull(entity, "Required parameter entity must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of a bucket.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Update setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Update setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key
      private java.lang.String entity;

      /** The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId, group-
     emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public java.lang.String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Update setEntity(java.lang.String entity) {
        this.entity = entity;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Update setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Objects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Objects.List request = storage.objects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Objects objects() {
    return new Objects();
  }

  /**
   * The "objects" collection of methods.
   */
  public class Objects {

    /**
     * Concatenates a list of existing objects into a new object in the same bucket.
     *
     * Create a request for the method "objects.compose".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Compose#execute()} method to invoke the remote operation.
     *
     * @param destinationBucket Name of the bucket in which to store the new object.
     * @param destinationObject Name of the new object.
     * @param content the {@link com.google.api.services.storage.model.ComposeRequest}
     * @return the request
     */
    public Compose compose(java.lang.String destinationBucket, java.lang.String destinationObject, com.google.api.services.storage.model.ComposeRequest content) throws java.io.IOException {
      Compose result = new Compose(destinationBucket, destinationObject, content);
      initialize(result);
      return result;
    }

    public class Compose extends StorageRequest<com.google.api.services.storage.model.StorageObject> {

      private static final String REST_PATH = "b/{destinationBucket}/o/{destinationObject}/compose";

      /**
       * Concatenates a list of existing objects into a new object in the same bucket.
       *
       * Create a request for the method "objects.compose".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Compose#execute()} method to invoke the remote operation. <p>
       * {@link
       * Compose#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param destinationBucket Name of the bucket in which to store the new object.
       * @param destinationObject Name of the new object.
       * @param content the {@link com.google.api.services.storage.model.ComposeRequest}
       * @since 1.13
       */
      protected Compose(java.lang.String destinationBucket, java.lang.String destinationObject, com.google.api.services.storage.model.ComposeRequest content) {
        super(Storage.this, "POST", REST_PATH, content, com.google.api.services.storage.model.StorageObject.class);
        this.destinationBucket = com.google.api.client.util.Preconditions.checkNotNull(destinationBucket, "Required parameter destinationBucket must be specified.");
        this.destinationObject = com.google.api.client.util.Preconditions.checkNotNull(destinationObject, "Required parameter destinationObject must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public Compose setAlt(java.lang.String alt) {
        return (Compose) super.setAlt(alt);
      }

      @Override
      public Compose setFields(java.lang.String fields) {
        return (Compose) super.setFields(fields);
      }

      @Override
      public Compose setKey(java.lang.String key) {
        return (Compose) super.setKey(key);
      }

      @Override
      public Compose setOauthToken(java.lang.String oauthToken) {
        return (Compose) super.setOauthToken(oauthToken);
      }

      @Override
      public Compose setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Compose) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Compose setQuotaUser(java.lang.String quotaUser) {
        return (Compose) super.setQuotaUser(quotaUser);
      }

      @Override
      public Compose setUserIp(java.lang.String userIp) {
        return (Compose) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to store the new object. */
      @com.google.api.client.util.Key
      private java.lang.String destinationBucket;

      /** Name of the bucket in which to store the new object.
       */
      public java.lang.String getDestinationBucket() {
        return destinationBucket;
      }

      /** Name of the bucket in which to store the new object. */
      public Compose setDestinationBucket(java.lang.String destinationBucket) {
        this.destinationBucket = destinationBucket;
        return this;
      }

      /** Name of the new object. */
      @com.google.api.client.util.Key
      private java.lang.String destinationObject;

      /** Name of the new object.
       */
      public java.lang.String getDestinationObject() {
        return destinationObject;
      }

      /** Name of the new object. */
      public Compose setDestinationObject(java.lang.String destinationObject) {
        this.destinationObject = destinationObject;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationMatch;

      /** Makes the operation conditional on whether the object's current generation matches the given value.
       */
      public java.lang.Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      public Compose setIfGenerationMatch(java.lang.Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the operation conditional on whether the object's current metageneration matches the given
     value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Compose setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /** Apply a predefined set of access controls to the destination object. */
      @com.google.api.client.util.Key
      private java.lang.String destinationPredefinedAcl;

      /** Apply a predefined set of access controls to the destination object.
       */
      public java.lang.String getDestinationPredefinedAcl() {
        return destinationPredefinedAcl;
      }

      /** Apply a predefined set of access controls to the destination object. */
      public Compose setDestinationPredefinedAcl(java.lang.String destinationPredefinedAcl) {
        this.destinationPredefinedAcl = destinationPredefinedAcl;
        return this;
      }

      @Override
      public Compose set(String parameterName, Object value) {
        return (Compose) super.set(parameterName, value);
      }
    }
    /**
     * Copies an object to a specified location. Optionally overrides metadata.
     *
     * Create a request for the method "objects.copy".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Copy#execute()} method to invoke the remote operation.
     *
     * @param sourceBucket Name of the bucket in which to find the source object.
     * @param sourceObject Name of the source object.
     * @param destinationBucket Name of the bucket in which to store the new object. Overrides the provided object metadata's bucket
     *        value, if any.
     * @param destinationObject Name of the new object. Required when the object metadata is not otherwise provided. Overrides the
     *        object metadata's name value, if any.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Copy copy(java.lang.String sourceBucket, java.lang.String sourceObject, java.lang.String destinationBucket, java.lang.String destinationObject, com.google.api.services.storage.model.StorageObject content) throws java.io.IOException {
      Copy result = new Copy(sourceBucket, sourceObject, destinationBucket, destinationObject, content);
      initialize(result);
      return result;
    }

    public class Copy extends StorageRequest<com.google.api.services.storage.model.StorageObject> {

      private static final String REST_PATH = "b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}";

      /**
       * Copies an object to a specified location. Optionally overrides metadata.
       *
       * Create a request for the method "objects.copy".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Copy#execute()} method to invoke the remote operation. <p> {@link
       * Copy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param sourceBucket Name of the bucket in which to find the source object.
       * @param sourceObject Name of the source object.
       * @param destinationBucket Name of the bucket in which to store the new object. Overrides the provided object metadata's bucket
     *        value, if any.
       * @param destinationObject Name of the new object. Required when the object metadata is not otherwise provided. Overrides the
     *        object metadata's name value, if any.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Copy(java.lang.String sourceBucket, java.lang.String sourceObject, java.lang.String destinationBucket, java.lang.String destinationObject, com.google.api.services.storage.model.StorageObject content) {
        super(Storage.this, "POST", REST_PATH, content, com.google.api.services.storage.model.StorageObject.class);
        this.sourceBucket = com.google.api.client.util.Preconditions.checkNotNull(sourceBucket, "Required parameter sourceBucket must be specified.");
        this.sourceObject = com.google.api.client.util.Preconditions.checkNotNull(sourceObject, "Required parameter sourceObject must be specified.");
        this.destinationBucket = com.google.api.client.util.Preconditions.checkNotNull(destinationBucket, "Required parameter destinationBucket must be specified.");
        this.destinationObject = com.google.api.client.util.Preconditions.checkNotNull(destinationObject, "Required parameter destinationObject must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public Copy setAlt(java.lang.String alt) {
        return (Copy) super.setAlt(alt);
      }

      @Override
      public Copy setFields(java.lang.String fields) {
        return (Copy) super.setFields(fields);
      }

      @Override
      public Copy setKey(java.lang.String key) {
        return (Copy) super.setKey(key);
      }

      @Override
      public Copy setOauthToken(java.lang.String oauthToken) {
        return (Copy) super.setOauthToken(oauthToken);
      }

      @Override
      public Copy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Copy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Copy setQuotaUser(java.lang.String quotaUser) {
        return (Copy) super.setQuotaUser(quotaUser);
      }

      @Override
      public Copy setUserIp(java.lang.String userIp) {
        return (Copy) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to find the source object. */
      @com.google.api.client.util.Key
      private java.lang.String sourceBucket;

      /** Name of the bucket in which to find the source object.
       */
      public java.lang.String getSourceBucket() {
        return sourceBucket;
      }

      /** Name of the bucket in which to find the source object. */
      public Copy setSourceBucket(java.lang.String sourceBucket) {
        this.sourceBucket = sourceBucket;
        return this;
      }

      /** Name of the source object. */
      @com.google.api.client.util.Key
      private java.lang.String sourceObject;

      /** Name of the source object.
       */
      public java.lang.String getSourceObject() {
        return sourceObject;
      }

      /** Name of the source object. */
      public Copy setSourceObject(java.lang.String sourceObject) {
        this.sourceObject = sourceObject;
        return this;
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      @com.google.api.client.util.Key
      private java.lang.String destinationBucket;

      /** Name of the bucket in which to store the new object. Overrides the provided object metadata's
     bucket value, if any.
       */
      public java.lang.String getDestinationBucket() {
        return destinationBucket;
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      public Copy setDestinationBucket(java.lang.String destinationBucket) {
        this.destinationBucket = destinationBucket;
        return this;
      }

      /**
       * Name of the new object. Required when the object metadata is not otherwise provided.
       * Overrides the object metadata's name value, if any.
       */
      @com.google.api.client.util.Key
      private java.lang.String destinationObject;

      /** Name of the new object. Required when the object metadata is not otherwise provided. Overrides the
     object metadata's name value, if any.
       */
      public java.lang.String getDestinationObject() {
        return destinationObject;
      }

      /**
       * Name of the new object. Required when the object metadata is not otherwise provided.
       * Overrides the object metadata's name value, if any.
       */
      public Copy setDestinationObject(java.lang.String destinationObject) {
        this.destinationObject = destinationObject;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's generation does not match
       * the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifSourceGenerationNotMatch;

      /** Makes the operation conditional on whether the source object's generation does not match the given
     value.
       */
      public java.lang.Long getIfSourceGenerationNotMatch() {
        return ifSourceGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's generation does not match
       * the given value.
       */
      public Copy setIfSourceGenerationNotMatch(java.lang.Long ifSourceGenerationNotMatch) {
        this.ifSourceGenerationNotMatch = ifSourceGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current generation does
       * not match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationNotMatch;

      /** Makes the operation conditional on whether the destination object's current generation does not
     match the given value.
       */
      public java.lang.Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current generation does
       * not match the given value.
       */
      public Copy setIfGenerationNotMatch(java.lang.Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifSourceMetagenerationNotMatch;

      /** Makes the operation conditional on whether the source object's current metageneration does not
     match the given value.
       */
      public java.lang.Long getIfSourceMetagenerationNotMatch() {
        return ifSourceMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      public Copy setIfSourceMetagenerationNotMatch(java.lang.Long ifSourceMetagenerationNotMatch) {
        this.ifSourceMetagenerationNotMatch = ifSourceMetagenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * matches the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the operation conditional on whether the destination object's current metageneration matches
     the given value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * matches the given value.
       */
      public Copy setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * If present, selects a specific revision of the source object (as opposed to the latest
       * version, the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long sourceGeneration;

      /** If present, selects a specific revision of the source object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getSourceGeneration() {
        return sourceGeneration;
      }

      /**
       * If present, selects a specific revision of the source object (as opposed to the latest
       * version, the default).
       */
      public Copy setSourceGeneration(java.lang.Long sourceGeneration) {
        this.sourceGeneration = sourceGeneration;
        return this;
      }

      /** Apply a predefined set of access controls to the destination object. */
      @com.google.api.client.util.Key
      private java.lang.String destinationPredefinedAcl;

      /** Apply a predefined set of access controls to the destination object.
       */
      public java.lang.String getDestinationPredefinedAcl() {
        return destinationPredefinedAcl;
      }

      /** Apply a predefined set of access controls to the destination object. */
      public Copy setDestinationPredefinedAcl(java.lang.String destinationPredefinedAcl) {
        this.destinationPredefinedAcl = destinationPredefinedAcl;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's generation matches the given
       * value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifSourceGenerationMatch;

      /** Makes the operation conditional on whether the source object's generation matches the given value.
       */
      public java.lang.Long getIfSourceGenerationMatch() {
        return ifSourceGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's generation matches the given
       * value.
       */
      public Copy setIfSourceGenerationMatch(java.lang.Long ifSourceGenerationMatch) {
        this.ifSourceGenerationMatch = ifSourceGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifSourceMetagenerationMatch;

      /** Makes the operation conditional on whether the source object's current metageneration matches the
     given value.
       */
      public java.lang.Long getIfSourceMetagenerationMatch() {
        return ifSourceMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      public Copy setIfSourceMetagenerationMatch(java.lang.Long ifSourceMetagenerationMatch) {
        this.ifSourceMetagenerationMatch = ifSourceMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current generation
       * matches the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationMatch;

      /** Makes the operation conditional on whether the destination object's current generation matches the
     given value.
       */
      public java.lang.Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current generation
       * matches the given value.
       */
      public Copy setIfGenerationMatch(java.lang.Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * does not match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the operation conditional on whether the destination object's current metageneration does not
     match the given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * does not match the given value.
       */
      public Copy setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to noAcl, unless the object resource specifies the acl
     property, when it defaults to full.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      public Copy setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Copy set(String parameterName, Object value) {
        return (Copy) super.set(parameterName, value);
      }
    }
    /**
     * Deletes an object and its metadata. Deletions are permanent if versioning is not enabled for the
     * bucket, or if the generation parameter is used.
     *
     * Create a request for the method "objects.delete".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object.
     * @return the request
     */
    public Delete delete(java.lang.String bucket, java.lang.String object__) throws java.io.IOException {
      Delete result = new Delete(bucket, object__);
      initialize(result);
      return result;
    }

    public class Delete extends StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/o/{object}";

      /**
       * Deletes an object and its metadata. Deletions are permanent if versioning is not enabled for
       * the bucket, or if the generation parameter is used.
       *
       * Create a request for the method "objects.delete".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object.
       * @since 1.13
       */
      protected Delete(java.lang.String bucket, java.lang.String object__) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of the bucket in which the object resides.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public Delete setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Delete setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationNotMatch;

      /** Makes the operation conditional on whether the object's current generation does not match the given
     value.
       */
      public java.lang.Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value.
       */
      public Delete setIfGenerationNotMatch(java.lang.Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * If present, permanently deletes a specific revision of this object (as opposed to the
       * latest version, the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, permanently deletes a specific revision of this object (as opposed to the latest
     version, the default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, permanently deletes a specific revision of this object (as opposed to the
       * latest version, the default).
       */
      public Delete setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the operation conditional on whether the object's current metageneration matches the given
     value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Delete setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationMatch;

      /** Makes the operation conditional on whether the object's current generation matches the given value.
       */
      public java.lang.Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      public Delete setIfGenerationMatch(java.lang.Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the operation conditional on whether the object's current metageneration does not match the
     given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Delete setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves an object or its metadata.
     *
     * Create a request for the method "objects.get".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object.
     * @return the request
     */
    public Get get(java.lang.String bucket, java.lang.String object__) throws java.io.IOException {
      Get result = new Get(bucket, object__);
      initialize(result);
      return result;
    }

    public class Get extends StorageRequest<com.google.api.services.storage.model.StorageObject> {

      private static final String REST_PATH = "b/{bucket}/o/{object}";

      /**
       * Retrieves an object or its metadata.
       *
       * Create a request for the method "objects.get".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object.
       * @since 1.13
       */
      protected Get(java.lang.String bucket, java.lang.String object__) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.StorageObject.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of the bucket in which the object resides.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public Get setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Get setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's generation does not match the given
       * value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationNotMatch;

      /** Makes the operation conditional on whether the object's generation does not match the given value.
       */
      public java.lang.Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's generation does not match the given
       * value.
       */
      public Get setIfGenerationNotMatch(java.lang.Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Get setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the operation conditional on whether the object's current metageneration matches the given
     value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Get setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's generation matches the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationMatch;

      /** Makes the operation conditional on whether the object's generation matches the given value.
       */
      public java.lang.Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's generation matches the given value.
       */
      public Get setIfGenerationMatch(java.lang.Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the operation conditional on whether the object's current metageneration does not match the
     given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Get setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to noAcl.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public Get setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Stores a new object and metadata.
     *
     * Create a request for the method "objects.insert".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which to store the new object. Overrides the provided object metadata's bucket
     *        value, if any.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Insert insert(java.lang.String bucket, com.google.api.services.storage.model.StorageObject content) throws java.io.IOException {
      Insert result = new Insert(bucket, content);
      initialize(result);
      return result;
    }

    /**
     * Stores a new object and metadata.
     *
     * Create a request for the method "objects.insert".
     *
     * This request holds the parameters needed by the the storage server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param bucket Name of the bucket in which to store the new object. Overrides the provided object metadata's bucket
     *        value, if any.
     * @param content the {@link com.google.api.services.storage.model.StorageObject} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.lang.String bucket, com.google.api.services.storage.model.StorageObject content,
        com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(bucket, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends StorageRequest<com.google.api.services.storage.model.StorageObject> {

      private static final String REST_PATH = "b/{bucket}/o";

      /**
       * Stores a new object and metadata.
       *
       * Create a request for the method "objects.insert".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of the bucket in which to store the new object. Overrides the provided object metadata's bucket
     *        value, if any.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Insert(java.lang.String bucket, com.google.api.services.storage.model.StorageObject content) {
        super(Storage.this, "POST", REST_PATH, content, com.google.api.services.storage.model.StorageObject.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        initializeMediaDownload();
      }

      /**
       * Stores a new object and metadata.
       *
       * Create a request for the method "objects.insert".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param bucket Name of the bucket in which to store the new object. Overrides the provided object metadata's bucket
     *        value, if any.
       * @param content the {@link com.google.api.services.storage.model.StorageObject} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(java.lang.String bucket, com.google.api.services.storage.model.StorageObject content,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Storage.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.storage.model.StorageObject.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of the bucket in which to store the new object. Overrides the provided object metadata's
     bucket value, if any.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      public Insert setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Apply a predefined set of access controls to this object. */
      @com.google.api.client.util.Key
      private java.lang.String predefinedAcl;

      /** Apply a predefined set of access controls to this object.
       */
      public java.lang.String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this object. */
      public Insert setPredefinedAcl(java.lang.String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to noAcl, unless the object resource specifies the acl
     property, when it defaults to full.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      public Insert setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationNotMatch;

      /** Makes the operation conditional on whether the object's current generation does not match the given
     value.
       */
      public java.lang.Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value.
       */
      public Insert setIfGenerationNotMatch(java.lang.Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the operation conditional on whether the object's current metageneration matches the given
     value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Insert setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * If set, sets the contentEncoding property of the final object to this value. Setting this
       * parameter is equivalent to setting the contentEncoding metadata property. This can be
       * useful when uploading an object with uploadType=media to indicate the encoding of the
       * content being uploaded.
       */
      @com.google.api.client.util.Key
      private java.lang.String contentEncoding;

      /** If set, sets the contentEncoding property of the final object to this value. Setting this parameter
     is equivalent to setting the contentEncoding metadata property. This can be useful when uploading
     an object with uploadType=media to indicate the encoding of the content being uploaded.
       */
      public java.lang.String getContentEncoding() {
        return contentEncoding;
      }

      /**
       * If set, sets the contentEncoding property of the final object to this value. Setting this
       * parameter is equivalent to setting the contentEncoding metadata property. This can be
       * useful when uploading an object with uploadType=media to indicate the encoding of the
       * content being uploaded.
       */
      public Insert setContentEncoding(java.lang.String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationMatch;

      /** Makes the operation conditional on whether the object's current generation matches the given value.
       */
      public java.lang.Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      public Insert setIfGenerationMatch(java.lang.Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the operation conditional on whether the object's current metageneration does not match the
     given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Insert setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /**
       * Name of the object. Required when the object metadata is not otherwise provided. Overrides
       * the object metadata's name value, if any.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Name of the object. Required when the object metadata is not otherwise provided. Overrides the
     object metadata's name value, if any.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Name of the object. Required when the object metadata is not otherwise provided. Overrides
       * the object metadata's name value, if any.
       */
      public Insert setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of objects matching the criteria.
     *
     * Create a request for the method "objects.list".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which to look for objects.
     * @return the request
     */
    public List list(java.lang.String bucket) throws java.io.IOException {
      List result = new List(bucket);
      initialize(result);
      return result;
    }

    public class List extends StorageRequest<com.google.api.services.storage.model.Objects> {

      private static final String REST_PATH = "b/{bucket}/o";

      /**
       * Retrieves a list of objects matching the criteria.
       *
       * Create a request for the method "objects.list".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of the bucket in which to look for objects.
       * @since 1.13
       */
      protected List(java.lang.String bucket) {
        super(Storage.this, "GET", REST_PATH, null, com.google.api.services.storage.model.Objects.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to look for objects. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of the bucket in which to look for objects.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which to look for objects. */
      public List setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to noAcl.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public List setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      /** If true, lists all versions of a file as distinct results. */
      @com.google.api.client.util.Key
      private java.lang.Boolean versions;

      /** If true, lists all versions of a file as distinct results.
       */
      public java.lang.Boolean getVersions() {
        return versions;
      }

      /** If true, lists all versions of a file as distinct results. */
      public List setVersions(java.lang.Boolean versions) {
        this.versions = versions;
        return this;
      }

      /** Filter results to objects whose names begin with this prefix. */
      @com.google.api.client.util.Key
      private java.lang.String prefix;

      /** Filter results to objects whose names begin with this prefix.
       */
      public java.lang.String getPrefix() {
        return prefix;
      }

      /** Filter results to objects whose names begin with this prefix. */
      public List setPrefix(java.lang.String prefix) {
        this.prefix = prefix;
        return this;
      }

      /**
       * Maximum number of items plus prefixes to return. As duplicate prefixes are omitted, fewer
       * total results may be returned than requested.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of items plus prefixes to return. As duplicate prefixes are omitted, fewer total
     results may be returned than requested.

     [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of items plus prefixes to return. As duplicate prefixes are omitted, fewer
       * total results may be returned than requested.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A previously-returned page token representing part of the larger set of results to view.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      @com.google.api.client.util.Key
      private java.lang.String delimiter;

      /** Returns results in a directory-like mode. items will contain only objects whose names, aside from
     the prefix, do not contain delimiter. Objects whose names, aside from the prefix, contain delimiter
     will have their name, truncated after the delimiter, returned in prefixes. Duplicate prefixes are
     omitted.
       */
      public java.lang.String getDelimiter() {
        return delimiter;
      }

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      public List setDelimiter(java.lang.String delimiter) {
        this.delimiter = delimiter;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an object's metadata. This method supports patch semantics.
     *
     * Create a request for the method "objects.patch".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Patch patch(java.lang.String bucket, java.lang.String object__, com.google.api.services.storage.model.StorageObject content) throws java.io.IOException {
      Patch result = new Patch(bucket, object__, content);
      initialize(result);
      return result;
    }

    public class Patch extends StorageRequest<com.google.api.services.storage.model.StorageObject> {

      private static final String REST_PATH = "b/{bucket}/o/{object}";

      /**
       * Updates an object's metadata. This method supports patch semantics.
       *
       * Create a request for the method "objects.patch".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Patch(java.lang.String bucket, java.lang.String object__, com.google.api.services.storage.model.StorageObject content) {
        super(Storage.this, "PATCH", REST_PATH, content, com.google.api.services.storage.model.StorageObject.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of the bucket in which the object resides.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public Patch setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Patch setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /** Apply a predefined set of access controls to this object. */
      @com.google.api.client.util.Key
      private java.lang.String predefinedAcl;

      /** Apply a predefined set of access controls to this object.
       */
      public java.lang.String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this object. */
      public Patch setPredefinedAcl(java.lang.String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationNotMatch;

      /** Makes the operation conditional on whether the object's current generation does not match the given
     value.
       */
      public java.lang.Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value.
       */
      public Patch setIfGenerationNotMatch(java.lang.Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Patch setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the operation conditional on whether the object's current metageneration matches the given
     value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Patch setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationMatch;

      /** Makes the operation conditional on whether the object's current generation matches the given value.
       */
      public java.lang.Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      public Patch setIfGenerationMatch(java.lang.Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the operation conditional on whether the object's current metageneration does not match the
     given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Patch setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Set of properties to return. Defaults to full. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to full.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to full. */
      public Patch setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an object's metadata.
     *
     * Create a request for the method "objects.update".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Update update(java.lang.String bucket, java.lang.String object__, com.google.api.services.storage.model.StorageObject content) throws java.io.IOException {
      Update result = new Update(bucket, object__, content);
      initialize(result);
      return result;
    }

    public class Update extends StorageRequest<com.google.api.services.storage.model.StorageObject> {

      private static final String REST_PATH = "b/{bucket}/o/{object}";

      /**
       * Updates an object's metadata.
       *
       * Create a request for the method "objects.update".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Update(java.lang.String bucket, java.lang.String object__, com.google.api.services.storage.model.StorageObject content) {
        super(Storage.this, "PUT", REST_PATH, content, com.google.api.services.storage.model.StorageObject.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
        this.object__ = com.google.api.client.util.Preconditions.checkNotNull(object__, "Required parameter object__ must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContentType(), "StorageObject.getContentType()");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of the bucket in which the object resides.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public Update setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the object. */
      @com.google.api.client.util.Key("object")
      private java.lang.String object__;

      /** Name of the object.
       */
      public java.lang.String getObject() {
        return object__;
      }

      /** Name of the object. */
      public Update setObject(java.lang.String object__) {
        this.object__ = object__;
        return this;
      }

      /** Apply a predefined set of access controls to this object. */
      @com.google.api.client.util.Key
      private java.lang.String predefinedAcl;

      /** Apply a predefined set of access controls to this object.
       */
      public java.lang.String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this object. */
      public Update setPredefinedAcl(java.lang.String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationNotMatch;

      /** Makes the operation conditional on whether the object's current generation does not match the given
     value.
       */
      public java.lang.Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value.
       */
      public Update setIfGenerationNotMatch(java.lang.Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key
      private java.lang.Long generation;

      /** If present, selects a specific revision of this object (as opposed to the latest version, the
     default).
       */
      public java.lang.Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Update setGeneration(java.lang.Long generation) {
        this.generation = generation;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationMatch;

      /** Makes the operation conditional on whether the object's current metageneration matches the given
     value.
       */
      public java.lang.Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Update setIfMetagenerationMatch(java.lang.Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifGenerationMatch;

      /** Makes the operation conditional on whether the object's current generation matches the given value.
       */
      public java.lang.Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value.
       */
      public Update setIfGenerationMatch(java.lang.Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key
      private java.lang.Long ifMetagenerationNotMatch;

      /** Makes the operation conditional on whether the object's current metageneration does not match the
     given value.
       */
      public java.lang.Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Update setIfMetagenerationNotMatch(java.lang.Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Set of properties to return. Defaults to full. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to full.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to full. */
      public Update setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Watch for changes on all objects in a bucket.
     *
     * Create a request for the method "objects.watchAll".
     *
     * This request holds the parameters needed by the storage server.  After setting any optional
     * parameters, call the {@link WatchAll#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which to look for objects.
     * @param content the {@link com.google.api.services.storage.model.Channel}
     * @return the request
     */
    public WatchAll watchAll(java.lang.String bucket, com.google.api.services.storage.model.Channel content) throws java.io.IOException {
      WatchAll result = new WatchAll(bucket, content);
      initialize(result);
      return result;
    }

    public class WatchAll extends StorageRequest<com.google.api.services.storage.model.Channel> {

      private static final String REST_PATH = "b/{bucket}/o/watch";

      /**
       * Watch for changes on all objects in a bucket.
       *
       * Create a request for the method "objects.watchAll".
       *
       * This request holds the parameters needed by the the storage server.  After setting any optional
       * parameters, call the {@link WatchAll#execute()} method to invoke the remote operation. <p>
       * {@link
       * WatchAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param bucket Name of the bucket in which to look for objects.
       * @param content the {@link com.google.api.services.storage.model.Channel}
       * @since 1.13
       */
      protected WatchAll(java.lang.String bucket, com.google.api.services.storage.model.Channel content) {
        super(Storage.this, "POST", REST_PATH, content, com.google.api.services.storage.model.Channel.class);
        this.bucket = com.google.api.client.util.Preconditions.checkNotNull(bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public WatchAll setAlt(java.lang.String alt) {
        return (WatchAll) super.setAlt(alt);
      }

      @Override
      public WatchAll setFields(java.lang.String fields) {
        return (WatchAll) super.setFields(fields);
      }

      @Override
      public WatchAll setKey(java.lang.String key) {
        return (WatchAll) super.setKey(key);
      }

      @Override
      public WatchAll setOauthToken(java.lang.String oauthToken) {
        return (WatchAll) super.setOauthToken(oauthToken);
      }

      @Override
      public WatchAll setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (WatchAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public WatchAll setQuotaUser(java.lang.String quotaUser) {
        return (WatchAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public WatchAll setUserIp(java.lang.String userIp) {
        return (WatchAll) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to look for objects. */
      @com.google.api.client.util.Key
      private java.lang.String bucket;

      /** Name of the bucket in which to look for objects.
       */
      public java.lang.String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which to look for objects. */
      public WatchAll setBucket(java.lang.String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Set of properties to return. Defaults to noAcl.
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public WatchAll setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      /** If true, lists all versions of a file as distinct results. */
      @com.google.api.client.util.Key
      private java.lang.Boolean versions;

      /** If true, lists all versions of a file as distinct results.
       */
      public java.lang.Boolean getVersions() {
        return versions;
      }

      /** If true, lists all versions of a file as distinct results. */
      public WatchAll setVersions(java.lang.Boolean versions) {
        this.versions = versions;
        return this;
      }

      /** Filter results to objects whose names begin with this prefix. */
      @com.google.api.client.util.Key
      private java.lang.String prefix;

      /** Filter results to objects whose names begin with this prefix.
       */
      public java.lang.String getPrefix() {
        return prefix;
      }

      /** Filter results to objects whose names begin with this prefix. */
      public WatchAll setPrefix(java.lang.String prefix) {
        this.prefix = prefix;
        return this;
      }

      /**
       * Maximum number of items plus prefixes to return. As duplicate prefixes are omitted, fewer
       * total results may be returned than requested.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of items plus prefixes to return. As duplicate prefixes are omitted, fewer total
     results may be returned than requested.

     [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of items plus prefixes to return. As duplicate prefixes are omitted, fewer
       * total results may be returned than requested.
       */
      public WatchAll setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** A previously-returned page token representing part of the larger set of results to view.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public WatchAll setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      @com.google.api.client.util.Key
      private java.lang.String delimiter;

      /** Returns results in a directory-like mode. items will contain only objects whose names, aside from
     the prefix, do not contain delimiter. Objects whose names, aside from the prefix, contain delimiter
     will have their name, truncated after the delimiter, returned in prefixes. Duplicate prefixes are
     omitted.
       */
      public java.lang.String getDelimiter() {
        return delimiter;
      }

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      public WatchAll setDelimiter(java.lang.String delimiter) {
        this.delimiter = delimiter;
        return this;
      }

      @Override
      public WatchAll set(String parameterName, Object value) {
        return (WatchAll) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Storage}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Storage}. */
    @Override
    public Storage build() {
      return new Storage(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link StorageRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setStorageRequestInitializer(
        StorageRequestInitializer storageRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(storageRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
