/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.sourcerepo.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.sourcerepo.v1.CloudSourceRepositoriesRequest;
import com.google.api.services.sourcerepo.v1.CloudSourceRepositoriesRequestInitializer;
import com.google.api.services.sourcerepo.v1.model.Empty;
import com.google.api.services.sourcerepo.v1.model.ListReposResponse;
import com.google.api.services.sourcerepo.v1.model.Operation;
import com.google.api.services.sourcerepo.v1.model.Policy;
import com.google.api.services.sourcerepo.v1.model.ProjectConfig;
import com.google.api.services.sourcerepo.v1.model.Repo;
import com.google.api.services.sourcerepo.v1.model.SetIamPolicyRequest;
import com.google.api.services.sourcerepo.v1.model.SyncRepoRequest;
import com.google.api.services.sourcerepo.v1.model.TestIamPermissionsRequest;
import com.google.api.services.sourcerepo.v1.model.TestIamPermissionsResponse;
import com.google.api.services.sourcerepo.v1.model.UpdateProjectConfigRequest;
import com.google.api.services.sourcerepo.v1.model.UpdateRepoRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudSourceRepositories
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://sourcerepo.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://sourcerepo.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://sourcerepo.googleapis.com/";

    public CloudSourceRepositories(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudSourceRepositories(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Cloud Source Repositories API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return CloudSourceRepositories.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://sourcerepo.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), CloudSourceRepositories.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudSourceRepositories.DEFAULT_BATCH_PATH);
        }

        public CloudSourceRepositories build() {
            return new CloudSourceRepositories(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudSourceRepositoriesRequestInitializer(CloudSourceRepositoriesRequestInitializer cloudsourcerepositoriesRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudsourcerepositoriesRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public GetConfig getConfig(String name) throws IOException {
            GetConfig result = new GetConfig(name);
            CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateConfig updateConfig(String name, UpdateProjectConfigRequest content) throws IOException {
            UpdateConfig result = new UpdateConfig(name, content);
            CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Repos repos() {
            return new Repos();
        }

        public class Repos {
            public Create create(String parent, Repo content) throws IOException {
                Create result = new Create(parent, content);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetIamPolicy getIamPolicy(String resource) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, UpdateRepoRequest content) throws IOException {
                Patch result = new Patch(name, content);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Sync sync(String name, SyncRepoRequest content) throws IOException {
                Sync result = new Sync(name, content);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                CloudSourceRepositories.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class TestIamPermissions
            extends CloudSourceRepositoriesRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(CloudSourceRepositories.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/repos/.*$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class Sync
            extends CloudSourceRepositoriesRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}:sync";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Sync(String name, SyncRepoRequest content) {
                    super(CloudSourceRepositories.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/repos/.*$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                }

                public Sync set$Xgafv(String $Xgafv) {
                    return (Sync)super.set$Xgafv($Xgafv);
                }

                public Sync setAccessToken(String accessToken) {
                    return (Sync)super.setAccessToken(accessToken);
                }

                public Sync setAlt(String alt) {
                    return (Sync)super.setAlt(alt);
                }

                public Sync setCallback(String callback) {
                    return (Sync)super.setCallback(callback);
                }

                public Sync setFields(String fields) {
                    return (Sync)super.setFields(fields);
                }

                public Sync setKey(String key) {
                    return (Sync)super.setKey(key);
                }

                public Sync setOauthToken(String oauthToken) {
                    return (Sync)super.setOauthToken(oauthToken);
                }

                public Sync setPrettyPrint(Boolean prettyPrint) {
                    return (Sync)super.setPrettyPrint(prettyPrint);
                }

                public Sync setQuotaUser(String quotaUser) {
                    return (Sync)super.setQuotaUser(quotaUser);
                }

                public Sync setUploadType(String uploadType) {
                    return (Sync)super.setUploadType(uploadType);
                }

                public Sync setUploadProtocol(String uploadProtocol) {
                    return (Sync)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Sync setName(String name) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Sync set(String parameterName, Object value) {
                    return (Sync)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends CloudSourceRepositoriesRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(CloudSourceRepositories.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/repos/.*$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Patch
            extends CloudSourceRepositoriesRequest<Repo> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String name, UpdateRepoRequest content) {
                    super(CloudSourceRepositories.this, "PATCH", REST_PATH, (Object)content, Repo.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/repos/.*$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends CloudSourceRepositoriesRequest<ListReposResponse> {
                private static final String REST_PATH = "v1/{+name}/repos";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(CloudSourceRepositories.this, "GET", REST_PATH, null, ListReposResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends CloudSourceRepositoriesRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;
                @Key(value="options.requestedPolicyVersion")
                private Integer optionsRequestedPolicyVersion;

                protected GetIamPolicy(String resource) {
                    super(CloudSourceRepositories.this, "GET", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/repos/.*$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                    this.resource = resource;
                    return this;
                }

                public Integer getOptionsRequestedPolicyVersion() {
                    return this.optionsRequestedPolicyVersion;
                }

                public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                    this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Get
            extends CloudSourceRepositoriesRequest<Repo> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(CloudSourceRepositories.this, "GET", REST_PATH, null, Repo.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/repos/.*$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends CloudSourceRepositoriesRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(CloudSourceRepositories.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/repos/.*$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/repos/.*$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends CloudSourceRepositoriesRequest<Repo> {
                private static final String REST_PATH = "v1/{+parent}/repos";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, Repo content) {
                    super(CloudSourceRepositories.this, "POST", REST_PATH, (Object)content, Repo.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class UpdateConfig
        extends CloudSourceRepositoriesRequest<ProjectConfig> {
            private static final String REST_PATH = "v1/{+name}/config";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected UpdateConfig(String name, UpdateProjectConfigRequest content) {
                super(CloudSourceRepositories.this, "PATCH", REST_PATH, (Object)content, ProjectConfig.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
            }

            public UpdateConfig set$Xgafv(String $Xgafv) {
                return (UpdateConfig)super.set$Xgafv($Xgafv);
            }

            public UpdateConfig setAccessToken(String accessToken) {
                return (UpdateConfig)super.setAccessToken(accessToken);
            }

            public UpdateConfig setAlt(String alt) {
                return (UpdateConfig)super.setAlt(alt);
            }

            public UpdateConfig setCallback(String callback) {
                return (UpdateConfig)super.setCallback(callback);
            }

            public UpdateConfig setFields(String fields) {
                return (UpdateConfig)super.setFields(fields);
            }

            public UpdateConfig setKey(String key) {
                return (UpdateConfig)super.setKey(key);
            }

            public UpdateConfig setOauthToken(String oauthToken) {
                return (UpdateConfig)super.setOauthToken(oauthToken);
            }

            public UpdateConfig setPrettyPrint(Boolean prettyPrint) {
                return (UpdateConfig)super.setPrettyPrint(prettyPrint);
            }

            public UpdateConfig setQuotaUser(String quotaUser) {
                return (UpdateConfig)super.setQuotaUser(quotaUser);
            }

            public UpdateConfig setUploadType(String uploadType) {
                return (UpdateConfig)super.setUploadType(uploadType);
            }

            public UpdateConfig setUploadProtocol(String uploadProtocol) {
                return (UpdateConfig)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateConfig setName(String name) {
                if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public UpdateConfig set(String parameterName, Object value) {
                return (UpdateConfig)super.set(parameterName, value);
            }
        }

        public class GetConfig
        extends CloudSourceRepositoriesRequest<ProjectConfig> {
            private static final String REST_PATH = "v1/{+name}/config";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetConfig(String name) {
                super(CloudSourceRepositories.this, "GET", REST_PATH, null, ProjectConfig.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetConfig set$Xgafv(String $Xgafv) {
                return (GetConfig)super.set$Xgafv($Xgafv);
            }

            public GetConfig setAccessToken(String accessToken) {
                return (GetConfig)super.setAccessToken(accessToken);
            }

            public GetConfig setAlt(String alt) {
                return (GetConfig)super.setAlt(alt);
            }

            public GetConfig setCallback(String callback) {
                return (GetConfig)super.setCallback(callback);
            }

            public GetConfig setFields(String fields) {
                return (GetConfig)super.setFields(fields);
            }

            public GetConfig setKey(String key) {
                return (GetConfig)super.setKey(key);
            }

            public GetConfig setOauthToken(String oauthToken) {
                return (GetConfig)super.setOauthToken(oauthToken);
            }

            public GetConfig setPrettyPrint(Boolean prettyPrint) {
                return (GetConfig)super.setPrettyPrint(prettyPrint);
            }

            public GetConfig setQuotaUser(String quotaUser) {
                return (GetConfig)super.setQuotaUser(quotaUser);
            }

            public GetConfig setUploadType(String uploadType) {
                return (GetConfig)super.setUploadType(uploadType);
            }

            public GetConfig setUploadProtocol(String uploadProtocol) {
                return (GetConfig)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetConfig setName(String name) {
                if (!CloudSourceRepositories.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetConfig set(String parameterName, Object value) {
                return (GetConfig)super.set(parameterName, value);
            }
        }
    }
}

