/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.logging.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.logging.v2.LoggingRequest;
import com.google.api.services.logging.v2.LoggingRequestInitializer;
import com.google.api.services.logging.v2.model.Empty;
import com.google.api.services.logging.v2.model.ListLogEntriesRequest;
import com.google.api.services.logging.v2.model.ListLogEntriesResponse;
import com.google.api.services.logging.v2.model.ListLogMetricsResponse;
import com.google.api.services.logging.v2.model.ListLogsResponse;
import com.google.api.services.logging.v2.model.ListMonitoredResourceDescriptorsResponse;
import com.google.api.services.logging.v2.model.ListSinksResponse;
import com.google.api.services.logging.v2.model.LogMetric;
import com.google.api.services.logging.v2.model.LogSink;
import com.google.api.services.logging.v2.model.WriteLogEntriesRequest;
import com.google.api.services.logging.v2.model.WriteLogEntriesResponse;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logging
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://logging.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://logging.googleapis.com/";

    public Logging(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Logging(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public BillingAccounts billingAccounts() {
        return new BillingAccounts();
    }

    public Entries entries() {
        return new Entries();
    }

    public Folders folders() {
        return new Folders();
    }

    public MonitoredResourceDescriptors monitoredResourceDescriptors() {
        return new MonitoredResourceDescriptors();
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the Stackdriver Logging API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://logging.googleapis.com/", Logging.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Logging build() {
            return new Logging(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setLoggingRequestInitializer(LoggingRequestInitializer loggingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)loggingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Logs logs() {
            return new Logs();
        }

        public Metrics metrics() {
            return new Metrics();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String string, LogSink logSink) throws IOException {
                Create create = new Create(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, LogSink logSink) throws IOException {
                Update update = new Update(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Update(String string, LogSink logSink) {
                    super(Logging.this, "PUT", REST_PATH, (Object)logSink, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^projects/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Update setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Update setUniqueWriterIdentity(Boolean bl) {
                    this.uniqueWriterIdentity = bl;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Get(String string) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^projects/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Get setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^projects/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Delete setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^projects/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Create(String string, LogSink logSink) {
                    super(Logging.this, "POST", REST_PATH, (Object)logSink, LogSink.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Create setUniqueWriterIdentity(Boolean bl) {
                    this.uniqueWriterIdentity = bl;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Metrics {
            public Create create(String string, LogMetric logMetric) throws IOException {
                Create create = new Create(string, logMetric);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, LogMetric logMetric) throws IOException {
                Update update = new Update(string, logMetric);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends LoggingRequest<LogMetric> {
                private static final String REST_PATH = "v2/{+metricName}";
                private final Pattern METRIC_NAME_PATTERN;
                @Key
                private String metricName;

                protected Update(String string, LogMetric logMetric) {
                    super(Logging.this, "PUT", REST_PATH, (Object)logMetric, LogMetric.class);
                    this.METRIC_NAME_PATTERN = Pattern.compile("^projects/[^/]+/metrics/[^/]+$");
                    this.metricName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter metricName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public Update setMetricName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                    this.metricName = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListLogMetricsResponse> {
                private static final String REST_PATH = "v2/{+parent}/metrics";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogMetricsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends LoggingRequest<LogMetric> {
                private static final String REST_PATH = "v2/{+metricName}";
                private final Pattern METRIC_NAME_PATTERN;
                @Key
                private String metricName;

                protected Get(String string) {
                    super(Logging.this, "GET", REST_PATH, null, LogMetric.class);
                    this.METRIC_NAME_PATTERN = Pattern.compile("^projects/[^/]+/metrics/[^/]+$");
                    this.metricName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter metricName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public Get setMetricName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                    this.metricName = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+metricName}";
                private final Pattern METRIC_NAME_PATTERN;
                @Key
                private String metricName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.METRIC_NAME_PATTERN = Pattern.compile("^projects/[^/]+/metrics/[^/]+$");
                    this.metricName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter metricName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public Delete setMetricName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRIC_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter metricName must conform to the pattern ^projects/[^/]+/metrics/[^/]+$");
                    }
                    this.metricName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends LoggingRequest<LogMetric> {
                private static final String REST_PATH = "v2/{+parent}/metrics";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String string, LogMetric logMetric) {
                    super(Logging.this, "POST", REST_PATH, (Object)logMetric, LogMetric.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Logs {
            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v2/{+parent}/logs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+logName}";
                private final Pattern LOG_NAME_PATTERN;
                @Key
                private String logName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.LOG_NAME_PATTERN = Pattern.compile("^projects/[^/]+/logs/[^/]+$");
                    this.logName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter logName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter logName must conform to the pattern ^projects/[^/]+/logs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getLogName() {
                    return this.logName;
                }

                public Delete setLogName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter logName must conform to the pattern ^projects/[^/]+/logs/[^/]+$");
                    }
                    this.logName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }
    }

    public class Organizations {
        public Logs logs() {
            return new Logs();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String string, LogSink logSink) throws IOException {
                Create create = new Create(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, LogSink logSink) throws IOException {
                Update update = new Update(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Update(String string, LogSink logSink) {
                    super(Logging.this, "PUT", REST_PATH, (Object)logSink, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Update setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Update setUniqueWriterIdentity(Boolean bl) {
                    this.uniqueWriterIdentity = bl;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Get(String string) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Get setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Delete setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^organizations/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Create(String string, LogSink logSink) {
                    super(Logging.this, "POST", REST_PATH, (Object)logSink, LogSink.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Create setUniqueWriterIdentity(Boolean bl) {
                    this.uniqueWriterIdentity = bl;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Logs {
            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v2/{+parent}/logs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+logName}";
                private final Pattern LOG_NAME_PATTERN;
                @Key
                private String logName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.LOG_NAME_PATTERN = Pattern.compile("^organizations/[^/]+/logs/[^/]+$");
                    this.logName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter logName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter logName must conform to the pattern ^organizations/[^/]+/logs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getLogName() {
                    return this.logName;
                }

                public Delete setLogName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter logName must conform to the pattern ^organizations/[^/]+/logs/[^/]+$");
                    }
                    this.logName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }
    }

    public class MonitoredResourceDescriptors {
        public List list() throws IOException {
            List list = new List();
            Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends LoggingRequest<ListMonitoredResourceDescriptorsResponse> {
            private static final String REST_PATH = "v2/monitoredResourceDescriptors";
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(Logging.this, "GET", REST_PATH, null, ListMonitoredResourceDescriptorsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Folders {
        public Logs logs() {
            return new Logs();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String string, LogSink logSink) throws IOException {
                Create create = new Create(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, LogSink logSink) throws IOException {
                Update update = new Update(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Update(String string, LogSink logSink) {
                    super(Logging.this, "PUT", REST_PATH, (Object)logSink, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^folders/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Update setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Update setUniqueWriterIdentity(Boolean bl) {
                    this.uniqueWriterIdentity = bl;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Get(String string) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^folders/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Get setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^folders/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Delete setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^folders/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Create(String string, LogSink logSink) {
                    super(Logging.this, "POST", REST_PATH, (Object)logSink, LogSink.class);
                    this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Create setUniqueWriterIdentity(Boolean bl) {
                    this.uniqueWriterIdentity = bl;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Logs {
            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v2/{+parent}/logs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^folders/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^folders/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+logName}";
                private final Pattern LOG_NAME_PATTERN;
                @Key
                private String logName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.LOG_NAME_PATTERN = Pattern.compile("^folders/[^/]+/logs/[^/]+$");
                    this.logName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter logName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter logName must conform to the pattern ^folders/[^/]+/logs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getLogName() {
                    return this.logName;
                }

                public Delete setLogName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter logName must conform to the pattern ^folders/[^/]+/logs/[^/]+$");
                    }
                    this.logName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }
    }

    public class Entries {
        public List list(ListLogEntriesRequest listLogEntriesRequest) throws IOException {
            List list = new List(listLogEntriesRequest);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Write write(WriteLogEntriesRequest writeLogEntriesRequest) throws IOException {
            Write write = new Write(writeLogEntriesRequest);
            Logging.this.initialize((AbstractGoogleClientRequest<?>)write);
            return write;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Write
        extends LoggingRequest<WriteLogEntriesResponse> {
            private static final String REST_PATH = "v2/entries:write";

            protected Write(WriteLogEntriesRequest writeLogEntriesRequest) {
                super(Logging.this, "POST", REST_PATH, (Object)writeLogEntriesRequest, WriteLogEntriesResponse.class);
            }

            public Write set$Xgafv(String string) {
                return (Write)super.set$Xgafv(string);
            }

            public Write setAccessToken(String string) {
                return (Write)super.setAccessToken(string);
            }

            public Write setAlt(String string) {
                return (Write)super.setAlt(string);
            }

            public Write setBearerToken(String string) {
                return (Write)super.setBearerToken(string);
            }

            public Write setCallback(String string) {
                return (Write)super.setCallback(string);
            }

            public Write setFields(String string) {
                return (Write)super.setFields(string);
            }

            public Write setKey(String string) {
                return (Write)super.setKey(string);
            }

            public Write setOauthToken(String string) {
                return (Write)super.setOauthToken(string);
            }

            public Write setPp(Boolean bl) {
                return (Write)super.setPp(bl);
            }

            public Write setPrettyPrint(Boolean bl) {
                return (Write)super.setPrettyPrint(bl);
            }

            public Write setQuotaUser(String string) {
                return (Write)super.setQuotaUser(string);
            }

            public Write setUploadType(String string) {
                return (Write)super.setUploadType(string);
            }

            public Write setUploadProtocol(String string) {
                return (Write)super.setUploadProtocol(string);
            }

            @Override
            public Write set(String string, Object object) {
                return (Write)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends LoggingRequest<ListLogEntriesResponse> {
            private static final String REST_PATH = "v2/entries:list";

            protected List(ListLogEntriesRequest listLogEntriesRequest) {
                super(Logging.this, "POST", REST_PATH, (Object)listLogEntriesRequest, ListLogEntriesResponse.class);
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class BillingAccounts {
        public Logs logs() {
            return new Logs();
        }

        public Sinks sinks() {
            return new Sinks();
        }

        public class Sinks {
            public Create create(String string, LogSink logSink) throws IOException {
                Create create = new Create(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, LogSink logSink) throws IOException {
                Update update = new Update(string, logSink);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Update(String string, LogSink logSink) {
                    super(Logging.this, "PUT", REST_PATH, (Object)logSink, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Update setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Update setUniqueWriterIdentity(Boolean bl) {
                    this.uniqueWriterIdentity = bl;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListSinksResponse> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListSinksResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Get(String string) {
                    super(Logging.this, "GET", REST_PATH, null, LogSink.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Get setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+sinkName}";
                private final Pattern SINK_NAME_PATTERN;
                @Key
                private String sinkName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.SINK_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/sinks/[^/]+$");
                    this.sinkName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter sinkName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getSinkName() {
                    return this.sinkName;
                }

                public Delete setSinkName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SINK_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter sinkName must conform to the pattern ^billingAccounts/[^/]+/sinks/[^/]+$");
                    }
                    this.sinkName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends LoggingRequest<LogSink> {
                private static final String REST_PATH = "v2/{+parent}/sinks";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean uniqueWriterIdentity;

                protected Create(String string, LogSink logSink) {
                    super(Logging.this, "POST", REST_PATH, (Object)logSink, LogSink.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Boolean getUniqueWriterIdentity() {
                    return this.uniqueWriterIdentity;
                }

                public Create setUniqueWriterIdentity(Boolean bl) {
                    this.uniqueWriterIdentity = bl;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Logs {
            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Logging.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends LoggingRequest<ListLogsResponse> {
                private static final String REST_PATH = "v2/{+parent}/logs";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Logging.this, "GET", REST_PATH, null, ListLogsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^billingAccounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^billingAccounts/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends LoggingRequest<Empty> {
                private static final String REST_PATH = "v2/{+logName}";
                private final Pattern LOG_NAME_PATTERN;
                @Key
                private String logName;

                protected Delete(String string) {
                    super(Logging.this, "DELETE", REST_PATH, null, Empty.class);
                    this.LOG_NAME_PATTERN = Pattern.compile("^billingAccounts/[^/]+/logs/[^/]+$");
                    this.logName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter logName must be specified.");
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter logName must conform to the pattern ^billingAccounts/[^/]+/logs/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setBearerToken(String string) {
                    return (Delete)super.setBearerToken(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPp(Boolean bl) {
                    return (Delete)super.setPp(bl);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getLogName() {
                    return this.logName;
                }

                public Delete setLogName(String string) {
                    if (!Logging.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LOG_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter logName must conform to the pattern ^billingAccounts/[^/]+/logs/[^/]+$");
                    }
                    this.logName = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }
    }
}

