/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.iamcredentials.v1.model;

/**
 * Model definition for SignBlobResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the IAM Service Account Credentials API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SignBlobResponse extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the key used to sign the blob. The key used for signing will remain valid for at
   * least 12 hours after the blob is signed. To verify the signature, you can retrieve the public
   * key in several formats from the following endpoints: - RSA public key wrapped in an X.509 v3
   * certificate: `https://www.googleapis.com/service_accounts/v1/metadata/x509/{ACCOUNT_EMAIL}` -
   * Raw key in JSON format:
   * `https://www.googleapis.com/service_accounts/v1/metadata/raw/{ACCOUNT_EMAIL}` - JSON Web Key
   * (JWK): `https://www.googleapis.com/service_accounts/v1/metadata/jwk/{ACCOUNT_EMAIL}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keyId;

  /**
   * The signature for the blob. Does not include the original blob. After the key pair referenced
   * by the `key_id` response field expires, Google no longer exposes the public key that can be
   * used to verify the blob. As a result, the receiver can no longer verify the signature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String signedBlob;

  /**
   * The ID of the key used to sign the blob. The key used for signing will remain valid for at
   * least 12 hours after the blob is signed. To verify the signature, you can retrieve the public
   * key in several formats from the following endpoints: - RSA public key wrapped in an X.509 v3
   * certificate: `https://www.googleapis.com/service_accounts/v1/metadata/x509/{ACCOUNT_EMAIL}` -
   * Raw key in JSON format:
   * `https://www.googleapis.com/service_accounts/v1/metadata/raw/{ACCOUNT_EMAIL}` - JSON Web Key
   * (JWK): `https://www.googleapis.com/service_accounts/v1/metadata/jwk/{ACCOUNT_EMAIL}`
   * @return value or {@code null} for none
   */
  public java.lang.String getKeyId() {
    return keyId;
  }

  /**
   * The ID of the key used to sign the blob. The key used for signing will remain valid for at
   * least 12 hours after the blob is signed. To verify the signature, you can retrieve the public
   * key in several formats from the following endpoints: - RSA public key wrapped in an X.509 v3
   * certificate: `https://www.googleapis.com/service_accounts/v1/metadata/x509/{ACCOUNT_EMAIL}` -
   * Raw key in JSON format:
   * `https://www.googleapis.com/service_accounts/v1/metadata/raw/{ACCOUNT_EMAIL}` - JSON Web Key
   * (JWK): `https://www.googleapis.com/service_accounts/v1/metadata/jwk/{ACCOUNT_EMAIL}`
   * @param keyId keyId or {@code null} for none
   */
  public SignBlobResponse setKeyId(java.lang.String keyId) {
    this.keyId = keyId;
    return this;
  }

  /**
   * The signature for the blob. Does not include the original blob. After the key pair referenced
   * by the `key_id` response field expires, Google no longer exposes the public key that can be
   * used to verify the blob. As a result, the receiver can no longer verify the signature.
   * @see #decodeSignedBlob()
   * @return value or {@code null} for none
   */
  public java.lang.String getSignedBlob() {
    return signedBlob;
  }

  /**
   * The signature for the blob. Does not include the original blob. After the key pair referenced
   * by the `key_id` response field expires, Google no longer exposes the public key that can be
   * used to verify the blob. As a result, the receiver can no longer verify the signature.
   * @see #getSignedBlob()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeSignedBlob() {
    return com.google.api.client.util.Base64.decodeBase64(signedBlob);
  }

  /**
   * The signature for the blob. Does not include the original blob. After the key pair referenced
   * by the `key_id` response field expires, Google no longer exposes the public key that can be
   * used to verify the blob. As a result, the receiver can no longer verify the signature.
   * @see #encodeSignedBlob()
   * @param signedBlob signedBlob or {@code null} for none
   */
  public SignBlobResponse setSignedBlob(java.lang.String signedBlob) {
    this.signedBlob = signedBlob;
    return this;
  }

  /**
   * The signature for the blob. Does not include the original blob. After the key pair referenced
   * by the `key_id` response field expires, Google no longer exposes the public key that can be
   * used to verify the blob. As a result, the receiver can no longer verify the signature.
   * @see #setSignedBlob()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public SignBlobResponse encodeSignedBlob(byte[] signedBlob) {
    this.signedBlob = com.google.api.client.util.Base64.encodeBase64URLSafeString(signedBlob);
    return this;
  }

  @Override
  public SignBlobResponse set(String fieldName, Object value) {
    return (SignBlobResponse) super.set(fieldName, value);
  }

  @Override
  public SignBlobResponse clone() {
    return (SignBlobResponse) super.clone();
  }

}
