/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.analyticsreporting.v4;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Preconditions;
import com.google.api.services.analyticsreporting.v4.AnalyticsReportingRequest;
import com.google.api.services.analyticsreporting.v4.AnalyticsReportingRequestInitializer;
import com.google.api.services.analyticsreporting.v4.model.GetReportsRequest;
import com.google.api.services.analyticsreporting.v4.model.GetReportsResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsReporting
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://analyticsreporting.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://analyticsreporting.googleapis.com/";

    public AnalyticsReporting(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    AnalyticsReporting(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Reports reports() {
        return new Reports();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Google Analytics Reporting API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://analyticsreporting.googleapis.com/", AnalyticsReporting.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AnalyticsReporting.DEFAULT_BATCH_PATH);
        }

        public AnalyticsReporting build() {
            return new AnalyticsReporting(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setAnalyticsReportingRequestInitializer(AnalyticsReportingRequestInitializer analyticsReportingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)analyticsReportingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Reports {
        public BatchGet batchGet(GetReportsRequest getReportsRequest) throws IOException {
            BatchGet batchGet = new BatchGet(getReportsRequest);
            AnalyticsReporting.this.initialize((AbstractGoogleClientRequest<?>)batchGet);
            return batchGet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class BatchGet
        extends AnalyticsReportingRequest<GetReportsResponse> {
            private static final String REST_PATH = "v4/reports:batchGet";

            protected BatchGet(GetReportsRequest getReportsRequest) {
                super(AnalyticsReporting.this, "POST", REST_PATH, (Object)getReportsRequest, GetReportsResponse.class);
            }

            public BatchGet set$Xgafv(String string) {
                return (BatchGet)super.set$Xgafv(string);
            }

            public BatchGet setAccessToken(String string) {
                return (BatchGet)super.setAccessToken(string);
            }

            public BatchGet setAlt(String string) {
                return (BatchGet)super.setAlt(string);
            }

            public BatchGet setBearerToken(String string) {
                return (BatchGet)super.setBearerToken(string);
            }

            public BatchGet setCallback(String string) {
                return (BatchGet)super.setCallback(string);
            }

            public BatchGet setFields(String string) {
                return (BatchGet)super.setFields(string);
            }

            public BatchGet setKey(String string) {
                return (BatchGet)super.setKey(string);
            }

            public BatchGet setOauthToken(String string) {
                return (BatchGet)super.setOauthToken(string);
            }

            public BatchGet setPp(Boolean bl) {
                return (BatchGet)super.setPp(bl);
            }

            public BatchGet setPrettyPrint(Boolean bl) {
                return (BatchGet)super.setPrettyPrint(bl);
            }

            public BatchGet setQuotaUser(String string) {
                return (BatchGet)super.setQuotaUser(string);
            }

            public BatchGet setUploadType(String string) {
                return (BatchGet)super.setUploadType(string);
            }

            public BatchGet setUploadProtocol(String string) {
                return (BatchGet)super.setUploadProtocol(string);
            }

            @Override
            public BatchGet set(String string, Object object) {
                return (BatchGet)super.set(string, object);
            }
        }
    }
}

