/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-11-09 at 02:16:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Filter Clause to be used in a segment definition, can be wither a metric or a dimension filter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SegmentFilterClause extends com.google.api.client.json.GenericJson {

  /**
   * Dimension Filter for the segment definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SegmentDimensionFilter dimensionFilter;

  /**
   * Metric Filter for the segment definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SegmentMetricFilter metricFilter;

  /**
   * Matches the complement (`!`) of the filter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean not;

  /**
   * Dimension Filter for the segment definition.
   * @return value or {@code null} for none
   */
  public SegmentDimensionFilter getDimensionFilter() {
    return dimensionFilter;
  }

  /**
   * Dimension Filter for the segment definition.
   * @param dimensionFilter dimensionFilter or {@code null} for none
   */
  public SegmentFilterClause setDimensionFilter(SegmentDimensionFilter dimensionFilter) {
    this.dimensionFilter = dimensionFilter;
    return this;
  }

  /**
   * Metric Filter for the segment definition.
   * @return value or {@code null} for none
   */
  public SegmentMetricFilter getMetricFilter() {
    return metricFilter;
  }

  /**
   * Metric Filter for the segment definition.
   * @param metricFilter metricFilter or {@code null} for none
   */
  public SegmentFilterClause setMetricFilter(SegmentMetricFilter metricFilter) {
    this.metricFilter = metricFilter;
    return this;
  }

  /**
   * Matches the complement (`!`) of the filter.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNot() {
    return not;
  }

  /**
   * Matches the complement (`!`) of the filter.
   * @param not not or {@code null} for none
   */
  public SegmentFilterClause setNot(java.lang.Boolean not) {
    this.not = not;
    return this;
  }

  @Override
  public SegmentFilterClause set(String fieldName, Object value) {
    return (SegmentFilterClause) super.set(fieldName, value);
  }

  @Override
  public SegmentFilterClause clone() {
    return (SegmentFilterClause) super.clone();
  }

}
