/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-11-09 at 02:16:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * The segment definition, if the report needs to be segmented. A Segment is a subset of the
 * Analytics data. For example, of the entire set of users, one Segment might be users from a
 * particular country or city.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Segment extends com.google.api.client.json.GenericJson {

  /**
   * A dynamic segment definition in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DynamicSegment dynamicSegment;

  /**
   * The segment ID of a built-in or custom segment, for example `gaid::-3`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String segmentId;

  /**
   * A dynamic segment definition in the request.
   * @return value or {@code null} for none
   */
  public DynamicSegment getDynamicSegment() {
    return dynamicSegment;
  }

  /**
   * A dynamic segment definition in the request.
   * @param dynamicSegment dynamicSegment or {@code null} for none
   */
  public Segment setDynamicSegment(DynamicSegment dynamicSegment) {
    this.dynamicSegment = dynamicSegment;
    return this;
  }

  /**
   * The segment ID of a built-in or custom segment, for example `gaid::-3`.
   * @return value or {@code null} for none
   */
  public java.lang.String getSegmentId() {
    return segmentId;
  }

  /**
   * The segment ID of a built-in or custom segment, for example `gaid::-3`.
   * @param segmentId segmentId or {@code null} for none
   */
  public Segment setSegmentId(java.lang.String segmentId) {
    this.segmentId = segmentId;
    return this;
  }

  @Override
  public Segment set(String fieldName, Object value) {
    return (Segment) super.set(fieldName, value);
  }

  @Override
  public Segment clone() {
    return (Segment) super.clone();
  }

}
