/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-11-09 at 02:16:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * The data response corresponding to the request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Report extends com.google.api.client.json.GenericJson {

  /**
   * The column headers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColumnHeader columnHeader;

  /**
   * Response data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReportData data;

  /**
   * Page token to retrieve the next page of results in the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The column headers.
   * @return value or {@code null} for none
   */
  public ColumnHeader getColumnHeader() {
    return columnHeader;
  }

  /**
   * The column headers.
   * @param columnHeader columnHeader or {@code null} for none
   */
  public Report setColumnHeader(ColumnHeader columnHeader) {
    this.columnHeader = columnHeader;
    return this;
  }

  /**
   * Response data.
   * @return value or {@code null} for none
   */
  public ReportData getData() {
    return data;
  }

  /**
   * Response data.
   * @param data data or {@code null} for none
   */
  public Report setData(ReportData data) {
    this.data = data;
    return this;
  }

  /**
   * Page token to retrieve the next page of results in the list.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Page token to retrieve the next page of results in the list.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public Report setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public Report set(String fieldName, Object value) {
    return (Report) super.set(fieldName, value);
  }

  @Override
  public Report clone() {
    return (Report) super.clone();
  }

}
