/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-11-09 at 02:16:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * The headers for the metrics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetricHeader extends com.google.api.client.json.GenericJson {

  /**
   * Headers for the metrics in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricHeaderEntry> metricHeaderEntries;

  static {
    // hack to force ProGuard to consider MetricHeaderEntry used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MetricHeaderEntry.class);
  }

  /**
   * Headers for the pivots in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PivotHeader> pivotHeaders;

  static {
    // hack to force ProGuard to consider PivotHeader used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PivotHeader.class);
  }

  /**
   * Headers for the metrics in the response.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricHeaderEntry> getMetricHeaderEntries() {
    return metricHeaderEntries;
  }

  /**
   * Headers for the metrics in the response.
   * @param metricHeaderEntries metricHeaderEntries or {@code null} for none
   */
  public MetricHeader setMetricHeaderEntries(java.util.List<MetricHeaderEntry> metricHeaderEntries) {
    this.metricHeaderEntries = metricHeaderEntries;
    return this;
  }

  /**
   * Headers for the pivots in the response.
   * @return value or {@code null} for none
   */
  public java.util.List<PivotHeader> getPivotHeaders() {
    return pivotHeaders;
  }

  /**
   * Headers for the pivots in the response.
   * @param pivotHeaders pivotHeaders or {@code null} for none
   */
  public MetricHeader setPivotHeaders(java.util.List<PivotHeader> pivotHeaders) {
    this.pivotHeaders = pivotHeaders;
    return this;
  }

  @Override
  public MetricHeader set(String fieldName, Object value) {
    return (MetricHeader) super.set(fieldName, value);
  }

  @Override
  public MetricHeader clone() {
    return (MetricHeader) super.clone();
  }

}
