/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-11-09 at 02:16:29 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Defines a cohort. A cohort is a group of users who share a common characteristic. For example,
 * all users with the same acquisition date belong to the same cohort.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics Reporting API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Cohort extends com.google.api.client.json.GenericJson {

  /**
   * This is used for `FIRST_VISIT_DATE` cohort, the cohort selects users whose first visit date is
   * between start date and end date defined in the DateRange. The date ranges should be aligned for
   * cohort requests. If the request contains `ga:cohortNthDay` it should be exactly one day long,
   * if `ga:cohortNthWeek` it should be aligned to the week boundary (starting at Sunday and ending
   * Saturday), and for `ga:cohortNthMonth` the date range should be aligned to the month (starting
   * at the first and ending on the last day of the month). For LTV requests there are no such
   * restrictions. You do not need to supply a date range for the `reportsRequest.dateRanges` field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateRange dateRange;

  /**
   * A unique name for the cohort. If not defined name will be auto-generated with values
   * cohort_[1234...].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Type of the cohort. The only supported type as of now is `FIRST_VISIT_DATE`. If this field is
   * unspecified the cohort is treated as `FIRST_VISIT_DATE` type cohort.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * This is used for `FIRST_VISIT_DATE` cohort, the cohort selects users whose first visit date is
   * between start date and end date defined in the DateRange. The date ranges should be aligned for
   * cohort requests. If the request contains `ga:cohortNthDay` it should be exactly one day long,
   * if `ga:cohortNthWeek` it should be aligned to the week boundary (starting at Sunday and ending
   * Saturday), and for `ga:cohortNthMonth` the date range should be aligned to the month (starting
   * at the first and ending on the last day of the month). For LTV requests there are no such
   * restrictions. You do not need to supply a date range for the `reportsRequest.dateRanges` field.
   * @return value or {@code null} for none
   */
  public DateRange getDateRange() {
    return dateRange;
  }

  /**
   * This is used for `FIRST_VISIT_DATE` cohort, the cohort selects users whose first visit date is
   * between start date and end date defined in the DateRange. The date ranges should be aligned for
   * cohort requests. If the request contains `ga:cohortNthDay` it should be exactly one day long,
   * if `ga:cohortNthWeek` it should be aligned to the week boundary (starting at Sunday and ending
   * Saturday), and for `ga:cohortNthMonth` the date range should be aligned to the month (starting
   * at the first and ending on the last day of the month). For LTV requests there are no such
   * restrictions. You do not need to supply a date range for the `reportsRequest.dateRanges` field.
   * @param dateRange dateRange or {@code null} for none
   */
  public Cohort setDateRange(DateRange dateRange) {
    this.dateRange = dateRange;
    return this;
  }

  /**
   * A unique name for the cohort. If not defined name will be auto-generated with values
   * cohort_[1234...].
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * A unique name for the cohort. If not defined name will be auto-generated with values
   * cohort_[1234...].
   * @param name name or {@code null} for none
   */
  public Cohort setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Type of the cohort. The only supported type as of now is `FIRST_VISIT_DATE`. If this field is
   * unspecified the cohort is treated as `FIRST_VISIT_DATE` type cohort.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of the cohort. The only supported type as of now is `FIRST_VISIT_DATE`. If this field is
   * unspecified the cohort is treated as `FIRST_VISIT_DATE` type cohort.
   * @param type type or {@code null} for none
   */
  public Cohort setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Cohort set(String fieldName, Object value) {
    return (Cohort) super.set(fieldName, value);
  }

  @Override
  public Cohort clone() {
    return (Cohort) super.clone();
  }

}
