/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecognizerName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RECOGNIZER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/recognizers/{recognizer}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String recognizer;

    @Deprecated
    protected RecognizerName() {
        this.project = null;
        this.location = null;
        this.recognizer = null;
    }

    private RecognizerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.recognizer = (String)Preconditions.checkNotNull((Object)builder.getRecognizer());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRecognizer() {
        return this.recognizer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecognizerName of(String project, String location, String recognizer) {
        return RecognizerName.newBuilder().setProject(project).setLocation(location).setRecognizer(recognizer).build();
    }

    public static String format(String project, String location, String recognizer) {
        return RecognizerName.newBuilder().setProject(project).setLocation(location).setRecognizer(recognizer).build().toString();
    }

    public static RecognizerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RECOGNIZER.validatedMatch(formattedString, "RecognizerName.parse: formattedString not in valid format");
        return RecognizerName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("recognizer"));
    }

    public static List<RecognizerName> parseList(List<String> formattedStrings) {
        ArrayList<RecognizerName> list = new ArrayList<RecognizerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecognizerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecognizerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecognizerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RECOGNIZER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecognizerName recognizerName = this;
            synchronized (recognizerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.recognizer != null) {
                        fieldMapBuilder.put((Object)"recognizer", (Object)this.recognizer);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RECOGNIZER.instantiate(new String[]{"project", this.project, "location", this.location, "recognizer", this.recognizer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RecognizerName that = (RecognizerName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.recognizer, that.recognizer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.recognizer);
    }

    public static class Builder {
        private String project;
        private String location;
        private String recognizer;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRecognizer() {
            return this.recognizer;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRecognizer(String recognizer) {
            this.recognizer = recognizer;
            return this;
        }

        private Builder(RecognizerName recognizerName) {
            this.project = recognizerName.project;
            this.location = recognizerName.location;
            this.recognizer = recognizerName.recognizer;
        }

        public RecognizerName build() {
            return new RecognizerName(this);
        }
    }
}

