/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v2/cloud_speech.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.speech.v2;

/**
 *
 *
 * <pre>
 * Output type for Cloud Storage of BatchRecognize transcripts. Though this
 * proto isn't returned in this API anywhere, the Cloud Storage transcripts will
 * be this proto serialized and should be parsed as such.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v2.BatchRecognizeResults}
 */
public final class BatchRecognizeResults extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v2.BatchRecognizeResults)
    BatchRecognizeResultsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchRecognizeResults.newBuilder() to construct.
  private BatchRecognizeResults(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchRecognizeResults() {
    results_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchRecognizeResults();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_BatchRecognizeResults_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v2.CloudSpeechProto
        .internal_static_google_cloud_speech_v2_BatchRecognizeResults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v2.BatchRecognizeResults.class,
            com.google.cloud.speech.v2.BatchRecognizeResults.Builder.class);
  }

  private int bitField0_;
  public static final int RESULTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.speech.v2.SpeechRecognitionResult> results_;
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to sequential
   * portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v2.SpeechRecognitionResult> getResultsList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to sequential
   * portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.speech.v2.SpeechRecognitionResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to sequential
   * portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to sequential
   * portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechRecognitionResult getResults(int index) {
    return results_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Sequential list of transcription results corresponding to sequential
   * portions of audio.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.SpeechRecognitionResultOrBuilder getResultsOrBuilder(
      int index) {
    return results_.get(index);
  }

  public static final int METADATA_FIELD_NUMBER = 2;
  private com.google.cloud.speech.v2.RecognitionResponseMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Metadata about the recognition.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metadata about the recognition.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionResponseMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata about the recognition.
   * </pre>
   *
   * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()
        : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(1, results_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, results_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v2.BatchRecognizeResults)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v2.BatchRecognizeResults other =
        (com.google.cloud.speech.v2.BatchRecognizeResults) obj;

    if (!getResultsList().equals(other.getResultsList())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.speech.v2.BatchRecognizeResults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Output type for Cloud Storage of BatchRecognize transcripts. Though this
   * proto isn't returned in this API anywhere, the Cloud Storage transcripts will
   * be this proto serialized and should be parsed as such.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v2.BatchRecognizeResults}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v2.BatchRecognizeResults)
      com.google.cloud.speech.v2.BatchRecognizeResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeResults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v2.BatchRecognizeResults.class,
              com.google.cloud.speech.v2.BatchRecognizeResults.Builder.class);
    }

    // Construct using com.google.cloud.speech.v2.BatchRecognizeResults.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultsFieldBuilder();
        getMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
      } else {
        results_ = null;
        resultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v2.CloudSpeechProto
          .internal_static_google_cloud_speech_v2_BatchRecognizeResults_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeResults getDefaultInstanceForType() {
      return com.google.cloud.speech.v2.BatchRecognizeResults.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeResults build() {
      com.google.cloud.speech.v2.BatchRecognizeResults result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v2.BatchRecognizeResults buildPartial() {
      com.google.cloud.speech.v2.BatchRecognizeResults result =
          new com.google.cloud.speech.v2.BatchRecognizeResults(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.speech.v2.BatchRecognizeResults result) {
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.speech.v2.BatchRecognizeResults result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v2.BatchRecognizeResults) {
        return mergeFrom((com.google.cloud.speech.v2.BatchRecognizeResults) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v2.BatchRecognizeResults other) {
      if (other == com.google.cloud.speech.v2.BatchRecognizeResults.getDefaultInstance())
        return this;
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.speech.v2.SpeechRecognitionResult m =
                    input.readMessage(
                        com.google.cloud.speech.v2.SpeechRecognitionResult.parser(),
                        extensionRegistry);
                if (resultsBuilder_ == null) {
                  ensureResultsIsMutable();
                  results_.add(m);
                } else {
                  resultsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.speech.v2.SpeechRecognitionResult> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        results_ =
            new java.util.ArrayList<com.google.cloud.speech.v2.SpeechRecognitionResult>(results_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.SpeechRecognitionResult,
            com.google.cloud.speech.v2.SpeechRecognitionResult.Builder,
            com.google.cloud.speech.v2.SpeechRecognitionResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public java.util.List<com.google.cloud.speech.v2.SpeechRecognitionResult> getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionResult getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder setResults(int index, com.google.cloud.speech.v2.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.speech.v2.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder addResults(com.google.cloud.speech.v2.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder addResults(int index, com.google.cloud.speech.v2.SpeechRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder addResults(
        com.google.cloud.speech.v2.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.speech.v2.SpeechRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.cloud.speech.v2.SpeechRecognitionResult> values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionResult.Builder getResultsBuilder(int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionResultOrBuilder getResultsOrBuilder(
        int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.speech.v2.SpeechRecognitionResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionResult.Builder addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(com.google.cloud.speech.v2.SpeechRecognitionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public com.google.cloud.speech.v2.SpeechRecognitionResult.Builder addResultsBuilder(int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.speech.v2.SpeechRecognitionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Sequential list of transcription results corresponding to sequential
     * portions of audio.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v2.SpeechRecognitionResult results = 1;</code>
     */
    public java.util.List<com.google.cloud.speech.v2.SpeechRecognitionResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v2.SpeechRecognitionResult,
            com.google.cloud.speech.v2.SpeechRecognitionResult.Builder,
            com.google.cloud.speech.v2.SpeechRecognitionResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v2.SpeechRecognitionResult,
                com.google.cloud.speech.v2.SpeechRecognitionResult.Builder,
                com.google.cloud.speech.v2.SpeechRecognitionResultOrBuilder>(
                results_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private com.google.cloud.speech.v2.RecognitionResponseMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionResponseMetadata,
            com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder,
            com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.speech.v2.RecognitionResponseMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     */
    public Builder setMetadata(com.google.cloud.speech.v2.RecognitionResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     */
    public Builder setMetadata(
        com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     */
    public Builder mergeMetadata(com.google.cloud.speech.v2.RecognitionResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && metadata_ != null
            && metadata_
                != com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000002);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     */
    public com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     */
    public com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.speech.v2.RecognitionResponseMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about the recognition.
     * </pre>
     *
     * <code>.google.cloud.speech.v2.RecognitionResponseMetadata metadata = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.speech.v2.RecognitionResponseMetadata,
            com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder,
            com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.speech.v2.RecognitionResponseMetadata,
                com.google.cloud.speech.v2.RecognitionResponseMetadata.Builder,
                com.google.cloud.speech.v2.RecognitionResponseMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v2.BatchRecognizeResults)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v2.BatchRecognizeResults)
  private static final com.google.cloud.speech.v2.BatchRecognizeResults DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v2.BatchRecognizeResults();
  }

  public static com.google.cloud.speech.v2.BatchRecognizeResults getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchRecognizeResults> PARSER =
      new com.google.protobuf.AbstractParser<BatchRecognizeResults>() {
        @java.lang.Override
        public BatchRecognizeResults parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchRecognizeResults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchRecognizeResults> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v2.BatchRecognizeResults getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
