/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * Metadata type for the long-running operation returned by
 * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.RestoreDatabaseMetadata}
 */
public final class RestoreDatabaseMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.RestoreDatabaseMetadata)
    RestoreDatabaseMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RestoreDatabaseMetadata.newBuilder() to construct.
  private RestoreDatabaseMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RestoreDatabaseMetadata() {
    name_ = "";
    sourceType_ = 0;
    optimizeDatabaseOperationName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RestoreDatabaseMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_RestoreDatabaseMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_RestoreDatabaseMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.RestoreDatabaseMetadata.class,
            com.google.spanner.admin.database.v1.RestoreDatabaseMetadata.Builder.class);
  }

  private int sourceInfoCase_ = 0;
  private java.lang.Object sourceInfo_;

  public enum SourceInfoCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BACKUP_INFO(3),
    SOURCEINFO_NOT_SET(0);
    private final int value;

    private SourceInfoCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceInfoCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceInfoCase forNumber(int value) {
      switch (value) {
        case 3:
          return BACKUP_INFO;
        case 0:
          return SOURCEINFO_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceInfoCase getSourceInfoCase() {
    return SourceInfoCase.forNumber(sourceInfoCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Name of the database being created and restored to.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the database being created and restored to.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_TYPE_FIELD_NUMBER = 2;
  private int sourceType_;
  /**
   *
   *
   * <pre>
   * The type of the restore source.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
   *
   * @return The enum numeric value on the wire for sourceType.
   */
  @java.lang.Override
  public int getSourceTypeValue() {
    return sourceType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the restore source.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
   *
   * @return The sourceType.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreSourceType getSourceType() {
    @SuppressWarnings("deprecation")
    com.google.spanner.admin.database.v1.RestoreSourceType result =
        com.google.spanner.admin.database.v1.RestoreSourceType.valueOf(sourceType_);
    return result == null
        ? com.google.spanner.admin.database.v1.RestoreSourceType.UNRECOGNIZED
        : result;
  }

  public static final int BACKUP_INFO_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Information about the backup used to restore the database.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
   *
   * @return Whether the backupInfo field is set.
   */
  @java.lang.Override
  public boolean hasBackupInfo() {
    return sourceInfoCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Information about the backup used to restore the database.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
   *
   * @return The backupInfo.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.BackupInfo getBackupInfo() {
    if (sourceInfoCase_ == 3) {
      return (com.google.spanner.admin.database.v1.BackupInfo) sourceInfo_;
    }
    return com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Information about the backup used to restore the database.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.BackupInfoOrBuilder getBackupInfoOrBuilder() {
    if (sourceInfoCase_ == 3) {
      return (com.google.spanner.admin.database.v1.BackupInfo) sourceInfo_;
    }
    return com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance();
  }

  public static final int PROGRESS_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.OperationProgress progress_;
  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
   *
   * @return Whether the progress field is set.
   */
  @java.lang.Override
  public boolean hasProgress() {
    return progress_ != null;
  }
  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
   *
   * @return The progress.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.OperationProgress getProgress() {
    return progress_ == null
        ? com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance()
        : progress_;
  }
  /**
   *
   *
   * <pre>
   * The progress of the
   * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
   * operation.
   * </pre>
   *
   * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.OperationProgressOrBuilder getProgressOrBuilder() {
    return getProgress();
  }

  public static final int CANCEL_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp cancelTime_;
  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
   *
   * @return Whether the cancelTime field is set.
   */
  @java.lang.Override
  public boolean hasCancelTime() {
    return cancelTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
   *
   * @return The cancelTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCancelTime() {
    return cancelTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : cancelTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which cancellation of this operation was received.
   * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
   * starts asynchronous cancellation on a long-running operation. The server
   * makes a best effort to cancel the operation, but success is not guaranteed.
   * Clients can use
   * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an [Operation.error][google.longrunning.Operation.error] value with a
   * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCancelTimeOrBuilder() {
    return getCancelTime();
  }

  public static final int OPTIMIZE_DATABASE_OPERATION_NAME_FIELD_NUMBER = 6;
  private volatile java.lang.Object optimizeDatabaseOperationName_;
  /**
   *
   *
   * <pre>
   * If exists, the name of the long-running operation that will be used to
   * track the post-restore optimization process to optimize the performance of
   * the restored database, and remove the dependency on the restore source.
   * The name is of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
   * where the &lt;database&gt; is the name of database being created and restored to.
   * The metadata type of the  long-running operation is
   * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata]. This long-running operation will be
   * automatically created by the system after the RestoreDatabase long-running
   * operation completes successfully. This operation will not be created if the
   * restore was not successful.
   * </pre>
   *
   * <code>string optimize_database_operation_name = 6;</code>
   *
   * @return The optimizeDatabaseOperationName.
   */
  @java.lang.Override
  public java.lang.String getOptimizeDatabaseOperationName() {
    java.lang.Object ref = optimizeDatabaseOperationName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      optimizeDatabaseOperationName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If exists, the name of the long-running operation that will be used to
   * track the post-restore optimization process to optimize the performance of
   * the restored database, and remove the dependency on the restore source.
   * The name is of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
   * where the &lt;database&gt; is the name of database being created and restored to.
   * The metadata type of the  long-running operation is
   * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata]. This long-running operation will be
   * automatically created by the system after the RestoreDatabase long-running
   * operation completes successfully. This operation will not be created if the
   * restore was not successful.
   * </pre>
   *
   * <code>string optimize_database_operation_name = 6;</code>
   *
   * @return The bytes for optimizeDatabaseOperationName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOptimizeDatabaseOperationNameBytes() {
    java.lang.Object ref = optimizeDatabaseOperationName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      optimizeDatabaseOperationName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (sourceType_
        != com.google.spanner.admin.database.v1.RestoreSourceType.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, sourceType_);
    }
    if (sourceInfoCase_ == 3) {
      output.writeMessage(3, (com.google.spanner.admin.database.v1.BackupInfo) sourceInfo_);
    }
    if (progress_ != null) {
      output.writeMessage(4, getProgress());
    }
    if (cancelTime_ != null) {
      output.writeMessage(5, getCancelTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizeDatabaseOperationName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, optimizeDatabaseOperationName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (sourceType_
        != com.google.spanner.admin.database.v1.RestoreSourceType.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, sourceType_);
    }
    if (sourceInfoCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.spanner.admin.database.v1.BackupInfo) sourceInfo_);
    }
    if (progress_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getProgress());
    }
    if (cancelTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCancelTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizeDatabaseOperationName_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              6, optimizeDatabaseOperationName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.RestoreDatabaseMetadata)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.RestoreDatabaseMetadata other =
        (com.google.spanner.admin.database.v1.RestoreDatabaseMetadata) obj;

    if (!getName().equals(other.getName())) return false;
    if (sourceType_ != other.sourceType_) return false;
    if (hasProgress() != other.hasProgress()) return false;
    if (hasProgress()) {
      if (!getProgress().equals(other.getProgress())) return false;
    }
    if (hasCancelTime() != other.hasCancelTime()) return false;
    if (hasCancelTime()) {
      if (!getCancelTime().equals(other.getCancelTime())) return false;
    }
    if (!getOptimizeDatabaseOperationName().equals(other.getOptimizeDatabaseOperationName()))
      return false;
    if (!getSourceInfoCase().equals(other.getSourceInfoCase())) return false;
    switch (sourceInfoCase_) {
      case 3:
        if (!getBackupInfo().equals(other.getBackupInfo())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + sourceType_;
    if (hasProgress()) {
      hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + getProgress().hashCode();
    }
    if (hasCancelTime()) {
      hash = (37 * hash) + CANCEL_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCancelTime().hashCode();
    }
    hash = (37 * hash) + OPTIMIZE_DATABASE_OPERATION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getOptimizeDatabaseOperationName().hashCode();
    switch (sourceInfoCase_) {
      case 3:
        hash = (37 * hash) + BACKUP_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getBackupInfo().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.RestoreDatabaseMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata type for the long-running operation returned by
   * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.RestoreDatabaseMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.RestoreDatabaseMetadata)
      com.google.spanner.admin.database.v1.RestoreDatabaseMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_RestoreDatabaseMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_RestoreDatabaseMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.RestoreDatabaseMetadata.class,
              com.google.spanner.admin.database.v1.RestoreDatabaseMetadata.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.RestoreDatabaseMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      sourceType_ = 0;

      if (backupInfoBuilder_ != null) {
        backupInfoBuilder_.clear();
      }
      if (progressBuilder_ == null) {
        progress_ = null;
      } else {
        progress_ = null;
        progressBuilder_ = null;
      }
      if (cancelTimeBuilder_ == null) {
        cancelTime_ = null;
      } else {
        cancelTime_ = null;
        cancelTimeBuilder_ = null;
      }
      optimizeDatabaseOperationName_ = "";

      sourceInfoCase_ = 0;
      sourceInfo_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_RestoreDatabaseMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.RestoreDatabaseMetadata
        getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.RestoreDatabaseMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.RestoreDatabaseMetadata build() {
      com.google.spanner.admin.database.v1.RestoreDatabaseMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.RestoreDatabaseMetadata buildPartial() {
      com.google.spanner.admin.database.v1.RestoreDatabaseMetadata result =
          new com.google.spanner.admin.database.v1.RestoreDatabaseMetadata(this);
      result.name_ = name_;
      result.sourceType_ = sourceType_;
      if (sourceInfoCase_ == 3) {
        if (backupInfoBuilder_ == null) {
          result.sourceInfo_ = sourceInfo_;
        } else {
          result.sourceInfo_ = backupInfoBuilder_.build();
        }
      }
      if (progressBuilder_ == null) {
        result.progress_ = progress_;
      } else {
        result.progress_ = progressBuilder_.build();
      }
      if (cancelTimeBuilder_ == null) {
        result.cancelTime_ = cancelTime_;
      } else {
        result.cancelTime_ = cancelTimeBuilder_.build();
      }
      result.optimizeDatabaseOperationName_ = optimizeDatabaseOperationName_;
      result.sourceInfoCase_ = sourceInfoCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.RestoreDatabaseMetadata) {
        return mergeFrom((com.google.spanner.admin.database.v1.RestoreDatabaseMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.RestoreDatabaseMetadata other) {
      if (other
          == com.google.spanner.admin.database.v1.RestoreDatabaseMetadata.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.sourceType_ != 0) {
        setSourceTypeValue(other.getSourceTypeValue());
      }
      if (other.hasProgress()) {
        mergeProgress(other.getProgress());
      }
      if (other.hasCancelTime()) {
        mergeCancelTime(other.getCancelTime());
      }
      if (!other.getOptimizeDatabaseOperationName().isEmpty()) {
        optimizeDatabaseOperationName_ = other.optimizeDatabaseOperationName_;
        onChanged();
      }
      switch (other.getSourceInfoCase()) {
        case BACKUP_INFO:
          {
            mergeBackupInfo(other.getBackupInfo());
            break;
          }
        case SOURCEINFO_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                sourceType_ = input.readEnum();

                break;
              } // case 16
            case 26:
              {
                input.readMessage(getBackupInfoFieldBuilder().getBuilder(), extensionRegistry);
                sourceInfoCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getProgressFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCancelTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                optimizeDatabaseOperationName_ = input.readStringRequireUtf8();

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceInfoCase_ = 0;
    private java.lang.Object sourceInfo_;

    public SourceInfoCase getSourceInfoCase() {
      return SourceInfoCase.forNumber(sourceInfoCase_);
    }

    public Builder clearSourceInfo() {
      sourceInfoCase_ = 0;
      sourceInfo_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the database being created and restored to.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the database being created and restored to.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the database being created and restored to.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the database being created and restored to.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the database being created and restored to.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int sourceType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
     *
     * @return The enum numeric value on the wire for sourceType.
     */
    @java.lang.Override
    public int getSourceTypeValue() {
      return sourceType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
     *
     * @param value The enum numeric value on the wire for sourceType to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTypeValue(int value) {

      sourceType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
     *
     * @return The sourceType.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.RestoreSourceType getSourceType() {
      @SuppressWarnings("deprecation")
      com.google.spanner.admin.database.v1.RestoreSourceType result =
          com.google.spanner.admin.database.v1.RestoreSourceType.valueOf(sourceType_);
      return result == null
          ? com.google.spanner.admin.database.v1.RestoreSourceType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
     *
     * @param value The sourceType to set.
     * @return This builder for chaining.
     */
    public Builder setSourceType(com.google.spanner.admin.database.v1.RestoreSourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the restore source.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.RestoreSourceType source_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceType() {

      sourceType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.BackupInfo,
            com.google.spanner.admin.database.v1.BackupInfo.Builder,
            com.google.spanner.admin.database.v1.BackupInfoOrBuilder>
        backupInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     *
     * @return Whether the backupInfo field is set.
     */
    @java.lang.Override
    public boolean hasBackupInfo() {
      return sourceInfoCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     *
     * @return The backupInfo.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.BackupInfo getBackupInfo() {
      if (backupInfoBuilder_ == null) {
        if (sourceInfoCase_ == 3) {
          return (com.google.spanner.admin.database.v1.BackupInfo) sourceInfo_;
        }
        return com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance();
      } else {
        if (sourceInfoCase_ == 3) {
          return backupInfoBuilder_.getMessage();
        }
        return com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     */
    public Builder setBackupInfo(com.google.spanner.admin.database.v1.BackupInfo value) {
      if (backupInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceInfo_ = value;
        onChanged();
      } else {
        backupInfoBuilder_.setMessage(value);
      }
      sourceInfoCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     */
    public Builder setBackupInfo(
        com.google.spanner.admin.database.v1.BackupInfo.Builder builderForValue) {
      if (backupInfoBuilder_ == null) {
        sourceInfo_ = builderForValue.build();
        onChanged();
      } else {
        backupInfoBuilder_.setMessage(builderForValue.build());
      }
      sourceInfoCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     */
    public Builder mergeBackupInfo(com.google.spanner.admin.database.v1.BackupInfo value) {
      if (backupInfoBuilder_ == null) {
        if (sourceInfoCase_ == 3
            && sourceInfo_
                != com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance()) {
          sourceInfo_ =
              com.google.spanner.admin.database.v1.BackupInfo.newBuilder(
                      (com.google.spanner.admin.database.v1.BackupInfo) sourceInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceInfo_ = value;
        }
        onChanged();
      } else {
        if (sourceInfoCase_ == 3) {
          backupInfoBuilder_.mergeFrom(value);
        } else {
          backupInfoBuilder_.setMessage(value);
        }
      }
      sourceInfoCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     */
    public Builder clearBackupInfo() {
      if (backupInfoBuilder_ == null) {
        if (sourceInfoCase_ == 3) {
          sourceInfoCase_ = 0;
          sourceInfo_ = null;
          onChanged();
        }
      } else {
        if (sourceInfoCase_ == 3) {
          sourceInfoCase_ = 0;
          sourceInfo_ = null;
        }
        backupInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     */
    public com.google.spanner.admin.database.v1.BackupInfo.Builder getBackupInfoBuilder() {
      return getBackupInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.BackupInfoOrBuilder getBackupInfoOrBuilder() {
      if ((sourceInfoCase_ == 3) && (backupInfoBuilder_ != null)) {
        return backupInfoBuilder_.getMessageOrBuilder();
      } else {
        if (sourceInfoCase_ == 3) {
          return (com.google.spanner.admin.database.v1.BackupInfo) sourceInfo_;
        }
        return com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the backup used to restore the database.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.BackupInfo backup_info = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.BackupInfo,
            com.google.spanner.admin.database.v1.BackupInfo.Builder,
            com.google.spanner.admin.database.v1.BackupInfoOrBuilder>
        getBackupInfoFieldBuilder() {
      if (backupInfoBuilder_ == null) {
        if (!(sourceInfoCase_ == 3)) {
          sourceInfo_ = com.google.spanner.admin.database.v1.BackupInfo.getDefaultInstance();
        }
        backupInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.BackupInfo,
                com.google.spanner.admin.database.v1.BackupInfo.Builder,
                com.google.spanner.admin.database.v1.BackupInfoOrBuilder>(
                (com.google.spanner.admin.database.v1.BackupInfo) sourceInfo_,
                getParentForChildren(),
                isClean());
        sourceInfo_ = null;
      }
      sourceInfoCase_ = 3;
      onChanged();
      ;
      return backupInfoBuilder_;
    }

    private com.google.spanner.admin.database.v1.OperationProgress progress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.OperationProgress,
            com.google.spanner.admin.database.v1.OperationProgress.Builder,
            com.google.spanner.admin.database.v1.OperationProgressOrBuilder>
        progressBuilder_;
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     *
     * @return Whether the progress field is set.
     */
    public boolean hasProgress() {
      return progressBuilder_ != null || progress_ != null;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     *
     * @return The progress.
     */
    public com.google.spanner.admin.database.v1.OperationProgress getProgress() {
      if (progressBuilder_ == null) {
        return progress_ == null
            ? com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance()
            : progress_;
      } else {
        return progressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     */
    public Builder setProgress(com.google.spanner.admin.database.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progress_ = value;
        onChanged();
      } else {
        progressBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     */
    public Builder setProgress(
        com.google.spanner.admin.database.v1.OperationProgress.Builder builderForValue) {
      if (progressBuilder_ == null) {
        progress_ = builderForValue.build();
        onChanged();
      } else {
        progressBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     */
    public Builder mergeProgress(com.google.spanner.admin.database.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (progress_ != null) {
          progress_ =
              com.google.spanner.admin.database.v1.OperationProgress.newBuilder(progress_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          progress_ = value;
        }
        onChanged();
      } else {
        progressBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     */
    public Builder clearProgress() {
      if (progressBuilder_ == null) {
        progress_ = null;
        onChanged();
      } else {
        progress_ = null;
        progressBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgress.Builder getProgressBuilder() {

      onChanged();
      return getProgressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgressOrBuilder getProgressOrBuilder() {
      if (progressBuilder_ != null) {
        return progressBuilder_.getMessageOrBuilder();
      } else {
        return progress_ == null
            ? com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance()
            : progress_;
      }
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [RestoreDatabase][google.spanner.admin.database.v1.DatabaseAdmin.RestoreDatabase]
     * operation.
     * </pre>
     *
     * <code>.google.spanner.admin.database.v1.OperationProgress progress = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.OperationProgress,
            com.google.spanner.admin.database.v1.OperationProgress.Builder,
            com.google.spanner.admin.database.v1.OperationProgressOrBuilder>
        getProgressFieldBuilder() {
      if (progressBuilder_ == null) {
        progressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.OperationProgress,
                com.google.spanner.admin.database.v1.OperationProgress.Builder,
                com.google.spanner.admin.database.v1.OperationProgressOrBuilder>(
                getProgress(), getParentForChildren(), isClean());
        progress_ = null;
      }
      return progressBuilder_;
    }

    private com.google.protobuf.Timestamp cancelTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        cancelTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     *
     * @return Whether the cancelTime field is set.
     */
    public boolean hasCancelTime() {
      return cancelTimeBuilder_ != null || cancelTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     *
     * @return The cancelTime.
     */
    public com.google.protobuf.Timestamp getCancelTime() {
      if (cancelTimeBuilder_ == null) {
        return cancelTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : cancelTime_;
      } else {
        return cancelTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     */
    public Builder setCancelTime(com.google.protobuf.Timestamp value) {
      if (cancelTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cancelTime_ = value;
        onChanged();
      } else {
        cancelTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     */
    public Builder setCancelTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (cancelTimeBuilder_ == null) {
        cancelTime_ = builderForValue.build();
        onChanged();
      } else {
        cancelTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     */
    public Builder mergeCancelTime(com.google.protobuf.Timestamp value) {
      if (cancelTimeBuilder_ == null) {
        if (cancelTime_ != null) {
          cancelTime_ =
              com.google.protobuf.Timestamp.newBuilder(cancelTime_).mergeFrom(value).buildPartial();
        } else {
          cancelTime_ = value;
        }
        onChanged();
      } else {
        cancelTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     */
    public Builder clearCancelTime() {
      if (cancelTimeBuilder_ == null) {
        cancelTime_ = null;
        onChanged();
      } else {
        cancelTime_ = null;
        cancelTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCancelTimeBuilder() {

      onChanged();
      return getCancelTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCancelTimeOrBuilder() {
      if (cancelTimeBuilder_ != null) {
        return cancelTimeBuilder_.getMessageOrBuilder();
      } else {
        return cancelTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : cancelTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which cancellation of this operation was received.
     * [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * starts asynchronous cancellation on a long-running operation. The server
     * makes a best effort to cancel the operation, but success is not guaranteed.
     * Clients can use
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
     * other methods to check whether the cancellation succeeded or whether the
     * operation completed despite cancellation. On successful cancellation,
     * the operation is not deleted; instead, it becomes an operation with
     * an [Operation.error][google.longrunning.Operation.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to `Code.CANCELLED`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp cancel_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCancelTimeFieldBuilder() {
      if (cancelTimeBuilder_ == null) {
        cancelTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCancelTime(), getParentForChildren(), isClean());
        cancelTime_ = null;
      }
      return cancelTimeBuilder_;
    }

    private java.lang.Object optimizeDatabaseOperationName_ = "";
    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored database, and remove the dependency on the restore source.
     * The name is of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
     * where the &lt;database&gt; is the name of database being created and restored to.
     * The metadata type of the  long-running operation is
     * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata]. This long-running operation will be
     * automatically created by the system after the RestoreDatabase long-running
     * operation completes successfully. This operation will not be created if the
     * restore was not successful.
     * </pre>
     *
     * <code>string optimize_database_operation_name = 6;</code>
     *
     * @return The optimizeDatabaseOperationName.
     */
    public java.lang.String getOptimizeDatabaseOperationName() {
      java.lang.Object ref = optimizeDatabaseOperationName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        optimizeDatabaseOperationName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored database, and remove the dependency on the restore source.
     * The name is of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
     * where the &lt;database&gt; is the name of database being created and restored to.
     * The metadata type of the  long-running operation is
     * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata]. This long-running operation will be
     * automatically created by the system after the RestoreDatabase long-running
     * operation completes successfully. This operation will not be created if the
     * restore was not successful.
     * </pre>
     *
     * <code>string optimize_database_operation_name = 6;</code>
     *
     * @return The bytes for optimizeDatabaseOperationName.
     */
    public com.google.protobuf.ByteString getOptimizeDatabaseOperationNameBytes() {
      java.lang.Object ref = optimizeDatabaseOperationName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        optimizeDatabaseOperationName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored database, and remove the dependency on the restore source.
     * The name is of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
     * where the &lt;database&gt; is the name of database being created and restored to.
     * The metadata type of the  long-running operation is
     * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata]. This long-running operation will be
     * automatically created by the system after the RestoreDatabase long-running
     * operation completes successfully. This operation will not be created if the
     * restore was not successful.
     * </pre>
     *
     * <code>string optimize_database_operation_name = 6;</code>
     *
     * @param value The optimizeDatabaseOperationName to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizeDatabaseOperationName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      optimizeDatabaseOperationName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored database, and remove the dependency on the restore source.
     * The name is of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
     * where the &lt;database&gt; is the name of database being created and restored to.
     * The metadata type of the  long-running operation is
     * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata]. This long-running operation will be
     * automatically created by the system after the RestoreDatabase long-running
     * operation completes successfully. This operation will not be created if the
     * restore was not successful.
     * </pre>
     *
     * <code>string optimize_database_operation_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOptimizeDatabaseOperationName() {

      optimizeDatabaseOperationName_ = getDefaultInstance().getOptimizeDatabaseOperationName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If exists, the name of the long-running operation that will be used to
     * track the post-restore optimization process to optimize the performance of
     * the restored database, and remove the dependency on the restore source.
     * The name is of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;/operations/&lt;operation&gt;`
     * where the &lt;database&gt; is the name of database being created and restored to.
     * The metadata type of the  long-running operation is
     * [OptimizeRestoredDatabaseMetadata][google.spanner.admin.database.v1.OptimizeRestoredDatabaseMetadata]. This long-running operation will be
     * automatically created by the system after the RestoreDatabase long-running
     * operation completes successfully. This operation will not be created if the
     * restore was not successful.
     * </pre>
     *
     * <code>string optimize_database_operation_name = 6;</code>
     *
     * @param value The bytes for optimizeDatabaseOperationName to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizeDatabaseOperationNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      optimizeDatabaseOperationName_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.RestoreDatabaseMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.RestoreDatabaseMetadata)
  private static final com.google.spanner.admin.database.v1.RestoreDatabaseMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.RestoreDatabaseMetadata();
  }

  public static com.google.spanner.admin.database.v1.RestoreDatabaseMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestoreDatabaseMetadata> PARSER =
      new com.google.protobuf.AbstractParser<RestoreDatabaseMetadata>() {
        @java.lang.Override
        public RestoreDatabaseMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestoreDatabaseMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestoreDatabaseMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreDatabaseMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
