/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/backup.proto

package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [ListBackupOperations][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupOperations].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.ListBackupOperationsRequest}
 */
public final class ListBackupOperationsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.ListBackupOperationsRequest)
    ListBackupOperationsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListBackupOperationsRequest.newBuilder() to construct.
  private ListBackupOperationsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListBackupOperationsRequest() {
    parent_ = "";
    filter_ = "";
    pageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListBackupOperationsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_ListBackupOperationsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_ListBackupOperationsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.ListBackupOperationsRequest.class,
            com.google.spanner.admin.database.v1.ListBackupOperationsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The instance of the backup operations. Values are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The instance of the backup operations. Values are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;
  private volatile java.lang.Object filter_;
  /**
   *
   *
   * <pre>
   * An expression that filters the list of returned backup operations.
   * A filter expression consists of a field name, a
   * comparison operator, and a value for filtering.
   * The value must be a string, a number, or a boolean. The comparison operator
   * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
   * Colon `:` is the contains operator. Filter rules are not case sensitive.
   * The following fields in the [operation][google.longrunning.Operation]
   * are eligible for filtering:
   *   * `name` - The name of the long-running operation
   *   * `done` - False if the operation is in progress, else true.
   *   * `metadata.&#64;type` - the type of metadata. For example, the type string
   *      for [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] is
   *      `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
   *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
   *      `metadata.&#64;type` must be specified first if filtering on metadata
   *      fields.
   *   * `error` - Error associated with the long-running operation.
   *   * `response.&#64;type` - the type of response.
   *   * `response.&lt;field_name&gt;` - any field in response.value.
   * You can combine multiple expressions by enclosing each expression in
   * parentheses. By default, expressions are combined with AND logic, but
   * you can specify AND, OR, and NOT logic explicitly.
   * Here are a few examples:
   *   * `done:true` - The operation is complete.
   *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
   *      `metadata.database:prod` - Returns operations where:
   *      * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
   *      * The database the backup was taken from has a name containing the
   *      string "prod".
   *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
   *     `(metadata.name:howl) AND` &#92;
   *     `(metadata.progress.start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;") AND` &#92;
   *     `(error:*)` - Returns operations where:
   *     * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
   *     * The backup name contains the string "howl".
   *     * The operation started before 2018-03-28T14:50:00Z.
   *     * The operation resulted in an error.
   *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` &#92;
   *     `(metadata.source_backup:test) AND` &#92;
   *     `(metadata.progress.start_time &lt; &#92;"2022-01-18T14:50:00Z&#92;") AND` &#92;
   *     `(error:*)` - Returns operations where:
   *     * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
   *     * The source backup of the copied backup name contains the string
   *     "test".
   *     * The operation started before 2022-01-18T14:50:00Z.
   *     * The operation resulted in an error.
   *   * `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
   *     `(metadata.database:test_db)) OR` &#92;
   *     `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
   *     AND` &#92;
   *     `(metadata.source_backup:test_bkp)) AND` &#92;
   *     `(error:*)` - Returns operations where:
   *     * The operation's metadata matches either of criteria:
   *       * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] AND the
   *       database the backup was taken from has name containing string
   *       "test_db"
   *       * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata] AND the
   *       backup the backup was copied from has name containing string
   *       "test_bkp"
   *     * The operation resulted in an error.
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An expression that filters the list of returned backup operations.
   * A filter expression consists of a field name, a
   * comparison operator, and a value for filtering.
   * The value must be a string, a number, or a boolean. The comparison operator
   * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
   * Colon `:` is the contains operator. Filter rules are not case sensitive.
   * The following fields in the [operation][google.longrunning.Operation]
   * are eligible for filtering:
   *   * `name` - The name of the long-running operation
   *   * `done` - False if the operation is in progress, else true.
   *   * `metadata.&#64;type` - the type of metadata. For example, the type string
   *      for [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] is
   *      `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
   *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
   *      `metadata.&#64;type` must be specified first if filtering on metadata
   *      fields.
   *   * `error` - Error associated with the long-running operation.
   *   * `response.&#64;type` - the type of response.
   *   * `response.&lt;field_name&gt;` - any field in response.value.
   * You can combine multiple expressions by enclosing each expression in
   * parentheses. By default, expressions are combined with AND logic, but
   * you can specify AND, OR, and NOT logic explicitly.
   * Here are a few examples:
   *   * `done:true` - The operation is complete.
   *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
   *      `metadata.database:prod` - Returns operations where:
   *      * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
   *      * The database the backup was taken from has a name containing the
   *      string "prod".
   *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
   *     `(metadata.name:howl) AND` &#92;
   *     `(metadata.progress.start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;") AND` &#92;
   *     `(error:*)` - Returns operations where:
   *     * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
   *     * The backup name contains the string "howl".
   *     * The operation started before 2018-03-28T14:50:00Z.
   *     * The operation resulted in an error.
   *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` &#92;
   *     `(metadata.source_backup:test) AND` &#92;
   *     `(metadata.progress.start_time &lt; &#92;"2022-01-18T14:50:00Z&#92;") AND` &#92;
   *     `(error:*)` - Returns operations where:
   *     * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
   *     * The source backup of the copied backup name contains the string
   *     "test".
   *     * The operation started before 2022-01-18T14:50:00Z.
   *     * The operation resulted in an error.
   *   * `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
   *     `(metadata.database:test_db)) OR` &#92;
   *     `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
   *     AND` &#92;
   *     `(metadata.source_backup:test_bkp)) AND` &#92;
   *     `(error:*)` - Returns operations where:
   *     * The operation's metadata matches either of criteria:
   *       * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] AND the
   *       database the backup was taken from has name containing string
   *       "test_db"
   *       * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata] AND the
   *       backup the backup was copied from has name containing string
   *       "test_bkp"
   *     * The operation resulted in an error.
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 3;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * Number of operations to be returned in the response. If 0 or
   * less, defaults to the server's maximum allowed page size.
   * </pre>
   *
   * <code>int32 page_size = 3;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` should contain a
   * [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
   * from a previous [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse] to the
   * same `parent` and with the same `filter`.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If non-empty, `page_token` should contain a
   * [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
   * from a previous [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse] to the
   * same `parent` and with the same `filter`.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.ListBackupOperationsRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.ListBackupOperationsRequest other =
        (com.google.spanner.admin.database.v1.ListBackupOperationsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.ListBackupOperationsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [ListBackupOperations][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupOperations].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.ListBackupOperationsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.ListBackupOperationsRequest)
      com.google.spanner.admin.database.v1.ListBackupOperationsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_ListBackupOperationsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_ListBackupOperationsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.ListBackupOperationsRequest.class,
              com.google.spanner.admin.database.v1.ListBackupOperationsRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.ListBackupOperationsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      filter_ = "";

      pageSize_ = 0;

      pageToken_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_ListBackupOperationsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.ListBackupOperationsRequest
        getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.ListBackupOperationsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.ListBackupOperationsRequest build() {
      com.google.spanner.admin.database.v1.ListBackupOperationsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.ListBackupOperationsRequest buildPartial() {
      com.google.spanner.admin.database.v1.ListBackupOperationsRequest result =
          new com.google.spanner.admin.database.v1.ListBackupOperationsRequest(this);
      result.parent_ = parent_;
      result.filter_ = filter_;
      result.pageSize_ = pageSize_;
      result.pageToken_ = pageToken_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.ListBackupOperationsRequest) {
        return mergeFrom((com.google.spanner.admin.database.v1.ListBackupOperationsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.spanner.admin.database.v1.ListBackupOperationsRequest other) {
      if (other
          == com.google.spanner.admin.database.v1.ListBackupOperationsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 24:
              {
                pageSize_ = input.readInt32();

                break;
              } // case 24
            case 34:
              {
                pageToken_ = input.readStringRequireUtf8();

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The instance of the backup operations. Values are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instance of the backup operations. Values are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instance of the backup operations. Values are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instance of the backup operations. Values are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instance of the backup operations. Values are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * An expression that filters the list of returned backup operations.
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     * The following fields in the [operation][google.longrunning.Operation]
     * are eligible for filtering:
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] is
     *      `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic, but
     * you can specify AND, OR, and NOT logic explicitly.
     * Here are a few examples:
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *      `metadata.database:prod` - Returns operations where:
     *      * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *      * The database the backup was taken from has a name containing the
     *      string "prod".
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.name:howl) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *     * The backup name contains the string "howl".
     *     * The operation started before 2018-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` &#92;
     *     `(metadata.source_backup:test) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2022-01-18T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
     *     * The source backup of the copied backup name contains the string
     *     "test".
     *     * The operation started before 2022-01-18T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.database:test_db)) OR` &#92;
     *     `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
     *     AND` &#92;
     *     `(metadata.source_backup:test_bkp)) AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata matches either of criteria:
     *       * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] AND the
     *       database the backup was taken from has name containing string
     *       "test_db"
     *       * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata] AND the
     *       backup the backup was copied from has name containing string
     *       "test_bkp"
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression that filters the list of returned backup operations.
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     * The following fields in the [operation][google.longrunning.Operation]
     * are eligible for filtering:
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] is
     *      `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic, but
     * you can specify AND, OR, and NOT logic explicitly.
     * Here are a few examples:
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *      `metadata.database:prod` - Returns operations where:
     *      * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *      * The database the backup was taken from has a name containing the
     *      string "prod".
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.name:howl) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *     * The backup name contains the string "howl".
     *     * The operation started before 2018-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` &#92;
     *     `(metadata.source_backup:test) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2022-01-18T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
     *     * The source backup of the copied backup name contains the string
     *     "test".
     *     * The operation started before 2022-01-18T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.database:test_db)) OR` &#92;
     *     `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
     *     AND` &#92;
     *     `(metadata.source_backup:test_bkp)) AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata matches either of criteria:
     *       * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] AND the
     *       database the backup was taken from has name containing string
     *       "test_db"
     *       * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata] AND the
     *       backup the backup was copied from has name containing string
     *       "test_bkp"
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression that filters the list of returned backup operations.
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     * The following fields in the [operation][google.longrunning.Operation]
     * are eligible for filtering:
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] is
     *      `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic, but
     * you can specify AND, OR, and NOT logic explicitly.
     * Here are a few examples:
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *      `metadata.database:prod` - Returns operations where:
     *      * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *      * The database the backup was taken from has a name containing the
     *      string "prod".
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.name:howl) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *     * The backup name contains the string "howl".
     *     * The operation started before 2018-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` &#92;
     *     `(metadata.source_backup:test) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2022-01-18T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
     *     * The source backup of the copied backup name contains the string
     *     "test".
     *     * The operation started before 2022-01-18T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.database:test_db)) OR` &#92;
     *     `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
     *     AND` &#92;
     *     `(metadata.source_backup:test_bkp)) AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata matches either of criteria:
     *       * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] AND the
     *       database the backup was taken from has name containing string
     *       "test_db"
     *       * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata] AND the
     *       backup the backup was copied from has name containing string
     *       "test_bkp"
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression that filters the list of returned backup operations.
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     * The following fields in the [operation][google.longrunning.Operation]
     * are eligible for filtering:
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] is
     *      `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic, but
     * you can specify AND, OR, and NOT logic explicitly.
     * Here are a few examples:
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *      `metadata.database:prod` - Returns operations where:
     *      * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *      * The database the backup was taken from has a name containing the
     *      string "prod".
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.name:howl) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *     * The backup name contains the string "howl".
     *     * The operation started before 2018-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` &#92;
     *     `(metadata.source_backup:test) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2022-01-18T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
     *     * The source backup of the copied backup name contains the string
     *     "test".
     *     * The operation started before 2022-01-18T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.database:test_db)) OR` &#92;
     *     `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
     *     AND` &#92;
     *     `(metadata.source_backup:test_bkp)) AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata matches either of criteria:
     *       * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] AND the
     *       database the backup was taken from has name containing string
     *       "test_db"
     *       * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata] AND the
     *       backup the backup was copied from has name containing string
     *       "test_bkp"
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {

      filter_ = getDefaultInstance().getFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression that filters the list of returned backup operations.
     * A filter expression consists of a field name, a
     * comparison operator, and a value for filtering.
     * The value must be a string, a number, or a boolean. The comparison operator
     * must be one of: `&lt;`, `&gt;`, `&lt;=`, `&gt;=`, `!=`, `=`, or `:`.
     * Colon `:` is the contains operator. Filter rules are not case sensitive.
     * The following fields in the [operation][google.longrunning.Operation]
     * are eligible for filtering:
     *   * `name` - The name of the long-running operation
     *   * `done` - False if the operation is in progress, else true.
     *   * `metadata.&#64;type` - the type of metadata. For example, the type string
     *      for [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] is
     *      `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
     *   * `metadata.&lt;field_name&gt;` - any field in metadata.value.
     *      `metadata.&#64;type` must be specified first if filtering on metadata
     *      fields.
     *   * `error` - Error associated with the long-running operation.
     *   * `response.&#64;type` - the type of response.
     *   * `response.&lt;field_name&gt;` - any field in response.value.
     * You can combine multiple expressions by enclosing each expression in
     * parentheses. By default, expressions are combined with AND logic, but
     * you can specify AND, OR, and NOT logic explicitly.
     * Here are a few examples:
     *   * `done:true` - The operation is complete.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *      `metadata.database:prod` - Returns operations where:
     *      * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *      * The database the backup was taken from has a name containing the
     *      string "prod".
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.name:howl) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2018-03-28T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     *     * The backup name contains the string "howl".
     *     * The operation started before 2018-03-28T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `(metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` &#92;
     *     `(metadata.source_backup:test) AND` &#92;
     *     `(metadata.progress.start_time &lt; &#92;"2022-01-18T14:50:00Z&#92;") AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
     *     * The source backup of the copied backup name contains the string
     *     "test".
     *     * The operation started before 2022-01-18T14:50:00Z.
     *     * The operation resulted in an error.
     *   * `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` &#92;
     *     `(metadata.database:test_db)) OR` &#92;
     *     `((metadata.&#64;type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
     *     AND` &#92;
     *     `(metadata.source_backup:test_bkp)) AND` &#92;
     *     `(error:*)` - Returns operations where:
     *     * The operation's metadata matches either of criteria:
     *       * The operation's metadata type is [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata] AND the
     *       database the backup was taken from has name containing string
     *       "test_db"
     *       * The operation's metadata type is [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata] AND the
     *       backup the backup was copied from has name containing string
     *       "test_bkp"
     *     * The operation resulted in an error.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filter_ = value;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Number of operations to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Number of operations to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of operations to be returned in the response. If 0 or
     * less, defaults to the server's maximum allowed page size.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
     * from a previous [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
     * from a previous [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
     * from a previous [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
     * from a previous [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If non-empty, `page_token` should contain a
     * [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
     * from a previous [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse] to the
     * same `parent` and with the same `filter`.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.ListBackupOperationsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.ListBackupOperationsRequest)
  private static final com.google.spanner.admin.database.v1.ListBackupOperationsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.ListBackupOperationsRequest();
  }

  public static com.google.spanner.admin.database.v1.ListBackupOperationsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListBackupOperationsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListBackupOperationsRequest>() {
        @java.lang.Override
        public ListBackupOperationsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListBackupOperationsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListBackupOperationsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.ListBackupOperationsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
