/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * The request for [CreateDatabase][google.spanner.admin.database.v1.DatabaseAdmin.CreateDatabase].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.CreateDatabaseRequest}
 */
public final class CreateDatabaseRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.CreateDatabaseRequest)
    CreateDatabaseRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateDatabaseRequest.newBuilder() to construct.
  private CreateDatabaseRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateDatabaseRequest() {
    parent_ = "";
    createStatement_ = "";
    extraStatements_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    databaseDialect_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateDatabaseRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.CreateDatabaseRequest.class,
            com.google.spanner.admin.database.v1.CreateDatabaseRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The name of the instance that will serve the new database.
   * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the instance that will serve the new database.
   * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_STATEMENT_FIELD_NUMBER = 2;
  private volatile java.lang.Object createStatement_;
  /**
   *
   *
   * <pre>
   * Required. A `CREATE DATABASE` statement, which specifies the ID of the
   * new database.  The database ID must conform to the regular expression
   * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
   * If the database ID is a reserved word or if it contains a hyphen, the
   * database ID must be enclosed in backticks (`` ` ``).
   * </pre>
   *
   * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The createStatement.
   */
  @java.lang.Override
  public java.lang.String getCreateStatement() {
    java.lang.Object ref = createStatement_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      createStatement_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A `CREATE DATABASE` statement, which specifies the ID of the
   * new database.  The database ID must conform to the regular expression
   * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
   * If the database ID is a reserved word or if it contains a hyphen, the
   * database ID must be enclosed in backticks (`` ` ``).
   * </pre>
   *
   * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for createStatement.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreateStatementBytes() {
    java.lang.Object ref = createStatement_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      createStatement_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTRA_STATEMENTS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList extraStatements_;
  /**
   *
   *
   * <pre>
   * Optional. A list of DDL statements to run inside the newly created
   * database. Statements can create tables, indexes, etc. These
   * statements execute atomically with the creation of the database:
   * if there is an error in any statement, the database is not created.
   * </pre>
   *
   * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the extraStatements.
   */
  public com.google.protobuf.ProtocolStringList getExtraStatementsList() {
    return extraStatements_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of DDL statements to run inside the newly created
   * database. Statements can create tables, indexes, etc. These
   * statements execute atomically with the creation of the database:
   * if there is an error in any statement, the database is not created.
   * </pre>
   *
   * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of extraStatements.
   */
  public int getExtraStatementsCount() {
    return extraStatements_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of DDL statements to run inside the newly created
   * database. Statements can create tables, indexes, etc. These
   * statements execute atomically with the creation of the database:
   * if there is an error in any statement, the database is not created.
   * </pre>
   *
   * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The extraStatements at the given index.
   */
  public java.lang.String getExtraStatements(int index) {
    return extraStatements_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of DDL statements to run inside the newly created
   * database. Statements can create tables, indexes, etc. These
   * statements execute atomically with the creation of the database:
   * if there is an error in any statement, the database is not created.
   * </pre>
   *
   * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the extraStatements at the given index.
   */
  public com.google.protobuf.ByteString getExtraStatementsBytes(int index) {
    return extraStatements_.getByteString(index);
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.EncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration for the database. If this field is not
   * specified, Cloud Spanner will encrypt/decrypt all data at rest using
   * Google default encryption.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return encryptionConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration for the database. If this field is not
   * specified, Cloud Spanner will encrypt/decrypt all data at rest using
   * Google default encryption.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration for the database. If this field is not
   * specified, Cloud Spanner will encrypt/decrypt all data at rest using
   * Google default encryption.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return getEncryptionConfig();
  }

  public static final int DATABASE_DIALECT_FIELD_NUMBER = 5;
  private int databaseDialect_;
  /**
   *
   *
   * <pre>
   * Optional. The dialect of the Cloud Spanner Database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseDialect.
   */
  @java.lang.Override
  public int getDatabaseDialectValue() {
    return databaseDialect_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The dialect of the Cloud Spanner Database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The databaseDialect.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect() {
    @SuppressWarnings("deprecation")
    com.google.spanner.admin.database.v1.DatabaseDialect result =
        com.google.spanner.admin.database.v1.DatabaseDialect.valueOf(databaseDialect_);
    return result == null
        ? com.google.spanner.admin.database.v1.DatabaseDialect.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(createStatement_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, createStatement_);
    }
    for (int i = 0; i < extraStatements_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, extraStatements_.getRaw(i));
    }
    if (encryptionConfig_ != null) {
      output.writeMessage(4, getEncryptionConfig());
    }
    if (databaseDialect_
        != com.google.spanner.admin.database.v1.DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, databaseDialect_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(createStatement_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, createStatement_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < extraStatements_.size(); i++) {
        dataSize += computeStringSizeNoTag(extraStatements_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExtraStatementsList().size();
    }
    if (encryptionConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEncryptionConfig());
    }
    if (databaseDialect_
        != com.google.spanner.admin.database.v1.DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, databaseDialect_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.CreateDatabaseRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.CreateDatabaseRequest other =
        (com.google.spanner.admin.database.v1.CreateDatabaseRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getCreateStatement().equals(other.getCreateStatement())) return false;
    if (!getExtraStatementsList().equals(other.getExtraStatementsList())) return false;
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (databaseDialect_ != other.databaseDialect_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + CREATE_STATEMENT_FIELD_NUMBER;
    hash = (53 * hash) + getCreateStatement().hashCode();
    if (getExtraStatementsCount() > 0) {
      hash = (37 * hash) + EXTRA_STATEMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getExtraStatementsList().hashCode();
    }
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    hash = (37 * hash) + DATABASE_DIALECT_FIELD_NUMBER;
    hash = (53 * hash) + databaseDialect_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.CreateDatabaseRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [CreateDatabase][google.spanner.admin.database.v1.DatabaseAdmin.CreateDatabase].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.CreateDatabaseRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.CreateDatabaseRequest)
      com.google.spanner.admin.database.v1.CreateDatabaseRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.CreateDatabaseRequest.class,
              com.google.spanner.admin.database.v1.CreateDatabaseRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.CreateDatabaseRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      createStatement_ = "";

      extraStatements_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = null;
      } else {
        encryptionConfig_ = null;
        encryptionConfigBuilder_ = null;
      }
      databaseDialect_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_CreateDatabaseRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateDatabaseRequest getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.CreateDatabaseRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateDatabaseRequest build() {
      com.google.spanner.admin.database.v1.CreateDatabaseRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CreateDatabaseRequest buildPartial() {
      com.google.spanner.admin.database.v1.CreateDatabaseRequest result =
          new com.google.spanner.admin.database.v1.CreateDatabaseRequest(this);
      int from_bitField0_ = bitField0_;
      result.parent_ = parent_;
      result.createStatement_ = createStatement_;
      if (((bitField0_ & 0x00000001) != 0)) {
        extraStatements_ = extraStatements_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.extraStatements_ = extraStatements_;
      if (encryptionConfigBuilder_ == null) {
        result.encryptionConfig_ = encryptionConfig_;
      } else {
        result.encryptionConfig_ = encryptionConfigBuilder_.build();
      }
      result.databaseDialect_ = databaseDialect_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.CreateDatabaseRequest) {
        return mergeFrom((com.google.spanner.admin.database.v1.CreateDatabaseRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.CreateDatabaseRequest other) {
      if (other == com.google.spanner.admin.database.v1.CreateDatabaseRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getCreateStatement().isEmpty()) {
        createStatement_ = other.createStatement_;
        onChanged();
      }
      if (!other.extraStatements_.isEmpty()) {
        if (extraStatements_.isEmpty()) {
          extraStatements_ = other.extraStatements_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureExtraStatementsIsMutable();
          extraStatements_.addAll(other.extraStatements_);
        }
        onChanged();
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      if (other.databaseDialect_ != 0) {
        setDatabaseDialectValue(other.getDatabaseDialectValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                createStatement_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExtraStatementsIsMutable();
                extraStatements_.add(s);
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 40:
              {
                databaseDialect_ = input.readEnum();

                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the instance that will serve the new database.
     * Values are of the form `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object createStatement_ = "";
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The createStatement.
     */
    public java.lang.String getCreateStatement() {
      java.lang.Object ref = createStatement_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        createStatement_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for createStatement.
     */
    public com.google.protobuf.ByteString getCreateStatementBytes() {
      java.lang.Object ref = createStatement_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        createStatement_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The createStatement to set.
     * @return This builder for chaining.
     */
    public Builder setCreateStatement(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      createStatement_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreateStatement() {

      createStatement_ = getDefaultInstance().getCreateStatement();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A `CREATE DATABASE` statement, which specifies the ID of the
     * new database.  The database ID must conform to the regular expression
     * `[a-z][a-z0-9_&#92;-]*[a-z0-9]` and be between 2 and 30 characters in length.
     * If the database ID is a reserved word or if it contains a hyphen, the
     * database ID must be enclosed in backticks (`` ` ``).
     * </pre>
     *
     * <code>string create_statement = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for createStatement to set.
     * @return This builder for chaining.
     */
    public Builder setCreateStatementBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      createStatement_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList extraStatements_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureExtraStatementsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        extraStatements_ = new com.google.protobuf.LazyStringArrayList(extraStatements_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the extraStatements.
     */
    public com.google.protobuf.ProtocolStringList getExtraStatementsList() {
      return extraStatements_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of extraStatements.
     */
    public int getExtraStatementsCount() {
      return extraStatements_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The extraStatements at the given index.
     */
    public java.lang.String getExtraStatements(int index) {
      return extraStatements_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the extraStatements at the given index.
     */
    public com.google.protobuf.ByteString getExtraStatementsBytes(int index) {
      return extraStatements_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The extraStatements to set.
     * @return This builder for chaining.
     */
    public Builder setExtraStatements(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExtraStatementsIsMutable();
      extraStatements_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The extraStatements to add.
     * @return This builder for chaining.
     */
    public Builder addExtraStatements(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExtraStatementsIsMutable();
      extraStatements_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The extraStatements to add.
     * @return This builder for chaining.
     */
    public Builder addAllExtraStatements(java.lang.Iterable<java.lang.String> values) {
      ensureExtraStatementsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, extraStatements_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExtraStatements() {
      extraStatements_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of DDL statements to run inside the newly created
     * database. Statements can create tables, indexes, etc. These
     * statements execute atomically with the creation of the database:
     * if there is an error in any statement, the database is not created.
     * </pre>
     *
     * <code>repeated string extra_statements = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the extraStatements to add.
     * @return This builder for chaining.
     */
    public Builder addExtraStatementsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExtraStatementsIsMutable();
      extraStatements_.add(value);
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.EncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionConfig,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return encryptionConfigBuilder_ != null || encryptionConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
        onChanged();
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
        onChanged();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (encryptionConfig_ != null) {
          encryptionConfig_ =
              com.google.spanner.admin.database.v1.EncryptionConfig.newBuilder(encryptionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          encryptionConfig_ = value;
        }
        onChanged();
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = null;
        onChanged();
      } else {
        encryptionConfig_ = null;
        encryptionConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionConfig.Builder
        getEncryptionConfigBuilder() {

      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration for the database. If this field is not
     * specified, Cloud Spanner will encrypt/decrypt all data at rest using
     * Google default encryption.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionConfig,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.EncryptionConfig,
                com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
                com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    private int databaseDialect_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for databaseDialect.
     */
    @java.lang.Override
    public int getDatabaseDialectValue() {
      return databaseDialect_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseDialect to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDialectValue(int value) {

      databaseDialect_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The databaseDialect.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect() {
      @SuppressWarnings("deprecation")
      com.google.spanner.admin.database.v1.DatabaseDialect result =
          com.google.spanner.admin.database.v1.DatabaseDialect.valueOf(databaseDialect_);
      return result == null
          ? com.google.spanner.admin.database.v1.DatabaseDialect.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The databaseDialect to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDialect(com.google.spanner.admin.database.v1.DatabaseDialect value) {
      if (value == null) {
        throw new NullPointerException();
      }

      databaseDialect_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseDialect() {

      databaseDialect_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.CreateDatabaseRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.CreateDatabaseRequest)
  private static final com.google.spanner.admin.database.v1.CreateDatabaseRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.CreateDatabaseRequest();
  }

  public static com.google.spanner.admin.database.v1.CreateDatabaseRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateDatabaseRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateDatabaseRequest>() {
        @java.lang.Override
        public CreateDatabaseRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateDatabaseRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateDatabaseRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.CreateDatabaseRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
