/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PolicyBasedRouteName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_POLICY_BASED_ROUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/{location}/global/PolicyBasedRoutes/{policy_based_route}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String policyBasedRoute;

    @Deprecated
    protected PolicyBasedRouteName() {
        this.project = null;
        this.location = null;
        this.policyBasedRoute = null;
    }

    private PolicyBasedRouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.policyBasedRoute = (String)Preconditions.checkNotNull((Object)builder.getPolicyBasedRoute());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPolicyBasedRoute() {
        return this.policyBasedRoute;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PolicyBasedRouteName of(String project, String location, String policyBasedRoute) {
        return PolicyBasedRouteName.newBuilder().setProject(project).setLocation(location).setPolicyBasedRoute(policyBasedRoute).build();
    }

    public static String format(String project, String location, String policyBasedRoute) {
        return PolicyBasedRouteName.newBuilder().setProject(project).setLocation(location).setPolicyBasedRoute(policyBasedRoute).build().toString();
    }

    public static PolicyBasedRouteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_POLICY_BASED_ROUTE.validatedMatch(formattedString, "PolicyBasedRouteName.parse: formattedString not in valid format");
        return PolicyBasedRouteName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("policy_based_route"));
    }

    public static List<PolicyBasedRouteName> parseList(List<String> formattedStrings) {
        ArrayList<PolicyBasedRouteName> list = new ArrayList<PolicyBasedRouteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PolicyBasedRouteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PolicyBasedRouteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PolicyBasedRouteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_POLICY_BASED_ROUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PolicyBasedRouteName policyBasedRouteName = this;
            synchronized (policyBasedRouteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.policyBasedRoute != null) {
                        fieldMapBuilder.put((Object)"policy_based_route", (Object)this.policyBasedRoute);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_POLICY_BASED_ROUTE.instantiate(new String[]{"project", this.project, "location", this.location, "policy_based_route", this.policyBasedRoute});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PolicyBasedRouteName that = (PolicyBasedRouteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.policyBasedRoute, that.policyBasedRoute);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.policyBasedRoute);
    }

    public static class Builder {
        private String project;
        private String location;
        private String policyBasedRoute;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPolicyBasedRoute() {
            return this.policyBasedRoute;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPolicyBasedRoute(String policyBasedRoute) {
            this.policyBasedRoute = policyBasedRoute;
            return this;
        }

        private Builder(PolicyBasedRouteName policyBasedRouteName) {
            this.project = policyBasedRouteName.project;
            this.location = policyBasedRouteName.location;
            this.policyBasedRoute = policyBasedRouteName.policyBasedRoute;
        }

        public PolicyBasedRouteName build() {
            return new PolicyBasedRouteName(this);
        }
    }
}

