/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkconnectivity/v1/hub.proto

package com.google.cloud.networkconnectivity.v1;

/**
 *
 *
 * <pre>
 * A Network Connectivity Center spoke represents a connection between your
 * Google Cloud network resources and a non-Google-Cloud network.
 * When you create a spoke, you associate it with a hub. You must also identify
 * a value for exactly one of the following fields:
 * * linked_vpn_tunnels
 * * linked_interconnect_attachments
 * * linked_router_appliance_instances
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkconnectivity.v1.Spoke}
 */
public final class Spoke extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkconnectivity.v1.Spoke)
    SpokeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Spoke.newBuilder() to construct.
  private Spoke(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Spoke() {
    name_ = "";
    description_ = "";
    hub_ = "";
    uniqueId_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Spoke();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkconnectivity.v1.HubProto
        .internal_static_google_cloud_networkconnectivity_v1_Spoke_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkconnectivity.v1.HubProto
        .internal_static_google_cloud_networkconnectivity_v1_Spoke_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkconnectivity.v1.Spoke.class,
            com.google.cloud.networkconnectivity.v1.Spoke.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Immutable. The name of the spoke. Spoke names must be unique. They use the
   * following form:
   *     `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The name of the spoke. Spoke names must be unique. They use the
   * following form:
   *     `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the spoke was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the spoke was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the spoke was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the spoke was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the spoke was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the spoke was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.networkconnectivity.v1.HubProto
                .internal_static_google_cloud_networkconnectivity_v1_Spoke_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * An optional description of the spoke.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of the spoke.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HUB_FIELD_NUMBER = 6;
  private volatile java.lang.Object hub_;
  /**
   *
   *
   * <pre>
   * Immutable. The name of the hub that this spoke is attached to.
   * </pre>
   *
   * <code>
   * string hub = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The hub.
   */
  @java.lang.Override
  public java.lang.String getHub() {
    java.lang.Object ref = hub_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hub_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The name of the hub that this spoke is attached to.
   * </pre>
   *
   * <code>
   * string hub = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for hub.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHubBytes() {
    java.lang.Object ref = hub_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hub_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_VPN_TUNNELS_FIELD_NUMBER = 17;
  private com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linkedVpnTunnels_;
  /**
   *
   *
   * <pre>
   * VPN tunnels that are associated with the spoke.
   * </pre>
   *
   * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
   *
   * @return Whether the linkedVpnTunnels field is set.
   */
  @java.lang.Override
  public boolean hasLinkedVpnTunnels() {
    return linkedVpnTunnels_ != null;
  }
  /**
   *
   *
   * <pre>
   * VPN tunnels that are associated with the spoke.
   * </pre>
   *
   * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
   *
   * @return The linkedVpnTunnels.
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels getLinkedVpnTunnels() {
    return linkedVpnTunnels_ == null
        ? com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.getDefaultInstance()
        : linkedVpnTunnels_;
  }
  /**
   *
   *
   * <pre>
   * VPN tunnels that are associated with the spoke.
   * </pre>
   *
   * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.LinkedVpnTunnelsOrBuilder
      getLinkedVpnTunnelsOrBuilder() {
    return getLinkedVpnTunnels();
  }

  public static final int LINKED_INTERCONNECT_ATTACHMENTS_FIELD_NUMBER = 18;
  private com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
      linkedInterconnectAttachments_;
  /**
   *
   *
   * <pre>
   * VLAN attachments that are associated with the spoke.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
   * </code>
   *
   * @return Whether the linkedInterconnectAttachments field is set.
   */
  @java.lang.Override
  public boolean hasLinkedInterconnectAttachments() {
    return linkedInterconnectAttachments_ != null;
  }
  /**
   *
   *
   * <pre>
   * VLAN attachments that are associated with the spoke.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
   * </code>
   *
   * @return The linkedInterconnectAttachments.
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
      getLinkedInterconnectAttachments() {
    return linkedInterconnectAttachments_ == null
        ? com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.getDefaultInstance()
        : linkedInterconnectAttachments_;
  }
  /**
   *
   *
   * <pre>
   * VLAN attachments that are associated with the spoke.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachmentsOrBuilder
      getLinkedInterconnectAttachmentsOrBuilder() {
    return getLinkedInterconnectAttachments();
  }

  public static final int LINKED_ROUTER_APPLIANCE_INSTANCES_FIELD_NUMBER = 19;
  private com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
      linkedRouterApplianceInstances_;
  /**
   *
   *
   * <pre>
   * Router appliance instances that are associated with the spoke.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
   * </code>
   *
   * @return Whether the linkedRouterApplianceInstances field is set.
   */
  @java.lang.Override
  public boolean hasLinkedRouterApplianceInstances() {
    return linkedRouterApplianceInstances_ != null;
  }
  /**
   *
   *
   * <pre>
   * Router appliance instances that are associated with the spoke.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
   * </code>
   *
   * @return The linkedRouterApplianceInstances.
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
      getLinkedRouterApplianceInstances() {
    return linkedRouterApplianceInstances_ == null
        ? com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
            .getDefaultInstance()
        : linkedRouterApplianceInstances_;
  }
  /**
   *
   *
   * <pre>
   * Router appliance instances that are associated with the spoke.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstancesOrBuilder
      getLinkedRouterApplianceInstancesOrBuilder() {
    return getLinkedRouterApplianceInstances();
  }

  public static final int UNIQUE_ID_FIELD_NUMBER = 11;
  private volatile java.lang.Object uniqueId_;
  /**
   *
   *
   * <pre>
   * Output only. The Google-generated UUID for the spoke. This value is unique
   * across all spoke resources. If a spoke is deleted and another with the same
   * name is created, the new spoke is assigned a different unique_id.
   * </pre>
   *
   * <code>string unique_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uniqueId.
   */
  @java.lang.Override
  public java.lang.String getUniqueId() {
    java.lang.Object ref = uniqueId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uniqueId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The Google-generated UUID for the spoke. This value is unique
   * across all spoke resources. If a spoke is deleted and another with the same
   * name is created, the new spoke is assigned a different unique_id.
   * </pre>
   *
   * <code>string unique_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uniqueId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUniqueIdBytes() {
    java.lang.Object ref = uniqueId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uniqueId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 15;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current lifecycle state of this spoke.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current lifecycle state of this spoke.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.networkconnectivity.v1.State result =
        com.google.cloud.networkconnectivity.v1.State.valueOf(state_);
    return result == null ? com.google.cloud.networkconnectivity.v1.State.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hub_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, hub_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uniqueId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, uniqueId_);
    }
    if (state_ != com.google.cloud.networkconnectivity.v1.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(15, state_);
    }
    if (linkedVpnTunnels_ != null) {
      output.writeMessage(17, getLinkedVpnTunnels());
    }
    if (linkedInterconnectAttachments_ != null) {
      output.writeMessage(18, getLinkedInterconnectAttachments());
    }
    if (linkedRouterApplianceInstances_ != null) {
      output.writeMessage(19, getLinkedRouterApplianceInstances());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hub_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, hub_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uniqueId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, uniqueId_);
    }
    if (state_ != com.google.cloud.networkconnectivity.v1.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, state_);
    }
    if (linkedVpnTunnels_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getLinkedVpnTunnels());
    }
    if (linkedInterconnectAttachments_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getLinkedInterconnectAttachments());
    }
    if (linkedRouterApplianceInstances_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, getLinkedRouterApplianceInstances());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkconnectivity.v1.Spoke)) {
      return super.equals(obj);
    }
    com.google.cloud.networkconnectivity.v1.Spoke other =
        (com.google.cloud.networkconnectivity.v1.Spoke) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getHub().equals(other.getHub())) return false;
    if (hasLinkedVpnTunnels() != other.hasLinkedVpnTunnels()) return false;
    if (hasLinkedVpnTunnels()) {
      if (!getLinkedVpnTunnels().equals(other.getLinkedVpnTunnels())) return false;
    }
    if (hasLinkedInterconnectAttachments() != other.hasLinkedInterconnectAttachments())
      return false;
    if (hasLinkedInterconnectAttachments()) {
      if (!getLinkedInterconnectAttachments().equals(other.getLinkedInterconnectAttachments()))
        return false;
    }
    if (hasLinkedRouterApplianceInstances() != other.hasLinkedRouterApplianceInstances())
      return false;
    if (hasLinkedRouterApplianceInstances()) {
      if (!getLinkedRouterApplianceInstances().equals(other.getLinkedRouterApplianceInstances()))
        return false;
    }
    if (!getUniqueId().equals(other.getUniqueId())) return false;
    if (state_ != other.state_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + HUB_FIELD_NUMBER;
    hash = (53 * hash) + getHub().hashCode();
    if (hasLinkedVpnTunnels()) {
      hash = (37 * hash) + LINKED_VPN_TUNNELS_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedVpnTunnels().hashCode();
    }
    if (hasLinkedInterconnectAttachments()) {
      hash = (37 * hash) + LINKED_INTERCONNECT_ATTACHMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedInterconnectAttachments().hashCode();
    }
    if (hasLinkedRouterApplianceInstances()) {
      hash = (37 * hash) + LINKED_ROUTER_APPLIANCE_INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + getLinkedRouterApplianceInstances().hashCode();
    }
    hash = (37 * hash) + UNIQUE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUniqueId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.networkconnectivity.v1.Spoke prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Network Connectivity Center spoke represents a connection between your
   * Google Cloud network resources and a non-Google-Cloud network.
   * When you create a spoke, you associate it with a hub. You must also identify
   * a value for exactly one of the following fields:
   * * linked_vpn_tunnels
   * * linked_interconnect_attachments
   * * linked_router_appliance_instances
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkconnectivity.v1.Spoke}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkconnectivity.v1.Spoke)
      com.google.cloud.networkconnectivity.v1.SpokeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_Spoke_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_Spoke_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkconnectivity.v1.Spoke.class,
              com.google.cloud.networkconnectivity.v1.Spoke.Builder.class);
    }

    // Construct using com.google.cloud.networkconnectivity.v1.Spoke.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      description_ = "";

      hub_ = "";

      if (linkedVpnTunnelsBuilder_ == null) {
        linkedVpnTunnels_ = null;
      } else {
        linkedVpnTunnels_ = null;
        linkedVpnTunnelsBuilder_ = null;
      }
      if (linkedInterconnectAttachmentsBuilder_ == null) {
        linkedInterconnectAttachments_ = null;
      } else {
        linkedInterconnectAttachments_ = null;
        linkedInterconnectAttachmentsBuilder_ = null;
      }
      if (linkedRouterApplianceInstancesBuilder_ == null) {
        linkedRouterApplianceInstances_ = null;
      } else {
        linkedRouterApplianceInstances_ = null;
        linkedRouterApplianceInstancesBuilder_ = null;
      }
      uniqueId_ = "";

      state_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_Spoke_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.Spoke getDefaultInstanceForType() {
      return com.google.cloud.networkconnectivity.v1.Spoke.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.Spoke build() {
      com.google.cloud.networkconnectivity.v1.Spoke result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.Spoke buildPartial() {
      com.google.cloud.networkconnectivity.v1.Spoke result =
          new com.google.cloud.networkconnectivity.v1.Spoke(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.description_ = description_;
      result.hub_ = hub_;
      if (linkedVpnTunnelsBuilder_ == null) {
        result.linkedVpnTunnels_ = linkedVpnTunnels_;
      } else {
        result.linkedVpnTunnels_ = linkedVpnTunnelsBuilder_.build();
      }
      if (linkedInterconnectAttachmentsBuilder_ == null) {
        result.linkedInterconnectAttachments_ = linkedInterconnectAttachments_;
      } else {
        result.linkedInterconnectAttachments_ = linkedInterconnectAttachmentsBuilder_.build();
      }
      if (linkedRouterApplianceInstancesBuilder_ == null) {
        result.linkedRouterApplianceInstances_ = linkedRouterApplianceInstances_;
      } else {
        result.linkedRouterApplianceInstances_ = linkedRouterApplianceInstancesBuilder_.build();
      }
      result.uniqueId_ = uniqueId_;
      result.state_ = state_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkconnectivity.v1.Spoke) {
        return mergeFrom((com.google.cloud.networkconnectivity.v1.Spoke) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkconnectivity.v1.Spoke other) {
      if (other == com.google.cloud.networkconnectivity.v1.Spoke.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getHub().isEmpty()) {
        hub_ = other.hub_;
        onChanged();
      }
      if (other.hasLinkedVpnTunnels()) {
        mergeLinkedVpnTunnels(other.getLinkedVpnTunnels());
      }
      if (other.hasLinkedInterconnectAttachments()) {
        mergeLinkedInterconnectAttachments(other.getLinkedInterconnectAttachments());
      }
      if (other.hasLinkedRouterApplianceInstances()) {
        mergeLinkedRouterApplianceInstances(other.getLinkedRouterApplianceInstances());
      }
      if (!other.getUniqueId().isEmpty()) {
        uniqueId_ = other.uniqueId_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                hub_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 90:
              {
                uniqueId_ = input.readStringRequireUtf8();

                break;
              } // case 90
            case 120:
              {
                state_ = input.readEnum();

                break;
              } // case 120
            case 138:
              {
                input.readMessage(
                    getLinkedVpnTunnelsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getLinkedInterconnectAttachmentsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getLinkedRouterApplianceInstancesFieldBuilder().getBuilder(),
                    extensionRegistry);

                break;
              } // case 154
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The name of the spoke. Spoke names must be unique. They use the
     * following form:
     *     `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the spoke. Spoke names must be unique. They use the
     * following form:
     *     `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the spoke. Spoke names must be unique. They use the
     * following form:
     *     `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the spoke. Spoke names must be unique. They use the
     * following form:
     *     `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the spoke. Spoke names must be unique. They use the
     * following form:
     *     `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the spoke was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional labels in key:value format. For more information about labels, see
     * [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional labels in key:value format. For more information about labels, see
     * [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional labels in key:value format. For more information about labels, see
     * [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional labels in key:value format. For more information about labels, see
     * [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional labels in key:value format. For more information about labels, see
     * [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional labels in key:value format. For more information about labels, see
     * [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional labels in key:value format. For more information about labels, see
     * [Requirements for
     * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of the spoke.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of the spoke.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of the spoke.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of the spoke.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of the spoke.
     * </pre>
     *
     * <code>string description = 5;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object hub_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The name of the hub that this spoke is attached to.
     * </pre>
     *
     * <code>
     * string hub = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The hub.
     */
    public java.lang.String getHub() {
      java.lang.Object ref = hub_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hub_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the hub that this spoke is attached to.
     * </pre>
     *
     * <code>
     * string hub = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for hub.
     */
    public com.google.protobuf.ByteString getHubBytes() {
      java.lang.Object ref = hub_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hub_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the hub that this spoke is attached to.
     * </pre>
     *
     * <code>
     * string hub = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The hub to set.
     * @return This builder for chaining.
     */
    public Builder setHub(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      hub_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the hub that this spoke is attached to.
     * </pre>
     *
     * <code>
     * string hub = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHub() {

      hub_ = getDefaultInstance().getHub();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The name of the hub that this spoke is attached to.
     * </pre>
     *
     * <code>
     * string hub = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for hub to set.
     * @return This builder for chaining.
     */
    public Builder setHubBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      hub_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linkedVpnTunnels_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels,
            com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.Builder,
            com.google.cloud.networkconnectivity.v1.LinkedVpnTunnelsOrBuilder>
        linkedVpnTunnelsBuilder_;
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     *
     * @return Whether the linkedVpnTunnels field is set.
     */
    public boolean hasLinkedVpnTunnels() {
      return linkedVpnTunnelsBuilder_ != null || linkedVpnTunnels_ != null;
    }
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     *
     * @return The linkedVpnTunnels.
     */
    public com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels getLinkedVpnTunnels() {
      if (linkedVpnTunnelsBuilder_ == null) {
        return linkedVpnTunnels_ == null
            ? com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.getDefaultInstance()
            : linkedVpnTunnels_;
      } else {
        return linkedVpnTunnelsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     */
    public Builder setLinkedVpnTunnels(
        com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels value) {
      if (linkedVpnTunnelsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedVpnTunnels_ = value;
        onChanged();
      } else {
        linkedVpnTunnelsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     */
    public Builder setLinkedVpnTunnels(
        com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.Builder builderForValue) {
      if (linkedVpnTunnelsBuilder_ == null) {
        linkedVpnTunnels_ = builderForValue.build();
        onChanged();
      } else {
        linkedVpnTunnelsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     */
    public Builder mergeLinkedVpnTunnels(
        com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels value) {
      if (linkedVpnTunnelsBuilder_ == null) {
        if (linkedVpnTunnels_ != null) {
          linkedVpnTunnels_ =
              com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.newBuilder(linkedVpnTunnels_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          linkedVpnTunnels_ = value;
        }
        onChanged();
      } else {
        linkedVpnTunnelsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     */
    public Builder clearLinkedVpnTunnels() {
      if (linkedVpnTunnelsBuilder_ == null) {
        linkedVpnTunnels_ = null;
        onChanged();
      } else {
        linkedVpnTunnels_ = null;
        linkedVpnTunnelsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     */
    public com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.Builder
        getLinkedVpnTunnelsBuilder() {

      onChanged();
      return getLinkedVpnTunnelsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     */
    public com.google.cloud.networkconnectivity.v1.LinkedVpnTunnelsOrBuilder
        getLinkedVpnTunnelsOrBuilder() {
      if (linkedVpnTunnelsBuilder_ != null) {
        return linkedVpnTunnelsBuilder_.getMessageOrBuilder();
      } else {
        return linkedVpnTunnels_ == null
            ? com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.getDefaultInstance()
            : linkedVpnTunnels_;
      }
    }
    /**
     *
     *
     * <pre>
     * VPN tunnels that are associated with the spoke.
     * </pre>
     *
     * <code>.google.cloud.networkconnectivity.v1.LinkedVpnTunnels linked_vpn_tunnels = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels,
            com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.Builder,
            com.google.cloud.networkconnectivity.v1.LinkedVpnTunnelsOrBuilder>
        getLinkedVpnTunnelsFieldBuilder() {
      if (linkedVpnTunnelsBuilder_ == null) {
        linkedVpnTunnelsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels,
                com.google.cloud.networkconnectivity.v1.LinkedVpnTunnels.Builder,
                com.google.cloud.networkconnectivity.v1.LinkedVpnTunnelsOrBuilder>(
                getLinkedVpnTunnels(), getParentForChildren(), isClean());
        linkedVpnTunnels_ = null;
      }
      return linkedVpnTunnelsBuilder_;
    }

    private com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
        linkedInterconnectAttachments_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments,
            com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.Builder,
            com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachmentsOrBuilder>
        linkedInterconnectAttachmentsBuilder_;
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     *
     * @return Whether the linkedInterconnectAttachments field is set.
     */
    public boolean hasLinkedInterconnectAttachments() {
      return linkedInterconnectAttachmentsBuilder_ != null
          || linkedInterconnectAttachments_ != null;
    }
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     *
     * @return The linkedInterconnectAttachments.
     */
    public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
        getLinkedInterconnectAttachments() {
      if (linkedInterconnectAttachmentsBuilder_ == null) {
        return linkedInterconnectAttachments_ == null
            ? com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
                .getDefaultInstance()
            : linkedInterconnectAttachments_;
      } else {
        return linkedInterconnectAttachmentsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     */
    public Builder setLinkedInterconnectAttachments(
        com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments value) {
      if (linkedInterconnectAttachmentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedInterconnectAttachments_ = value;
        onChanged();
      } else {
        linkedInterconnectAttachmentsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     */
    public Builder setLinkedInterconnectAttachments(
        com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.Builder
            builderForValue) {
      if (linkedInterconnectAttachmentsBuilder_ == null) {
        linkedInterconnectAttachments_ = builderForValue.build();
        onChanged();
      } else {
        linkedInterconnectAttachmentsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     */
    public Builder mergeLinkedInterconnectAttachments(
        com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments value) {
      if (linkedInterconnectAttachmentsBuilder_ == null) {
        if (linkedInterconnectAttachments_ != null) {
          linkedInterconnectAttachments_ =
              com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.newBuilder(
                      linkedInterconnectAttachments_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          linkedInterconnectAttachments_ = value;
        }
        onChanged();
      } else {
        linkedInterconnectAttachmentsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     */
    public Builder clearLinkedInterconnectAttachments() {
      if (linkedInterconnectAttachmentsBuilder_ == null) {
        linkedInterconnectAttachments_ = null;
        onChanged();
      } else {
        linkedInterconnectAttachments_ = null;
        linkedInterconnectAttachmentsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.Builder
        getLinkedInterconnectAttachmentsBuilder() {

      onChanged();
      return getLinkedInterconnectAttachmentsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachmentsOrBuilder
        getLinkedInterconnectAttachmentsOrBuilder() {
      if (linkedInterconnectAttachmentsBuilder_ != null) {
        return linkedInterconnectAttachmentsBuilder_.getMessageOrBuilder();
      } else {
        return linkedInterconnectAttachments_ == null
            ? com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
                .getDefaultInstance()
            : linkedInterconnectAttachments_;
      }
    }
    /**
     *
     *
     * <pre>
     * VLAN attachments that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments linked_interconnect_attachments = 18;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments,
            com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.Builder,
            com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachmentsOrBuilder>
        getLinkedInterconnectAttachmentsFieldBuilder() {
      if (linkedInterconnectAttachmentsBuilder_ == null) {
        linkedInterconnectAttachmentsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments,
                com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.Builder,
                com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachmentsOrBuilder>(
                getLinkedInterconnectAttachments(), getParentForChildren(), isClean());
        linkedInterconnectAttachments_ = null;
      }
      return linkedInterconnectAttachmentsBuilder_;
    }

    private com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
        linkedRouterApplianceInstances_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances,
            com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances.Builder,
            com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstancesOrBuilder>
        linkedRouterApplianceInstancesBuilder_;
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     *
     * @return Whether the linkedRouterApplianceInstances field is set.
     */
    public boolean hasLinkedRouterApplianceInstances() {
      return linkedRouterApplianceInstancesBuilder_ != null
          || linkedRouterApplianceInstances_ != null;
    }
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     *
     * @return The linkedRouterApplianceInstances.
     */
    public com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
        getLinkedRouterApplianceInstances() {
      if (linkedRouterApplianceInstancesBuilder_ == null) {
        return linkedRouterApplianceInstances_ == null
            ? com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
                .getDefaultInstance()
            : linkedRouterApplianceInstances_;
      } else {
        return linkedRouterApplianceInstancesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     */
    public Builder setLinkedRouterApplianceInstances(
        com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances value) {
      if (linkedRouterApplianceInstancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedRouterApplianceInstances_ = value;
        onChanged();
      } else {
        linkedRouterApplianceInstancesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     */
    public Builder setLinkedRouterApplianceInstances(
        com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances.Builder
            builderForValue) {
      if (linkedRouterApplianceInstancesBuilder_ == null) {
        linkedRouterApplianceInstances_ = builderForValue.build();
        onChanged();
      } else {
        linkedRouterApplianceInstancesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     */
    public Builder mergeLinkedRouterApplianceInstances(
        com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances value) {
      if (linkedRouterApplianceInstancesBuilder_ == null) {
        if (linkedRouterApplianceInstances_ != null) {
          linkedRouterApplianceInstances_ =
              com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances.newBuilder(
                      linkedRouterApplianceInstances_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          linkedRouterApplianceInstances_ = value;
        }
        onChanged();
      } else {
        linkedRouterApplianceInstancesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     */
    public Builder clearLinkedRouterApplianceInstances() {
      if (linkedRouterApplianceInstancesBuilder_ == null) {
        linkedRouterApplianceInstances_ = null;
        onChanged();
      } else {
        linkedRouterApplianceInstances_ = null;
        linkedRouterApplianceInstancesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances.Builder
        getLinkedRouterApplianceInstancesBuilder() {

      onChanged();
      return getLinkedRouterApplianceInstancesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstancesOrBuilder
        getLinkedRouterApplianceInstancesOrBuilder() {
      if (linkedRouterApplianceInstancesBuilder_ != null) {
        return linkedRouterApplianceInstancesBuilder_.getMessageOrBuilder();
      } else {
        return linkedRouterApplianceInstances_ == null
            ? com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
                .getDefaultInstance()
            : linkedRouterApplianceInstances_;
      }
    }
    /**
     *
     *
     * <pre>
     * Router appliance instances that are associated with the spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances linked_router_appliance_instances = 19;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances,
            com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances.Builder,
            com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstancesOrBuilder>
        getLinkedRouterApplianceInstancesFieldBuilder() {
      if (linkedRouterApplianceInstancesBuilder_ == null) {
        linkedRouterApplianceInstancesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances,
                com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances.Builder,
                com.google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstancesOrBuilder>(
                getLinkedRouterApplianceInstances(), getParentForChildren(), isClean());
        linkedRouterApplianceInstances_ = null;
      }
      return linkedRouterApplianceInstancesBuilder_;
    }

    private java.lang.Object uniqueId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The Google-generated UUID for the spoke. This value is unique
     * across all spoke resources. If a spoke is deleted and another with the same
     * name is created, the new spoke is assigned a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uniqueId.
     */
    public java.lang.String getUniqueId() {
      java.lang.Object ref = uniqueId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uniqueId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Google-generated UUID for the spoke. This value is unique
     * across all spoke resources. If a spoke is deleted and another with the same
     * name is created, the new spoke is assigned a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uniqueId.
     */
    public com.google.protobuf.ByteString getUniqueIdBytes() {
      java.lang.Object ref = uniqueId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uniqueId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Google-generated UUID for the spoke. This value is unique
     * across all spoke resources. If a spoke is deleted and another with the same
     * name is created, the new spoke is assigned a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uniqueId to set.
     * @return This builder for chaining.
     */
    public Builder setUniqueId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      uniqueId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Google-generated UUID for the spoke. This value is unique
     * across all spoke resources. If a spoke is deleted and another with the same
     * name is created, the new spoke is assigned a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUniqueId() {

      uniqueId_ = getDefaultInstance().getUniqueId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Google-generated UUID for the spoke. This value is unique
     * across all spoke resources. If a spoke is deleted and another with the same
     * name is created, the new spoke is assigned a different unique_id.
     * </pre>
     *
     * <code>string unique_id = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uniqueId to set.
     * @return This builder for chaining.
     */
    public Builder setUniqueIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      uniqueId_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current lifecycle state of this spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current lifecycle state of this spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current lifecycle state of this spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkconnectivity.v1.State result =
          com.google.cloud.networkconnectivity.v1.State.valueOf(state_);
      return result == null ? com.google.cloud.networkconnectivity.v1.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current lifecycle state of this spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.networkconnectivity.v1.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current lifecycle state of this spoke.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkconnectivity.v1.Spoke)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkconnectivity.v1.Spoke)
  private static final com.google.cloud.networkconnectivity.v1.Spoke DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkconnectivity.v1.Spoke();
  }

  public static com.google.cloud.networkconnectivity.v1.Spoke getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Spoke> PARSER =
      new com.google.protobuf.AbstractParser<Spoke>() {
        @java.lang.Override
        public Spoke parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Spoke> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Spoke> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.Spoke getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
