/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

package com.google.cloud.networkconnectivity.v1;

/**
 *
 *
 * <pre>
 * Policy Based Routes (PBR) are more powerful routes that allows GCP customers
 * to route their L4 network traffic based on not just destination IP, but also
 * source IP, protocol and more. A PBR always take precedence when it conflicts
 * with other types of routes.
 * Next id: 19
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute}
 */
public final class PolicyBasedRoute extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute)
    PolicyBasedRouteOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PolicyBasedRoute.newBuilder() to construct.
  private PolicyBasedRoute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PolicyBasedRoute() {
    name_ = "";
    description_ = "";
    network_ = "";
    warnings_ = java.util.Collections.emptyList();
    selfLink_ = "";
    kind_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PolicyBasedRoute();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
        .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
        .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.class,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Builder.class);
  }

  public interface VirtualMachineOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A list of VM instance tags to which this policy based route applies to.
     * VM instances that have ANY of tags specified here will install this
     * PBR.
     * </pre>
     *
     * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the tags.
     */
    java.util.List<java.lang.String> getTagsList();
    /**
     *
     *
     * <pre>
     * Optional. A list of VM instance tags to which this policy based route applies to.
     * VM instances that have ANY of tags specified here will install this
     * PBR.
     * </pre>
     *
     * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of tags.
     */
    int getTagsCount();
    /**
     *
     *
     * <pre>
     * Optional. A list of VM instance tags to which this policy based route applies to.
     * VM instances that have ANY of tags specified here will install this
     * PBR.
     * </pre>
     *
     * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    java.lang.String getTags(int index);
    /**
     *
     *
     * <pre>
     * Optional. A list of VM instance tags to which this policy based route applies to.
     * VM instances that have ANY of tags specified here will install this
     * PBR.
     * </pre>
     *
     * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    com.google.protobuf.ByteString getTagsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * VM instances to which this policy based route applies to.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine}
   */
  public static final class VirtualMachine extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine)
      VirtualMachineOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use VirtualMachine.newBuilder() to construct.
    private VirtualMachine(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VirtualMachine() {
      tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VirtualMachine();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_VirtualMachine_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_VirtualMachine_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.class,
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.Builder
                  .class);
    }

    public static final int TAGS_FIELD_NUMBER = 1;
    private com.google.protobuf.LazyStringList tags_;
    /**
     *
     *
     * <pre>
     * Optional. A list of VM instance tags to which this policy based route applies to.
     * VM instances that have ANY of tags specified here will install this
     * PBR.
     * </pre>
     *
     * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of VM instance tags to which this policy based route applies to.
     * VM instances that have ANY of tags specified here will install this
     * PBR.
     * </pre>
     *
     * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of VM instance tags to which this policy based route applies to.
     * VM instances that have ANY of tags specified here will install this
     * PBR.
     * </pre>
     *
     * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of VM instance tags to which this policy based route applies to.
     * VM instances that have ANY of tags specified here will install this
     * PBR.
     * </pre>
     *
     * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < tags_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tags_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < tags_.size(); i++) {
          dataSize += computeStringSizeNoTag(tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getTagsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine)) {
        return super.equals(obj);
      }
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine other =
          (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) obj;

      if (!getTagsList().equals(other.getTagsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * VM instances to which this policy based route applies to.
     * </pre>
     *
     * Protobuf type {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine)
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachineOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_VirtualMachine_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_VirtualMachine_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.class,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_VirtualMachine_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
          getDefaultInstanceForType() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine build() {
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
          buildPartial() {
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine result =
            new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          tags_ = tags_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.tags_ = tags_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) {
          return mergeFrom(
              (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine other) {
        if (other
            == com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
                .getDefaultInstance()) return this;
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureTagsIsMutable();
                  tags_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringList tags_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureTagsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the tags.
       */
      public com.google.protobuf.ProtocolStringList getTagsList() {
        return tags_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public com.google.protobuf.ByteString getTagsBytes(int index) {
        return tags_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The tags to set.
       * @return This builder for chaining.
       */
      public Builder setTags(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The tags to add.
       * @return This builder for chaining.
       */
      public Builder addTags(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The tags to add.
       * @return This builder for chaining.
       */
      public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTags() {
        tags_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A list of VM instance tags to which this policy based route applies to.
       * VM instances that have ANY of tags specified here will install this
       * PBR.
       * </pre>
       *
       * <code>repeated string tags = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the tags to add.
       * @return This builder for chaining.
       */
      public Builder addTagsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureTagsIsMutable();
        tags_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine)
    private static final com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine();
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VirtualMachine> PARSER =
        new com.google.protobuf.AbstractParser<VirtualMachine>() {
          @java.lang.Override
          public VirtualMachine parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VirtualMachine> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VirtualMachine> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InterconnectAttachmentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Cloud region to install this policy based route on interconnect
     * attachment. Use `all` to install it on all interconnect attachments.
     * </pre>
     *
     * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The region.
     */
    java.lang.String getRegion();
    /**
     *
     *
     * <pre>
     * Optional. Cloud region to install this policy based route on interconnect
     * attachment. Use `all` to install it on all interconnect attachments.
     * </pre>
     *
     * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for region.
     */
    com.google.protobuf.ByteString getRegionBytes();
  }
  /**
   *
   *
   * <pre>
   * InterconnectAttachment to which this route applies to.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment}
   */
  public static final class InterconnectAttachment extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
      InterconnectAttachmentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InterconnectAttachment.newBuilder() to construct.
    private InterconnectAttachment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InterconnectAttachment() {
      region_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InterconnectAttachment();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_InterconnectAttachment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_InterconnectAttachment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment.class,
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
                  .Builder.class);
    }

    public static final int REGION_FIELD_NUMBER = 1;
    private volatile java.lang.Object region_;
    /**
     *
     *
     * <pre>
     * Optional. Cloud region to install this policy based route on interconnect
     * attachment. Use `all` to install it on all interconnect attachments.
     * </pre>
     *
     * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The region.
     */
    @java.lang.Override
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cloud region to install this policy based route on interconnect
     * attachment. Use `all` to install it on all interconnect attachments.
     * </pre>
     *
     * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for region.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, region_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, region_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)) {
        return super.equals(obj);
      }
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment other =
          (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment) obj;

      if (!getRegion().equals(other.getRegion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * InterconnectAttachment to which this route applies to.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachmentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_InterconnectAttachment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_InterconnectAttachment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
                    .class,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        region_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_InterconnectAttachment_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
          getDefaultInstanceForType() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
          build() {
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
          buildPartial() {
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment result =
            new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment(
                this);
        result.region_ = region_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment) {
          return mergeFrom(
              (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment other) {
        if (other
            == com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
                .getDefaultInstance()) return this;
        if (!other.getRegion().isEmpty()) {
          region_ = other.region_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  region_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object region_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Cloud region to install this policy based route on interconnect
       * attachment. Use `all` to install it on all interconnect attachments.
       * </pre>
       *
       * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The region.
       */
      public java.lang.String getRegion() {
        java.lang.Object ref = region_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          region_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Cloud region to install this policy based route on interconnect
       * attachment. Use `all` to install it on all interconnect attachments.
       * </pre>
       *
       * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for region.
       */
      public com.google.protobuf.ByteString getRegionBytes() {
        java.lang.Object ref = region_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          region_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Cloud region to install this policy based route on interconnect
       * attachment. Use `all` to install it on all interconnect attachments.
       * </pre>
       *
       * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The region to set.
       * @return This builder for chaining.
       */
      public Builder setRegion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        region_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Cloud region to install this policy based route on interconnect
       * attachment. Use `all` to install it on all interconnect attachments.
       * </pre>
       *
       * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRegion() {

        region_ = getDefaultInstance().getRegion();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Cloud region to install this policy based route on interconnect
       * attachment. Use `all` to install it on all interconnect attachments.
       * </pre>
       *
       * <code>string region = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for region to set.
       * @return This builder for chaining.
       */
      public Builder setRegionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        region_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
    private static final com.google.cloud.networkconnectivity.v1.PolicyBasedRoute
            .InterconnectAttachment
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment();
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InterconnectAttachment> PARSER =
        new com.google.protobuf.AbstractParser<InterconnectAttachment>() {
          @java.lang.Override
          public InterconnectAttachment parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InterconnectAttachment> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InterconnectAttachment> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The IP protocol that this policy based route applies to. Valid values are
     * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
     * </pre>
     *
     * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ipProtocol.
     */
    java.lang.String getIpProtocol();
    /**
     *
     *
     * <pre>
     * Optional. The IP protocol that this policy based route applies to. Valid values are
     * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
     * </pre>
     *
     * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for ipProtocol.
     */
    com.google.protobuf.ByteString getIpProtocolBytes();

    /**
     *
     *
     * <pre>
     * Optional. The source IP range of outgoing packets that this policy based route
     * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
     * </pre>
     *
     * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The srcRange.
     */
    java.lang.String getSrcRange();
    /**
     *
     *
     * <pre>
     * Optional. The source IP range of outgoing packets that this policy based route
     * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
     * </pre>
     *
     * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for srcRange.
     */
    com.google.protobuf.ByteString getSrcRangeBytes();

    /**
     *
     *
     * <pre>
     * Optional. The destination IP range of outgoing packets that this policy based route
     * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
     * </pre>
     *
     * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The destRange.
     */
    java.lang.String getDestRange();
    /**
     *
     *
     * <pre>
     * Optional. The destination IP range of outgoing packets that this policy based route
     * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
     * </pre>
     *
     * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for destRange.
     */
    com.google.protobuf.ByteString getDestRangeBytes();

    /**
     *
     *
     * <pre>
     * Required. Internet protocol versions this policy based route applies to. For this
     * version, only IPV4 is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for protocolVersion.
     */
    int getProtocolVersionValue();
    /**
     *
     *
     * <pre>
     * Required. Internet protocol versions this policy based route applies to. For this
     * version, only IPV4 is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The protocolVersion.
     */
    com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
        getProtocolVersion();
  }
  /**
   *
   *
   * <pre>
   * Filter matches L4 traffic.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter}
   */
  public static final class Filter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter)
      FilterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Filter.newBuilder() to construct.
    private Filter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Filter() {
      ipProtocol_ = "";
      srcRange_ = "";
      destRange_ = "";
      protocolVersion_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Filter();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Filter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Filter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.class,
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The internet protocol version.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion}
     */
    public enum ProtocolVersion implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>PROTOCOL_VERSION_UNSPECIFIED = 0;</code>
       */
      PROTOCOL_VERSION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The PBR is for IPv4 internet protocol traffic.
       * </pre>
       *
       * <code>IPV4 = 1;</code>
       */
      IPV4(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>PROTOCOL_VERSION_UNSPECIFIED = 0;</code>
       */
      public static final int PROTOCOL_VERSION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The PBR is for IPv4 internet protocol traffic.
       * </pre>
       *
       * <code>IPV4 = 1;</code>
       */
      public static final int IPV4_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ProtocolVersion valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ProtocolVersion forNumber(int value) {
        switch (value) {
          case 0:
            return PROTOCOL_VERSION_UNSPECIFIED;
          case 1:
            return IPV4;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ProtocolVersion>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ProtocolVersion>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ProtocolVersion>() {
                public ProtocolVersion findValueByNumber(int number) {
                  return ProtocolVersion.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ProtocolVersion[] VALUES = values();

      public static ProtocolVersion valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ProtocolVersion(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion)
    }

    public static final int IP_PROTOCOL_FIELD_NUMBER = 1;
    private volatile java.lang.Object ipProtocol_;
    /**
     *
     *
     * <pre>
     * Optional. The IP protocol that this policy based route applies to. Valid values are
     * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
     * </pre>
     *
     * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ipProtocol.
     */
    @java.lang.Override
    public java.lang.String getIpProtocol() {
      java.lang.Object ref = ipProtocol_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipProtocol_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP protocol that this policy based route applies to. Valid values are
     * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
     * </pre>
     *
     * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for ipProtocol.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIpProtocolBytes() {
      java.lang.Object ref = ipProtocol_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipProtocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SRC_RANGE_FIELD_NUMBER = 2;
    private volatile java.lang.Object srcRange_;
    /**
     *
     *
     * <pre>
     * Optional. The source IP range of outgoing packets that this policy based route
     * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
     * </pre>
     *
     * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The srcRange.
     */
    @java.lang.Override
    public java.lang.String getSrcRange() {
      java.lang.Object ref = srcRange_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        srcRange_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The source IP range of outgoing packets that this policy based route
     * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
     * </pre>
     *
     * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for srcRange.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSrcRangeBytes() {
      java.lang.Object ref = srcRange_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        srcRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEST_RANGE_FIELD_NUMBER = 3;
    private volatile java.lang.Object destRange_;
    /**
     *
     *
     * <pre>
     * Optional. The destination IP range of outgoing packets that this policy based route
     * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
     * </pre>
     *
     * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The destRange.
     */
    @java.lang.Override
    public java.lang.String getDestRange() {
      java.lang.Object ref = destRange_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destRange_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The destination IP range of outgoing packets that this policy based route
     * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
     * </pre>
     *
     * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for destRange.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDestRangeBytes() {
      java.lang.Object ref = destRange_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROTOCOL_VERSION_FIELD_NUMBER = 6;
    private int protocolVersion_;
    /**
     *
     *
     * <pre>
     * Required. Internet protocol versions this policy based route applies to. For this
     * version, only IPV4 is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for protocolVersion.
     */
    @java.lang.Override
    public int getProtocolVersionValue() {
      return protocolVersion_;
    }
    /**
     *
     *
     * <pre>
     * Required. Internet protocol versions this policy based route applies to. For this
     * version, only IPV4 is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The protocolVersion.
     */
    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
        getProtocolVersion() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion result =
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion.valueOf(
              protocolVersion_);
      return result == null
          ? com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipProtocol_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ipProtocol_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(srcRange_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, srcRange_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destRange_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, destRange_);
      }
      if (protocolVersion_
          != com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
              .PROTOCOL_VERSION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(6, protocolVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipProtocol_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ipProtocol_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(srcRange_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, srcRange_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destRange_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, destRange_);
      }
      if (protocolVersion_
          != com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
              .PROTOCOL_VERSION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, protocolVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter)) {
        return super.equals(obj);
      }
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter other =
          (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter) obj;

      if (!getIpProtocol().equals(other.getIpProtocol())) return false;
      if (!getSrcRange().equals(other.getSrcRange())) return false;
      if (!getDestRange().equals(other.getDestRange())) return false;
      if (protocolVersion_ != other.protocolVersion_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IP_PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + getIpProtocol().hashCode();
      hash = (37 * hash) + SRC_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getSrcRange().hashCode();
      hash = (37 * hash) + DEST_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getDestRange().hashCode();
      hash = (37 * hash) + PROTOCOL_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + protocolVersion_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Filter matches L4 traffic.
     * </pre>
     *
     * Protobuf type {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter)
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.FilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Filter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Filter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.class,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.Builder.class);
      }

      // Construct using
      // com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        ipProtocol_ = "";

        srcRange_ = "";

        destRange_ = "";

        protocolVersion_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Filter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter
          getDefaultInstanceForType() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter build() {
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter buildPartial() {
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter result =
            new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter(this);
        result.ipProtocol_ = ipProtocol_;
        result.srcRange_ = srcRange_;
        result.destRange_ = destRange_;
        result.protocolVersion_ = protocolVersion_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter) {
          return mergeFrom((com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter other) {
        if (other
            == com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.getDefaultInstance())
          return this;
        if (!other.getIpProtocol().isEmpty()) {
          ipProtocol_ = other.ipProtocol_;
          onChanged();
        }
        if (!other.getSrcRange().isEmpty()) {
          srcRange_ = other.srcRange_;
          onChanged();
        }
        if (!other.getDestRange().isEmpty()) {
          destRange_ = other.destRange_;
          onChanged();
        }
        if (other.protocolVersion_ != 0) {
          setProtocolVersionValue(other.getProtocolVersionValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  ipProtocol_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  srcRange_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  destRange_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              case 48:
                {
                  protocolVersion_ = input.readEnum();

                  break;
                } // case 48
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object ipProtocol_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The IP protocol that this policy based route applies to. Valid values are
       * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
       * </pre>
       *
       * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The ipProtocol.
       */
      public java.lang.String getIpProtocol() {
        java.lang.Object ref = ipProtocol_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ipProtocol_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The IP protocol that this policy based route applies to. Valid values are
       * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
       * </pre>
       *
       * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for ipProtocol.
       */
      public com.google.protobuf.ByteString getIpProtocolBytes() {
        java.lang.Object ref = ipProtocol_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ipProtocol_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The IP protocol that this policy based route applies to. Valid values are
       * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
       * </pre>
       *
       * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The ipProtocol to set.
       * @return This builder for chaining.
       */
      public Builder setIpProtocol(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        ipProtocol_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The IP protocol that this policy based route applies to. Valid values are
       * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
       * </pre>
       *
       * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIpProtocol() {

        ipProtocol_ = getDefaultInstance().getIpProtocol();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The IP protocol that this policy based route applies to. Valid values are
       * 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
       * </pre>
       *
       * <code>string ip_protocol = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for ipProtocol to set.
       * @return This builder for chaining.
       */
      public Builder setIpProtocolBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        ipProtocol_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object srcRange_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The source IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The srcRange.
       */
      public java.lang.String getSrcRange() {
        java.lang.Object ref = srcRange_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          srcRange_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The source IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for srcRange.
       */
      public com.google.protobuf.ByteString getSrcRangeBytes() {
        java.lang.Object ref = srcRange_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          srcRange_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The source IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The srcRange to set.
       * @return This builder for chaining.
       */
      public Builder setSrcRange(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        srcRange_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The source IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSrcRange() {

        srcRange_ = getDefaultInstance().getSrcRange();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The source IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string src_range = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for srcRange to set.
       * @return This builder for chaining.
       */
      public Builder setSrcRangeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        srcRange_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object destRange_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The destination IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The destRange.
       */
      public java.lang.String getDestRange() {
        java.lang.Object ref = destRange_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          destRange_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The destination IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for destRange.
       */
      public com.google.protobuf.ByteString getDestRangeBytes() {
        java.lang.Object ref = destRange_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          destRange_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The destination IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The destRange to set.
       * @return This builder for chaining.
       */
      public Builder setDestRange(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        destRange_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The destination IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDestRange() {

        destRange_ = getDefaultInstance().getDestRange();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The destination IP range of outgoing packets that this policy based route
       * applies to. Default is "0.0.0.0/0" if protocol version is IPv4.
       * </pre>
       *
       * <code>string dest_range = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for destRange to set.
       * @return This builder for chaining.
       */
      public Builder setDestRangeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        destRange_ = value;
        onChanged();
        return this;
      }

      private int protocolVersion_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Internet protocol versions this policy based route applies to. For this
       * version, only IPV4 is supported.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for protocolVersion.
       */
      @java.lang.Override
      public int getProtocolVersionValue() {
        return protocolVersion_;
      }
      /**
       *
       *
       * <pre>
       * Required. Internet protocol versions this policy based route applies to. For this
       * version, only IPV4 is supported.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for protocolVersion to set.
       * @return This builder for chaining.
       */
      public Builder setProtocolVersionValue(int value) {

        protocolVersion_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Internet protocol versions this policy based route applies to. For this
       * version, only IPV4 is supported.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The protocolVersion.
       */
      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
          getProtocolVersion() {
        @SuppressWarnings("deprecation")
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion result =
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion.valueOf(
                protocolVersion_);
        return result == null
            ? com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. Internet protocol versions this policy based route applies to. For this
       * version, only IPV4 is supported.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The protocolVersion to set.
       * @return This builder for chaining.
       */
      public Builder setProtocolVersion(
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion value) {
        if (value == null) {
          throw new NullPointerException();
        }

        protocolVersion_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Internet protocol versions this policy based route applies to. For this
       * version, only IPV4 is supported.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.ProtocolVersion protocol_version = 6 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProtocolVersion() {

        protocolVersion_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter)
    private static final com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter();
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Filter> PARSER =
        new com.google.protobuf.AbstractParser<Filter>() {
          @java.lang.Override
          public Filter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Filter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Filter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WarningsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. A warning code, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for code.
     */
    int getCodeValue();
    /**
     *
     *
     * <pre>
     * Output only. A warning code, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The code.
     */
    com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code getCode();

    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    int getDataCount();
    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    boolean containsData(java.lang.String key);
    /** Use {@link #getDataMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getData();
    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getDataMap();
    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */

    /* nullable */
    java.lang.String getDataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    java.lang.String getDataOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Output only. A human-readable description of the warning code.
     * </pre>
     *
     * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The warningMessage.
     */
    java.lang.String getWarningMessage();
    /**
     *
     *
     * <pre>
     * Output only. A human-readable description of the warning code.
     * </pre>
     *
     * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for warningMessage.
     */
    com.google.protobuf.ByteString getWarningMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * Informational warning message.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings}
   */
  public static final class Warnings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings)
      WarningsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Warnings.newBuilder() to construct.
    private Warnings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Warnings() {
      code_ = 0;
      warningMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Warnings();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Warnings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetData();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Warnings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.class,
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Warning code for Policy Based Routing. Expect to add values in the
     * future.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code}
     */
    public enum Code implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>WARNING_UNSPECIFIED = 0;</code>
       */
      WARNING_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The policy based route is not active and functioning. Common causes are
       * the dependent network was deleted or the resource project was turned
       * off.
       * </pre>
       *
       * <code>RESOURCE_NOT_ACTIVE = 1;</code>
       */
      RESOURCE_NOT_ACTIVE(1),
      /**
       *
       *
       * <pre>
       * The policy based route is being modified (e.g. created/deleted) at this
       * time.
       * </pre>
       *
       * <code>RESOURCE_BEING_MODIFIED = 2;</code>
       */
      RESOURCE_BEING_MODIFIED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value.
       * </pre>
       *
       * <code>WARNING_UNSPECIFIED = 0;</code>
       */
      public static final int WARNING_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The policy based route is not active and functioning. Common causes are
       * the dependent network was deleted or the resource project was turned
       * off.
       * </pre>
       *
       * <code>RESOURCE_NOT_ACTIVE = 1;</code>
       */
      public static final int RESOURCE_NOT_ACTIVE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The policy based route is being modified (e.g. created/deleted) at this
       * time.
       * </pre>
       *
       * <code>RESOURCE_BEING_MODIFIED = 2;</code>
       */
      public static final int RESOURCE_BEING_MODIFIED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Code valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Code forNumber(int value) {
        switch (value) {
          case 0:
            return WARNING_UNSPECIFIED;
          case 1:
            return RESOURCE_NOT_ACTIVE;
          case 2:
            return RESOURCE_BEING_MODIFIED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Code> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Code> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Code>() {
            public Code findValueByNumber(int number) {
              return Code.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Code[] VALUES = values();

      public static Code valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Code(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code)
    }

    public static final int CODE_FIELD_NUMBER = 1;
    private int code_;
    /**
     *
     *
     * <pre>
     * Output only. A warning code, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A warning code, if applicable.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code getCode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code result =
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code.valueOf(code_);
      return result == null
          ? com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code.UNRECOGNIZED
          : result;
    }

    public static final int DATA_FIELD_NUMBER = 2;

    private static final class DataDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
                  .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Warnings_DataEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> data_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetData() {
      if (data_ == null) {
        return com.google.protobuf.MapField.emptyMapField(DataDefaultEntryHolder.defaultEntry);
      }
      return data_;
    }

    public int getDataCount() {
      return internalGetData().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public boolean containsData(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetData().getMap().containsKey(key);
    }
    /** Use {@link #getDataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getData() {
      return getDataMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDataMap() {
      return internalGetData().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public java.lang.String getDataOrDefault(java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetData().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about this warning in key: value format. The key should provides
     * more detail on the warning being returned. For example, for warnings
     * where there are no results in a list request for a particular zone, this
     * key might be scope and the key value might be the zone name. Other
     * examples might be a key indicating a deprecated resource and a suggested
     * replacement.
     * </pre>
     *
     * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public java.lang.String getDataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetData().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int WARNING_MESSAGE_FIELD_NUMBER = 3;
    private volatile java.lang.Object warningMessage_;
    /**
     *
     *
     * <pre>
     * Output only. A human-readable description of the warning code.
     * </pre>
     *
     * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The warningMessage.
     */
    @java.lang.Override
    public java.lang.String getWarningMessage() {
      java.lang.Object ref = warningMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        warningMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A human-readable description of the warning code.
     * </pre>
     *
     * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for warningMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getWarningMessageBytes() {
      java.lang.Object ref = warningMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        warningMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (code_
          != com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code
              .WARNING_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, code_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetData(), DataDefaultEntryHolder.defaultEntry, 2);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(warningMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, warningMessage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (code_
          != com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code
              .WARNING_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, code_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetData().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> data__ =
            DataDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, data__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(warningMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, warningMessage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings)) {
        return super.equals(obj);
      }
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings other =
          (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings) obj;

      if (code_ != other.code_) return false;
      if (!internalGetData().equals(other.internalGetData())) return false;
      if (!getWarningMessage().equals(other.getWarningMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + code_;
      if (!internalGetData().getMap().isEmpty()) {
        hash = (37 * hash) + DATA_FIELD_NUMBER;
        hash = (53 * hash) + internalGetData().hashCode();
      }
      hash = (37 * hash) + WARNING_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getWarningMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Informational warning message.
     * </pre>
     *
     * Protobuf type {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings)
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.WarningsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Warnings_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 2:
            return internalGetData();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 2:
            return internalGetMutableData();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Warnings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.class,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder.class);
      }

      // Construct using
      // com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        code_ = 0;

        internalGetMutableData().clear();
        warningMessage_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
            .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_Warnings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
          getDefaultInstanceForType() {
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings build() {
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings buildPartial() {
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings result =
            new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings(this);
        int from_bitField0_ = bitField0_;
        result.code_ = code_;
        result.data_ = internalGetData();
        result.data_.makeImmutable();
        result.warningMessage_ = warningMessage_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings) {
          return mergeFrom(
              (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings other) {
        if (other
            == com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
                .getDefaultInstance()) return this;
        if (other.code_ != 0) {
          setCodeValue(other.getCodeValue());
        }
        internalGetMutableData().mergeFrom(other.internalGetData());
        if (!other.getWarningMessage().isEmpty()) {
          warningMessage_ = other.warningMessage_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  code_ = input.readEnum();

                  break;
                } // case 8
              case 18:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> data__ =
                      input.readMessage(
                          DataDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableData().getMutableMap().put(data__.getKey(), data__.getValue());
                  break;
                } // case 18
              case 26:
                {
                  warningMessage_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int code_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. A warning code, if applicable.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for code.
       */
      @java.lang.Override
      public int getCodeValue() {
        return code_;
      }
      /**
       *
       *
       * <pre>
       * Output only. A warning code, if applicable.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for code to set.
       * @return This builder for chaining.
       */
      public Builder setCodeValue(int value) {

        code_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A warning code, if applicable.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The code.
       */
      @java.lang.Override
      public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code getCode() {
        @SuppressWarnings("deprecation")
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code result =
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code.valueOf(code_);
        return result == null
            ? com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. A warning code, if applicable.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(
          com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code value) {
        if (value == null) {
          throw new NullPointerException();
        }

        code_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A warning code, if applicable.
       * </pre>
       *
       * <code>
       * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Code code = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCode() {

        code_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> data_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetData() {
        if (data_ == null) {
          return com.google.protobuf.MapField.emptyMapField(DataDefaultEntryHolder.defaultEntry);
        }
        return data_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableData() {
        onChanged();
        ;
        if (data_ == null) {
          data_ = com.google.protobuf.MapField.newMapField(DataDefaultEntryHolder.defaultEntry);
        }
        if (!data_.isMutable()) {
          data_ = data_.copy();
        }
        return data_;
      }

      public int getDataCount() {
        return internalGetData().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata about this warning in key: value format. The key should provides
       * more detail on the warning being returned. For example, for warnings
       * where there are no results in a list request for a particular zone, this
       * key might be scope and the key value might be the zone name. Other
       * examples might be a key indicating a deprecated resource and a suggested
       * replacement.
       * </pre>
       *
       * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      @java.lang.Override
      public boolean containsData(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetData().getMap().containsKey(key);
      }
      /** Use {@link #getDataMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getData() {
        return getDataMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata about this warning in key: value format. The key should provides
       * more detail on the warning being returned. For example, for warnings
       * where there are no results in a list request for a particular zone, this
       * key might be scope and the key value might be the zone name. Other
       * examples might be a key indicating a deprecated resource and a suggested
       * replacement.
       * </pre>
       *
       * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getDataMap() {
        return internalGetData().getMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata about this warning in key: value format. The key should provides
       * more detail on the warning being returned. For example, for warnings
       * where there are no results in a list request for a particular zone, this
       * key might be scope and the key value might be the zone name. Other
       * examples might be a key indicating a deprecated resource and a suggested
       * replacement.
       * </pre>
       *
       * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      @java.lang.Override
      public java.lang.String getDataOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetData().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata about this warning in key: value format. The key should provides
       * more detail on the warning being returned. For example, for warnings
       * where there are no results in a list request for a particular zone, this
       * key might be scope and the key value might be the zone name. Other
       * examples might be a key indicating a deprecated resource and a suggested
       * replacement.
       * </pre>
       *
       * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      @java.lang.Override
      public java.lang.String getDataOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetData().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearData() {
        internalGetMutableData().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata about this warning in key: value format. The key should provides
       * more detail on the warning being returned. For example, for warnings
       * where there are no results in a list request for a particular zone, this
       * key might be scope and the key value might be the zone name. Other
       * examples might be a key indicating a deprecated resource and a suggested
       * replacement.
       * </pre>
       *
       * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeData(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableData().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableData() {
        return internalGetMutableData().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata about this warning in key: value format. The key should provides
       * more detail on the warning being returned. For example, for warnings
       * where there are no results in a list request for a particular zone, this
       * key might be scope and the key value might be the zone name. Other
       * examples might be a key indicating a deprecated resource and a suggested
       * replacement.
       * </pre>
       *
       * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder putData(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableData().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata about this warning in key: value format. The key should provides
       * more detail on the warning being returned. For example, for warnings
       * where there are no results in a list request for a particular zone, this
       * key might be scope and the key value might be the zone name. Other
       * examples might be a key indicating a deprecated resource and a suggested
       * replacement.
       * </pre>
       *
       * <code>map&lt;string, string&gt; data = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder putAllData(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableData().getMutableMap().putAll(values);
        return this;
      }

      private java.lang.Object warningMessage_ = "";
      /**
       *
       *
       * <pre>
       * Output only. A human-readable description of the warning code.
       * </pre>
       *
       * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The warningMessage.
       */
      public java.lang.String getWarningMessage() {
        java.lang.Object ref = warningMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          warningMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A human-readable description of the warning code.
       * </pre>
       *
       * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for warningMessage.
       */
      public com.google.protobuf.ByteString getWarningMessageBytes() {
        java.lang.Object ref = warningMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          warningMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. A human-readable description of the warning code.
       * </pre>
       *
       * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The warningMessage to set.
       * @return This builder for chaining.
       */
      public Builder setWarningMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        warningMessage_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A human-readable description of the warning code.
       * </pre>
       *
       * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWarningMessage() {

        warningMessage_ = getDefaultInstance().getWarningMessage();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A human-readable description of the warning code.
       * </pre>
       *
       * <code>string warning_message = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for warningMessage to set.
       * @return This builder for chaining.
       */
      public Builder setWarningMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        warningMessage_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings)
    private static final com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings();
    }

    public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Warnings> PARSER =
        new com.google.protobuf.AbstractParser<Warnings>() {
          @java.lang.Override
          public Warnings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Warnings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Warnings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int targetCase_ = 0;
  private java.lang.Object target_;

  public enum TargetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VIRTUAL_MACHINE(18),
    INTERCONNECT_ATTACHMENT(9),
    TARGET_NOT_SET(0);
    private final int value;

    private TargetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetCase forNumber(int value) {
      switch (value) {
        case 18:
          return VIRTUAL_MACHINE;
        case 9:
          return INTERCONNECT_ATTACHMENT;
        case 0:
          return TARGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetCase getTargetCase() {
    return TargetCase.forNumber(targetCase_);
  }

  private int nextHopCase_ = 0;
  private java.lang.Object nextHop_;

  public enum NextHopCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NEXT_HOP_ILB_IP(12),
    NEXTHOP_NOT_SET(0);
    private final int value;

    private NextHopCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NextHopCase valueOf(int value) {
      return forNumber(value);
    }

    public static NextHopCase forNumber(int value) {
      switch (value) {
        case 12:
          return NEXT_HOP_ILB_IP;
        case 0:
          return NEXTHOP_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public NextHopCase getNextHopCase() {
    return NextHopCase.forNumber(nextHopCase_);
  }

  public static final int VIRTUAL_MACHINE_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Optional. VM instances to which this policy based route applies to.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the virtualMachine field is set.
   */
  @java.lang.Override
  public boolean hasVirtualMachine() {
    return targetCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Optional. VM instances to which this policy based route applies to.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The virtualMachine.
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
      getVirtualMachine() {
    if (targetCase_ == 18) {
      return (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) target_;
    }
    return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. VM instances to which this policy based route applies to.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachineOrBuilder
      getVirtualMachineOrBuilder() {
    if (targetCase_ == 18) {
      return (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) target_;
    }
    return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
        .getDefaultInstance();
  }

  public static final int INTERCONNECT_ATTACHMENT_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Optional. The interconnect attachments to which this route applies to.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the interconnectAttachment field is set.
   */
  @java.lang.Override
  public boolean hasInterconnectAttachment() {
    return targetCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Optional. The interconnect attachments to which this route applies to.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The interconnectAttachment.
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
      getInterconnectAttachment() {
    if (targetCase_ == 9) {
      return (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
          target_;
    }
    return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. The interconnect attachments to which this route applies to.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachmentOrBuilder
      getInterconnectAttachmentOrBuilder() {
    if (targetCase_ == 9) {
      return (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
          target_;
    }
    return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        .getDefaultInstance();
  }

  public static final int NEXT_HOP_ILB_IP_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
   * handle matching packets. For this version, only next_hop_ilb_ip is
   * supported.
   * </pre>
   *
   * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the nextHopIlbIp field is set.
   */
  public boolean hasNextHopIlbIp() {
    return nextHopCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
   * handle matching packets. For this version, only next_hop_ilb_ip is
   * supported.
   * </pre>
   *
   * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The nextHopIlbIp.
   */
  public java.lang.String getNextHopIlbIp() {
    java.lang.Object ref = "";
    if (nextHopCase_ == 12) {
      ref = nextHop_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (nextHopCase_ == 12) {
        nextHop_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
   * handle matching packets. For this version, only next_hop_ilb_ip is
   * supported.
   * </pre>
   *
   * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for nextHopIlbIp.
   */
  public com.google.protobuf.ByteString getNextHopIlbIpBytes() {
    java.lang.Object ref = "";
    if (nextHopCase_ == 12) {
      ref = nextHop_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (nextHopCase_ == 12) {
        nextHop_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Immutable. A unique name of the resource in the form of
   * `projects/{project_number}/locations/global/PolicyBasedRoutes/{policy_based_route_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. A unique name of the resource in the form of
   * `projects/{project_number}/locations/global/PolicyBasedRoutes/{policy_based_route_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the PolicyBasedRoute was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the PolicyBasedRoute was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the PolicyBasedRoute was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the PolicyBasedRoute was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the PolicyBasedRoute was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the PolicyBasedRoute was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
                .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-defined labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. An optional description of this resource. Provide this field when you
   * create the resource.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional description of this resource. Provide this field when you
   * create the resource.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 6;
  private volatile java.lang.Object network_;
  /**
   *
   *
   * <pre>
   * Required. Fully-qualified URL of the network that this route applies to. e.g.
   * projects/my-project/global/networks/my-network.
   * </pre>
   *
   * <code>
   * string network = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Fully-qualified URL of the network that this route applies to. e.g.
   * projects/my-project/global/networks/my-network.
   * </pre>
   *
   * <code>
   * string network = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 10;
  private com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter_;
  /**
   *
   *
   * <pre>
   * Required. The filter to match L4 traffic.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return filter_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The filter to match L4 traffic.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter getFilter() {
    return filter_ == null
        ? com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.getDefaultInstance()
        : filter_;
  }
  /**
   *
   *
   * <pre>
   * Required. The filter to match L4 traffic.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.FilterOrBuilder
      getFilterOrBuilder() {
    return getFilter();
  }

  public static final int PRIORITY_FIELD_NUMBER = 11;
  private int priority_;
  /**
   *
   *
   * <pre>
   * Optional. The priority of this policy based route. Priority is used to break ties in
   * cases where there are more than one matching policy based routes found. In
   * cases where multiple policy based routes are matched, the one with the
   * lowest-numbered priority value wins. The default value is 1000. The
   * priority value must be from 1 to 65535, inclusive.
   * </pre>
   *
   * <code>int32 priority = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int WARNINGS_FIELD_NUMBER = 14;
  private java.util.List<com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings>
      warnings_;
  /**
   *
   *
   * <pre>
   * Output only. If potential misconfigurations are detected for this route,
   * this field will be populated with warning messages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings>
      getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If potential misconfigurations are detected for this route,
   * this field will be populated with warning messages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.WarningsOrBuilder>
      getWarningsOrBuilderList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If potential misconfigurations are detected for this route,
   * this field will be populated with warning messages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. If potential misconfigurations are detected for this route,
   * this field will be populated with warning messages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. If potential misconfigurations are detected for this route,
   * this field will be populated with warning messages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.WarningsOrBuilder
      getWarningsOrBuilder(int index) {
    return warnings_.get(index);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 15;
  private volatile java.lang.Object selfLink_;
  /**
   *
   *
   * <pre>
   * Output only. Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>string self_link = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Server-defined fully-qualified URL for this resource.
   * </pre>
   *
   * <code>string self_link = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 16;
  private volatile java.lang.Object kind_;
  /**
   *
   *
   * <pre>
   * Output only. Type of this resource. Always networkconnectivity#policyBasedRoute for
   * Policy Based Route resources.
   * </pre>
   *
   * <code>string kind = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Type of this resource. Always networkconnectivity#policyBasedRoute for
   * Policy Based Route resources.
   * </pre>
   *
   * <code>string kind = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, network_);
    }
    if (targetCase_ == 9) {
      output.writeMessage(
          9,
          (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
              target_);
    }
    if (filter_ != null) {
      output.writeMessage(10, getFilter());
    }
    if (priority_ != 0) {
      output.writeInt32(11, priority_);
    }
    if (nextHopCase_ == 12) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, nextHop_);
    }
    for (int i = 0; i < warnings_.size(); i++) {
      output.writeMessage(14, warnings_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selfLink_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, selfLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, kind_);
    }
    if (targetCase_ == 18) {
      output.writeMessage(
          18, (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) target_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, network_);
    }
    if (targetCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
                  target_);
    }
    if (filter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getFilter());
    }
    if (priority_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, priority_);
    }
    if (nextHopCase_ == 12) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, nextHop_);
    }
    for (int i = 0; i < warnings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, warnings_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(selfLink_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, selfLink_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, kind_);
    }
    if (targetCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18,
              (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) target_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkconnectivity.v1.PolicyBasedRoute)) {
      return super.equals(obj);
    }
    com.google.cloud.networkconnectivity.v1.PolicyBasedRoute other =
        (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (getPriority() != other.getPriority()) return false;
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (!getSelfLink().equals(other.getSelfLink())) return false;
    if (!getKind().equals(other.getKind())) return false;
    if (!getTargetCase().equals(other.getTargetCase())) return false;
    switch (targetCase_) {
      case 18:
        if (!getVirtualMachine().equals(other.getVirtualMachine())) return false;
        break;
      case 9:
        if (!getInterconnectAttachment().equals(other.getInterconnectAttachment())) return false;
        break;
      case 0:
      default:
    }
    if (!getNextHopCase().equals(other.getNextHopCase())) return false;
    switch (nextHopCase_) {
      case 12:
        if (!getNextHopIlbIp().equals(other.getNextHopIlbIp())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + getPriority();
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
    hash = (53 * hash) + getSelfLink().hashCode();
    hash = (37 * hash) + KIND_FIELD_NUMBER;
    hash = (53 * hash) + getKind().hashCode();
    switch (targetCase_) {
      case 18:
        hash = (37 * hash) + VIRTUAL_MACHINE_FIELD_NUMBER;
        hash = (53 * hash) + getVirtualMachine().hashCode();
        break;
      case 9:
        hash = (37 * hash) + INTERCONNECT_ATTACHMENT_FIELD_NUMBER;
        hash = (53 * hash) + getInterconnectAttachment().hashCode();
        break;
      case 0:
      default:
    }
    switch (nextHopCase_) {
      case 12:
        hash = (37 * hash) + NEXT_HOP_ILB_IP_FIELD_NUMBER;
        hash = (53 * hash) + getNextHopIlbIp().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Policy Based Routes (PBR) are more powerful routes that allows GCP customers
   * to route their L4 network traffic based on not just destination IP, but also
   * source IP, protocol and more. A PBR always take precedence when it conflicts
   * with other types of routes.
   * Next id: 19
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkconnectivity.v1.PolicyBasedRoute}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkconnectivity.v1.PolicyBasedRoute)
      com.google.cloud.networkconnectivity.v1.PolicyBasedRouteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.class,
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Builder.class);
    }

    // Construct using com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (virtualMachineBuilder_ != null) {
        virtualMachineBuilder_.clear();
      }
      if (interconnectAttachmentBuilder_ != null) {
        interconnectAttachmentBuilder_.clear();
      }
      name_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      description_ = "";

      network_ = "";

      if (filterBuilder_ == null) {
        filter_ = null;
      } else {
        filter_ = null;
        filterBuilder_ = null;
      }
      priority_ = 0;

      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
      } else {
        warnings_ = null;
        warningsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      selfLink_ = "";

      kind_ = "";

      targetCase_ = 0;
      target_ = null;
      nextHopCase_ = 0;
      nextHop_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoutingProto
          .internal_static_google_cloud_networkconnectivity_v1_PolicyBasedRoute_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute getDefaultInstanceForType() {
      return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute build() {
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute buildPartial() {
      com.google.cloud.networkconnectivity.v1.PolicyBasedRoute result =
          new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute(this);
      int from_bitField0_ = bitField0_;
      if (targetCase_ == 18) {
        if (virtualMachineBuilder_ == null) {
          result.target_ = target_;
        } else {
          result.target_ = virtualMachineBuilder_.build();
        }
      }
      if (targetCase_ == 9) {
        if (interconnectAttachmentBuilder_ == null) {
          result.target_ = target_;
        } else {
          result.target_ = interconnectAttachmentBuilder_.build();
        }
      }
      if (nextHopCase_ == 12) {
        result.nextHop_ = nextHop_;
      }
      result.name_ = name_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.description_ = description_;
      result.network_ = network_;
      if (filterBuilder_ == null) {
        result.filter_ = filter_;
      } else {
        result.filter_ = filterBuilder_.build();
      }
      result.priority_ = priority_;
      if (warningsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          warnings_ = java.util.Collections.unmodifiableList(warnings_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.warnings_ = warnings_;
      } else {
        result.warnings_ = warningsBuilder_.build();
      }
      result.selfLink_ = selfLink_;
      result.kind_ = kind_;
      result.targetCase_ = targetCase_;
      result.nextHopCase_ = nextHopCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkconnectivity.v1.PolicyBasedRoute) {
        return mergeFrom((com.google.cloud.networkconnectivity.v1.PolicyBasedRoute) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkconnectivity.v1.PolicyBasedRoute other) {
      if (other == com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        onChanged();
      }
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (other.getPriority() != 0) {
        setPriority(other.getPriority());
      }
      if (warningsBuilder_ == null) {
        if (!other.warnings_.isEmpty()) {
          if (warnings_.isEmpty()) {
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureWarningsIsMutable();
            warnings_.addAll(other.warnings_);
          }
          onChanged();
        }
      } else {
        if (!other.warnings_.isEmpty()) {
          if (warningsBuilder_.isEmpty()) {
            warningsBuilder_.dispose();
            warningsBuilder_ = null;
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x00000002);
            warningsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWarningsFieldBuilder()
                    : null;
          } else {
            warningsBuilder_.addAllMessages(other.warnings_);
          }
        }
      }
      if (!other.getSelfLink().isEmpty()) {
        selfLink_ = other.selfLink_;
        onChanged();
      }
      if (!other.getKind().isEmpty()) {
        kind_ = other.kind_;
        onChanged();
      }
      switch (other.getTargetCase()) {
        case VIRTUAL_MACHINE:
          {
            mergeVirtualMachine(other.getVirtualMachine());
            break;
          }
        case INTERCONNECT_ATTACHMENT:
          {
            mergeInterconnectAttachment(other.getInterconnectAttachment());
            break;
          }
        case TARGET_NOT_SET:
          {
            break;
          }
      }
      switch (other.getNextHopCase()) {
        case NEXT_HOP_ILB_IP:
          {
            nextHopCase_ = 12;
            nextHop_ = other.nextHop_;
            onChanged();
            break;
          }
        case NEXTHOP_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                network_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 74:
              {
                input.readMessage(
                    getInterconnectAttachmentFieldBuilder().getBuilder(), extensionRegistry);
                targetCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            case 88:
              {
                priority_ = input.readInt32();

                break;
              } // case 88
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                nextHopCase_ = 12;
                nextHop_ = s;
                break;
              } // case 98
            case 114:
              {
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings m =
                    input.readMessage(
                        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.parser(),
                        extensionRegistry);
                if (warningsBuilder_ == null) {
                  ensureWarningsIsMutable();
                  warnings_.add(m);
                } else {
                  warningsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 122:
              {
                selfLink_ = input.readStringRequireUtf8();

                break;
              } // case 122
            case 130:
              {
                kind_ = input.readStringRequireUtf8();

                break;
              } // case 130
            case 146:
              {
                input.readMessage(getVirtualMachineFieldBuilder().getBuilder(), extensionRegistry);
                targetCase_ = 18;
                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int targetCase_ = 0;
    private java.lang.Object target_;

    public TargetCase getTargetCase() {
      return TargetCase.forNumber(targetCase_);
    }

    public Builder clearTarget() {
      targetCase_ = 0;
      target_ = null;
      onChanged();
      return this;
    }

    private int nextHopCase_ = 0;
    private java.lang.Object nextHop_;

    public NextHopCase getNextHopCase() {
      return NextHopCase.forNumber(nextHopCase_);
    }

    public Builder clearNextHop() {
      nextHopCase_ = 0;
      nextHop_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.Builder,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachineOrBuilder>
        virtualMachineBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the virtualMachine field is set.
     */
    @java.lang.Override
    public boolean hasVirtualMachine() {
      return targetCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The virtualMachine.
     */
    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
        getVirtualMachine() {
      if (virtualMachineBuilder_ == null) {
        if (targetCase_ == 18) {
          return (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) target_;
        }
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
            .getDefaultInstance();
      } else {
        if (targetCase_ == 18) {
          return virtualMachineBuilder_.getMessage();
        }
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVirtualMachine(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine value) {
      if (virtualMachineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        onChanged();
      } else {
        virtualMachineBuilder_.setMessage(value);
      }
      targetCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVirtualMachine(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.Builder
            builderForValue) {
      if (virtualMachineBuilder_ == null) {
        target_ = builderForValue.build();
        onChanged();
      } else {
        virtualMachineBuilder_.setMessage(builderForValue.build());
      }
      targetCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeVirtualMachine(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine value) {
      if (virtualMachineBuilder_ == null) {
        if (targetCase_ == 18
            && target_
                != com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
                    .getDefaultInstance()) {
          target_ =
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.newBuilder(
                      (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine)
                          target_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          target_ = value;
        }
        onChanged();
      } else {
        if (targetCase_ == 18) {
          virtualMachineBuilder_.mergeFrom(value);
        } else {
          virtualMachineBuilder_.setMessage(value);
        }
      }
      targetCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVirtualMachine() {
      if (virtualMachineBuilder_ == null) {
        if (targetCase_ == 18) {
          targetCase_ = 0;
          target_ = null;
          onChanged();
        }
      } else {
        if (targetCase_ == 18) {
          targetCase_ = 0;
          target_ = null;
        }
        virtualMachineBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.Builder
        getVirtualMachineBuilder() {
      return getVirtualMachineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachineOrBuilder
        getVirtualMachineOrBuilder() {
      if ((targetCase_ == 18) && (virtualMachineBuilder_ != null)) {
        return virtualMachineBuilder_.getMessageOrBuilder();
      } else {
        if (targetCase_ == 18) {
          return (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) target_;
        }
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. VM instances to which this policy based route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine virtual_machine = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.Builder,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachineOrBuilder>
        getVirtualMachineFieldBuilder() {
      if (virtualMachineBuilder_ == null) {
        if (!(targetCase_ == 18)) {
          target_ =
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine
                  .getDefaultInstance();
        }
        virtualMachineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine.Builder,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachineOrBuilder>(
                (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.VirtualMachine) target_,
                getParentForChildren(),
                isClean());
        target_ = null;
      }
      targetCase_ = 18;
      onChanged();
      ;
      return virtualMachineBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment.Builder,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute
                .InterconnectAttachmentOrBuilder>
        interconnectAttachmentBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the interconnectAttachment field is set.
     */
    @java.lang.Override
    public boolean hasInterconnectAttachment() {
      return targetCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The interconnectAttachment.
     */
    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
        getInterconnectAttachment() {
      if (interconnectAttachmentBuilder_ == null) {
        if (targetCase_ == 9) {
          return (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
              target_;
        }
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
            .getDefaultInstance();
      } else {
        if (targetCase_ == 9) {
          return interconnectAttachmentBuilder_.getMessage();
        }
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInterconnectAttachment(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment value) {
      if (interconnectAttachmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        onChanged();
      } else {
        interconnectAttachmentBuilder_.setMessage(value);
      }
      targetCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInterconnectAttachment(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment.Builder
            builderForValue) {
      if (interconnectAttachmentBuilder_ == null) {
        target_ = builderForValue.build();
        onChanged();
      } else {
        interconnectAttachmentBuilder_.setMessage(builderForValue.build());
      }
      targetCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeInterconnectAttachment(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment value) {
      if (interconnectAttachmentBuilder_ == null) {
        if (targetCase_ == 9
            && target_
                != com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
                    .getDefaultInstance()) {
          target_ =
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
                  .newBuilder(
                      (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute
                              .InterconnectAttachment)
                          target_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          target_ = value;
        }
        onChanged();
      } else {
        if (targetCase_ == 9) {
          interconnectAttachmentBuilder_.mergeFrom(value);
        } else {
          interconnectAttachmentBuilder_.setMessage(value);
        }
      }
      targetCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInterconnectAttachment() {
      if (interconnectAttachmentBuilder_ == null) {
        if (targetCase_ == 9) {
          targetCase_ = 0;
          target_ = null;
          onChanged();
        }
      } else {
        if (targetCase_ == 9) {
          targetCase_ = 0;
          target_ = null;
        }
        interconnectAttachmentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment.Builder
        getInterconnectAttachmentBuilder() {
      return getInterconnectAttachmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachmentOrBuilder
        getInterconnectAttachmentOrBuilder() {
      if ((targetCase_ == 9) && (interconnectAttachmentBuilder_ != null)) {
        return interconnectAttachmentBuilder_.getMessageOrBuilder();
      } else {
        if (targetCase_ == 9) {
          return (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
              target_;
        }
        return com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The interconnect attachments to which this route applies to.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment interconnect_attachment = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment.Builder,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute
                .InterconnectAttachmentOrBuilder>
        getInterconnectAttachmentFieldBuilder() {
      if (interconnectAttachmentBuilder_ == null) {
        if (!(targetCase_ == 9)) {
          target_ =
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
                  .getDefaultInstance();
        }
        interconnectAttachmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment
                    .Builder,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute
                    .InterconnectAttachmentOrBuilder>(
                (com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.InterconnectAttachment)
                    target_,
                getParentForChildren(),
                isClean());
        target_ = null;
      }
      targetCase_ = 9;
      onChanged();
      ;
      return interconnectAttachmentBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
     * handle matching packets. For this version, only next_hop_ilb_ip is
     * supported.
     * </pre>
     *
     * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the nextHopIlbIp field is set.
     */
    @java.lang.Override
    public boolean hasNextHopIlbIp() {
      return nextHopCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
     * handle matching packets. For this version, only next_hop_ilb_ip is
     * supported.
     * </pre>
     *
     * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The nextHopIlbIp.
     */
    @java.lang.Override
    public java.lang.String getNextHopIlbIp() {
      java.lang.Object ref = "";
      if (nextHopCase_ == 12) {
        ref = nextHop_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (nextHopCase_ == 12) {
          nextHop_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
     * handle matching packets. For this version, only next_hop_ilb_ip is
     * supported.
     * </pre>
     *
     * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for nextHopIlbIp.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNextHopIlbIpBytes() {
      java.lang.Object ref = "";
      if (nextHopCase_ == 12) {
        ref = nextHop_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (nextHopCase_ == 12) {
          nextHop_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
     * handle matching packets. For this version, only next_hop_ilb_ip is
     * supported.
     * </pre>
     *
     * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The nextHopIlbIp to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopIlbIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextHopCase_ = 12;
      nextHop_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
     * handle matching packets. For this version, only next_hop_ilb_ip is
     * supported.
     * </pre>
     *
     * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextHopIlbIp() {
      if (nextHopCase_ == 12) {
        nextHopCase_ = 0;
        nextHop_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The IP of a global access enabled L4 ILB that should be the next hop to
     * handle matching packets. For this version, only next_hop_ilb_ip is
     * supported.
     * </pre>
     *
     * <code>string next_hop_ilb_ip = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for nextHopIlbIp to set.
     * @return This builder for chaining.
     */
    public Builder setNextHopIlbIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextHopCase_ = 12;
      nextHop_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. A unique name of the resource in the form of
     * `projects/{project_number}/locations/global/PolicyBasedRoutes/{policy_based_route_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. A unique name of the resource in the form of
     * `projects/{project_number}/locations/global/PolicyBasedRoutes/{policy_based_route_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. A unique name of the resource in the form of
     * `projects/{project_number}/locations/global/PolicyBasedRoutes/{policy_based_route_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. A unique name of the resource in the form of
     * `projects/{project_number}/locations/global/PolicyBasedRoutes/{policy_based_route_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. A unique name of the resource in the form of
     * `projects/{project_number}/locations/global/PolicyBasedRoutes/{policy_based_route_id}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the PolicyBasedRoute was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An optional description of this resource. Provide this field when you
     * create the resource.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional description of this resource. Provide this field when you
     * create the resource.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional description of this resource. Provide this field when you
     * create the resource.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional description of this resource. Provide this field when you
     * create the resource.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional description of this resource. Provide this field when you
     * create the resource.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * Required. Fully-qualified URL of the network that this route applies to. e.g.
     * projects/my-project/global/networks/my-network.
     * </pre>
     *
     * <code>
     * string network = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Fully-qualified URL of the network that this route applies to. e.g.
     * projects/my-project/global/networks/my-network.
     * </pre>
     *
     * <code>
     * string network = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Fully-qualified URL of the network that this route applies to. e.g.
     * projects/my-project/global/networks/my-network.
     * </pre>
     *
     * <code>
     * string network = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      network_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Fully-qualified URL of the network that this route applies to. e.g.
     * projects/my-project/global/networks/my-network.
     * </pre>
     *
     * <code>
     * string network = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {

      network_ = getDefaultInstance().getNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Fully-qualified URL of the network that this route applies to. e.g.
     * projects/my-project/global/networks/my-network.
     * </pre>
     *
     * <code>
     * string network = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      network_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.Builder,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.FilterOrBuilder>
        filterBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return filterBuilder_ != null || filter_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The filter.
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null
            ? com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.getDefaultInstance()
            : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFilter(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        filterBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setFilter(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeFilter(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter value) {
      if (filterBuilder_ == null) {
        if (filter_ != null) {
          filter_ =
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.newBuilder(filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        filterBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearFilter() {
      if (filterBuilder_ == null) {
        filter_ = null;
        onChanged();
      } else {
        filter_ = null;
        filterBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.Builder
        getFilterBuilder() {

      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.FilterOrBuilder
        getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null
            ? com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.getDefaultInstance()
            : filter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The filter to match L4 traffic.
     * </pre>
     *
     * <code>
     * .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter filter = 10 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.Builder,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.FilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Filter.Builder,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.FilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private int priority_;
    /**
     *
     *
     * <pre>
     * Optional. The priority of this policy based route. Priority is used to break ties in
     * cases where there are more than one matching policy based routes found. In
     * cases where multiple policy based routes are matched, the one with the
     * lowest-numbered priority value wins. The default value is 1000. The
     * priority value must be from 1 to 65535, inclusive.
     * </pre>
     *
     * <code>int32 priority = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The priority of this policy based route. Priority is used to break ties in
     * cases where there are more than one matching policy based routes found. In
     * cases where multiple policy based routes are matched, the one with the
     * lowest-numbered priority value wins. The default value is 1000. The
     * priority value must be from 1 to 65535, inclusive.
     * </pre>
     *
     * <code>int32 priority = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The priority of this policy based route. Priority is used to break ties in
     * cases where there are more than one matching policy based routes found. In
     * cases where multiple policy based routes are matched, the one with the
     * lowest-numbered priority value wins. The default value is 1000. The
     * priority value must be from 1 to 65535, inclusive.
     * </pre>
     *
     * <code>int32 priority = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {

      priority_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings>
        warnings_ = java.util.Collections.emptyList();

    private void ensureWarningsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        warnings_ =
            new java.util.ArrayList<
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings>(warnings_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.WarningsOrBuilder>
        warningsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings>
        getWarningsList() {
      if (warningsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(warnings_);
      } else {
        return warningsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getWarningsCount() {
      if (warningsBuilder_ == null) {
        return warnings_.size();
      } else {
        return warningsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings getWarnings(
        int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setWarnings(
        int index, com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.set(index, value);
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setWarnings(
        int index,
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.set(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWarnings(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWarnings(
        int index, com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(index, value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWarnings(
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addWarnings(
        int index,
        com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllWarnings(
        java.lang.Iterable<
                ? extends com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings>
            values) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
        onChanged();
      } else {
        warningsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearWarnings() {
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        warningsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeWarnings(int index) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.remove(index);
        onChanged();
      } else {
        warningsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder
        getWarningsBuilder(int index) {
      return getWarningsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.WarningsOrBuilder
        getWarningsOrBuilder(int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.WarningsOrBuilder>
        getWarningsOrBuilderList() {
      if (warningsBuilder_ != null) {
        return warningsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(warnings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder
        addWarningsBuilder() {
      return getWarningsFieldBuilder()
          .addBuilder(
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder
        addWarningsBuilder(int index) {
      return getWarningsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. If potential misconfigurations are detected for this route,
     * this field will be populated with warning messages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings warnings = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder>
        getWarningsBuilderList() {
      return getWarningsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder,
            com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.WarningsOrBuilder>
        getWarningsFieldBuilder() {
      if (warningsBuilder_ == null) {
        warningsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.Warnings.Builder,
                com.google.cloud.networkconnectivity.v1.PolicyBasedRoute.WarningsOrBuilder>(
                warnings_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        warnings_ = null;
      }
      return warningsBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>string self_link = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>string self_link = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>string self_link = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      selfLink_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>string self_link = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {

      selfLink_ = getDefaultInstance().getSelfLink();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Server-defined fully-qualified URL for this resource.
     * </pre>
     *
     * <code>string self_link = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      selfLink_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Type of this resource. Always networkconnectivity#policyBasedRoute for
     * Policy Based Route resources.
     * </pre>
     *
     * <code>string kind = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of this resource. Always networkconnectivity#policyBasedRoute for
     * Policy Based Route resources.
     * </pre>
     *
     * <code>string kind = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of this resource. Always networkconnectivity#policyBasedRoute for
     * Policy Based Route resources.
     * </pre>
     *
     * <code>string kind = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of this resource. Always networkconnectivity#policyBasedRoute for
     * Policy Based Route resources.
     * </pre>
     *
     * <code>string kind = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {

      kind_ = getDefaultInstance().getKind();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of this resource. Always networkconnectivity#policyBasedRoute for
     * Policy Based Route resources.
     * </pre>
     *
     * <code>string kind = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      kind_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkconnectivity.v1.PolicyBasedRoute)
  private static final com.google.cloud.networkconnectivity.v1.PolicyBasedRoute DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkconnectivity.v1.PolicyBasedRoute();
  }

  public static com.google.cloud.networkconnectivity.v1.PolicyBasedRoute getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PolicyBasedRoute> PARSER =
      new com.google.protobuf.AbstractParser<PolicyBasedRoute>() {
        @java.lang.Override
        public PolicyBasedRoute parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PolicyBasedRoute> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PolicyBasedRoute> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.PolicyBasedRoute getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
