/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkconnectivity/v1/hub.proto

package com.google.cloud.networkconnectivity.v1;

/**
 *
 *
 * <pre>
 * The response for
 * [HubService.ListSpokes][google.cloud.networkconnectivity.v1.HubService.ListSpokes].
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkconnectivity.v1.ListSpokesResponse}
 */
public final class ListSpokesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkconnectivity.v1.ListSpokesResponse)
    ListSpokesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListSpokesResponse.newBuilder() to construct.
  private ListSpokesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListSpokesResponse() {
    spokes_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListSpokesResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkconnectivity.v1.HubProto
        .internal_static_google_cloud_networkconnectivity_v1_ListSpokesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkconnectivity.v1.HubProto
        .internal_static_google_cloud_networkconnectivity_v1_ListSpokesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkconnectivity.v1.ListSpokesResponse.class,
            com.google.cloud.networkconnectivity.v1.ListSpokesResponse.Builder.class);
  }

  public static final int SPOKES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.networkconnectivity.v1.Spoke> spokes_;
  /**
   *
   *
   * <pre>
   * The requested spokes.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.networkconnectivity.v1.Spoke> getSpokesList() {
    return spokes_;
  }
  /**
   *
   *
   * <pre>
   * The requested spokes.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.networkconnectivity.v1.SpokeOrBuilder>
      getSpokesOrBuilderList() {
    return spokes_;
  }
  /**
   *
   *
   * <pre>
   * The requested spokes.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
   */
  @java.lang.Override
  public int getSpokesCount() {
    return spokes_.size();
  }
  /**
   *
   *
   * <pre>
   * The requested spokes.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.Spoke getSpokes(int index) {
    return spokes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The requested spokes.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.SpokeOrBuilder getSpokesOrBuilder(int index) {
    return spokes_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * The next pagination token in the List response. It should be used as
   * page_token for the following request. An empty value means no more result.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The next pagination token in the List response. It should be used as
   * page_token for the following request. An empty value means no more result.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNREACHABLE_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList unreachable_;
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return A list containing the unreachable.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableList() {
    return unreachable_;
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return The count of unreachable.
   */
  public int getUnreachableCount() {
    return unreachable_.size();
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The unreachable at the given index.
   */
  public java.lang.String getUnreachable(int index) {
    return unreachable_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Locations that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachable at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableBytes(int index) {
    return unreachable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < spokes_.size(); i++) {
      output.writeMessage(1, spokes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < unreachable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unreachable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < spokes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, spokes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkconnectivity.v1.ListSpokesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.networkconnectivity.v1.ListSpokesResponse other =
        (com.google.cloud.networkconnectivity.v1.ListSpokesResponse) obj;

    if (!getSpokesList().equals(other.getSpokesList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnreachableList().equals(other.getUnreachableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSpokesCount() > 0) {
      hash = (37 * hash) + SPOKES_FIELD_NUMBER;
      hash = (53 * hash) + getSpokesList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getUnreachableCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkconnectivity.v1.ListSpokesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for
   * [HubService.ListSpokes][google.cloud.networkconnectivity.v1.HubService.ListSpokes].
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkconnectivity.v1.ListSpokesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkconnectivity.v1.ListSpokesResponse)
      com.google.cloud.networkconnectivity.v1.ListSpokesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_ListSpokesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_ListSpokesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkconnectivity.v1.ListSpokesResponse.class,
              com.google.cloud.networkconnectivity.v1.ListSpokesResponse.Builder.class);
    }

    // Construct using com.google.cloud.networkconnectivity.v1.ListSpokesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (spokesBuilder_ == null) {
        spokes_ = java.util.Collections.emptyList();
      } else {
        spokes_ = null;
        spokesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";

      unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_ListSpokesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.ListSpokesResponse getDefaultInstanceForType() {
      return com.google.cloud.networkconnectivity.v1.ListSpokesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.ListSpokesResponse build() {
      com.google.cloud.networkconnectivity.v1.ListSpokesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.ListSpokesResponse buildPartial() {
      com.google.cloud.networkconnectivity.v1.ListSpokesResponse result =
          new com.google.cloud.networkconnectivity.v1.ListSpokesResponse(this);
      int from_bitField0_ = bitField0_;
      if (spokesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          spokes_ = java.util.Collections.unmodifiableList(spokes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.spokes_ = spokes_;
      } else {
        result.spokes_ = spokesBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      if (((bitField0_ & 0x00000002) != 0)) {
        unreachable_ = unreachable_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.unreachable_ = unreachable_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkconnectivity.v1.ListSpokesResponse) {
        return mergeFrom((com.google.cloud.networkconnectivity.v1.ListSpokesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.networkconnectivity.v1.ListSpokesResponse other) {
      if (other == com.google.cloud.networkconnectivity.v1.ListSpokesResponse.getDefaultInstance())
        return this;
      if (spokesBuilder_ == null) {
        if (!other.spokes_.isEmpty()) {
          if (spokes_.isEmpty()) {
            spokes_ = other.spokes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSpokesIsMutable();
            spokes_.addAll(other.spokes_);
          }
          onChanged();
        }
      } else {
        if (!other.spokes_.isEmpty()) {
          if (spokesBuilder_.isEmpty()) {
            spokesBuilder_.dispose();
            spokesBuilder_ = null;
            spokes_ = other.spokes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            spokesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpokesFieldBuilder()
                    : null;
          } else {
            spokesBuilder_.addAllMessages(other.spokes_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      if (!other.unreachable_.isEmpty()) {
        if (unreachable_.isEmpty()) {
          unreachable_ = other.unreachable_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureUnreachableIsMutable();
          unreachable_.addAll(other.unreachable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.networkconnectivity.v1.Spoke m =
                    input.readMessage(
                        com.google.cloud.networkconnectivity.v1.Spoke.parser(), extensionRegistry);
                if (spokesBuilder_ == null) {
                  ensureSpokesIsMutable();
                  spokes_.add(m);
                } else {
                  spokesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableIsMutable();
                unreachable_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.networkconnectivity.v1.Spoke> spokes_ =
        java.util.Collections.emptyList();

    private void ensureSpokesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        spokes_ = new java.util.ArrayList<com.google.cloud.networkconnectivity.v1.Spoke>(spokes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.Spoke,
            com.google.cloud.networkconnectivity.v1.Spoke.Builder,
            com.google.cloud.networkconnectivity.v1.SpokeOrBuilder>
        spokesBuilder_;

    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public java.util.List<com.google.cloud.networkconnectivity.v1.Spoke> getSpokesList() {
      if (spokesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(spokes_);
      } else {
        return spokesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public int getSpokesCount() {
      if (spokesBuilder_ == null) {
        return spokes_.size();
      } else {
        return spokesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public com.google.cloud.networkconnectivity.v1.Spoke getSpokes(int index) {
      if (spokesBuilder_ == null) {
        return spokes_.get(index);
      } else {
        return spokesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder setSpokes(int index, com.google.cloud.networkconnectivity.v1.Spoke value) {
      if (spokesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpokesIsMutable();
        spokes_.set(index, value);
        onChanged();
      } else {
        spokesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder setSpokes(
        int index, com.google.cloud.networkconnectivity.v1.Spoke.Builder builderForValue) {
      if (spokesBuilder_ == null) {
        ensureSpokesIsMutable();
        spokes_.set(index, builderForValue.build());
        onChanged();
      } else {
        spokesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder addSpokes(com.google.cloud.networkconnectivity.v1.Spoke value) {
      if (spokesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpokesIsMutable();
        spokes_.add(value);
        onChanged();
      } else {
        spokesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder addSpokes(int index, com.google.cloud.networkconnectivity.v1.Spoke value) {
      if (spokesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpokesIsMutable();
        spokes_.add(index, value);
        onChanged();
      } else {
        spokesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder addSpokes(
        com.google.cloud.networkconnectivity.v1.Spoke.Builder builderForValue) {
      if (spokesBuilder_ == null) {
        ensureSpokesIsMutable();
        spokes_.add(builderForValue.build());
        onChanged();
      } else {
        spokesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder addSpokes(
        int index, com.google.cloud.networkconnectivity.v1.Spoke.Builder builderForValue) {
      if (spokesBuilder_ == null) {
        ensureSpokesIsMutable();
        spokes_.add(index, builderForValue.build());
        onChanged();
      } else {
        spokesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder addAllSpokes(
        java.lang.Iterable<? extends com.google.cloud.networkconnectivity.v1.Spoke> values) {
      if (spokesBuilder_ == null) {
        ensureSpokesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, spokes_);
        onChanged();
      } else {
        spokesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder clearSpokes() {
      if (spokesBuilder_ == null) {
        spokes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        spokesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public Builder removeSpokes(int index) {
      if (spokesBuilder_ == null) {
        ensureSpokesIsMutable();
        spokes_.remove(index);
        onChanged();
      } else {
        spokesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public com.google.cloud.networkconnectivity.v1.Spoke.Builder getSpokesBuilder(int index) {
      return getSpokesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public com.google.cloud.networkconnectivity.v1.SpokeOrBuilder getSpokesOrBuilder(int index) {
      if (spokesBuilder_ == null) {
        return spokes_.get(index);
      } else {
        return spokesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.networkconnectivity.v1.SpokeOrBuilder>
        getSpokesOrBuilderList() {
      if (spokesBuilder_ != null) {
        return spokesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(spokes_);
      }
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public com.google.cloud.networkconnectivity.v1.Spoke.Builder addSpokesBuilder() {
      return getSpokesFieldBuilder()
          .addBuilder(com.google.cloud.networkconnectivity.v1.Spoke.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public com.google.cloud.networkconnectivity.v1.Spoke.Builder addSpokesBuilder(int index) {
      return getSpokesFieldBuilder()
          .addBuilder(index, com.google.cloud.networkconnectivity.v1.Spoke.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The requested spokes.
     * </pre>
     *
     * <code>repeated .google.cloud.networkconnectivity.v1.Spoke spokes = 1;</code>
     */
    public java.util.List<com.google.cloud.networkconnectivity.v1.Spoke.Builder>
        getSpokesBuilderList() {
      return getSpokesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.networkconnectivity.v1.Spoke,
            com.google.cloud.networkconnectivity.v1.Spoke.Builder,
            com.google.cloud.networkconnectivity.v1.SpokeOrBuilder>
        getSpokesFieldBuilder() {
      if (spokesBuilder_ == null) {
        spokesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.networkconnectivity.v1.Spoke,
                com.google.cloud.networkconnectivity.v1.Spoke.Builder,
                com.google.cloud.networkconnectivity.v1.SpokeOrBuilder>(
                spokes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        spokes_ = null;
      }
      return spokesBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * The next pagination token in the List response. It should be used as
     * page_token for the following request. An empty value means no more result.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The next pagination token in the List response. It should be used as
     * page_token for the following request. An empty value means no more result.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The next pagination token in the List response. It should be used as
     * page_token for the following request. An empty value means no more result.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The next pagination token in the List response. It should be used as
     * page_token for the following request. An empty value means no more result.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The next pagination token in the List response. It should be used as
     * page_token for the following request. An empty value means no more result.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList unreachable_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureUnreachableIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        unreachable_ = new com.google.protobuf.LazyStringArrayList(unreachable_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return A list containing the unreachable.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableList() {
      return unreachable_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return The count of unreachable.
     */
    public int getUnreachableCount() {
      return unreachable_.size();
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The unreachable at the given index.
     */
    public java.lang.String getUnreachable(int index) {
      return unreachable_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachable at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableBytes(int index) {
      return unreachable_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachable to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param values The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachable(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachable_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachable() {
      unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Locations that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The bytes of the unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkconnectivity.v1.ListSpokesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkconnectivity.v1.ListSpokesResponse)
  private static final com.google.cloud.networkconnectivity.v1.ListSpokesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkconnectivity.v1.ListSpokesResponse();
  }

  public static com.google.cloud.networkconnectivity.v1.ListSpokesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListSpokesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListSpokesResponse>() {
        @java.lang.Override
        public ListSpokesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListSpokesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListSpokesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.ListSpokesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
