/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkconnectivity/v1/hub.proto

package com.google.cloud.networkconnectivity.v1;

/**
 *
 *
 * <pre>
 * A collection of VLAN attachment resources. These resources should
 * be redundant attachments that all advertise the same prefixes to Google
 * Cloud. Alternatively, in active/passive configurations, all attachments
 * should be capable of advertising the same prefixes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments}
 */
public final class LinkedInterconnectAttachments extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments)
    LinkedInterconnectAttachmentsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LinkedInterconnectAttachments.newBuilder() to construct.
  private LinkedInterconnectAttachments(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LinkedInterconnectAttachments() {
    uris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    vpcNetwork_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LinkedInterconnectAttachments();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.networkconnectivity.v1.HubProto
        .internal_static_google_cloud_networkconnectivity_v1_LinkedInterconnectAttachments_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.networkconnectivity.v1.HubProto
        .internal_static_google_cloud_networkconnectivity_v1_LinkedInterconnectAttachments_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.class,
            com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.Builder.class);
  }

  public static final int URIS_FIELD_NUMBER = 1;
  private com.google.protobuf.LazyStringList uris_;
  /**
   *
   *
   * <pre>
   * The URIs of linked interconnect attachment resources
   * </pre>
   *
   * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the uris.
   */
  public com.google.protobuf.ProtocolStringList getUrisList() {
    return uris_;
  }
  /**
   *
   *
   * <pre>
   * The URIs of linked interconnect attachment resources
   * </pre>
   *
   * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of uris.
   */
  public int getUrisCount() {
    return uris_.size();
  }
  /**
   *
   *
   * <pre>
   * The URIs of linked interconnect attachment resources
   * </pre>
   *
   * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The uris at the given index.
   */
  public java.lang.String getUris(int index) {
    return uris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The URIs of linked interconnect attachment resources
   * </pre>
   *
   * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the uris at the given index.
   */
  public com.google.protobuf.ByteString getUrisBytes(int index) {
    return uris_.getByteString(index);
  }

  public static final int SITE_TO_SITE_DATA_TRANSFER_FIELD_NUMBER = 2;
  private boolean siteToSiteDataTransfer_;
  /**
   *
   *
   * <pre>
   * A value that controls whether site-to-site data transfer is enabled for
   * these resources. Data transfer is available only in [supported
   * locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
   * </pre>
   *
   * <code>bool site_to_site_data_transfer = 2;</code>
   *
   * @return The siteToSiteDataTransfer.
   */
  @java.lang.Override
  public boolean getSiteToSiteDataTransfer() {
    return siteToSiteDataTransfer_;
  }

  public static final int VPC_NETWORK_FIELD_NUMBER = 3;
  private volatile java.lang.Object vpcNetwork_;
  /**
   *
   *
   * <pre>
   * Output only. The VPC network where these VLAN attachments are located.
   * </pre>
   *
   * <code>
   * string vpc_network = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The vpcNetwork.
   */
  @java.lang.Override
  public java.lang.String getVpcNetwork() {
    java.lang.Object ref = vpcNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vpcNetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The VPC network where these VLAN attachments are located.
   * </pre>
   *
   * <code>
   * string vpc_network = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for vpcNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVpcNetworkBytes() {
    java.lang.Object ref = vpcNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vpcNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < uris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uris_.getRaw(i));
    }
    if (siteToSiteDataTransfer_ != false) {
      output.writeBool(2, siteToSiteDataTransfer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpcNetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, vpcNetwork_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < uris_.size(); i++) {
        dataSize += computeStringSizeNoTag(uris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUrisList().size();
    }
    if (siteToSiteDataTransfer_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, siteToSiteDataTransfer_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpcNetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, vpcNetwork_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments)) {
      return super.equals(obj);
    }
    com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments other =
        (com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments) obj;

    if (!getUrisList().equals(other.getUrisList())) return false;
    if (getSiteToSiteDataTransfer() != other.getSiteToSiteDataTransfer()) return false;
    if (!getVpcNetwork().equals(other.getVpcNetwork())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getUrisCount() > 0) {
      hash = (37 * hash) + URIS_FIELD_NUMBER;
      hash = (53 * hash) + getUrisList().hashCode();
    }
    hash = (37 * hash) + SITE_TO_SITE_DATA_TRANSFER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSiteToSiteDataTransfer());
    hash = (37 * hash) + VPC_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getVpcNetwork().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A collection of VLAN attachment resources. These resources should
   * be redundant attachments that all advertise the same prefixes to Google
   * Cloud. Alternatively, in active/passive configurations, all attachments
   * should be capable of advertising the same prefixes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments)
      com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachmentsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_LinkedInterconnectAttachments_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_LinkedInterconnectAttachments_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.class,
              com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.Builder.class);
    }

    // Construct using
    // com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      uris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      siteToSiteDataTransfer_ = false;

      vpcNetwork_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.networkconnectivity.v1.HubProto
          .internal_static_google_cloud_networkconnectivity_v1_LinkedInterconnectAttachments_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
        getDefaultInstanceForType() {
      return com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments build() {
      com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments buildPartial() {
      com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments result =
          new com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        uris_ = uris_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.uris_ = uris_;
      result.siteToSiteDataTransfer_ = siteToSiteDataTransfer_;
      result.vpcNetwork_ = vpcNetwork_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments) {
        return mergeFrom(
            (com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments other) {
      if (other
          == com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
              .getDefaultInstance()) return this;
      if (!other.uris_.isEmpty()) {
        if (uris_.isEmpty()) {
          uris_ = other.uris_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureUrisIsMutable();
          uris_.addAll(other.uris_);
        }
        onChanged();
      }
      if (other.getSiteToSiteDataTransfer() != false) {
        setSiteToSiteDataTransfer(other.getSiteToSiteDataTransfer());
      }
      if (!other.getVpcNetwork().isEmpty()) {
        vpcNetwork_ = other.vpcNetwork_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUrisIsMutable();
                uris_.add(s);
                break;
              } // case 10
            case 16:
              {
                siteToSiteDataTransfer_ = input.readBool();

                break;
              } // case 16
            case 26:
              {
                vpcNetwork_ = input.readStringRequireUtf8();

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList uris_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureUrisIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        uris_ = new com.google.protobuf.LazyStringArrayList(uris_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the uris.
     */
    public com.google.protobuf.ProtocolStringList getUrisList() {
      return uris_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of uris.
     */
    public int getUrisCount() {
      return uris_.size();
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The uris at the given index.
     */
    public java.lang.String getUris(int index) {
      return uris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the uris at the given index.
     */
    public com.google.protobuf.ByteString getUrisBytes(int index) {
      return uris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The uris to set.
     * @return This builder for chaining.
     */
    public Builder setUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUrisIsMutable();
      uris_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The uris to add.
     * @return This builder for chaining.
     */
    public Builder addUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUrisIsMutable();
      uris_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The uris to add.
     * @return This builder for chaining.
     */
    public Builder addAllUris(java.lang.Iterable<java.lang.String> values) {
      ensureUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uris_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUris() {
      uris_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URIs of linked interconnect attachment resources
     * </pre>
     *
     * <code>repeated string uris = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the uris to add.
     * @return This builder for chaining.
     */
    public Builder addUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUrisIsMutable();
      uris_.add(value);
      onChanged();
      return this;
    }

    private boolean siteToSiteDataTransfer_;
    /**
     *
     *
     * <pre>
     * A value that controls whether site-to-site data transfer is enabled for
     * these resources. Data transfer is available only in [supported
     * locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
     * </pre>
     *
     * <code>bool site_to_site_data_transfer = 2;</code>
     *
     * @return The siteToSiteDataTransfer.
     */
    @java.lang.Override
    public boolean getSiteToSiteDataTransfer() {
      return siteToSiteDataTransfer_;
    }
    /**
     *
     *
     * <pre>
     * A value that controls whether site-to-site data transfer is enabled for
     * these resources. Data transfer is available only in [supported
     * locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
     * </pre>
     *
     * <code>bool site_to_site_data_transfer = 2;</code>
     *
     * @param value The siteToSiteDataTransfer to set.
     * @return This builder for chaining.
     */
    public Builder setSiteToSiteDataTransfer(boolean value) {

      siteToSiteDataTransfer_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A value that controls whether site-to-site data transfer is enabled for
     * these resources. Data transfer is available only in [supported
     * locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
     * </pre>
     *
     * <code>bool site_to_site_data_transfer = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSiteToSiteDataTransfer() {

      siteToSiteDataTransfer_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object vpcNetwork_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The VPC network where these VLAN attachments are located.
     * </pre>
     *
     * <code>
     * string vpc_network = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The vpcNetwork.
     */
    public java.lang.String getVpcNetwork() {
      java.lang.Object ref = vpcNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vpcNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The VPC network where these VLAN attachments are located.
     * </pre>
     *
     * <code>
     * string vpc_network = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for vpcNetwork.
     */
    public com.google.protobuf.ByteString getVpcNetworkBytes() {
      java.lang.Object ref = vpcNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vpcNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The VPC network where these VLAN attachments are located.
     * </pre>
     *
     * <code>
     * string vpc_network = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The vpcNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setVpcNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      vpcNetwork_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The VPC network where these VLAN attachments are located.
     * </pre>
     *
     * <code>
     * string vpc_network = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpcNetwork() {

      vpcNetwork_ = getDefaultInstance().getVpcNetwork();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The VPC network where these VLAN attachments are located.
     * </pre>
     *
     * <code>
     * string vpc_network = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for vpcNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setVpcNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      vpcNetwork_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments)
  private static final com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments();
  }

  public static com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LinkedInterconnectAttachments> PARSER =
      new com.google.protobuf.AbstractParser<LinkedInterconnectAttachments>() {
        @java.lang.Override
        public LinkedInterconnectAttachments parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LinkedInterconnectAttachments> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LinkedInterconnectAttachments> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
