/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/networkconnectivity/v1/hub.proto

package com.google.cloud.networkconnectivity.v1;

public interface HubOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.networkconnectivity.v1.Hub)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Immutable. The name of the hub. Hub names must be unique. They use the
   * following form:
   *     `projects/{project_number}/locations/global/hubs/{hub_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Immutable. The name of the hub. Hub names must be unique. They use the
   * following form:
   *     `projects/{project_number}/locations/global/hubs/{hub_id}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The time the hub was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the hub was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the hub was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The time the hub was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the hub was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the hub was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */

  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional labels in key:value format. For more information about labels, see
   * [Requirements for
   * labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * An optional description of the hub.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * An optional description of the hub.
   * </pre>
   *
   * <code>string description = 5;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. The Google-generated UUID for the hub. This value is unique
   * across all hub resources. If a hub is deleted and another with the same
   * name is created, the new hub is assigned a different unique_id.
   * </pre>
   *
   * <code>string unique_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uniqueId.
   */
  java.lang.String getUniqueId();
  /**
   *
   *
   * <pre>
   * Output only. The Google-generated UUID for the hub. This value is unique
   * across all hub resources. If a hub is deleted and another with the same
   * name is created, the new hub is assigned a different unique_id.
   * </pre>
   *
   * <code>string unique_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uniqueId.
   */
  com.google.protobuf.ByteString getUniqueIdBytes();

  /**
   *
   *
   * <pre>
   * Output only. The current lifecycle state of this hub.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current lifecycle state of this hub.
   * </pre>
   *
   * <code>
   * .google.cloud.networkconnectivity.v1.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.networkconnectivity.v1.State getState();

  /**
   *
   *
   * <pre>
   * The VPC networks associated with this hub's spokes.
   * This field is read-only. Network Connectivity Center automatically
   * populates it based on the set of spokes attached to the hub.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.RoutingVPC routing_vpcs = 10;</code>
   */
  java.util.List<com.google.cloud.networkconnectivity.v1.RoutingVPC> getRoutingVpcsList();
  /**
   *
   *
   * <pre>
   * The VPC networks associated with this hub's spokes.
   * This field is read-only. Network Connectivity Center automatically
   * populates it based on the set of spokes attached to the hub.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.RoutingVPC routing_vpcs = 10;</code>
   */
  com.google.cloud.networkconnectivity.v1.RoutingVPC getRoutingVpcs(int index);
  /**
   *
   *
   * <pre>
   * The VPC networks associated with this hub's spokes.
   * This field is read-only. Network Connectivity Center automatically
   * populates it based on the set of spokes attached to the hub.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.RoutingVPC routing_vpcs = 10;</code>
   */
  int getRoutingVpcsCount();
  /**
   *
   *
   * <pre>
   * The VPC networks associated with this hub's spokes.
   * This field is read-only. Network Connectivity Center automatically
   * populates it based on the set of spokes attached to the hub.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.RoutingVPC routing_vpcs = 10;</code>
   */
  java.util.List<? extends com.google.cloud.networkconnectivity.v1.RoutingVPCOrBuilder>
      getRoutingVpcsOrBuilderList();
  /**
   *
   *
   * <pre>
   * The VPC networks associated with this hub's spokes.
   * This field is read-only. Network Connectivity Center automatically
   * populates it based on the set of spokes attached to the hub.
   * </pre>
   *
   * <code>repeated .google.cloud.networkconnectivity.v1.RoutingVPC routing_vpcs = 10;</code>
   */
  com.google.cloud.networkconnectivity.v1.RoutingVPCOrBuilder getRoutingVpcsOrBuilder(int index);
}
