/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric_service.proto

// Protobuf Java Version: 3.25.8
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * The `CreateTimeSeries` request.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.CreateTimeSeriesRequest}
 */
public final class CreateTimeSeriesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.CreateTimeSeriesRequest)
    CreateTimeSeriesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateTimeSeriesRequest.newBuilder() to construct.
  private CreateTimeSeriesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateTimeSeriesRequest() {
    name_ = "";
    timeSeries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateTimeSeriesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_CreateTimeSeriesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricServiceProto
        .internal_static_google_monitoring_v3_CreateTimeSeriesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.CreateTimeSeriesRequest.class,
            com.google.monitoring.v3.CreateTimeSeriesRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The
   * [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
   * to execute the request. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]
   * </pre>
   *
   * <code>
   * string name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The
   * [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
   * to execute the request. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]
   * </pre>
   *
   * <code>
   * string name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_SERIES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.TimeSeries> timeSeries_;

  /**
   *
   *
   * <pre>
   * Required. The new data to be added to a list of time series.
   * Adds at most one data point to each of several time series.  The new data
   * point must be more recent than any other point in its time series.  Each
   * `TimeSeries` value must fully specify a unique time series by supplying
   * all label values for the metric and the monitored resource.
   *
   * The maximum number of `TimeSeries` objects per `Create` request is 200.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.TimeSeries> getTimeSeriesList() {
    return timeSeries_;
  }

  /**
   *
   *
   * <pre>
   * Required. The new data to be added to a list of time series.
   * Adds at most one data point to each of several time series.  The new data
   * point must be more recent than any other point in its time series.  Each
   * `TimeSeries` value must fully specify a unique time series by supplying
   * all label values for the metric and the monitored resource.
   *
   * The maximum number of `TimeSeries` objects per `Create` request is 200.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.TimeSeriesOrBuilder>
      getTimeSeriesOrBuilderList() {
    return timeSeries_;
  }

  /**
   *
   *
   * <pre>
   * Required. The new data to be added to a list of time series.
   * Adds at most one data point to each of several time series.  The new data
   * point must be more recent than any other point in its time series.  Each
   * `TimeSeries` value must fully specify a unique time series by supplying
   * all label values for the metric and the monitored resource.
   *
   * The maximum number of `TimeSeries` objects per `Create` request is 200.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getTimeSeriesCount() {
    return timeSeries_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The new data to be added to a list of time series.
   * Adds at most one data point to each of several time series.  The new data
   * point must be more recent than any other point in its time series.  Each
   * `TimeSeries` value must fully specify a unique time series by supplying
   * all label values for the metric and the monitored resource.
   *
   * The maximum number of `TimeSeries` objects per `Create` request is 200.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeries getTimeSeries(int index) {
    return timeSeries_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The new data to be added to a list of time series.
   * Adds at most one data point to each of several time series.  The new data
   * point must be more recent than any other point in its time series.  Each
   * `TimeSeries` value must fully specify a unique time series by supplying
   * all label values for the metric and the monitored resource.
   *
   * The maximum number of `TimeSeries` objects per `Create` request is 200.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeSeriesOrBuilder getTimeSeriesOrBuilder(int index) {
    return timeSeries_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < timeSeries_.size(); i++) {
      output.writeMessage(2, timeSeries_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < timeSeries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, timeSeries_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.CreateTimeSeriesRequest)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.CreateTimeSeriesRequest other =
        (com.google.monitoring.v3.CreateTimeSeriesRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTimeSeriesList().equals(other.getTimeSeriesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getTimeSeriesCount() > 0) {
      hash = (37 * hash) + TIME_SERIES_FIELD_NUMBER;
      hash = (53 * hash) + getTimeSeriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.CreateTimeSeriesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The `CreateTimeSeries` request.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.CreateTimeSeriesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.CreateTimeSeriesRequest)
      com.google.monitoring.v3.CreateTimeSeriesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_CreateTimeSeriesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_CreateTimeSeriesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.CreateTimeSeriesRequest.class,
              com.google.monitoring.v3.CreateTimeSeriesRequest.Builder.class);
    }

    // Construct using com.google.monitoring.v3.CreateTimeSeriesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (timeSeriesBuilder_ == null) {
        timeSeries_ = java.util.Collections.emptyList();
      } else {
        timeSeries_ = null;
        timeSeriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricServiceProto
          .internal_static_google_monitoring_v3_CreateTimeSeriesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.CreateTimeSeriesRequest getDefaultInstanceForType() {
      return com.google.monitoring.v3.CreateTimeSeriesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.CreateTimeSeriesRequest build() {
      com.google.monitoring.v3.CreateTimeSeriesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.CreateTimeSeriesRequest buildPartial() {
      com.google.monitoring.v3.CreateTimeSeriesRequest result =
          new com.google.monitoring.v3.CreateTimeSeriesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.monitoring.v3.CreateTimeSeriesRequest result) {
      if (timeSeriesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          timeSeries_ = java.util.Collections.unmodifiableList(timeSeries_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.timeSeries_ = timeSeries_;
      } else {
        result.timeSeries_ = timeSeriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.monitoring.v3.CreateTimeSeriesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.CreateTimeSeriesRequest) {
        return mergeFrom((com.google.monitoring.v3.CreateTimeSeriesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.CreateTimeSeriesRequest other) {
      if (other == com.google.monitoring.v3.CreateTimeSeriesRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (timeSeriesBuilder_ == null) {
        if (!other.timeSeries_.isEmpty()) {
          if (timeSeries_.isEmpty()) {
            timeSeries_ = other.timeSeries_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTimeSeriesIsMutable();
            timeSeries_.addAll(other.timeSeries_);
          }
          onChanged();
        }
      } else {
        if (!other.timeSeries_.isEmpty()) {
          if (timeSeriesBuilder_.isEmpty()) {
            timeSeriesBuilder_.dispose();
            timeSeriesBuilder_ = null;
            timeSeries_ = other.timeSeries_;
            bitField0_ = (bitField0_ & ~0x00000002);
            timeSeriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTimeSeriesFieldBuilder()
                    : null;
          } else {
            timeSeriesBuilder_.addAllMessages(other.timeSeries_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.monitoring.v3.TimeSeries m =
                    input.readMessage(
                        com.google.monitoring.v3.TimeSeries.parser(), extensionRegistry);
                if (timeSeriesBuilder_ == null) {
                  ensureTimeSeriesIsMutable();
                  timeSeries_.add(m);
                } else {
                  timeSeriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The
     * [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
     * to execute the request. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The
     * [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
     * to execute the request. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The
     * [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
     * to execute the request. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The
     * [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
     * to execute the request. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The
     * [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
     * to execute the request. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]
     * </pre>
     *
     * <code>
     * string name = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.monitoring.v3.TimeSeries> timeSeries_ =
        java.util.Collections.emptyList();

    private void ensureTimeSeriesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        timeSeries_ = new java.util.ArrayList<com.google.monitoring.v3.TimeSeries>(timeSeries_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeries,
            com.google.monitoring.v3.TimeSeries.Builder,
            com.google.monitoring.v3.TimeSeriesOrBuilder>
        timeSeriesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeries> getTimeSeriesList() {
      if (timeSeriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(timeSeries_);
      } else {
        return timeSeriesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getTimeSeriesCount() {
      if (timeSeriesBuilder_ == null) {
        return timeSeries_.size();
      } else {
        return timeSeriesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.TimeSeries getTimeSeries(int index) {
      if (timeSeriesBuilder_ == null) {
        return timeSeries_.get(index);
      } else {
        return timeSeriesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTimeSeries(int index, com.google.monitoring.v3.TimeSeries value) {
      if (timeSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesIsMutable();
        timeSeries_.set(index, value);
        onChanged();
      } else {
        timeSeriesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTimeSeries(
        int index, com.google.monitoring.v3.TimeSeries.Builder builderForValue) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        timeSeries_.set(index, builderForValue.build());
        onChanged();
      } else {
        timeSeriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTimeSeries(com.google.monitoring.v3.TimeSeries value) {
      if (timeSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesIsMutable();
        timeSeries_.add(value);
        onChanged();
      } else {
        timeSeriesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTimeSeries(int index, com.google.monitoring.v3.TimeSeries value) {
      if (timeSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimeSeriesIsMutable();
        timeSeries_.add(index, value);
        onChanged();
      } else {
        timeSeriesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTimeSeries(com.google.monitoring.v3.TimeSeries.Builder builderForValue) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        timeSeries_.add(builderForValue.build());
        onChanged();
      } else {
        timeSeriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addTimeSeries(
        int index, com.google.monitoring.v3.TimeSeries.Builder builderForValue) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        timeSeries_.add(index, builderForValue.build());
        onChanged();
      } else {
        timeSeriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllTimeSeries(
        java.lang.Iterable<? extends com.google.monitoring.v3.TimeSeries> values) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, timeSeries_);
        onChanged();
      } else {
        timeSeriesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTimeSeries() {
      if (timeSeriesBuilder_ == null) {
        timeSeries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        timeSeriesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeTimeSeries(int index) {
      if (timeSeriesBuilder_ == null) {
        ensureTimeSeriesIsMutable();
        timeSeries_.remove(index);
        onChanged();
      } else {
        timeSeriesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.TimeSeries.Builder getTimeSeriesBuilder(int index) {
      return getTimeSeriesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.TimeSeriesOrBuilder getTimeSeriesOrBuilder(int index) {
      if (timeSeriesBuilder_ == null) {
        return timeSeries_.get(index);
      } else {
        return timeSeriesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.monitoring.v3.TimeSeriesOrBuilder>
        getTimeSeriesOrBuilderList() {
      if (timeSeriesBuilder_ != null) {
        return timeSeriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(timeSeries_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.TimeSeries.Builder addTimeSeriesBuilder() {
      return getTimeSeriesFieldBuilder()
          .addBuilder(com.google.monitoring.v3.TimeSeries.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.TimeSeries.Builder addTimeSeriesBuilder(int index) {
      return getTimeSeriesFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.TimeSeries.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The new data to be added to a list of time series.
     * Adds at most one data point to each of several time series.  The new data
     * point must be more recent than any other point in its time series.  Each
     * `TimeSeries` value must fully specify a unique time series by supplying
     * all label values for the metric and the monitored resource.
     *
     * The maximum number of `TimeSeries` objects per `Create` request is 200.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.TimeSeries time_series = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.monitoring.v3.TimeSeries.Builder> getTimeSeriesBuilderList() {
      return getTimeSeriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.TimeSeries,
            com.google.monitoring.v3.TimeSeries.Builder,
            com.google.monitoring.v3.TimeSeriesOrBuilder>
        getTimeSeriesFieldBuilder() {
      if (timeSeriesBuilder_ == null) {
        timeSeriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.TimeSeries,
                com.google.monitoring.v3.TimeSeries.Builder,
                com.google.monitoring.v3.TimeSeriesOrBuilder>(
                timeSeries_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        timeSeries_ = null;
      }
      return timeSeriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.CreateTimeSeriesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.CreateTimeSeriesRequest)
  private static final com.google.monitoring.v3.CreateTimeSeriesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.CreateTimeSeriesRequest();
  }

  public static com.google.monitoring.v3.CreateTimeSeriesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateTimeSeriesRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateTimeSeriesRequest>() {
        @java.lang.Override
        public CreateTimeSeriesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateTimeSeriesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateTimeSeriesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.CreateTimeSeriesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
