/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * Carries information about storage that can be attached to a VM.
 * Specify either [`Volume`][google.cloud.lifesciences.v2beta.Volume] or
 * [`Disk`][google.cloud.lifesciences.v2beta.Disk], but not both.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.Volume}
 */
public final class Volume extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.Volume)
    VolumeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Volume.newBuilder() to construct.
  private Volume(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Volume() {
    volume_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Volume();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Volume_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Volume_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.Volume.class,
            com.google.cloud.lifesciences.v2beta.Volume.Builder.class);
  }

  private int storageCase_ = 0;
  private java.lang.Object storage_;

  public enum StorageCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PERSISTENT_DISK(2),
    EXISTING_DISK(3),
    NFS_MOUNT(4),
    STORAGE_NOT_SET(0);
    private final int value;

    private StorageCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StorageCase valueOf(int value) {
      return forNumber(value);
    }

    public static StorageCase forNumber(int value) {
      switch (value) {
        case 2:
          return PERSISTENT_DISK;
        case 3:
          return EXISTING_DISK;
        case 4:
          return NFS_MOUNT;
        case 0:
          return STORAGE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StorageCase getStorageCase() {
    return StorageCase.forNumber(storageCase_);
  }

  public static final int VOLUME_FIELD_NUMBER = 1;
  private volatile java.lang.Object volume_;
  /**
   *
   *
   * <pre>
   * A user-supplied name for the volume. Used when mounting the volume into
   * [`Actions`][google.cloud.lifesciences.v2beta.Action]. The name must contain
   * only upper and lowercase alphanumeric characters and hyphens and cannot
   * start with a hyphen.
   * </pre>
   *
   * <code>string volume = 1;</code>
   *
   * @return The volume.
   */
  @java.lang.Override
  public java.lang.String getVolume() {
    java.lang.Object ref = volume_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      volume_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-supplied name for the volume. Used when mounting the volume into
   * [`Actions`][google.cloud.lifesciences.v2beta.Action]. The name must contain
   * only upper and lowercase alphanumeric characters and hyphens and cannot
   * start with a hyphen.
   * </pre>
   *
   * <code>string volume = 1;</code>
   *
   * @return The bytes for volume.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVolumeBytes() {
    java.lang.Object ref = volume_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      volume_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PERSISTENT_DISK_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Configuration for a persistent disk.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
   *
   * @return Whether the persistentDisk field is set.
   */
  @java.lang.Override
  public boolean hasPersistentDisk() {
    return storageCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a persistent disk.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
   *
   * @return The persistentDisk.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.PersistentDisk getPersistentDisk() {
    if (storageCase_ == 2) {
      return (com.google.cloud.lifesciences.v2beta.PersistentDisk) storage_;
    }
    return com.google.cloud.lifesciences.v2beta.PersistentDisk.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a persistent disk.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.PersistentDiskOrBuilder getPersistentDiskOrBuilder() {
    if (storageCase_ == 2) {
      return (com.google.cloud.lifesciences.v2beta.PersistentDisk) storage_;
    }
    return com.google.cloud.lifesciences.v2beta.PersistentDisk.getDefaultInstance();
  }

  public static final int EXISTING_DISK_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Configuration for a existing disk.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
   *
   * @return Whether the existingDisk field is set.
   */
  @java.lang.Override
  public boolean hasExistingDisk() {
    return storageCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a existing disk.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
   *
   * @return The existingDisk.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ExistingDisk getExistingDisk() {
    if (storageCase_ == 3) {
      return (com.google.cloud.lifesciences.v2beta.ExistingDisk) storage_;
    }
    return com.google.cloud.lifesciences.v2beta.ExistingDisk.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a existing disk.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ExistingDiskOrBuilder getExistingDiskOrBuilder() {
    if (storageCase_ == 3) {
      return (com.google.cloud.lifesciences.v2beta.ExistingDisk) storage_;
    }
    return com.google.cloud.lifesciences.v2beta.ExistingDisk.getDefaultInstance();
  }

  public static final int NFS_MOUNT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Configuration for an NFS mount.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
   *
   * @return Whether the nfsMount field is set.
   */
  @java.lang.Override
  public boolean hasNfsMount() {
    return storageCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Configuration for an NFS mount.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
   *
   * @return The nfsMount.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.NFSMount getNfsMount() {
    if (storageCase_ == 4) {
      return (com.google.cloud.lifesciences.v2beta.NFSMount) storage_;
    }
    return com.google.cloud.lifesciences.v2beta.NFSMount.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for an NFS mount.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.NFSMountOrBuilder getNfsMountOrBuilder() {
    if (storageCase_ == 4) {
      return (com.google.cloud.lifesciences.v2beta.NFSMount) storage_;
    }
    return com.google.cloud.lifesciences.v2beta.NFSMount.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(volume_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, volume_);
    }
    if (storageCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.lifesciences.v2beta.PersistentDisk) storage_);
    }
    if (storageCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.lifesciences.v2beta.ExistingDisk) storage_);
    }
    if (storageCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.lifesciences.v2beta.NFSMount) storage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(volume_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, volume_);
    }
    if (storageCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.lifesciences.v2beta.PersistentDisk) storage_);
    }
    if (storageCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.lifesciences.v2beta.ExistingDisk) storage_);
    }
    if (storageCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.lifesciences.v2beta.NFSMount) storage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.Volume)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.Volume other =
        (com.google.cloud.lifesciences.v2beta.Volume) obj;

    if (!getVolume().equals(other.getVolume())) return false;
    if (!getStorageCase().equals(other.getStorageCase())) return false;
    switch (storageCase_) {
      case 2:
        if (!getPersistentDisk().equals(other.getPersistentDisk())) return false;
        break;
      case 3:
        if (!getExistingDisk().equals(other.getExistingDisk())) return false;
        break;
      case 4:
        if (!getNfsMount().equals(other.getNfsMount())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VOLUME_FIELD_NUMBER;
    hash = (53 * hash) + getVolume().hashCode();
    switch (storageCase_) {
      case 2:
        hash = (37 * hash) + PERSISTENT_DISK_FIELD_NUMBER;
        hash = (53 * hash) + getPersistentDisk().hashCode();
        break;
      case 3:
        hash = (37 * hash) + EXISTING_DISK_FIELD_NUMBER;
        hash = (53 * hash) + getExistingDisk().hashCode();
        break;
      case 4:
        hash = (37 * hash) + NFS_MOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getNfsMount().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Volume parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.lifesciences.v2beta.Volume prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Carries information about storage that can be attached to a VM.
   * Specify either [`Volume`][google.cloud.lifesciences.v2beta.Volume] or
   * [`Disk`][google.cloud.lifesciences.v2beta.Disk], but not both.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.Volume}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.Volume)
      com.google.cloud.lifesciences.v2beta.VolumeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Volume_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Volume_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.Volume.class,
              com.google.cloud.lifesciences.v2beta.Volume.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.Volume.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      volume_ = "";

      if (persistentDiskBuilder_ != null) {
        persistentDiskBuilder_.clear();
      }
      if (existingDiskBuilder_ != null) {
        existingDiskBuilder_.clear();
      }
      if (nfsMountBuilder_ != null) {
        nfsMountBuilder_.clear();
      }
      storageCase_ = 0;
      storage_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Volume_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Volume getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.Volume.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Volume build() {
      com.google.cloud.lifesciences.v2beta.Volume result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Volume buildPartial() {
      com.google.cloud.lifesciences.v2beta.Volume result =
          new com.google.cloud.lifesciences.v2beta.Volume(this);
      result.volume_ = volume_;
      if (storageCase_ == 2) {
        if (persistentDiskBuilder_ == null) {
          result.storage_ = storage_;
        } else {
          result.storage_ = persistentDiskBuilder_.build();
        }
      }
      if (storageCase_ == 3) {
        if (existingDiskBuilder_ == null) {
          result.storage_ = storage_;
        } else {
          result.storage_ = existingDiskBuilder_.build();
        }
      }
      if (storageCase_ == 4) {
        if (nfsMountBuilder_ == null) {
          result.storage_ = storage_;
        } else {
          result.storage_ = nfsMountBuilder_.build();
        }
      }
      result.storageCase_ = storageCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.Volume) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.Volume) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.Volume other) {
      if (other == com.google.cloud.lifesciences.v2beta.Volume.getDefaultInstance()) return this;
      if (!other.getVolume().isEmpty()) {
        volume_ = other.volume_;
        onChanged();
      }
      switch (other.getStorageCase()) {
        case PERSISTENT_DISK:
          {
            mergePersistentDisk(other.getPersistentDisk());
            break;
          }
        case EXISTING_DISK:
          {
            mergeExistingDisk(other.getExistingDisk());
            break;
          }
        case NFS_MOUNT:
          {
            mergeNfsMount(other.getNfsMount());
            break;
          }
        case STORAGE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                volume_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPersistentDiskFieldBuilder().getBuilder(), extensionRegistry);
                storageCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getExistingDiskFieldBuilder().getBuilder(), extensionRegistry);
                storageCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getNfsMountFieldBuilder().getBuilder(), extensionRegistry);
                storageCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int storageCase_ = 0;
    private java.lang.Object storage_;

    public StorageCase getStorageCase() {
      return StorageCase.forNumber(storageCase_);
    }

    public Builder clearStorage() {
      storageCase_ = 0;
      storage_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object volume_ = "";
    /**
     *
     *
     * <pre>
     * A user-supplied name for the volume. Used when mounting the volume into
     * [`Actions`][google.cloud.lifesciences.v2beta.Action]. The name must contain
     * only upper and lowercase alphanumeric characters and hyphens and cannot
     * start with a hyphen.
     * </pre>
     *
     * <code>string volume = 1;</code>
     *
     * @return The volume.
     */
    public java.lang.String getVolume() {
      java.lang.Object ref = volume_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        volume_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-supplied name for the volume. Used when mounting the volume into
     * [`Actions`][google.cloud.lifesciences.v2beta.Action]. The name must contain
     * only upper and lowercase alphanumeric characters and hyphens and cannot
     * start with a hyphen.
     * </pre>
     *
     * <code>string volume = 1;</code>
     *
     * @return The bytes for volume.
     */
    public com.google.protobuf.ByteString getVolumeBytes() {
      java.lang.Object ref = volume_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        volume_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-supplied name for the volume. Used when mounting the volume into
     * [`Actions`][google.cloud.lifesciences.v2beta.Action]. The name must contain
     * only upper and lowercase alphanumeric characters and hyphens and cannot
     * start with a hyphen.
     * </pre>
     *
     * <code>string volume = 1;</code>
     *
     * @param value The volume to set.
     * @return This builder for chaining.
     */
    public Builder setVolume(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      volume_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-supplied name for the volume. Used when mounting the volume into
     * [`Actions`][google.cloud.lifesciences.v2beta.Action]. The name must contain
     * only upper and lowercase alphanumeric characters and hyphens and cannot
     * start with a hyphen.
     * </pre>
     *
     * <code>string volume = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVolume() {

      volume_ = getDefaultInstance().getVolume();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-supplied name for the volume. Used when mounting the volume into
     * [`Actions`][google.cloud.lifesciences.v2beta.Action]. The name must contain
     * only upper and lowercase alphanumeric characters and hyphens and cannot
     * start with a hyphen.
     * </pre>
     *
     * <code>string volume = 1;</code>
     *
     * @param value The bytes for volume to set.
     * @return This builder for chaining.
     */
    public Builder setVolumeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      volume_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.PersistentDisk,
            com.google.cloud.lifesciences.v2beta.PersistentDisk.Builder,
            com.google.cloud.lifesciences.v2beta.PersistentDiskOrBuilder>
        persistentDiskBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     *
     * @return Whether the persistentDisk field is set.
     */
    @java.lang.Override
    public boolean hasPersistentDisk() {
      return storageCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     *
     * @return The persistentDisk.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.PersistentDisk getPersistentDisk() {
      if (persistentDiskBuilder_ == null) {
        if (storageCase_ == 2) {
          return (com.google.cloud.lifesciences.v2beta.PersistentDisk) storage_;
        }
        return com.google.cloud.lifesciences.v2beta.PersistentDisk.getDefaultInstance();
      } else {
        if (storageCase_ == 2) {
          return persistentDiskBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.PersistentDisk.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     */
    public Builder setPersistentDisk(com.google.cloud.lifesciences.v2beta.PersistentDisk value) {
      if (persistentDiskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storage_ = value;
        onChanged();
      } else {
        persistentDiskBuilder_.setMessage(value);
      }
      storageCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     */
    public Builder setPersistentDisk(
        com.google.cloud.lifesciences.v2beta.PersistentDisk.Builder builderForValue) {
      if (persistentDiskBuilder_ == null) {
        storage_ = builderForValue.build();
        onChanged();
      } else {
        persistentDiskBuilder_.setMessage(builderForValue.build());
      }
      storageCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     */
    public Builder mergePersistentDisk(com.google.cloud.lifesciences.v2beta.PersistentDisk value) {
      if (persistentDiskBuilder_ == null) {
        if (storageCase_ == 2
            && storage_
                != com.google.cloud.lifesciences.v2beta.PersistentDisk.getDefaultInstance()) {
          storage_ =
              com.google.cloud.lifesciences.v2beta.PersistentDisk.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.PersistentDisk) storage_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storage_ = value;
        }
        onChanged();
      } else {
        if (storageCase_ == 2) {
          persistentDiskBuilder_.mergeFrom(value);
        } else {
          persistentDiskBuilder_.setMessage(value);
        }
      }
      storageCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     */
    public Builder clearPersistentDisk() {
      if (persistentDiskBuilder_ == null) {
        if (storageCase_ == 2) {
          storageCase_ = 0;
          storage_ = null;
          onChanged();
        }
      } else {
        if (storageCase_ == 2) {
          storageCase_ = 0;
          storage_ = null;
        }
        persistentDiskBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     */
    public com.google.cloud.lifesciences.v2beta.PersistentDisk.Builder getPersistentDiskBuilder() {
      return getPersistentDiskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.PersistentDiskOrBuilder
        getPersistentDiskOrBuilder() {
      if ((storageCase_ == 2) && (persistentDiskBuilder_ != null)) {
        return persistentDiskBuilder_.getMessageOrBuilder();
      } else {
        if (storageCase_ == 2) {
          return (com.google.cloud.lifesciences.v2beta.PersistentDisk) storage_;
        }
        return com.google.cloud.lifesciences.v2beta.PersistentDisk.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a persistent disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PersistentDisk persistent_disk = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.PersistentDisk,
            com.google.cloud.lifesciences.v2beta.PersistentDisk.Builder,
            com.google.cloud.lifesciences.v2beta.PersistentDiskOrBuilder>
        getPersistentDiskFieldBuilder() {
      if (persistentDiskBuilder_ == null) {
        if (!(storageCase_ == 2)) {
          storage_ = com.google.cloud.lifesciences.v2beta.PersistentDisk.getDefaultInstance();
        }
        persistentDiskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.PersistentDisk,
                com.google.cloud.lifesciences.v2beta.PersistentDisk.Builder,
                com.google.cloud.lifesciences.v2beta.PersistentDiskOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.PersistentDisk) storage_,
                getParentForChildren(),
                isClean());
        storage_ = null;
      }
      storageCase_ = 2;
      onChanged();
      ;
      return persistentDiskBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ExistingDisk,
            com.google.cloud.lifesciences.v2beta.ExistingDisk.Builder,
            com.google.cloud.lifesciences.v2beta.ExistingDiskOrBuilder>
        existingDiskBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     *
     * @return Whether the existingDisk field is set.
     */
    @java.lang.Override
    public boolean hasExistingDisk() {
      return storageCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     *
     * @return The existingDisk.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ExistingDisk getExistingDisk() {
      if (existingDiskBuilder_ == null) {
        if (storageCase_ == 3) {
          return (com.google.cloud.lifesciences.v2beta.ExistingDisk) storage_;
        }
        return com.google.cloud.lifesciences.v2beta.ExistingDisk.getDefaultInstance();
      } else {
        if (storageCase_ == 3) {
          return existingDiskBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.ExistingDisk.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     */
    public Builder setExistingDisk(com.google.cloud.lifesciences.v2beta.ExistingDisk value) {
      if (existingDiskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storage_ = value;
        onChanged();
      } else {
        existingDiskBuilder_.setMessage(value);
      }
      storageCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     */
    public Builder setExistingDisk(
        com.google.cloud.lifesciences.v2beta.ExistingDisk.Builder builderForValue) {
      if (existingDiskBuilder_ == null) {
        storage_ = builderForValue.build();
        onChanged();
      } else {
        existingDiskBuilder_.setMessage(builderForValue.build());
      }
      storageCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     */
    public Builder mergeExistingDisk(com.google.cloud.lifesciences.v2beta.ExistingDisk value) {
      if (existingDiskBuilder_ == null) {
        if (storageCase_ == 3
            && storage_ != com.google.cloud.lifesciences.v2beta.ExistingDisk.getDefaultInstance()) {
          storage_ =
              com.google.cloud.lifesciences.v2beta.ExistingDisk.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.ExistingDisk) storage_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storage_ = value;
        }
        onChanged();
      } else {
        if (storageCase_ == 3) {
          existingDiskBuilder_.mergeFrom(value);
        } else {
          existingDiskBuilder_.setMessage(value);
        }
      }
      storageCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     */
    public Builder clearExistingDisk() {
      if (existingDiskBuilder_ == null) {
        if (storageCase_ == 3) {
          storageCase_ = 0;
          storage_ = null;
          onChanged();
        }
      } else {
        if (storageCase_ == 3) {
          storageCase_ = 0;
          storage_ = null;
        }
        existingDiskBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     */
    public com.google.cloud.lifesciences.v2beta.ExistingDisk.Builder getExistingDiskBuilder() {
      return getExistingDiskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ExistingDiskOrBuilder getExistingDiskOrBuilder() {
      if ((storageCase_ == 3) && (existingDiskBuilder_ != null)) {
        return existingDiskBuilder_.getMessageOrBuilder();
      } else {
        if (storageCase_ == 3) {
          return (com.google.cloud.lifesciences.v2beta.ExistingDisk) storage_;
        }
        return com.google.cloud.lifesciences.v2beta.ExistingDisk.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a existing disk.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ExistingDisk existing_disk = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ExistingDisk,
            com.google.cloud.lifesciences.v2beta.ExistingDisk.Builder,
            com.google.cloud.lifesciences.v2beta.ExistingDiskOrBuilder>
        getExistingDiskFieldBuilder() {
      if (existingDiskBuilder_ == null) {
        if (!(storageCase_ == 3)) {
          storage_ = com.google.cloud.lifesciences.v2beta.ExistingDisk.getDefaultInstance();
        }
        existingDiskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.ExistingDisk,
                com.google.cloud.lifesciences.v2beta.ExistingDisk.Builder,
                com.google.cloud.lifesciences.v2beta.ExistingDiskOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.ExistingDisk) storage_,
                getParentForChildren(),
                isClean());
        storage_ = null;
      }
      storageCase_ = 3;
      onChanged();
      ;
      return existingDiskBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.NFSMount,
            com.google.cloud.lifesciences.v2beta.NFSMount.Builder,
            com.google.cloud.lifesciences.v2beta.NFSMountOrBuilder>
        nfsMountBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     *
     * @return Whether the nfsMount field is set.
     */
    @java.lang.Override
    public boolean hasNfsMount() {
      return storageCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     *
     * @return The nfsMount.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.NFSMount getNfsMount() {
      if (nfsMountBuilder_ == null) {
        if (storageCase_ == 4) {
          return (com.google.cloud.lifesciences.v2beta.NFSMount) storage_;
        }
        return com.google.cloud.lifesciences.v2beta.NFSMount.getDefaultInstance();
      } else {
        if (storageCase_ == 4) {
          return nfsMountBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.NFSMount.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     */
    public Builder setNfsMount(com.google.cloud.lifesciences.v2beta.NFSMount value) {
      if (nfsMountBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storage_ = value;
        onChanged();
      } else {
        nfsMountBuilder_.setMessage(value);
      }
      storageCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     */
    public Builder setNfsMount(
        com.google.cloud.lifesciences.v2beta.NFSMount.Builder builderForValue) {
      if (nfsMountBuilder_ == null) {
        storage_ = builderForValue.build();
        onChanged();
      } else {
        nfsMountBuilder_.setMessage(builderForValue.build());
      }
      storageCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     */
    public Builder mergeNfsMount(com.google.cloud.lifesciences.v2beta.NFSMount value) {
      if (nfsMountBuilder_ == null) {
        if (storageCase_ == 4
            && storage_ != com.google.cloud.lifesciences.v2beta.NFSMount.getDefaultInstance()) {
          storage_ =
              com.google.cloud.lifesciences.v2beta.NFSMount.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.NFSMount) storage_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storage_ = value;
        }
        onChanged();
      } else {
        if (storageCase_ == 4) {
          nfsMountBuilder_.mergeFrom(value);
        } else {
          nfsMountBuilder_.setMessage(value);
        }
      }
      storageCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     */
    public Builder clearNfsMount() {
      if (nfsMountBuilder_ == null) {
        if (storageCase_ == 4) {
          storageCase_ = 0;
          storage_ = null;
          onChanged();
        }
      } else {
        if (storageCase_ == 4) {
          storageCase_ = 0;
          storage_ = null;
        }
        nfsMountBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     */
    public com.google.cloud.lifesciences.v2beta.NFSMount.Builder getNfsMountBuilder() {
      return getNfsMountFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.NFSMountOrBuilder getNfsMountOrBuilder() {
      if ((storageCase_ == 4) && (nfsMountBuilder_ != null)) {
        return nfsMountBuilder_.getMessageOrBuilder();
      } else {
        if (storageCase_ == 4) {
          return (com.google.cloud.lifesciences.v2beta.NFSMount) storage_;
        }
        return com.google.cloud.lifesciences.v2beta.NFSMount.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for an NFS mount.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.NFSMount nfs_mount = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.NFSMount,
            com.google.cloud.lifesciences.v2beta.NFSMount.Builder,
            com.google.cloud.lifesciences.v2beta.NFSMountOrBuilder>
        getNfsMountFieldBuilder() {
      if (nfsMountBuilder_ == null) {
        if (!(storageCase_ == 4)) {
          storage_ = com.google.cloud.lifesciences.v2beta.NFSMount.getDefaultInstance();
        }
        nfsMountBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.NFSMount,
                com.google.cloud.lifesciences.v2beta.NFSMount.Builder,
                com.google.cloud.lifesciences.v2beta.NFSMountOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.NFSMount) storage_,
                getParentForChildren(),
                isClean());
        storage_ = null;
      }
      storageCase_ = 4;
      onChanged();
      ;
      return nfsMountBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.Volume)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.Volume)
  private static final com.google.cloud.lifesciences.v2beta.Volume DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.Volume();
  }

  public static com.google.cloud.lifesciences.v2beta.Volume getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Volume> PARSER =
      new com.google.protobuf.AbstractParser<Volume>() {
        @java.lang.Override
        public Volume parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Volume> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Volume> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Volume getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
