/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * Carries information about a Compute Engine VM resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.VirtualMachine}
 */
public final class VirtualMachine extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.VirtualMachine)
    VirtualMachineOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VirtualMachine.newBuilder() to construct.
  private VirtualMachine(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VirtualMachine() {
    machineType_ = "";
    disks_ = java.util.Collections.emptyList();
    accelerators_ = java.util.Collections.emptyList();
    cpuPlatform_ = "";
    bootImage_ = "";
    nvidiaDriverVersion_ = "";
    dockerCacheImages_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    volumes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VirtualMachine();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_VirtualMachine_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_VirtualMachine_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.VirtualMachine.class,
            com.google.cloud.lifesciences.v2beta.VirtualMachine.Builder.class);
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object machineType_;
  /**
   *
   *
   * <pre>
   * Required. The machine type of the virtual machine to create. Must be the short name
   * of a standard machine type (such as "n1-standard-1") or a custom machine
   * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
   * "4096" indicates the memory in MB). See
   * [Creating an instance with a custom machine
   * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
   * for more specifications on creating a custom machine type.
   * </pre>
   *
   * <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The machine type of the virtual machine to create. Must be the short name
   * of a standard machine type (such as "n1-standard-1") or a custom machine
   * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
   * "4096" indicates the memory in MB). See
   * [Creating an instance with a custom machine
   * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
   * for more specifications on creating a custom machine type.
   * </pre>
   *
   * <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREEMPTIBLE_FIELD_NUMBER = 2;
  private boolean preemptible_;
  /**
   *
   *
   * <pre>
   * If true, allocate a preemptible VM.
   * </pre>
   *
   * <code>bool preemptible = 2;</code>
   *
   * @return The preemptible.
   */
  @java.lang.Override
  public boolean getPreemptible() {
    return preemptible_;
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.lifesciences.v2beta.WorkflowsProto
                .internal_static_google_cloud_lifesciences_v2beta_VirtualMachine_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional set of labels to apply to the VM and any attached disk resources.
   * These labels must adhere to the [name and value
   * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
   * VM labels imposed by Compute Engine.
   * Labels keys with the prefix 'google-' are reserved for use by Google.
   * Labels applied at creation time to the VM. Applied on a best-effort basis
   * to attached disk resources shortly after VM creation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional set of labels to apply to the VM and any attached disk resources.
   * These labels must adhere to the [name and value
   * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
   * VM labels imposed by Compute Engine.
   * Labels keys with the prefix 'google-' are reserved for use by Google.
   * Labels applied at creation time to the VM. Applied on a best-effort basis
   * to attached disk resources shortly after VM creation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional set of labels to apply to the VM and any attached disk resources.
   * These labels must adhere to the [name and value
   * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
   * VM labels imposed by Compute Engine.
   * Labels keys with the prefix 'google-' are reserved for use by Google.
   * Labels applied at creation time to the VM. Applied on a best-effort basis
   * to attached disk resources shortly after VM creation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional set of labels to apply to the VM and any attached disk resources.
   * These labels must adhere to the [name and value
   * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
   * VM labels imposed by Compute Engine.
   * Labels keys with the prefix 'google-' are reserved for use by Google.
   * Labels applied at creation time to the VM. Applied on a best-effort basis
   * to attached disk resources shortly after VM creation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISKS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.lifesciences.v2beta.Disk> disks_;
  /**
   *
   *
   * <pre>
   * The list of disks to create and attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.lifesciences.v2beta.Disk> getDisksList() {
    return disks_;
  }
  /**
   *
   *
   * <pre>
   * The list of disks to create and attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.lifesciences.v2beta.DiskOrBuilder>
      getDisksOrBuilderList() {
    return disks_;
  }
  /**
   *
   *
   * <pre>
   * The list of disks to create and attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
   */
  @java.lang.Override
  public int getDisksCount() {
    return disks_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of disks to create and attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Disk getDisks(int index) {
    return disks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of disks to create and attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.DiskOrBuilder getDisksOrBuilder(int index) {
    return disks_.get(index);
  }

  public static final int NETWORK_FIELD_NUMBER = 5;
  private com.google.cloud.lifesciences.v2beta.Network network_;
  /**
   *
   *
   * <pre>
   * The VM network configuration.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return network_ != null;
  }
  /**
   *
   *
   * <pre>
   * The VM network configuration.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Network getNetwork() {
    return network_ == null
        ? com.google.cloud.lifesciences.v2beta.Network.getDefaultInstance()
        : network_;
  }
  /**
   *
   *
   * <pre>
   * The VM network configuration.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.NetworkOrBuilder getNetworkOrBuilder() {
    return getNetwork();
  }

  public static final int ACCELERATORS_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.lifesciences.v2beta.Accelerator> accelerators_;
  /**
   *
   *
   * <pre>
   * The list of accelerators to attach to the VM.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.lifesciences.v2beta.Accelerator> getAcceleratorsList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * The list of accelerators to attach to the VM.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.lifesciences.v2beta.AcceleratorOrBuilder>
      getAcceleratorsOrBuilderList() {
    return accelerators_;
  }
  /**
   *
   *
   * <pre>
   * The list of accelerators to attach to the VM.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
   */
  @java.lang.Override
  public int getAcceleratorsCount() {
    return accelerators_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of accelerators to attach to the VM.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Accelerator getAccelerators(int index) {
    return accelerators_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of accelerators to attach to the VM.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.AcceleratorOrBuilder getAcceleratorsOrBuilder(
      int index) {
    return accelerators_.get(index);
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 7;
  private com.google.cloud.lifesciences.v2beta.ServiceAccount serviceAccount_;
  /**
   *
   *
   * <pre>
   * The service account to install on the VM. This account does not need
   * any permissions other than those required by the pipeline.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
   *
   * @return Whether the serviceAccount field is set.
   */
  @java.lang.Override
  public boolean hasServiceAccount() {
    return serviceAccount_ != null;
  }
  /**
   *
   *
   * <pre>
   * The service account to install on the VM. This account does not need
   * any permissions other than those required by the pipeline.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ServiceAccount getServiceAccount() {
    return serviceAccount_ == null
        ? com.google.cloud.lifesciences.v2beta.ServiceAccount.getDefaultInstance()
        : serviceAccount_;
  }
  /**
   *
   *
   * <pre>
   * The service account to install on the VM. This account does not need
   * any permissions other than those required by the pipeline.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ServiceAccountOrBuilder getServiceAccountOrBuilder() {
    return getServiceAccount();
  }

  public static final int BOOT_DISK_SIZE_GB_FIELD_NUMBER = 8;
  private int bootDiskSizeGb_;
  /**
   *
   *
   * <pre>
   * The size of the boot disk, in GB. The boot disk must be large
   * enough to accommodate all of the Docker images from each action in the
   * pipeline at the same time. If not specified, a small but reasonable
   * default value is used.
   * </pre>
   *
   * <code>int32 boot_disk_size_gb = 8;</code>
   *
   * @return The bootDiskSizeGb.
   */
  @java.lang.Override
  public int getBootDiskSizeGb() {
    return bootDiskSizeGb_;
  }

  public static final int CPU_PLATFORM_FIELD_NUMBER = 9;
  private volatile java.lang.Object cpuPlatform_;
  /**
   *
   *
   * <pre>
   * The CPU platform to request. An instance based on a newer platform can be
   * allocated, but never one with fewer capabilities. The value of this
   * parameter must be a valid Compute Engine CPU platform name (such as "Intel
   * Skylake"). This parameter is only useful for carefully optimized work
   * loads where the CPU platform has a significant impact.
   * For more information about the effect of this parameter, see
   * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
   * </pre>
   *
   * <code>string cpu_platform = 9;</code>
   *
   * @return The cpuPlatform.
   */
  @java.lang.Override
  public java.lang.String getCpuPlatform() {
    java.lang.Object ref = cpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cpuPlatform_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The CPU platform to request. An instance based on a newer platform can be
   * allocated, but never one with fewer capabilities. The value of this
   * parameter must be a valid Compute Engine CPU platform name (such as "Intel
   * Skylake"). This parameter is only useful for carefully optimized work
   * loads where the CPU platform has a significant impact.
   * For more information about the effect of this parameter, see
   * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
   * </pre>
   *
   * <code>string cpu_platform = 9;</code>
   *
   * @return The bytes for cpuPlatform.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCpuPlatformBytes() {
    java.lang.Object ref = cpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BOOT_IMAGE_FIELD_NUMBER = 10;
  private volatile java.lang.Object bootImage_;
  /**
   *
   *
   * <pre>
   * The host operating system image to use.
   * Currently, only Container-Optimized OS images can be used.
   * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
   * which selects the latest stable release of Container-Optimized OS.
   * This option is provided to allow testing against the beta release of the
   * operating system to ensure that the new version does not interact
   * negatively with production pipelines.
   * To test a pipeline against the beta release of Container-Optimized OS,
   * use the value `projects/cos-cloud/global/images/family/cos-beta`.
   * </pre>
   *
   * <code>string boot_image = 10;</code>
   *
   * @return The bootImage.
   */
  @java.lang.Override
  public java.lang.String getBootImage() {
    java.lang.Object ref = bootImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bootImage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The host operating system image to use.
   * Currently, only Container-Optimized OS images can be used.
   * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
   * which selects the latest stable release of Container-Optimized OS.
   * This option is provided to allow testing against the beta release of the
   * operating system to ensure that the new version does not interact
   * negatively with production pipelines.
   * To test a pipeline against the beta release of Container-Optimized OS,
   * use the value `projects/cos-cloud/global/images/family/cos-beta`.
   * </pre>
   *
   * <code>string boot_image = 10;</code>
   *
   * @return The bytes for bootImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBootImageBytes() {
    java.lang.Object ref = bootImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bootImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NVIDIA_DRIVER_VERSION_FIELD_NUMBER = 11;
  private volatile java.lang.Object nvidiaDriverVersion_;
  /**
   *
   *
   * <pre>
   * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
   * The version specified here must be compatible with the GPU libraries
   * contained in the container being executed, and must be one of the drivers
   * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
   * </pre>
   *
   * <code>string nvidia_driver_version = 11 [deprecated = true];</code>
   *
   * @deprecated google.cloud.lifesciences.v2beta.VirtualMachine.nvidia_driver_version is
   *     deprecated. See google/cloud/lifesciences/v2beta/workflows.proto;l=390
   * @return The nvidiaDriverVersion.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getNvidiaDriverVersion() {
    java.lang.Object ref = nvidiaDriverVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nvidiaDriverVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
   * The version specified here must be compatible with the GPU libraries
   * contained in the container being executed, and must be one of the drivers
   * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
   * </pre>
   *
   * <code>string nvidia_driver_version = 11 [deprecated = true];</code>
   *
   * @deprecated google.cloud.lifesciences.v2beta.VirtualMachine.nvidia_driver_version is
   *     deprecated. See google/cloud/lifesciences/v2beta/workflows.proto;l=390
   * @return The bytes for nvidiaDriverVersion.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getNvidiaDriverVersionBytes() {
    java.lang.Object ref = nvidiaDriverVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nvidiaDriverVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_STACKDRIVER_MONITORING_FIELD_NUMBER = 12;
  private boolean enableStackdriverMonitoring_;
  /**
   *
   *
   * <pre>
   * Whether Stackdriver monitoring should be enabled on the VM.
   * </pre>
   *
   * <code>bool enable_stackdriver_monitoring = 12;</code>
   *
   * @return The enableStackdriverMonitoring.
   */
  @java.lang.Override
  public boolean getEnableStackdriverMonitoring() {
    return enableStackdriverMonitoring_;
  }

  public static final int DOCKER_CACHE_IMAGES_FIELD_NUMBER = 13;
  private com.google.protobuf.LazyStringList dockerCacheImages_;
  /**
   *
   *
   * <pre>
   * The Compute Engine Disk Images to use as a Docker cache. The disks will be
   * mounted into the Docker folder in a way that the images present in the
   * cache will not need to be pulled. The digests of the cached images must
   * match those of the tags used or the latest version will still be pulled.
   * The root directory of the ext4 image must contain `image` and `overlay2`
   * directories copied from the Docker directory of a VM where the desired
   * Docker images have already been pulled. Any images pulled that are not
   * cached will be stored on the first cache disk instead of the boot disk.
   * Only a single image is supported.
   * </pre>
   *
   * <code>repeated string docker_cache_images = 13;</code>
   *
   * @return A list containing the dockerCacheImages.
   */
  public com.google.protobuf.ProtocolStringList getDockerCacheImagesList() {
    return dockerCacheImages_;
  }
  /**
   *
   *
   * <pre>
   * The Compute Engine Disk Images to use as a Docker cache. The disks will be
   * mounted into the Docker folder in a way that the images present in the
   * cache will not need to be pulled. The digests of the cached images must
   * match those of the tags used or the latest version will still be pulled.
   * The root directory of the ext4 image must contain `image` and `overlay2`
   * directories copied from the Docker directory of a VM where the desired
   * Docker images have already been pulled. Any images pulled that are not
   * cached will be stored on the first cache disk instead of the boot disk.
   * Only a single image is supported.
   * </pre>
   *
   * <code>repeated string docker_cache_images = 13;</code>
   *
   * @return The count of dockerCacheImages.
   */
  public int getDockerCacheImagesCount() {
    return dockerCacheImages_.size();
  }
  /**
   *
   *
   * <pre>
   * The Compute Engine Disk Images to use as a Docker cache. The disks will be
   * mounted into the Docker folder in a way that the images present in the
   * cache will not need to be pulled. The digests of the cached images must
   * match those of the tags used or the latest version will still be pulled.
   * The root directory of the ext4 image must contain `image` and `overlay2`
   * directories copied from the Docker directory of a VM where the desired
   * Docker images have already been pulled. Any images pulled that are not
   * cached will be stored on the first cache disk instead of the boot disk.
   * Only a single image is supported.
   * </pre>
   *
   * <code>repeated string docker_cache_images = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The dockerCacheImages at the given index.
   */
  public java.lang.String getDockerCacheImages(int index) {
    return dockerCacheImages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Compute Engine Disk Images to use as a Docker cache. The disks will be
   * mounted into the Docker folder in a way that the images present in the
   * cache will not need to be pulled. The digests of the cached images must
   * match those of the tags used or the latest version will still be pulled.
   * The root directory of the ext4 image must contain `image` and `overlay2`
   * directories copied from the Docker directory of a VM where the desired
   * Docker images have already been pulled. Any images pulled that are not
   * cached will be stored on the first cache disk instead of the boot disk.
   * Only a single image is supported.
   * </pre>
   *
   * <code>repeated string docker_cache_images = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dockerCacheImages at the given index.
   */
  public com.google.protobuf.ByteString getDockerCacheImagesBytes(int index) {
    return dockerCacheImages_.getByteString(index);
  }

  public static final int VOLUMES_FIELD_NUMBER = 14;
  private java.util.List<com.google.cloud.lifesciences.v2beta.Volume> volumes_;
  /**
   *
   *
   * <pre>
   * The list of disks and other storage to create or attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.lifesciences.v2beta.Volume> getVolumesList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * The list of disks and other storage to create or attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.lifesciences.v2beta.VolumeOrBuilder>
      getVolumesOrBuilderList() {
    return volumes_;
  }
  /**
   *
   *
   * <pre>
   * The list of disks and other storage to create or attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public int getVolumesCount() {
    return volumes_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of disks and other storage to create or attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Volume getVolumes(int index) {
    return volumes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of disks and other storage to create or attach to the VM.
   * Specify either the `volumes[]` field or the `disks[]` field, but not both.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.VolumeOrBuilder getVolumesOrBuilder(int index) {
    return volumes_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
    }
    if (preemptible_ != false) {
      output.writeBool(2, preemptible_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    for (int i = 0; i < disks_.size(); i++) {
      output.writeMessage(4, disks_.get(i));
    }
    if (network_ != null) {
      output.writeMessage(5, getNetwork());
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      output.writeMessage(6, accelerators_.get(i));
    }
    if (serviceAccount_ != null) {
      output.writeMessage(7, getServiceAccount());
    }
    if (bootDiskSizeGb_ != 0) {
      output.writeInt32(8, bootDiskSizeGb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuPlatform_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, cpuPlatform_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootImage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, bootImage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nvidiaDriverVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, nvidiaDriverVersion_);
    }
    if (enableStackdriverMonitoring_ != false) {
      output.writeBool(12, enableStackdriverMonitoring_);
    }
    for (int i = 0; i < dockerCacheImages_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, dockerCacheImages_.getRaw(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      output.writeMessage(14, volumes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
    }
    if (preemptible_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, preemptible_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    for (int i = 0; i < disks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, disks_.get(i));
    }
    if (network_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getNetwork());
    }
    for (int i = 0; i < accelerators_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, accelerators_.get(i));
    }
    if (serviceAccount_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getServiceAccount());
    }
    if (bootDiskSizeGb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, bootDiskSizeGb_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cpuPlatform_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, cpuPlatform_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootImage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, bootImage_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nvidiaDriverVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, nvidiaDriverVersion_);
    }
    if (enableStackdriverMonitoring_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(12, enableStackdriverMonitoring_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < dockerCacheImages_.size(); i++) {
        dataSize += computeStringSizeNoTag(dockerCacheImages_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDockerCacheImagesList().size();
    }
    for (int i = 0; i < volumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, volumes_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.VirtualMachine)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.VirtualMachine other =
        (com.google.cloud.lifesciences.v2beta.VirtualMachine) obj;

    if (!getMachineType().equals(other.getMachineType())) return false;
    if (getPreemptible() != other.getPreemptible()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDisksList().equals(other.getDisksList())) return false;
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
    if (hasServiceAccount() != other.hasServiceAccount()) return false;
    if (hasServiceAccount()) {
      if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    }
    if (getBootDiskSizeGb() != other.getBootDiskSizeGb()) return false;
    if (!getCpuPlatform().equals(other.getCpuPlatform())) return false;
    if (!getBootImage().equals(other.getBootImage())) return false;
    if (!getNvidiaDriverVersion().equals(other.getNvidiaDriverVersion())) return false;
    if (getEnableStackdriverMonitoring() != other.getEnableStackdriverMonitoring()) return false;
    if (!getDockerCacheImagesList().equals(other.getDockerCacheImagesList())) return false;
    if (!getVolumesList().equals(other.getVolumesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    hash = (37 * hash) + PREEMPTIBLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPreemptible());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getDisksCount() > 0) {
      hash = (37 * hash) + DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getDisksList().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (getAcceleratorsCount() > 0) {
      hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getAcceleratorsList().hashCode();
    }
    if (hasServiceAccount()) {
      hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccount().hashCode();
    }
    hash = (37 * hash) + BOOT_DISK_SIZE_GB_FIELD_NUMBER;
    hash = (53 * hash) + getBootDiskSizeGb();
    hash = (37 * hash) + CPU_PLATFORM_FIELD_NUMBER;
    hash = (53 * hash) + getCpuPlatform().hashCode();
    hash = (37 * hash) + BOOT_IMAGE_FIELD_NUMBER;
    hash = (53 * hash) + getBootImage().hashCode();
    hash = (37 * hash) + NVIDIA_DRIVER_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getNvidiaDriverVersion().hashCode();
    hash = (37 * hash) + ENABLE_STACKDRIVER_MONITORING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableStackdriverMonitoring());
    if (getDockerCacheImagesCount() > 0) {
      hash = (37 * hash) + DOCKER_CACHE_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getDockerCacheImagesList().hashCode();
    }
    if (getVolumesCount() > 0) {
      hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getVolumesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.lifesciences.v2beta.VirtualMachine prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Carries information about a Compute Engine VM resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.VirtualMachine}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.VirtualMachine)
      com.google.cloud.lifesciences.v2beta.VirtualMachineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_VirtualMachine_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_VirtualMachine_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.VirtualMachine.class,
              com.google.cloud.lifesciences.v2beta.VirtualMachine.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.VirtualMachine.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      machineType_ = "";

      preemptible_ = false;

      internalGetMutableLabels().clear();
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
      } else {
        disks_ = null;
        disksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (networkBuilder_ == null) {
        network_ = null;
      } else {
        network_ = null;
        networkBuilder_ = null;
      }
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
      } else {
        accelerators_ = null;
        acceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (serviceAccountBuilder_ == null) {
        serviceAccount_ = null;
      } else {
        serviceAccount_ = null;
        serviceAccountBuilder_ = null;
      }
      bootDiskSizeGb_ = 0;

      cpuPlatform_ = "";

      bootImage_ = "";

      nvidiaDriverVersion_ = "";

      enableStackdriverMonitoring_ = false;

      dockerCacheImages_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
      } else {
        volumes_ = null;
        volumesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_VirtualMachine_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.VirtualMachine getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.VirtualMachine.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.VirtualMachine build() {
      com.google.cloud.lifesciences.v2beta.VirtualMachine result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.VirtualMachine buildPartial() {
      com.google.cloud.lifesciences.v2beta.VirtualMachine result =
          new com.google.cloud.lifesciences.v2beta.VirtualMachine(this);
      int from_bitField0_ = bitField0_;
      result.machineType_ = machineType_;
      result.preemptible_ = preemptible_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (disksBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          disks_ = java.util.Collections.unmodifiableList(disks_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.disks_ = disks_;
      } else {
        result.disks_ = disksBuilder_.build();
      }
      if (networkBuilder_ == null) {
        result.network_ = network_;
      } else {
        result.network_ = networkBuilder_.build();
      }
      if (acceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.accelerators_ = accelerators_;
      } else {
        result.accelerators_ = acceleratorsBuilder_.build();
      }
      if (serviceAccountBuilder_ == null) {
        result.serviceAccount_ = serviceAccount_;
      } else {
        result.serviceAccount_ = serviceAccountBuilder_.build();
      }
      result.bootDiskSizeGb_ = bootDiskSizeGb_;
      result.cpuPlatform_ = cpuPlatform_;
      result.bootImage_ = bootImage_;
      result.nvidiaDriverVersion_ = nvidiaDriverVersion_;
      result.enableStackdriverMonitoring_ = enableStackdriverMonitoring_;
      if (((bitField0_ & 0x00000008) != 0)) {
        dockerCacheImages_ = dockerCacheImages_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.dockerCacheImages_ = dockerCacheImages_;
      if (volumesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          volumes_ = java.util.Collections.unmodifiableList(volumes_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.volumes_ = volumes_;
      } else {
        result.volumes_ = volumesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.VirtualMachine) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.VirtualMachine) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.VirtualMachine other) {
      if (other == com.google.cloud.lifesciences.v2beta.VirtualMachine.getDefaultInstance())
        return this;
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        onChanged();
      }
      if (other.getPreemptible() != false) {
        setPreemptible(other.getPreemptible());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (disksBuilder_ == null) {
        if (!other.disks_.isEmpty()) {
          if (disks_.isEmpty()) {
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDisksIsMutable();
            disks_.addAll(other.disks_);
          }
          onChanged();
        }
      } else {
        if (!other.disks_.isEmpty()) {
          if (disksBuilder_.isEmpty()) {
            disksBuilder_.dispose();
            disksBuilder_ = null;
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000002);
            disksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDisksFieldBuilder()
                    : null;
          } else {
            disksBuilder_.addAllMessages(other.disks_);
          }
        }
      }
      if (other.hasNetwork()) {
        mergeNetwork(other.getNetwork());
      }
      if (acceleratorsBuilder_ == null) {
        if (!other.accelerators_.isEmpty()) {
          if (accelerators_.isEmpty()) {
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAcceleratorsIsMutable();
            accelerators_.addAll(other.accelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.accelerators_.isEmpty()) {
          if (acceleratorsBuilder_.isEmpty()) {
            acceleratorsBuilder_.dispose();
            acceleratorsBuilder_ = null;
            accelerators_ = other.accelerators_;
            bitField0_ = (bitField0_ & ~0x00000004);
            acceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAcceleratorsFieldBuilder()
                    : null;
          } else {
            acceleratorsBuilder_.addAllMessages(other.accelerators_);
          }
        }
      }
      if (other.hasServiceAccount()) {
        mergeServiceAccount(other.getServiceAccount());
      }
      if (other.getBootDiskSizeGb() != 0) {
        setBootDiskSizeGb(other.getBootDiskSizeGb());
      }
      if (!other.getCpuPlatform().isEmpty()) {
        cpuPlatform_ = other.cpuPlatform_;
        onChanged();
      }
      if (!other.getBootImage().isEmpty()) {
        bootImage_ = other.bootImage_;
        onChanged();
      }
      if (!other.getNvidiaDriverVersion().isEmpty()) {
        nvidiaDriverVersion_ = other.nvidiaDriverVersion_;
        onChanged();
      }
      if (other.getEnableStackdriverMonitoring() != false) {
        setEnableStackdriverMonitoring(other.getEnableStackdriverMonitoring());
      }
      if (!other.dockerCacheImages_.isEmpty()) {
        if (dockerCacheImages_.isEmpty()) {
          dockerCacheImages_ = other.dockerCacheImages_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureDockerCacheImagesIsMutable();
          dockerCacheImages_.addAll(other.dockerCacheImages_);
        }
        onChanged();
      }
      if (volumesBuilder_ == null) {
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
      } else {
        if (!other.volumes_.isEmpty()) {
          if (volumesBuilder_.isEmpty()) {
            volumesBuilder_.dispose();
            volumesBuilder_ = null;
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000010);
            volumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumesFieldBuilder()
                    : null;
          } else {
            volumesBuilder_.addAllMessages(other.volumes_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                machineType_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                preemptible_ = input.readBool();

                break;
              } // case 16
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.lifesciences.v2beta.Disk m =
                    input.readMessage(
                        com.google.cloud.lifesciences.v2beta.Disk.parser(), extensionRegistry);
                if (disksBuilder_ == null) {
                  ensureDisksIsMutable();
                  disks_.add(m);
                } else {
                  disksBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getNetworkFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                com.google.cloud.lifesciences.v2beta.Accelerator m =
                    input.readMessage(
                        com.google.cloud.lifesciences.v2beta.Accelerator.parser(),
                        extensionRegistry);
                if (acceleratorsBuilder_ == null) {
                  ensureAcceleratorsIsMutable();
                  accelerators_.add(m);
                } else {
                  acceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getServiceAccountFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 64:
              {
                bootDiskSizeGb_ = input.readInt32();

                break;
              } // case 64
            case 74:
              {
                cpuPlatform_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 82:
              {
                bootImage_ = input.readStringRequireUtf8();

                break;
              } // case 82
            case 90:
              {
                nvidiaDriverVersion_ = input.readStringRequireUtf8();

                break;
              } // case 90
            case 96:
              {
                enableStackdriverMonitoring_ = input.readBool();

                break;
              } // case 96
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDockerCacheImagesIsMutable();
                dockerCacheImages_.add(s);
                break;
              } // case 106
            case 114:
              {
                com.google.cloud.lifesciences.v2beta.Volume m =
                    input.readMessage(
                        com.google.cloud.lifesciences.v2beta.Volume.parser(), extensionRegistry);
                if (volumesBuilder_ == null) {
                  ensureVolumesIsMutable();
                  volumes_.add(m);
                } else {
                  volumesBuilder_.addMessage(m);
                }
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The machine type of the virtual machine to create. Must be the short name
     * of a standard machine type (such as "n1-standard-1") or a custom machine
     * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     * "4096" indicates the memory in MB). See
     * [Creating an instance with a custom machine
     * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     * for more specifications on creating a custom machine type.
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The machine type of the virtual machine to create. Must be the short name
     * of a standard machine type (such as "n1-standard-1") or a custom machine
     * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     * "4096" indicates the memory in MB). See
     * [Creating an instance with a custom machine
     * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     * for more specifications on creating a custom machine type.
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The machine type of the virtual machine to create. Must be the short name
     * of a standard machine type (such as "n1-standard-1") or a custom machine
     * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     * "4096" indicates the memory in MB). See
     * [Creating an instance with a custom machine
     * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     * for more specifications on creating a custom machine type.
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      machineType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The machine type of the virtual machine to create. Must be the short name
     * of a standard machine type (such as "n1-standard-1") or a custom machine
     * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     * "4096" indicates the memory in MB). See
     * [Creating an instance with a custom machine
     * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     * for more specifications on creating a custom machine type.
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {

      machineType_ = getDefaultInstance().getMachineType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The machine type of the virtual machine to create. Must be the short name
     * of a standard machine type (such as "n1-standard-1") or a custom machine
     * type (such as "custom-1-4096", where "1" indicates the number of vCPUs and
     * "4096" indicates the memory in MB). See
     * [Creating an instance with a custom machine
     * type](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create)
     * for more specifications on creating a custom machine type.
     * </pre>
     *
     * <code>string machine_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      machineType_ = value;
      onChanged();
      return this;
    }

    private boolean preemptible_;
    /**
     *
     *
     * <pre>
     * If true, allocate a preemptible VM.
     * </pre>
     *
     * <code>bool preemptible = 2;</code>
     *
     * @return The preemptible.
     */
    @java.lang.Override
    public boolean getPreemptible() {
      return preemptible_;
    }
    /**
     *
     *
     * <pre>
     * If true, allocate a preemptible VM.
     * </pre>
     *
     * <code>bool preemptible = 2;</code>
     *
     * @param value The preemptible to set.
     * @return This builder for chaining.
     */
    public Builder setPreemptible(boolean value) {

      preemptible_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, allocate a preemptible VM.
     * </pre>
     *
     * <code>bool preemptible = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreemptible() {

      preemptible_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional set of labels to apply to the VM and any attached disk resources.
     * These labels must adhere to the [name and value
     * restrictions](https://cloud.google.com/compute/docs/labeling-resources) on
     * VM labels imposed by Compute Engine.
     * Labels keys with the prefix 'google-' are reserved for use by Google.
     * Labels applied at creation time to the VM. Applied on a best-effort basis
     * to attached disk resources shortly after VM creation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.util.List<com.google.cloud.lifesciences.v2beta.Disk> disks_ =
        java.util.Collections.emptyList();

    private void ensureDisksIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        disks_ = new java.util.ArrayList<com.google.cloud.lifesciences.v2beta.Disk>(disks_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Disk,
            com.google.cloud.lifesciences.v2beta.Disk.Builder,
            com.google.cloud.lifesciences.v2beta.DiskOrBuilder>
        disksBuilder_;

    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Disk> getDisksList() {
      if (disksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(disks_);
      } else {
        return disksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public int getDisksCount() {
      if (disksBuilder_ == null) {
        return disks_.size();
      } else {
        return disksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Disk getDisks(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder setDisks(int index, com.google.cloud.lifesciences.v2beta.Disk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.set(index, value);
        onChanged();
      } else {
        disksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder setDisks(
        int index, com.google.cloud.lifesciences.v2beta.Disk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.set(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder addDisks(com.google.cloud.lifesciences.v2beta.Disk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(value);
        onChanged();
      } else {
        disksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder addDisks(int index, com.google.cloud.lifesciences.v2beta.Disk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(index, value);
        onChanged();
      } else {
        disksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder addDisks(com.google.cloud.lifesciences.v2beta.Disk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder addDisks(
        int index, com.google.cloud.lifesciences.v2beta.Disk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder addAllDisks(
        java.lang.Iterable<? extends com.google.cloud.lifesciences.v2beta.Disk> values) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, disks_);
        onChanged();
      } else {
        disksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder clearDisks() {
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        disksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public Builder removeDisks(int index) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.remove(index);
        onChanged();
      } else {
        disksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Disk.Builder getDisksBuilder(int index) {
      return getDisksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public com.google.cloud.lifesciences.v2beta.DiskOrBuilder getDisksOrBuilder(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.lifesciences.v2beta.DiskOrBuilder>
        getDisksOrBuilderList() {
      if (disksBuilder_ != null) {
        return disksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(disks_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Disk.Builder addDisksBuilder() {
      return getDisksFieldBuilder()
          .addBuilder(com.google.cloud.lifesciences.v2beta.Disk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Disk.Builder addDisksBuilder(int index) {
      return getDisksFieldBuilder()
          .addBuilder(index, com.google.cloud.lifesciences.v2beta.Disk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of disks to create and attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Disk disks = 4;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Disk.Builder> getDisksBuilderList() {
      return getDisksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Disk,
            com.google.cloud.lifesciences.v2beta.Disk.Builder,
            com.google.cloud.lifesciences.v2beta.DiskOrBuilder>
        getDisksFieldBuilder() {
      if (disksBuilder_ == null) {
        disksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Disk,
                com.google.cloud.lifesciences.v2beta.Disk.Builder,
                com.google.cloud.lifesciences.v2beta.DiskOrBuilder>(
                disks_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        disks_ = null;
      }
      return disksBuilder_;
    }

    private com.google.cloud.lifesciences.v2beta.Network network_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Network,
            com.google.cloud.lifesciences.v2beta.Network.Builder,
            com.google.cloud.lifesciences.v2beta.NetworkOrBuilder>
        networkBuilder_;
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return networkBuilder_ != null || network_ != null;
    }
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     *
     * @return The network.
     */
    public com.google.cloud.lifesciences.v2beta.Network getNetwork() {
      if (networkBuilder_ == null) {
        return network_ == null
            ? com.google.cloud.lifesciences.v2beta.Network.getDefaultInstance()
            : network_;
      } else {
        return networkBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     */
    public Builder setNetwork(com.google.cloud.lifesciences.v2beta.Network value) {
      if (networkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        network_ = value;
        onChanged();
      } else {
        networkBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     */
    public Builder setNetwork(
        com.google.cloud.lifesciences.v2beta.Network.Builder builderForValue) {
      if (networkBuilder_ == null) {
        network_ = builderForValue.build();
        onChanged();
      } else {
        networkBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     */
    public Builder mergeNetwork(com.google.cloud.lifesciences.v2beta.Network value) {
      if (networkBuilder_ == null) {
        if (network_ != null) {
          network_ =
              com.google.cloud.lifesciences.v2beta.Network.newBuilder(network_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          network_ = value;
        }
        onChanged();
      } else {
        networkBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     */
    public Builder clearNetwork() {
      if (networkBuilder_ == null) {
        network_ = null;
        onChanged();
      } else {
        network_ = null;
        networkBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Network.Builder getNetworkBuilder() {

      onChanged();
      return getNetworkFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     */
    public com.google.cloud.lifesciences.v2beta.NetworkOrBuilder getNetworkOrBuilder() {
      if (networkBuilder_ != null) {
        return networkBuilder_.getMessageOrBuilder();
      } else {
        return network_ == null
            ? com.google.cloud.lifesciences.v2beta.Network.getDefaultInstance()
            : network_;
      }
    }
    /**
     *
     *
     * <pre>
     * The VM network configuration.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Network network = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Network,
            com.google.cloud.lifesciences.v2beta.Network.Builder,
            com.google.cloud.lifesciences.v2beta.NetworkOrBuilder>
        getNetworkFieldBuilder() {
      if (networkBuilder_ == null) {
        networkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Network,
                com.google.cloud.lifesciences.v2beta.Network.Builder,
                com.google.cloud.lifesciences.v2beta.NetworkOrBuilder>(
                getNetwork(), getParentForChildren(), isClean());
        network_ = null;
      }
      return networkBuilder_;
    }

    private java.util.List<com.google.cloud.lifesciences.v2beta.Accelerator> accelerators_ =
        java.util.Collections.emptyList();

    private void ensureAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        accelerators_ =
            new java.util.ArrayList<com.google.cloud.lifesciences.v2beta.Accelerator>(
                accelerators_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Accelerator,
            com.google.cloud.lifesciences.v2beta.Accelerator.Builder,
            com.google.cloud.lifesciences.v2beta.AcceleratorOrBuilder>
        acceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Accelerator> getAcceleratorsList() {
      if (acceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(accelerators_);
      } else {
        return acceleratorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public int getAcceleratorsCount() {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.size();
      } else {
        return acceleratorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Accelerator getAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder setAccelerators(
        int index, com.google.cloud.lifesciences.v2beta.Accelerator value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder setAccelerators(
        int index, com.google.cloud.lifesciences.v2beta.Accelerator.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder addAccelerators(com.google.cloud.lifesciences.v2beta.Accelerator value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder addAccelerators(
        int index, com.google.cloud.lifesciences.v2beta.Accelerator value) {
      if (acceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, value);
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder addAccelerators(
        com.google.cloud.lifesciences.v2beta.Accelerator.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder addAccelerators(
        int index, com.google.cloud.lifesciences.v2beta.Accelerator.Builder builderForValue) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        acceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder addAllAccelerators(
        java.lang.Iterable<? extends com.google.cloud.lifesciences.v2beta.Accelerator> values) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
        onChanged();
      } else {
        acceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder clearAccelerators() {
      if (acceleratorsBuilder_ == null) {
        accelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        acceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public Builder removeAccelerators(int index) {
      if (acceleratorsBuilder_ == null) {
        ensureAcceleratorsIsMutable();
        accelerators_.remove(index);
        onChanged();
      } else {
        acceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Accelerator.Builder getAcceleratorsBuilder(
        int index) {
      return getAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public com.google.cloud.lifesciences.v2beta.AcceleratorOrBuilder getAcceleratorsOrBuilder(
        int index) {
      if (acceleratorsBuilder_ == null) {
        return accelerators_.get(index);
      } else {
        return acceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.lifesciences.v2beta.AcceleratorOrBuilder>
        getAcceleratorsOrBuilderList() {
      if (acceleratorsBuilder_ != null) {
        return acceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(accelerators_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Accelerator.Builder addAcceleratorsBuilder() {
      return getAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.lifesciences.v2beta.Accelerator.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Accelerator.Builder addAcceleratorsBuilder(
        int index) {
      return getAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.lifesciences.v2beta.Accelerator.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of accelerators to attach to the VM.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Accelerator accelerators = 6;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Accelerator.Builder>
        getAcceleratorsBuilderList() {
      return getAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Accelerator,
            com.google.cloud.lifesciences.v2beta.Accelerator.Builder,
            com.google.cloud.lifesciences.v2beta.AcceleratorOrBuilder>
        getAcceleratorsFieldBuilder() {
      if (acceleratorsBuilder_ == null) {
        acceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Accelerator,
                com.google.cloud.lifesciences.v2beta.Accelerator.Builder,
                com.google.cloud.lifesciences.v2beta.AcceleratorOrBuilder>(
                accelerators_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        accelerators_ = null;
      }
      return acceleratorsBuilder_;
    }

    private com.google.cloud.lifesciences.v2beta.ServiceAccount serviceAccount_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ServiceAccount,
            com.google.cloud.lifesciences.v2beta.ServiceAccount.Builder,
            com.google.cloud.lifesciences.v2beta.ServiceAccountOrBuilder>
        serviceAccountBuilder_;
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     *
     * @return Whether the serviceAccount field is set.
     */
    public boolean hasServiceAccount() {
      return serviceAccountBuilder_ != null || serviceAccount_ != null;
    }
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     *
     * @return The serviceAccount.
     */
    public com.google.cloud.lifesciences.v2beta.ServiceAccount getServiceAccount() {
      if (serviceAccountBuilder_ == null) {
        return serviceAccount_ == null
            ? com.google.cloud.lifesciences.v2beta.ServiceAccount.getDefaultInstance()
            : serviceAccount_;
      } else {
        return serviceAccountBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     */
    public Builder setServiceAccount(com.google.cloud.lifesciences.v2beta.ServiceAccount value) {
      if (serviceAccountBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceAccount_ = value;
        onChanged();
      } else {
        serviceAccountBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     */
    public Builder setServiceAccount(
        com.google.cloud.lifesciences.v2beta.ServiceAccount.Builder builderForValue) {
      if (serviceAccountBuilder_ == null) {
        serviceAccount_ = builderForValue.build();
        onChanged();
      } else {
        serviceAccountBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     */
    public Builder mergeServiceAccount(com.google.cloud.lifesciences.v2beta.ServiceAccount value) {
      if (serviceAccountBuilder_ == null) {
        if (serviceAccount_ != null) {
          serviceAccount_ =
              com.google.cloud.lifesciences.v2beta.ServiceAccount.newBuilder(serviceAccount_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          serviceAccount_ = value;
        }
        onChanged();
      } else {
        serviceAccountBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     */
    public Builder clearServiceAccount() {
      if (serviceAccountBuilder_ == null) {
        serviceAccount_ = null;
        onChanged();
      } else {
        serviceAccount_ = null;
        serviceAccountBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     */
    public com.google.cloud.lifesciences.v2beta.ServiceAccount.Builder getServiceAccountBuilder() {

      onChanged();
      return getServiceAccountFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     */
    public com.google.cloud.lifesciences.v2beta.ServiceAccountOrBuilder
        getServiceAccountOrBuilder() {
      if (serviceAccountBuilder_ != null) {
        return serviceAccountBuilder_.getMessageOrBuilder();
      } else {
        return serviceAccount_ == null
            ? com.google.cloud.lifesciences.v2beta.ServiceAccount.getDefaultInstance()
            : serviceAccount_;
      }
    }
    /**
     *
     *
     * <pre>
     * The service account to install on the VM. This account does not need
     * any permissions other than those required by the pipeline.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ServiceAccount service_account = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ServiceAccount,
            com.google.cloud.lifesciences.v2beta.ServiceAccount.Builder,
            com.google.cloud.lifesciences.v2beta.ServiceAccountOrBuilder>
        getServiceAccountFieldBuilder() {
      if (serviceAccountBuilder_ == null) {
        serviceAccountBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.ServiceAccount,
                com.google.cloud.lifesciences.v2beta.ServiceAccount.Builder,
                com.google.cloud.lifesciences.v2beta.ServiceAccountOrBuilder>(
                getServiceAccount(), getParentForChildren(), isClean());
        serviceAccount_ = null;
      }
      return serviceAccountBuilder_;
    }

    private int bootDiskSizeGb_;
    /**
     *
     *
     * <pre>
     * The size of the boot disk, in GB. The boot disk must be large
     * enough to accommodate all of the Docker images from each action in the
     * pipeline at the same time. If not specified, a small but reasonable
     * default value is used.
     * </pre>
     *
     * <code>int32 boot_disk_size_gb = 8;</code>
     *
     * @return The bootDiskSizeGb.
     */
    @java.lang.Override
    public int getBootDiskSizeGb() {
      return bootDiskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * The size of the boot disk, in GB. The boot disk must be large
     * enough to accommodate all of the Docker images from each action in the
     * pipeline at the same time. If not specified, a small but reasonable
     * default value is used.
     * </pre>
     *
     * <code>int32 boot_disk_size_gb = 8;</code>
     *
     * @param value The bootDiskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setBootDiskSizeGb(int value) {

      bootDiskSizeGb_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The size of the boot disk, in GB. The boot disk must be large
     * enough to accommodate all of the Docker images from each action in the
     * pipeline at the same time. If not specified, a small but reasonable
     * default value is used.
     * </pre>
     *
     * <code>int32 boot_disk_size_gb = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBootDiskSizeGb() {

      bootDiskSizeGb_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object cpuPlatform_ = "";
    /**
     *
     *
     * <pre>
     * The CPU platform to request. An instance based on a newer platform can be
     * allocated, but never one with fewer capabilities. The value of this
     * parameter must be a valid Compute Engine CPU platform name (such as "Intel
     * Skylake"). This parameter is only useful for carefully optimized work
     * loads where the CPU platform has a significant impact.
     * For more information about the effect of this parameter, see
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string cpu_platform = 9;</code>
     *
     * @return The cpuPlatform.
     */
    public java.lang.String getCpuPlatform() {
      java.lang.Object ref = cpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The CPU platform to request. An instance based on a newer platform can be
     * allocated, but never one with fewer capabilities. The value of this
     * parameter must be a valid Compute Engine CPU platform name (such as "Intel
     * Skylake"). This parameter is only useful for carefully optimized work
     * loads where the CPU platform has a significant impact.
     * For more information about the effect of this parameter, see
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string cpu_platform = 9;</code>
     *
     * @return The bytes for cpuPlatform.
     */
    public com.google.protobuf.ByteString getCpuPlatformBytes() {
      java.lang.Object ref = cpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The CPU platform to request. An instance based on a newer platform can be
     * allocated, but never one with fewer capabilities. The value of this
     * parameter must be a valid Compute Engine CPU platform name (such as "Intel
     * Skylake"). This parameter is only useful for carefully optimized work
     * loads where the CPU platform has a significant impact.
     * For more information about the effect of this parameter, see
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string cpu_platform = 9;</code>
     *
     * @param value The cpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      cpuPlatform_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CPU platform to request. An instance based on a newer platform can be
     * allocated, but never one with fewer capabilities. The value of this
     * parameter must be a valid Compute Engine CPU platform name (such as "Intel
     * Skylake"). This parameter is only useful for carefully optimized work
     * loads where the CPU platform has a significant impact.
     * For more information about the effect of this parameter, see
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string cpu_platform = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCpuPlatform() {

      cpuPlatform_ = getDefaultInstance().getCpuPlatform();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CPU platform to request. An instance based on a newer platform can be
     * allocated, but never one with fewer capabilities. The value of this
     * parameter must be a valid Compute Engine CPU platform name (such as "Intel
     * Skylake"). This parameter is only useful for carefully optimized work
     * loads where the CPU platform has a significant impact.
     * For more information about the effect of this parameter, see
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string cpu_platform = 9;</code>
     *
     * @param value The bytes for cpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      cpuPlatform_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object bootImage_ = "";
    /**
     *
     *
     * <pre>
     * The host operating system image to use.
     * Currently, only Container-Optimized OS images can be used.
     * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     * which selects the latest stable release of Container-Optimized OS.
     * This option is provided to allow testing against the beta release of the
     * operating system to ensure that the new version does not interact
     * negatively with production pipelines.
     * To test a pipeline against the beta release of Container-Optimized OS,
     * use the value `projects/cos-cloud/global/images/family/cos-beta`.
     * </pre>
     *
     * <code>string boot_image = 10;</code>
     *
     * @return The bootImage.
     */
    public java.lang.String getBootImage() {
      java.lang.Object ref = bootImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bootImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The host operating system image to use.
     * Currently, only Container-Optimized OS images can be used.
     * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     * which selects the latest stable release of Container-Optimized OS.
     * This option is provided to allow testing against the beta release of the
     * operating system to ensure that the new version does not interact
     * negatively with production pipelines.
     * To test a pipeline against the beta release of Container-Optimized OS,
     * use the value `projects/cos-cloud/global/images/family/cos-beta`.
     * </pre>
     *
     * <code>string boot_image = 10;</code>
     *
     * @return The bytes for bootImage.
     */
    public com.google.protobuf.ByteString getBootImageBytes() {
      java.lang.Object ref = bootImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bootImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The host operating system image to use.
     * Currently, only Container-Optimized OS images can be used.
     * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     * which selects the latest stable release of Container-Optimized OS.
     * This option is provided to allow testing against the beta release of the
     * operating system to ensure that the new version does not interact
     * negatively with production pipelines.
     * To test a pipeline against the beta release of Container-Optimized OS,
     * use the value `projects/cos-cloud/global/images/family/cos-beta`.
     * </pre>
     *
     * <code>string boot_image = 10;</code>
     *
     * @param value The bootImage to set.
     * @return This builder for chaining.
     */
    public Builder setBootImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      bootImage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The host operating system image to use.
     * Currently, only Container-Optimized OS images can be used.
     * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     * which selects the latest stable release of Container-Optimized OS.
     * This option is provided to allow testing against the beta release of the
     * operating system to ensure that the new version does not interact
     * negatively with production pipelines.
     * To test a pipeline against the beta release of Container-Optimized OS,
     * use the value `projects/cos-cloud/global/images/family/cos-beta`.
     * </pre>
     *
     * <code>string boot_image = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBootImage() {

      bootImage_ = getDefaultInstance().getBootImage();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The host operating system image to use.
     * Currently, only Container-Optimized OS images can be used.
     * The default value is `projects/cos-cloud/global/images/family/cos-stable`,
     * which selects the latest stable release of Container-Optimized OS.
     * This option is provided to allow testing against the beta release of the
     * operating system to ensure that the new version does not interact
     * negatively with production pipelines.
     * To test a pipeline against the beta release of Container-Optimized OS,
     * use the value `projects/cos-cloud/global/images/family/cos-beta`.
     * </pre>
     *
     * <code>string boot_image = 10;</code>
     *
     * @param value The bytes for bootImage to set.
     * @return This builder for chaining.
     */
    public Builder setBootImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      bootImage_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object nvidiaDriverVersion_ = "";
    /**
     *
     *
     * <pre>
     * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     * The version specified here must be compatible with the GPU libraries
     * contained in the container being executed, and must be one of the drivers
     * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     * </pre>
     *
     * <code>string nvidia_driver_version = 11 [deprecated = true];</code>
     *
     * @deprecated google.cloud.lifesciences.v2beta.VirtualMachine.nvidia_driver_version is
     *     deprecated. See google/cloud/lifesciences/v2beta/workflows.proto;l=390
     * @return The nvidiaDriverVersion.
     */
    @java.lang.Deprecated
    public java.lang.String getNvidiaDriverVersion() {
      java.lang.Object ref = nvidiaDriverVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nvidiaDriverVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     * The version specified here must be compatible with the GPU libraries
     * contained in the container being executed, and must be one of the drivers
     * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     * </pre>
     *
     * <code>string nvidia_driver_version = 11 [deprecated = true];</code>
     *
     * @deprecated google.cloud.lifesciences.v2beta.VirtualMachine.nvidia_driver_version is
     *     deprecated. See google/cloud/lifesciences/v2beta/workflows.proto;l=390
     * @return The bytes for nvidiaDriverVersion.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getNvidiaDriverVersionBytes() {
      java.lang.Object ref = nvidiaDriverVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nvidiaDriverVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     * The version specified here must be compatible with the GPU libraries
     * contained in the container being executed, and must be one of the drivers
     * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     * </pre>
     *
     * <code>string nvidia_driver_version = 11 [deprecated = true];</code>
     *
     * @deprecated google.cloud.lifesciences.v2beta.VirtualMachine.nvidia_driver_version is
     *     deprecated. See google/cloud/lifesciences/v2beta/workflows.proto;l=390
     * @param value The nvidiaDriverVersion to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNvidiaDriverVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nvidiaDriverVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     * The version specified here must be compatible with the GPU libraries
     * contained in the container being executed, and must be one of the drivers
     * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     * </pre>
     *
     * <code>string nvidia_driver_version = 11 [deprecated = true];</code>
     *
     * @deprecated google.cloud.lifesciences.v2beta.VirtualMachine.nvidia_driver_version is
     *     deprecated. See google/cloud/lifesciences/v2beta/workflows.proto;l=390
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearNvidiaDriverVersion() {

      nvidiaDriverVersion_ = getDefaultInstance().getNvidiaDriverVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The NVIDIA driver version to use when attaching an NVIDIA GPU accelerator.
     * The version specified here must be compatible with the GPU libraries
     * contained in the container being executed, and must be one of the drivers
     * hosted in the `nvidia-drivers-us-public` bucket on Google Cloud Storage.
     * </pre>
     *
     * <code>string nvidia_driver_version = 11 [deprecated = true];</code>
     *
     * @deprecated google.cloud.lifesciences.v2beta.VirtualMachine.nvidia_driver_version is
     *     deprecated. See google/cloud/lifesciences/v2beta/workflows.proto;l=390
     * @param value The bytes for nvidiaDriverVersion to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setNvidiaDriverVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nvidiaDriverVersion_ = value;
      onChanged();
      return this;
    }

    private boolean enableStackdriverMonitoring_;
    /**
     *
     *
     * <pre>
     * Whether Stackdriver monitoring should be enabled on the VM.
     * </pre>
     *
     * <code>bool enable_stackdriver_monitoring = 12;</code>
     *
     * @return The enableStackdriverMonitoring.
     */
    @java.lang.Override
    public boolean getEnableStackdriverMonitoring() {
      return enableStackdriverMonitoring_;
    }
    /**
     *
     *
     * <pre>
     * Whether Stackdriver monitoring should be enabled on the VM.
     * </pre>
     *
     * <code>bool enable_stackdriver_monitoring = 12;</code>
     *
     * @param value The enableStackdriverMonitoring to set.
     * @return This builder for chaining.
     */
    public Builder setEnableStackdriverMonitoring(boolean value) {

      enableStackdriverMonitoring_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether Stackdriver monitoring should be enabled on the VM.
     * </pre>
     *
     * <code>bool enable_stackdriver_monitoring = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableStackdriverMonitoring() {

      enableStackdriverMonitoring_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList dockerCacheImages_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureDockerCacheImagesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        dockerCacheImages_ = new com.google.protobuf.LazyStringArrayList(dockerCacheImages_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @return A list containing the dockerCacheImages.
     */
    public com.google.protobuf.ProtocolStringList getDockerCacheImagesList() {
      return dockerCacheImages_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @return The count of dockerCacheImages.
     */
    public int getDockerCacheImagesCount() {
      return dockerCacheImages_.size();
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The dockerCacheImages at the given index.
     */
    public java.lang.String getDockerCacheImages(int index) {
      return dockerCacheImages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dockerCacheImages at the given index.
     */
    public com.google.protobuf.ByteString getDockerCacheImagesBytes(int index) {
      return dockerCacheImages_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The dockerCacheImages to set.
     * @return This builder for chaining.
     */
    public Builder setDockerCacheImages(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDockerCacheImagesIsMutable();
      dockerCacheImages_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @param value The dockerCacheImages to add.
     * @return This builder for chaining.
     */
    public Builder addDockerCacheImages(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDockerCacheImagesIsMutable();
      dockerCacheImages_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @param values The dockerCacheImages to add.
     * @return This builder for chaining.
     */
    public Builder addAllDockerCacheImages(java.lang.Iterable<java.lang.String> values) {
      ensureDockerCacheImagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dockerCacheImages_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDockerCacheImages() {
      dockerCacheImages_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Compute Engine Disk Images to use as a Docker cache. The disks will be
     * mounted into the Docker folder in a way that the images present in the
     * cache will not need to be pulled. The digests of the cached images must
     * match those of the tags used or the latest version will still be pulled.
     * The root directory of the ext4 image must contain `image` and `overlay2`
     * directories copied from the Docker directory of a VM where the desired
     * Docker images have already been pulled. Any images pulled that are not
     * cached will be stored on the first cache disk instead of the boot disk.
     * Only a single image is supported.
     * </pre>
     *
     * <code>repeated string docker_cache_images = 13;</code>
     *
     * @param value The bytes of the dockerCacheImages to add.
     * @return This builder for chaining.
     */
    public Builder addDockerCacheImagesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDockerCacheImagesIsMutable();
      dockerCacheImages_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.lifesciences.v2beta.Volume> volumes_ =
        java.util.Collections.emptyList();

    private void ensureVolumesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        volumes_ = new java.util.ArrayList<com.google.cloud.lifesciences.v2beta.Volume>(volumes_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Volume,
            com.google.cloud.lifesciences.v2beta.Volume.Builder,
            com.google.cloud.lifesciences.v2beta.VolumeOrBuilder>
        volumesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Volume> getVolumesList() {
      if (volumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumes_);
      } else {
        return volumesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public int getVolumesCount() {
      if (volumesBuilder_ == null) {
        return volumes_.size();
      } else {
        return volumesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Volume getVolumes(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder setVolumes(int index, com.google.cloud.lifesciences.v2beta.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder setVolumes(
        int index, com.google.cloud.lifesciences.v2beta.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder addVolumes(com.google.cloud.lifesciences.v2beta.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder addVolumes(int index, com.google.cloud.lifesciences.v2beta.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(index, value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder addVolumes(com.google.cloud.lifesciences.v2beta.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder addVolumes(
        int index, com.google.cloud.lifesciences.v2beta.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder addAllVolumes(
        java.lang.Iterable<? extends com.google.cloud.lifesciences.v2beta.Volume> values) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        onChanged();
      } else {
        volumesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder clearVolumes() {
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public Builder removeVolumes(int index) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.remove(index);
        onChanged();
      } else {
        volumesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Volume.Builder getVolumesBuilder(int index) {
      return getVolumesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public com.google.cloud.lifesciences.v2beta.VolumeOrBuilder getVolumesOrBuilder(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public java.util.List<? extends com.google.cloud.lifesciences.v2beta.VolumeOrBuilder>
        getVolumesOrBuilderList() {
      if (volumesBuilder_ != null) {
        return volumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumes_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Volume.Builder addVolumesBuilder() {
      return getVolumesFieldBuilder()
          .addBuilder(com.google.cloud.lifesciences.v2beta.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Volume.Builder addVolumesBuilder(int index) {
      return getVolumesFieldBuilder()
          .addBuilder(index, com.google.cloud.lifesciences.v2beta.Volume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of disks and other storage to create or attach to the VM.
     * Specify either the `volumes[]` field or the `disks[]` field, but not both.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Volume volumes = 14;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Volume.Builder>
        getVolumesBuilderList() {
      return getVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Volume,
            com.google.cloud.lifesciences.v2beta.Volume.Builder,
            com.google.cloud.lifesciences.v2beta.VolumeOrBuilder>
        getVolumesFieldBuilder() {
      if (volumesBuilder_ == null) {
        volumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Volume,
                com.google.cloud.lifesciences.v2beta.Volume.Builder,
                com.google.cloud.lifesciences.v2beta.VolumeOrBuilder>(
                volumes_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        volumes_ = null;
      }
      return volumesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.VirtualMachine)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.VirtualMachine)
  private static final com.google.cloud.lifesciences.v2beta.VirtualMachine DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.VirtualMachine();
  }

  public static com.google.cloud.lifesciences.v2beta.VirtualMachine getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VirtualMachine> PARSER =
      new com.google.protobuf.AbstractParser<VirtualMachine>() {
        @java.lang.Override
        public VirtualMachine parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VirtualMachine> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VirtualMachine> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.VirtualMachine getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
