/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * The arguments to the `RunPipeline` method. The requesting user must have
 * the `iam.serviceAccounts.actAs` permission for the Cloud Life Sciences
 * service account or the request will fail.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.RunPipelineRequest}
 */
public final class RunPipelineRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.RunPipelineRequest)
    RunPipelineRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunPipelineRequest.newBuilder() to construct.
  private RunPipelineRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunPipelineRequest() {
    parent_ = "";
    pubSubTopic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunPipelineRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_RunPipelineRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_RunPipelineRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.RunPipelineRequest.class,
            com.google.cloud.lifesciences.v2beta.RunPipelineRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 4;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * The project and location that this request should be executed against.
   * </pre>
   *
   * <code>string parent = 4;</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project and location that this request should be executed against.
   * </pre>
   *
   * <code>string parent = 4;</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PIPELINE_FIELD_NUMBER = 1;
  private com.google.cloud.lifesciences.v2beta.Pipeline pipeline_;
  /**
   *
   *
   * <pre>
   * Required. The description of the pipeline to run.
   * </pre>
   *
   * <code>
   * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the pipeline field is set.
   */
  @java.lang.Override
  public boolean hasPipeline() {
    return pipeline_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The description of the pipeline to run.
   * </pre>
   *
   * <code>
   * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The pipeline.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Pipeline getPipeline() {
    return pipeline_ == null
        ? com.google.cloud.lifesciences.v2beta.Pipeline.getDefaultInstance()
        : pipeline_;
  }
  /**
   *
   *
   * <pre>
   * Required. The description of the pipeline to run.
   * </pre>
   *
   * <code>
   * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.PipelineOrBuilder getPipelineOrBuilder() {
    return getPipeline();
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.lifesciences.v2beta.WorkflowsProto
                .internal_static_google_cloud_lifesciences_v2beta_RunPipelineRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels to associate with the returned operation. These
   * labels are not propagated to any Google Cloud Platform resources used by
   * the operation, and can be modified at any time.
   * To associate labels with resources created while executing the operation,
   * see the appropriate resource message (for example, `VirtualMachine`).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels to associate with the returned operation. These
   * labels are not propagated to any Google Cloud Platform resources used by
   * the operation, and can be modified at any time.
   * To associate labels with resources created while executing the operation,
   * see the appropriate resource message (for example, `VirtualMachine`).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * User-defined labels to associate with the returned operation. These
   * labels are not propagated to any Google Cloud Platform resources used by
   * the operation, and can be modified at any time.
   * To associate labels with resources created while executing the operation,
   * see the appropriate resource message (for example, `VirtualMachine`).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User-defined labels to associate with the returned operation. These
   * labels are not propagated to any Google Cloud Platform resources used by
   * the operation, and can be modified at any time.
   * To associate labels with resources created while executing the operation,
   * see the appropriate resource message (for example, `VirtualMachine`).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PUB_SUB_TOPIC_FIELD_NUMBER = 3;
  private volatile java.lang.Object pubSubTopic_;
  /**
   *
   *
   * <pre>
   * The name of an existing Pub/Sub topic.  The server will publish
   * messages to this topic whenever the status of the operation changes.
   * The Life Sciences Service Agent account must have publisher permissions to
   * the specified topic or notifications will not be sent.
   * </pre>
   *
   * <code>string pub_sub_topic = 3;</code>
   *
   * @return The pubSubTopic.
   */
  @java.lang.Override
  public java.lang.String getPubSubTopic() {
    java.lang.Object ref = pubSubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pubSubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of an existing Pub/Sub topic.  The server will publish
   * messages to this topic whenever the status of the operation changes.
   * The Life Sciences Service Agent account must have publisher permissions to
   * the specified topic or notifications will not be sent.
   * </pre>
   *
   * <code>string pub_sub_topic = 3;</code>
   *
   * @return The bytes for pubSubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPubSubTopicBytes() {
    java.lang.Object ref = pubSubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pubSubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (pipeline_ != null) {
      output.writeMessage(1, getPipeline());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 2);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubSubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pubSubTopic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, parent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (pipeline_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPipeline());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubSubTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pubSubTopic_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, parent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.RunPipelineRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.RunPipelineRequest other =
        (com.google.cloud.lifesciences.v2beta.RunPipelineRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasPipeline() != other.hasPipeline()) return false;
    if (hasPipeline()) {
      if (!getPipeline().equals(other.getPipeline())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getPubSubTopic().equals(other.getPubSubTopic())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasPipeline()) {
      hash = (37 * hash) + PIPELINE_FIELD_NUMBER;
      hash = (53 * hash) + getPipeline().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + PUB_SUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getPubSubTopic().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.lifesciences.v2beta.RunPipelineRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The arguments to the `RunPipeline` method. The requesting user must have
   * the `iam.serviceAccounts.actAs` permission for the Cloud Life Sciences
   * service account or the request will fail.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.RunPipelineRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.RunPipelineRequest)
      com.google.cloud.lifesciences.v2beta.RunPipelineRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_RunPipelineRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_RunPipelineRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.RunPipelineRequest.class,
              com.google.cloud.lifesciences.v2beta.RunPipelineRequest.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.RunPipelineRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (pipelineBuilder_ == null) {
        pipeline_ = null;
      } else {
        pipeline_ = null;
        pipelineBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      pubSubTopic_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_RunPipelineRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.RunPipelineRequest getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.RunPipelineRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.RunPipelineRequest build() {
      com.google.cloud.lifesciences.v2beta.RunPipelineRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.RunPipelineRequest buildPartial() {
      com.google.cloud.lifesciences.v2beta.RunPipelineRequest result =
          new com.google.cloud.lifesciences.v2beta.RunPipelineRequest(this);
      int from_bitField0_ = bitField0_;
      result.parent_ = parent_;
      if (pipelineBuilder_ == null) {
        result.pipeline_ = pipeline_;
      } else {
        result.pipeline_ = pipelineBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.pubSubTopic_ = pubSubTopic_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.RunPipelineRequest) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.RunPipelineRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.RunPipelineRequest other) {
      if (other == com.google.cloud.lifesciences.v2beta.RunPipelineRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.hasPipeline()) {
        mergePipeline(other.getPipeline());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (!other.getPubSubTopic().isEmpty()) {
        pubSubTopic_ = other.pubSubTopic_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPipelineFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 18
            case 26:
              {
                pubSubTopic_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * The project and location that this request should be executed against.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project and location that this request should be executed against.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project and location that this request should be executed against.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project and location that this request should be executed against.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project and location that this request should be executed against.
     * </pre>
     *
     * <code>string parent = 4;</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.lifesciences.v2beta.Pipeline pipeline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Pipeline,
            com.google.cloud.lifesciences.v2beta.Pipeline.Builder,
            com.google.cloud.lifesciences.v2beta.PipelineOrBuilder>
        pipelineBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the pipeline field is set.
     */
    public boolean hasPipeline() {
      return pipelineBuilder_ != null || pipeline_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The pipeline.
     */
    public com.google.cloud.lifesciences.v2beta.Pipeline getPipeline() {
      if (pipelineBuilder_ == null) {
        return pipeline_ == null
            ? com.google.cloud.lifesciences.v2beta.Pipeline.getDefaultInstance()
            : pipeline_;
      } else {
        return pipelineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPipeline(com.google.cloud.lifesciences.v2beta.Pipeline value) {
      if (pipelineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pipeline_ = value;
        onChanged();
      } else {
        pipelineBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPipeline(
        com.google.cloud.lifesciences.v2beta.Pipeline.Builder builderForValue) {
      if (pipelineBuilder_ == null) {
        pipeline_ = builderForValue.build();
        onChanged();
      } else {
        pipelineBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergePipeline(com.google.cloud.lifesciences.v2beta.Pipeline value) {
      if (pipelineBuilder_ == null) {
        if (pipeline_ != null) {
          pipeline_ =
              com.google.cloud.lifesciences.v2beta.Pipeline.newBuilder(pipeline_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pipeline_ = value;
        }
        onChanged();
      } else {
        pipelineBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPipeline() {
      if (pipelineBuilder_ == null) {
        pipeline_ = null;
        onChanged();
      } else {
        pipeline_ = null;
        pipelineBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.lifesciences.v2beta.Pipeline.Builder getPipelineBuilder() {

      onChanged();
      return getPipelineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.lifesciences.v2beta.PipelineOrBuilder getPipelineOrBuilder() {
      if (pipelineBuilder_ != null) {
        return pipelineBuilder_.getMessageOrBuilder();
      } else {
        return pipeline_ == null
            ? com.google.cloud.lifesciences.v2beta.Pipeline.getDefaultInstance()
            : pipeline_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the pipeline to run.
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.Pipeline pipeline = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Pipeline,
            com.google.cloud.lifesciences.v2beta.Pipeline.Builder,
            com.google.cloud.lifesciences.v2beta.PipelineOrBuilder>
        getPipelineFieldBuilder() {
      if (pipelineBuilder_ == null) {
        pipelineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Pipeline,
                com.google.cloud.lifesciences.v2beta.Pipeline.Builder,
                com.google.cloud.lifesciences.v2beta.PipelineOrBuilder>(
                getPipeline(), getParentForChildren(), isClean());
        pipeline_ = null;
      }
      return pipelineBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels to associate with the returned operation. These
     * labels are not propagated to any Google Cloud Platform resources used by
     * the operation, and can be modified at any time.
     * To associate labels with resources created while executing the operation,
     * see the appropriate resource message (for example, `VirtualMachine`).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels to associate with the returned operation. These
     * labels are not propagated to any Google Cloud Platform resources used by
     * the operation, and can be modified at any time.
     * To associate labels with resources created while executing the operation,
     * see the appropriate resource message (for example, `VirtualMachine`).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels to associate with the returned operation. These
     * labels are not propagated to any Google Cloud Platform resources used by
     * the operation, and can be modified at any time.
     * To associate labels with resources created while executing the operation,
     * see the appropriate resource message (for example, `VirtualMachine`).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels to associate with the returned operation. These
     * labels are not propagated to any Google Cloud Platform resources used by
     * the operation, and can be modified at any time.
     * To associate labels with resources created while executing the operation,
     * see the appropriate resource message (for example, `VirtualMachine`).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels to associate with the returned operation. These
     * labels are not propagated to any Google Cloud Platform resources used by
     * the operation, and can be modified at any time.
     * To associate labels with resources created while executing the operation,
     * see the appropriate resource message (for example, `VirtualMachine`).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User-defined labels to associate with the returned operation. These
     * labels are not propagated to any Google Cloud Platform resources used by
     * the operation, and can be modified at any time.
     * To associate labels with resources created while executing the operation,
     * see the appropriate resource message (for example, `VirtualMachine`).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined labels to associate with the returned operation. These
     * labels are not propagated to any Google Cloud Platform resources used by
     * the operation, and can be modified at any time.
     * To associate labels with resources created while executing the operation,
     * see the appropriate resource message (for example, `VirtualMachine`).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object pubSubTopic_ = "";
    /**
     *
     *
     * <pre>
     * The name of an existing Pub/Sub topic.  The server will publish
     * messages to this topic whenever the status of the operation changes.
     * The Life Sciences Service Agent account must have publisher permissions to
     * the specified topic or notifications will not be sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 3;</code>
     *
     * @return The pubSubTopic.
     */
    public java.lang.String getPubSubTopic() {
      java.lang.Object ref = pubSubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pubSubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of an existing Pub/Sub topic.  The server will publish
     * messages to this topic whenever the status of the operation changes.
     * The Life Sciences Service Agent account must have publisher permissions to
     * the specified topic or notifications will not be sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 3;</code>
     *
     * @return The bytes for pubSubTopic.
     */
    public com.google.protobuf.ByteString getPubSubTopicBytes() {
      java.lang.Object ref = pubSubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pubSubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of an existing Pub/Sub topic.  The server will publish
     * messages to this topic whenever the status of the operation changes.
     * The Life Sciences Service Agent account must have publisher permissions to
     * the specified topic or notifications will not be sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 3;</code>
     *
     * @param value The pubSubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubSubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pubSubTopic_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of an existing Pub/Sub topic.  The server will publish
     * messages to this topic whenever the status of the operation changes.
     * The Life Sciences Service Agent account must have publisher permissions to
     * the specified topic or notifications will not be sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPubSubTopic() {

      pubSubTopic_ = getDefaultInstance().getPubSubTopic();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of an existing Pub/Sub topic.  The server will publish
     * messages to this topic whenever the status of the operation changes.
     * The Life Sciences Service Agent account must have publisher permissions to
     * the specified topic or notifications will not be sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 3;</code>
     *
     * @param value The bytes for pubSubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubSubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pubSubTopic_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.RunPipelineRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.RunPipelineRequest)
  private static final com.google.cloud.lifesciences.v2beta.RunPipelineRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.RunPipelineRequest();
  }

  public static com.google.cloud.lifesciences.v2beta.RunPipelineRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunPipelineRequest> PARSER =
      new com.google.protobuf.AbstractParser<RunPipelineRequest>() {
        @java.lang.Override
        public RunPipelineRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RunPipelineRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunPipelineRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.RunPipelineRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
