/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * Specifies a series of actions to execute, expressed as Docker containers.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.Pipeline}
 */
public final class Pipeline extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.Pipeline)
    PipelineOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Pipeline.newBuilder() to construct.
  private Pipeline(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Pipeline() {
    actions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Pipeline();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Pipeline_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetEnvironment();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Pipeline_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.Pipeline.class,
            com.google.cloud.lifesciences.v2beta.Pipeline.Builder.class);
  }

  public static final int ACTIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.lifesciences.v2beta.Action> actions_;
  /**
   *
   *
   * <pre>
   * The list of actions to execute, in the order they are specified.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.lifesciences.v2beta.Action> getActionsList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * The list of actions to execute, in the order they are specified.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.lifesciences.v2beta.ActionOrBuilder>
      getActionsOrBuilderList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * The list of actions to execute, in the order they are specified.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
   */
  @java.lang.Override
  public int getActionsCount() {
    return actions_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of actions to execute, in the order they are specified.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Action getActions(int index) {
    return actions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of actions to execute, in the order they are specified.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ActionOrBuilder getActionsOrBuilder(int index) {
    return actions_.get(index);
  }

  public static final int RESOURCES_FIELD_NUMBER = 2;
  private com.google.cloud.lifesciences.v2beta.Resources resources_;
  /**
   *
   *
   * <pre>
   * The resources required for execution.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
   *
   * @return Whether the resources field is set.
   */
  @java.lang.Override
  public boolean hasResources() {
    return resources_ != null;
  }
  /**
   *
   *
   * <pre>
   * The resources required for execution.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
   *
   * @return The resources.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Resources getResources() {
    return resources_ == null
        ? com.google.cloud.lifesciences.v2beta.Resources.getDefaultInstance()
        : resources_;
  }
  /**
   *
   *
   * <pre>
   * The resources required for execution.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ResourcesOrBuilder getResourcesOrBuilder() {
    return getResources();
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 3;

  private static final class EnvironmentDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.lifesciences.v2beta.WorkflowsProto
                .internal_static_google_cloud_lifesciences_v2beta_Pipeline_EnvironmentEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> environment_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvironment() {
    if (environment_ == null) {
      return com.google.protobuf.MapField.emptyMapField(EnvironmentDefaultEntryHolder.defaultEntry);
    }
    return environment_;
  }

  public int getEnvironmentCount() {
    return internalGetEnvironment().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The environment to pass into every action. Each action can also specify
   * additional environment variables but cannot delete an entry from this map
   * (though they can overwrite it with a different value).
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment = 3;</code>
   */
  @java.lang.Override
  public boolean containsEnvironment(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEnvironment().getMap().containsKey(key);
  }
  /** Use {@link #getEnvironmentMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
    return getEnvironmentMap();
  }
  /**
   *
   *
   * <pre>
   * The environment to pass into every action. Each action can also specify
   * additional environment variables but cannot delete an entry from this map
   * (though they can overwrite it with a different value).
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentMap() {
    return internalGetEnvironment().getMap();
  }
  /**
   *
   *
   * <pre>
   * The environment to pass into every action. Each action can also specify
   * additional environment variables but cannot delete an entry from this map
   * (though they can overwrite it with a different value).
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironment().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The environment to pass into every action. Each action can also specify
   * additional environment variables but cannot delete an entry from this map
   * (though they can overwrite it with a different value).
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironment().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TIMEOUT_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * The maximum amount of time to give the pipeline to complete.  This includes
   * the time spent waiting for a worker to be allocated.  If the pipeline fails
   * to complete before the timeout, it will be cancelled and the error code
   * will be set to DEADLINE_EXCEEDED.
   * If unspecified, it will default to 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 4;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time to give the pipeline to complete.  This includes
   * the time spent waiting for a worker to be allocated.  If the pipeline fails
   * to complete before the timeout, it will be cancelled and the error code
   * will be set to DEADLINE_EXCEEDED.
   * If unspecified, it will default to 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 4;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time to give the pipeline to complete.  This includes
   * the time spent waiting for a worker to be allocated.  If the pipeline fails
   * to complete before the timeout, it will be cancelled and the error code
   * will be set to DEADLINE_EXCEEDED.
   * If unspecified, it will default to 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < actions_.size(); i++) {
      output.writeMessage(1, actions_.get(i));
    }
    if (resources_ != null) {
      output.writeMessage(2, getResources());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetEnvironment(), EnvironmentDefaultEntryHolder.defaultEntry, 3);
    if (timeout_ != null) {
      output.writeMessage(4, getTimeout());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < actions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, actions_.get(i));
    }
    if (resources_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResources());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvironment().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environment__ =
          EnvironmentDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, environment__);
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTimeout());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.Pipeline)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.Pipeline other =
        (com.google.cloud.lifesciences.v2beta.Pipeline) obj;

    if (!getActionsList().equals(other.getActionsList())) return false;
    if (hasResources() != other.hasResources()) return false;
    if (hasResources()) {
      if (!getResources().equals(other.getResources())) return false;
    }
    if (!internalGetEnvironment().equals(other.internalGetEnvironment())) return false;
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getActionsCount() > 0) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getActionsList().hashCode();
    }
    if (hasResources()) {
      hash = (37 * hash) + RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getResources().hashCode();
    }
    if (!internalGetEnvironment().getMap().isEmpty()) {
      hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvironment().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.lifesciences.v2beta.Pipeline prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies a series of actions to execute, expressed as Docker containers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.Pipeline}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.Pipeline)
      com.google.cloud.lifesciences.v2beta.PipelineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Pipeline_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetEnvironment();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableEnvironment();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Pipeline_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.Pipeline.class,
              com.google.cloud.lifesciences.v2beta.Pipeline.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.Pipeline.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
      } else {
        actions_ = null;
        actionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (resourcesBuilder_ == null) {
        resources_ = null;
      } else {
        resources_ = null;
        resourcesBuilder_ = null;
      }
      internalGetMutableEnvironment().clear();
      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Pipeline_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Pipeline getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.Pipeline.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Pipeline build() {
      com.google.cloud.lifesciences.v2beta.Pipeline result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Pipeline buildPartial() {
      com.google.cloud.lifesciences.v2beta.Pipeline result =
          new com.google.cloud.lifesciences.v2beta.Pipeline(this);
      int from_bitField0_ = bitField0_;
      if (actionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          actions_ = java.util.Collections.unmodifiableList(actions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.actions_ = actions_;
      } else {
        result.actions_ = actionsBuilder_.build();
      }
      if (resourcesBuilder_ == null) {
        result.resources_ = resources_;
      } else {
        result.resources_ = resourcesBuilder_.build();
      }
      result.environment_ = internalGetEnvironment();
      result.environment_.makeImmutable();
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.Pipeline) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.Pipeline) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.Pipeline other) {
      if (other == com.google.cloud.lifesciences.v2beta.Pipeline.getDefaultInstance()) return this;
      if (actionsBuilder_ == null) {
        if (!other.actions_.isEmpty()) {
          if (actions_.isEmpty()) {
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureActionsIsMutable();
            actions_.addAll(other.actions_);
          }
          onChanged();
        }
      } else {
        if (!other.actions_.isEmpty()) {
          if (actionsBuilder_.isEmpty()) {
            actionsBuilder_.dispose();
            actionsBuilder_ = null;
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            actionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActionsFieldBuilder()
                    : null;
          } else {
            actionsBuilder_.addAllMessages(other.actions_);
          }
        }
      }
      if (other.hasResources()) {
        mergeResources(other.getResources());
      }
      internalGetMutableEnvironment().mergeFrom(other.internalGetEnvironment());
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.lifesciences.v2beta.Action m =
                    input.readMessage(
                        com.google.cloud.lifesciences.v2beta.Action.parser(), extensionRegistry);
                if (actionsBuilder_ == null) {
                  ensureActionsIsMutable();
                  actions_.add(m);
                } else {
                  actionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getResourcesFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environment__ =
                    input.readMessage(
                        EnvironmentDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableEnvironment()
                    .getMutableMap()
                    .put(environment__.getKey(), environment__.getValue());
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.lifesciences.v2beta.Action> actions_ =
        java.util.Collections.emptyList();

    private void ensureActionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        actions_ = new java.util.ArrayList<com.google.cloud.lifesciences.v2beta.Action>(actions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Action,
            com.google.cloud.lifesciences.v2beta.Action.Builder,
            com.google.cloud.lifesciences.v2beta.ActionOrBuilder>
        actionsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Action> getActionsList() {
      if (actionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(actions_);
      } else {
        return actionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public int getActionsCount() {
      if (actionsBuilder_ == null) {
        return actions_.size();
      } else {
        return actionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Action getActions(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder setActions(int index, com.google.cloud.lifesciences.v2beta.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.set(index, value);
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder setActions(
        int index, com.google.cloud.lifesciences.v2beta.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.set(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder addActions(com.google.cloud.lifesciences.v2beta.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder addActions(int index, com.google.cloud.lifesciences.v2beta.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(index, value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder addActions(com.google.cloud.lifesciences.v2beta.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder addActions(
        int index, com.google.cloud.lifesciences.v2beta.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder addAllActions(
        java.lang.Iterable<? extends com.google.cloud.lifesciences.v2beta.Action> values) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
        onChanged();
      } else {
        actionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder clearActions() {
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        actionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public Builder removeActions(int index) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.remove(index);
        onChanged();
      } else {
        actionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Action.Builder getActionsBuilder(int index) {
      return getActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public com.google.cloud.lifesciences.v2beta.ActionOrBuilder getActionsOrBuilder(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.lifesciences.v2beta.ActionOrBuilder>
        getActionsOrBuilderList() {
      if (actionsBuilder_ != null) {
        return actionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(actions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Action.Builder addActionsBuilder() {
      return getActionsFieldBuilder()
          .addBuilder(com.google.cloud.lifesciences.v2beta.Action.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Action.Builder addActionsBuilder(int index) {
      return getActionsFieldBuilder()
          .addBuilder(index, com.google.cloud.lifesciences.v2beta.Action.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of actions to execute, in the order they are specified.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Action actions = 1;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Action.Builder>
        getActionsBuilderList() {
      return getActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Action,
            com.google.cloud.lifesciences.v2beta.Action.Builder,
            com.google.cloud.lifesciences.v2beta.ActionOrBuilder>
        getActionsFieldBuilder() {
      if (actionsBuilder_ == null) {
        actionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Action,
                com.google.cloud.lifesciences.v2beta.Action.Builder,
                com.google.cloud.lifesciences.v2beta.ActionOrBuilder>(
                actions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        actions_ = null;
      }
      return actionsBuilder_;
    }

    private com.google.cloud.lifesciences.v2beta.Resources resources_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Resources,
            com.google.cloud.lifesciences.v2beta.Resources.Builder,
            com.google.cloud.lifesciences.v2beta.ResourcesOrBuilder>
        resourcesBuilder_;
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     *
     * @return Whether the resources field is set.
     */
    public boolean hasResources() {
      return resourcesBuilder_ != null || resources_ != null;
    }
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     *
     * @return The resources.
     */
    public com.google.cloud.lifesciences.v2beta.Resources getResources() {
      if (resourcesBuilder_ == null) {
        return resources_ == null
            ? com.google.cloud.lifesciences.v2beta.Resources.getDefaultInstance()
            : resources_;
      } else {
        return resourcesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     */
    public Builder setResources(com.google.cloud.lifesciences.v2beta.Resources value) {
      if (resourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resources_ = value;
        onChanged();
      } else {
        resourcesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     */
    public Builder setResources(
        com.google.cloud.lifesciences.v2beta.Resources.Builder builderForValue) {
      if (resourcesBuilder_ == null) {
        resources_ = builderForValue.build();
        onChanged();
      } else {
        resourcesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     */
    public Builder mergeResources(com.google.cloud.lifesciences.v2beta.Resources value) {
      if (resourcesBuilder_ == null) {
        if (resources_ != null) {
          resources_ =
              com.google.cloud.lifesciences.v2beta.Resources.newBuilder(resources_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resources_ = value;
        }
        onChanged();
      } else {
        resourcesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     */
    public Builder clearResources() {
      if (resourcesBuilder_ == null) {
        resources_ = null;
        onChanged();
      } else {
        resources_ = null;
        resourcesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Resources.Builder getResourcesBuilder() {

      onChanged();
      return getResourcesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     */
    public com.google.cloud.lifesciences.v2beta.ResourcesOrBuilder getResourcesOrBuilder() {
      if (resourcesBuilder_ != null) {
        return resourcesBuilder_.getMessageOrBuilder();
      } else {
        return resources_ == null
            ? com.google.cloud.lifesciences.v2beta.Resources.getDefaultInstance()
            : resources_;
      }
    }
    /**
     *
     *
     * <pre>
     * The resources required for execution.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Resources resources = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Resources,
            com.google.cloud.lifesciences.v2beta.Resources.Builder,
            com.google.cloud.lifesciences.v2beta.ResourcesOrBuilder>
        getResourcesFieldBuilder() {
      if (resourcesBuilder_ == null) {
        resourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Resources,
                com.google.cloud.lifesciences.v2beta.Resources.Builder,
                com.google.cloud.lifesciences.v2beta.ResourcesOrBuilder>(
                getResources(), getParentForChildren(), isClean());
        resources_ = null;
      }
      return resourcesBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> environment_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvironment() {
      if (environment_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvironmentDefaultEntryHolder.defaultEntry);
      }
      return environment_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvironment() {
      onChanged();
      ;
      if (environment_ == null) {
        environment_ =
            com.google.protobuf.MapField.newMapField(EnvironmentDefaultEntryHolder.defaultEntry);
      }
      if (!environment_.isMutable()) {
        environment_ = environment_.copy();
      }
      return environment_;
    }

    public int getEnvironmentCount() {
      return internalGetEnvironment().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into every action. Each action can also specify
     * additional environment variables but cannot delete an entry from this map
     * (though they can overwrite it with a different value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 3;</code>
     */
    @java.lang.Override
    public boolean containsEnvironment(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnvironment().getMap().containsKey(key);
    }
    /** Use {@link #getEnvironmentMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
      return getEnvironmentMap();
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into every action. Each action can also specify
     * additional environment variables but cannot delete an entry from this map
     * (though they can overwrite it with a different value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentMap() {
      return internalGetEnvironment().getMap();
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into every action. Each action can also specify
     * additional environment variables but cannot delete an entry from this map
     * (though they can overwrite it with a different value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironment().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into every action. Each action can also specify
     * additional environment variables but cannot delete an entry from this map
     * (though they can overwrite it with a different value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironment().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEnvironment() {
      internalGetMutableEnvironment().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into every action. Each action can also specify
     * additional environment variables but cannot delete an entry from this map
     * (though they can overwrite it with a different value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 3;</code>
     */
    public Builder removeEnvironment(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEnvironment().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvironment() {
      return internalGetMutableEnvironment().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into every action. Each action can also specify
     * additional environment variables but cannot delete an entry from this map
     * (though they can overwrite it with a different value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 3;</code>
     */
    public Builder putEnvironment(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableEnvironment().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into every action. Each action can also specify
     * additional environment variables but cannot delete an entry from this map
     * (though they can overwrite it with a different value).
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 3;</code>
     */
    public Builder putAllEnvironment(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvironment().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
              com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {

      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the pipeline to complete.  This includes
     * the time spent waiting for a worker to be allocated.  If the pipeline fails
     * to complete before the timeout, it will be cancelled and the error code
     * will be set to DEADLINE_EXCEEDED.
     * If unspecified, it will default to 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.Pipeline)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.Pipeline)
  private static final com.google.cloud.lifesciences.v2beta.Pipeline DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.Pipeline();
  }

  public static com.google.cloud.lifesciences.v2beta.Pipeline getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Pipeline> PARSER =
      new com.google.protobuf.AbstractParser<Pipeline>() {
        @java.lang.Override
        public Pipeline parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Pipeline> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Pipeline> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Pipeline getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
