/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * Carries information about the pipeline execution that is returned
 * in the long running operation's metadata field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.Metadata}
 */
public final class Metadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.Metadata)
    MetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Metadata.newBuilder() to construct.
  private Metadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Metadata() {
    events_ = java.util.Collections.emptyList();
    pubSubTopic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Metadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Metadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Metadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.Metadata.class,
            com.google.cloud.lifesciences.v2beta.Metadata.Builder.class);
  }

  public static final int PIPELINE_FIELD_NUMBER = 1;
  private com.google.cloud.lifesciences.v2beta.Pipeline pipeline_;
  /**
   *
   *
   * <pre>
   * The pipeline this operation represents.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
   *
   * @return Whether the pipeline field is set.
   */
  @java.lang.Override
  public boolean hasPipeline() {
    return pipeline_ != null;
  }
  /**
   *
   *
   * <pre>
   * The pipeline this operation represents.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
   *
   * @return The pipeline.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Pipeline getPipeline() {
    return pipeline_ == null
        ? com.google.cloud.lifesciences.v2beta.Pipeline.getDefaultInstance()
        : pipeline_;
  }
  /**
   *
   *
   * <pre>
   * The pipeline this operation represents.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.PipelineOrBuilder getPipelineOrBuilder() {
    return getPipeline();
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.lifesciences.v2beta.WorkflowsProto
                .internal_static_google_cloud_lifesciences_v2beta_Metadata_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The user-defined labels associated with this operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The user-defined labels associated with this operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The user-defined labels associated with this operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The user-defined labels associated with this operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EVENTS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.lifesciences.v2beta.Event> events_;
  /**
   *
   *
   * <pre>
   * The list of events that have happened so far during the execution of this
   * operation.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.lifesciences.v2beta.Event> getEventsList() {
    return events_;
  }
  /**
   *
   *
   * <pre>
   * The list of events that have happened so far during the execution of this
   * operation.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.lifesciences.v2beta.EventOrBuilder>
      getEventsOrBuilderList() {
    return events_;
  }
  /**
   *
   *
   * <pre>
   * The list of events that have happened so far during the execution of this
   * operation.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
   */
  @java.lang.Override
  public int getEventsCount() {
    return events_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of events that have happened so far during the execution of this
   * operation.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Event getEvents(int index) {
    return events_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of events that have happened so far during the execution of this
   * operation.
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.EventOrBuilder getEventsOrBuilder(int index) {
    return events_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time at which the operation was created by the API.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the operation was created by the API.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the operation was created by the API.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int START_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The first time at which resources were allocated to execute the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The first time at which resources were allocated to execute the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The first time at which resources were allocated to execute the pipeline.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time at which execution was completed and resources were cleaned up.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which execution was completed and resources were cleaned up.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which execution was completed and resources were cleaned up.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int PUB_SUB_TOPIC_FIELD_NUMBER = 7;
  private volatile java.lang.Object pubSubTopic_;
  /**
   *
   *
   * <pre>
   * The name of the Cloud Pub/Sub topic where notifications of operation status
   * changes are sent.
   * </pre>
   *
   * <code>string pub_sub_topic = 7;</code>
   *
   * @return The pubSubTopic.
   */
  @java.lang.Override
  public java.lang.String getPubSubTopic() {
    java.lang.Object ref = pubSubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pubSubTopic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Cloud Pub/Sub topic where notifications of operation status
   * changes are sent.
   * </pre>
   *
   * <code>string pub_sub_topic = 7;</code>
   *
   * @return The bytes for pubSubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPubSubTopicBytes() {
    java.lang.Object ref = pubSubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pubSubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (pipeline_ != null) {
      output.writeMessage(1, getPipeline());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 2);
    for (int i = 0; i < events_.size(); i++) {
      output.writeMessage(3, events_.get(i));
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (startTime_ != null) {
      output.writeMessage(5, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(6, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubSubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, pubSubTopic_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (pipeline_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPipeline());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels__);
    }
    for (int i = 0; i < events_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, events_.get(i));
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubSubTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, pubSubTopic_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.Metadata)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.Metadata other =
        (com.google.cloud.lifesciences.v2beta.Metadata) obj;

    if (hasPipeline() != other.hasPipeline()) return false;
    if (hasPipeline()) {
      if (!getPipeline().equals(other.getPipeline())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getEventsList().equals(other.getEventsList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getPubSubTopic().equals(other.getPubSubTopic())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPipeline()) {
      hash = (37 * hash) + PIPELINE_FIELD_NUMBER;
      hash = (53 * hash) + getPipeline().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getEventsCount() > 0) {
      hash = (37 * hash) + EVENTS_FIELD_NUMBER;
      hash = (53 * hash) + getEventsList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + PUB_SUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getPubSubTopic().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.lifesciences.v2beta.Metadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Carries information about the pipeline execution that is returned
   * in the long running operation's metadata field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.Metadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.Metadata)
      com.google.cloud.lifesciences.v2beta.MetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Metadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Metadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.Metadata.class,
              com.google.cloud.lifesciences.v2beta.Metadata.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.Metadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (pipelineBuilder_ == null) {
        pipeline_ = null;
      } else {
        pipeline_ = null;
        pipelineBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (eventsBuilder_ == null) {
        events_ = java.util.Collections.emptyList();
      } else {
        events_ = null;
        eventsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      pubSubTopic_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Metadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Metadata getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.Metadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Metadata build() {
      com.google.cloud.lifesciences.v2beta.Metadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Metadata buildPartial() {
      com.google.cloud.lifesciences.v2beta.Metadata result =
          new com.google.cloud.lifesciences.v2beta.Metadata(this);
      int from_bitField0_ = bitField0_;
      if (pipelineBuilder_ == null) {
        result.pipeline_ = pipeline_;
      } else {
        result.pipeline_ = pipelineBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (eventsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          events_ = java.util.Collections.unmodifiableList(events_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.events_ = events_;
      } else {
        result.events_ = eventsBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.pubSubTopic_ = pubSubTopic_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.Metadata) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.Metadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.Metadata other) {
      if (other == com.google.cloud.lifesciences.v2beta.Metadata.getDefaultInstance()) return this;
      if (other.hasPipeline()) {
        mergePipeline(other.getPipeline());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (eventsBuilder_ == null) {
        if (!other.events_.isEmpty()) {
          if (events_.isEmpty()) {
            events_ = other.events_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureEventsIsMutable();
            events_.addAll(other.events_);
          }
          onChanged();
        }
      } else {
        if (!other.events_.isEmpty()) {
          if (eventsBuilder_.isEmpty()) {
            eventsBuilder_.dispose();
            eventsBuilder_ = null;
            events_ = other.events_;
            bitField0_ = (bitField0_ & ~0x00000002);
            eventsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEventsFieldBuilder()
                    : null;
          } else {
            eventsBuilder_.addAllMessages(other.events_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (!other.getPubSubTopic().isEmpty()) {
        pubSubTopic_ = other.pubSubTopic_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPipelineFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.lifesciences.v2beta.Event m =
                    input.readMessage(
                        com.google.cloud.lifesciences.v2beta.Event.parser(), extensionRegistry);
                if (eventsBuilder_ == null) {
                  ensureEventsIsMutable();
                  events_.add(m);
                } else {
                  eventsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                pubSubTopic_ = input.readStringRequireUtf8();

                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.lifesciences.v2beta.Pipeline pipeline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Pipeline,
            com.google.cloud.lifesciences.v2beta.Pipeline.Builder,
            com.google.cloud.lifesciences.v2beta.PipelineOrBuilder>
        pipelineBuilder_;
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     *
     * @return Whether the pipeline field is set.
     */
    public boolean hasPipeline() {
      return pipelineBuilder_ != null || pipeline_ != null;
    }
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     *
     * @return The pipeline.
     */
    public com.google.cloud.lifesciences.v2beta.Pipeline getPipeline() {
      if (pipelineBuilder_ == null) {
        return pipeline_ == null
            ? com.google.cloud.lifesciences.v2beta.Pipeline.getDefaultInstance()
            : pipeline_;
      } else {
        return pipelineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     */
    public Builder setPipeline(com.google.cloud.lifesciences.v2beta.Pipeline value) {
      if (pipelineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pipeline_ = value;
        onChanged();
      } else {
        pipelineBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     */
    public Builder setPipeline(
        com.google.cloud.lifesciences.v2beta.Pipeline.Builder builderForValue) {
      if (pipelineBuilder_ == null) {
        pipeline_ = builderForValue.build();
        onChanged();
      } else {
        pipelineBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     */
    public Builder mergePipeline(com.google.cloud.lifesciences.v2beta.Pipeline value) {
      if (pipelineBuilder_ == null) {
        if (pipeline_ != null) {
          pipeline_ =
              com.google.cloud.lifesciences.v2beta.Pipeline.newBuilder(pipeline_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pipeline_ = value;
        }
        onChanged();
      } else {
        pipelineBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     */
    public Builder clearPipeline() {
      if (pipelineBuilder_ == null) {
        pipeline_ = null;
        onChanged();
      } else {
        pipeline_ = null;
        pipelineBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Pipeline.Builder getPipelineBuilder() {

      onChanged();
      return getPipelineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     */
    public com.google.cloud.lifesciences.v2beta.PipelineOrBuilder getPipelineOrBuilder() {
      if (pipelineBuilder_ != null) {
        return pipelineBuilder_.getMessageOrBuilder();
      } else {
        return pipeline_ == null
            ? com.google.cloud.lifesciences.v2beta.Pipeline.getDefaultInstance()
            : pipeline_;
      }
    }
    /**
     *
     *
     * <pre>
     * The pipeline this operation represents.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Pipeline pipeline = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Pipeline,
            com.google.cloud.lifesciences.v2beta.Pipeline.Builder,
            com.google.cloud.lifesciences.v2beta.PipelineOrBuilder>
        getPipelineFieldBuilder() {
      if (pipelineBuilder_ == null) {
        pipelineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Pipeline,
                com.google.cloud.lifesciences.v2beta.Pipeline.Builder,
                com.google.cloud.lifesciences.v2beta.PipelineOrBuilder>(
                getPipeline(), getParentForChildren(), isClean());
        pipeline_ = null;
      }
      return pipelineBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The user-defined labels associated with this operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The user-defined labels associated with this operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The user-defined labels associated with this operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The user-defined labels associated with this operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-defined labels associated with this operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The user-defined labels associated with this operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The user-defined labels associated with this operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private java.util.List<com.google.cloud.lifesciences.v2beta.Event> events_ =
        java.util.Collections.emptyList();

    private void ensureEventsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        events_ = new java.util.ArrayList<com.google.cloud.lifesciences.v2beta.Event>(events_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Event,
            com.google.cloud.lifesciences.v2beta.Event.Builder,
            com.google.cloud.lifesciences.v2beta.EventOrBuilder>
        eventsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Event> getEventsList() {
      if (eventsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(events_);
      } else {
        return eventsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public int getEventsCount() {
      if (eventsBuilder_ == null) {
        return events_.size();
      } else {
        return eventsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Event getEvents(int index) {
      if (eventsBuilder_ == null) {
        return events_.get(index);
      } else {
        return eventsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder setEvents(int index, com.google.cloud.lifesciences.v2beta.Event value) {
      if (eventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventsIsMutable();
        events_.set(index, value);
        onChanged();
      } else {
        eventsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder setEvents(
        int index, com.google.cloud.lifesciences.v2beta.Event.Builder builderForValue) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        events_.set(index, builderForValue.build());
        onChanged();
      } else {
        eventsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder addEvents(com.google.cloud.lifesciences.v2beta.Event value) {
      if (eventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventsIsMutable();
        events_.add(value);
        onChanged();
      } else {
        eventsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder addEvents(int index, com.google.cloud.lifesciences.v2beta.Event value) {
      if (eventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEventsIsMutable();
        events_.add(index, value);
        onChanged();
      } else {
        eventsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder addEvents(com.google.cloud.lifesciences.v2beta.Event.Builder builderForValue) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        events_.add(builderForValue.build());
        onChanged();
      } else {
        eventsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder addEvents(
        int index, com.google.cloud.lifesciences.v2beta.Event.Builder builderForValue) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        events_.add(index, builderForValue.build());
        onChanged();
      } else {
        eventsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder addAllEvents(
        java.lang.Iterable<? extends com.google.cloud.lifesciences.v2beta.Event> values) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, events_);
        onChanged();
      } else {
        eventsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder clearEvents() {
      if (eventsBuilder_ == null) {
        events_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        eventsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public Builder removeEvents(int index) {
      if (eventsBuilder_ == null) {
        ensureEventsIsMutable();
        events_.remove(index);
        onChanged();
      } else {
        eventsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Event.Builder getEventsBuilder(int index) {
      return getEventsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public com.google.cloud.lifesciences.v2beta.EventOrBuilder getEventsOrBuilder(int index) {
      if (eventsBuilder_ == null) {
        return events_.get(index);
      } else {
        return eventsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.lifesciences.v2beta.EventOrBuilder>
        getEventsOrBuilderList() {
      if (eventsBuilder_ != null) {
        return eventsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(events_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Event.Builder addEventsBuilder() {
      return getEventsFieldBuilder()
          .addBuilder(com.google.cloud.lifesciences.v2beta.Event.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Event.Builder addEventsBuilder(int index) {
      return getEventsFieldBuilder()
          .addBuilder(index, com.google.cloud.lifesciences.v2beta.Event.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of events that have happened so far during the execution of this
     * operation.
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Event events = 3;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Event.Builder>
        getEventsBuilderList() {
      return getEventsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Event,
            com.google.cloud.lifesciences.v2beta.Event.Builder,
            com.google.cloud.lifesciences.v2beta.EventOrBuilder>
        getEventsFieldBuilder() {
      if (eventsBuilder_ == null) {
        eventsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Event,
                com.google.cloud.lifesciences.v2beta.Event.Builder,
                com.google.cloud.lifesciences.v2beta.EventOrBuilder>(
                events_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        events_ = null;
      }
      return eventsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation was created by the API.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The first time at which resources were allocated to execute the pipeline.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which execution was completed and resources were cleaned up.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object pubSubTopic_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Cloud Pub/Sub topic where notifications of operation status
     * changes are sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 7;</code>
     *
     * @return The pubSubTopic.
     */
    public java.lang.String getPubSubTopic() {
      java.lang.Object ref = pubSubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pubSubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud Pub/Sub topic where notifications of operation status
     * changes are sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 7;</code>
     *
     * @return The bytes for pubSubTopic.
     */
    public com.google.protobuf.ByteString getPubSubTopicBytes() {
      java.lang.Object ref = pubSubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pubSubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud Pub/Sub topic where notifications of operation status
     * changes are sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 7;</code>
     *
     * @param value The pubSubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubSubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pubSubTopic_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud Pub/Sub topic where notifications of operation status
     * changes are sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPubSubTopic() {

      pubSubTopic_ = getDefaultInstance().getPubSubTopic();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Cloud Pub/Sub topic where notifications of operation status
     * changes are sent.
     * </pre>
     *
     * <code>string pub_sub_topic = 7;</code>
     *
     * @param value The bytes for pubSubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubSubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pubSubTopic_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.Metadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.Metadata)
  private static final com.google.cloud.lifesciences.v2beta.Metadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.Metadata();
  }

  public static com.google.cloud.lifesciences.v2beta.Metadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Metadata> PARSER =
      new com.google.protobuf.AbstractParser<Metadata>() {
        @java.lang.Override
        public Metadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Metadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Metadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Metadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
