/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * Carries information about events that occur during pipeline execution.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.Event}
 */
public final class Event extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.Event)
    EventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Event.newBuilder() to construct.
  private Event(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Event() {
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Event();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Event_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Event_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.Event.class,
            com.google.cloud.lifesciences.v2beta.Event.Builder.class);
  }

  private int detailsCase_ = 0;
  private java.lang.Object details_;

  public enum DetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DELAYED(17),
    WORKER_ASSIGNED(18),
    WORKER_RELEASED(19),
    PULL_STARTED(20),
    PULL_STOPPED(21),
    CONTAINER_STARTED(22),
    CONTAINER_STOPPED(23),
    CONTAINER_KILLED(24),
    UNEXPECTED_EXIT_STATUS(25),
    FAILED(26),
    DETAILS_NOT_SET(0);
    private final int value;

    private DetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailsCase forNumber(int value) {
      switch (value) {
        case 17:
          return DELAYED;
        case 18:
          return WORKER_ASSIGNED;
        case 19:
          return WORKER_RELEASED;
        case 20:
          return PULL_STARTED;
        case 21:
          return PULL_STOPPED;
        case 22:
          return CONTAINER_STARTED;
        case 23:
          return CONTAINER_STOPPED;
        case 24:
          return CONTAINER_KILLED;
        case 25:
          return UNEXPECTED_EXIT_STATUS;
        case 26:
          return FAILED;
        case 0:
          return DETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailsCase getDetailsCase() {
    return DetailsCase.forNumber(detailsCase_);
  }

  public static final int TIMESTAMP_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp timestamp_;
  /**
   *
   *
   * <pre>
   * The time at which the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 1;</code>
   *
   * @return Whether the timestamp field is set.
   */
  @java.lang.Override
  public boolean hasTimestamp() {
    return timestamp_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 1;</code>
   *
   * @return The timestamp.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTimestamp() {
    return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the event occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
    return getTimestamp();
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * A human-readable description of the event. Note that these strings can
   * change at any time without notice. Any application logic must use the
   * information in the `details` field.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A human-readable description of the event. Note that these strings can
   * change at any time without notice. Any application logic must use the
   * information in the `details` field.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELAYED_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
   *
   * @return Whether the delayed field is set.
   */
  @java.lang.Override
  public boolean hasDelayed() {
    return detailsCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
   *
   * @return The delayed.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.DelayedEvent getDelayed() {
    if (detailsCase_ == 17) {
      return (com.google.cloud.lifesciences.v2beta.DelayedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.DelayedEventOrBuilder getDelayedOrBuilder() {
    if (detailsCase_ == 17) {
      return (com.google.cloud.lifesciences.v2beta.DelayedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance();
  }

  public static final int WORKER_ASSIGNED_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
   *
   * @return Whether the workerAssigned field is set.
   */
  @java.lang.Override
  public boolean hasWorkerAssigned() {
    return detailsCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
   *
   * @return The workerAssigned.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent getWorkerAssigned() {
    if (detailsCase_ == 18) {
      return (com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.WorkerAssignedEventOrBuilder
      getWorkerAssignedOrBuilder() {
    if (detailsCase_ == 18) {
      return (com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.getDefaultInstance();
  }

  public static final int WORKER_RELEASED_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
   *
   * @return Whether the workerReleased field is set.
   */
  @java.lang.Override
  public boolean hasWorkerReleased() {
    return detailsCase_ == 19;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
   *
   * @return The workerReleased.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent getWorkerReleased() {
    if (detailsCase_ == 19) {
      return (com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.WorkerReleasedEventOrBuilder
      getWorkerReleasedOrBuilder() {
    if (detailsCase_ == 19) {
      return (com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.getDefaultInstance();
  }

  public static final int PULL_STARTED_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
   *
   * @return Whether the pullStarted field is set.
   */
  @java.lang.Override
  public boolean hasPullStarted() {
    return detailsCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
   *
   * @return The pullStarted.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.PullStartedEvent getPullStarted() {
    if (detailsCase_ == 20) {
      return (com.google.cloud.lifesciences.v2beta.PullStartedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.PullStartedEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.PullStartedEventOrBuilder getPullStartedOrBuilder() {
    if (detailsCase_ == 20) {
      return (com.google.cloud.lifesciences.v2beta.PullStartedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.PullStartedEvent.getDefaultInstance();
  }

  public static final int PULL_STOPPED_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
   *
   * @return Whether the pullStopped field is set.
   */
  @java.lang.Override
  public boolean hasPullStopped() {
    return detailsCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
   *
   * @return The pullStopped.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.PullStoppedEvent getPullStopped() {
    if (detailsCase_ == 21) {
      return (com.google.cloud.lifesciences.v2beta.PullStoppedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.PullStoppedEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.PullStoppedEventOrBuilder getPullStoppedOrBuilder() {
    if (detailsCase_ == 21) {
      return (com.google.cloud.lifesciences.v2beta.PullStoppedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.PullStoppedEvent.getDefaultInstance();
  }

  public static final int CONTAINER_STARTED_FIELD_NUMBER = 22;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
   *
   * @return Whether the containerStarted field is set.
   */
  @java.lang.Override
  public boolean hasContainerStarted() {
    return detailsCase_ == 22;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
   *
   * @return The containerStarted.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ContainerStartedEvent getContainerStarted() {
    if (detailsCase_ == 22) {
      return (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ContainerStartedEventOrBuilder
      getContainerStartedOrBuilder() {
    if (detailsCase_ == 22) {
      return (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.getDefaultInstance();
  }

  public static final int CONTAINER_STOPPED_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
   *
   * @return Whether the containerStopped field is set.
   */
  @java.lang.Override
  public boolean hasContainerStopped() {
    return detailsCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
   *
   * @return The containerStopped.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent getContainerStopped() {
    if (detailsCase_ == 23) {
      return (com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ContainerStoppedEventOrBuilder
      getContainerStoppedOrBuilder() {
    if (detailsCase_ == 23) {
      return (com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.getDefaultInstance();
  }

  public static final int CONTAINER_KILLED_FIELD_NUMBER = 24;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
   *
   * @return Whether the containerKilled field is set.
   */
  @java.lang.Override
  public boolean hasContainerKilled() {
    return detailsCase_ == 24;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
   *
   * @return The containerKilled.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ContainerKilledEvent getContainerKilled() {
    if (detailsCase_ == 24) {
      return (com.google.cloud.lifesciences.v2beta.ContainerKilledEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ContainerKilledEventOrBuilder
      getContainerKilledOrBuilder() {
    if (detailsCase_ == 24) {
      return (com.google.cloud.lifesciences.v2beta.ContainerKilledEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.getDefaultInstance();
  }

  public static final int UNEXPECTED_EXIT_STATUS_FIELD_NUMBER = 25;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
   * </code>
   *
   * @return Whether the unexpectedExitStatus field is set.
   */
  @java.lang.Override
  public boolean hasUnexpectedExitStatus() {
    return detailsCase_ == 25;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
   * </code>
   *
   * @return The unexpectedExitStatus.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent getUnexpectedExitStatus() {
    if (detailsCase_ == 25) {
      return (com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEventOrBuilder
      getUnexpectedExitStatusOrBuilder() {
    if (detailsCase_ == 25) {
      return (com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.getDefaultInstance();
  }

  public static final int FAILED_FIELD_NUMBER = 26;
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
   *
   * @return Whether the failed field is set.
   */
  @java.lang.Override
  public boolean hasFailed() {
    return detailsCase_ == 26;
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
   *
   * @return The failed.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.FailedEvent getFailed() {
    if (detailsCase_ == 26) {
      return (com.google.cloud.lifesciences.v2beta.FailedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.FailedEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.FailedEventOrBuilder getFailedOrBuilder() {
    if (detailsCase_ == 26) {
      return (com.google.cloud.lifesciences.v2beta.FailedEvent) details_;
    }
    return com.google.cloud.lifesciences.v2beta.FailedEvent.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (timestamp_ != null) {
      output.writeMessage(1, getTimestamp());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (detailsCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.lifesciences.v2beta.DelayedEvent) details_);
    }
    if (detailsCase_ == 18) {
      output.writeMessage(18, (com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent) details_);
    }
    if (detailsCase_ == 19) {
      output.writeMessage(19, (com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent) details_);
    }
    if (detailsCase_ == 20) {
      output.writeMessage(20, (com.google.cloud.lifesciences.v2beta.PullStartedEvent) details_);
    }
    if (detailsCase_ == 21) {
      output.writeMessage(21, (com.google.cloud.lifesciences.v2beta.PullStoppedEvent) details_);
    }
    if (detailsCase_ == 22) {
      output.writeMessage(
          22, (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) details_);
    }
    if (detailsCase_ == 23) {
      output.writeMessage(
          23, (com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent) details_);
    }
    if (detailsCase_ == 24) {
      output.writeMessage(24, (com.google.cloud.lifesciences.v2beta.ContainerKilledEvent) details_);
    }
    if (detailsCase_ == 25) {
      output.writeMessage(
          25, (com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent) details_);
    }
    if (detailsCase_ == 26) {
      output.writeMessage(26, (com.google.cloud.lifesciences.v2beta.FailedEvent) details_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (timestamp_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTimestamp());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (detailsCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.lifesciences.v2beta.DelayedEvent) details_);
    }
    if (detailsCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent) details_);
    }
    if (detailsCase_ == 19) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, (com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent) details_);
    }
    if (detailsCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.cloud.lifesciences.v2beta.PullStartedEvent) details_);
    }
    if (detailsCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.lifesciences.v2beta.PullStoppedEvent) details_);
    }
    if (detailsCase_ == 22) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              22, (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) details_);
    }
    if (detailsCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, (com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent) details_);
    }
    if (detailsCase_ == 24) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, (com.google.cloud.lifesciences.v2beta.ContainerKilledEvent) details_);
    }
    if (detailsCase_ == 25) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              25, (com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent) details_);
    }
    if (detailsCase_ == 26) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              26, (com.google.cloud.lifesciences.v2beta.FailedEvent) details_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.Event)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.Event other =
        (com.google.cloud.lifesciences.v2beta.Event) obj;

    if (hasTimestamp() != other.hasTimestamp()) return false;
    if (hasTimestamp()) {
      if (!getTimestamp().equals(other.getTimestamp())) return false;
    }
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getDetailsCase().equals(other.getDetailsCase())) return false;
    switch (detailsCase_) {
      case 17:
        if (!getDelayed().equals(other.getDelayed())) return false;
        break;
      case 18:
        if (!getWorkerAssigned().equals(other.getWorkerAssigned())) return false;
        break;
      case 19:
        if (!getWorkerReleased().equals(other.getWorkerReleased())) return false;
        break;
      case 20:
        if (!getPullStarted().equals(other.getPullStarted())) return false;
        break;
      case 21:
        if (!getPullStopped().equals(other.getPullStopped())) return false;
        break;
      case 22:
        if (!getContainerStarted().equals(other.getContainerStarted())) return false;
        break;
      case 23:
        if (!getContainerStopped().equals(other.getContainerStopped())) return false;
        break;
      case 24:
        if (!getContainerKilled().equals(other.getContainerKilled())) return false;
        break;
      case 25:
        if (!getUnexpectedExitStatus().equals(other.getUnexpectedExitStatus())) return false;
        break;
      case 26:
        if (!getFailed().equals(other.getFailed())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTimestamp()) {
      hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getTimestamp().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    switch (detailsCase_) {
      case 17:
        hash = (37 * hash) + DELAYED_FIELD_NUMBER;
        hash = (53 * hash) + getDelayed().hashCode();
        break;
      case 18:
        hash = (37 * hash) + WORKER_ASSIGNED_FIELD_NUMBER;
        hash = (53 * hash) + getWorkerAssigned().hashCode();
        break;
      case 19:
        hash = (37 * hash) + WORKER_RELEASED_FIELD_NUMBER;
        hash = (53 * hash) + getWorkerReleased().hashCode();
        break;
      case 20:
        hash = (37 * hash) + PULL_STARTED_FIELD_NUMBER;
        hash = (53 * hash) + getPullStarted().hashCode();
        break;
      case 21:
        hash = (37 * hash) + PULL_STOPPED_FIELD_NUMBER;
        hash = (53 * hash) + getPullStopped().hashCode();
        break;
      case 22:
        hash = (37 * hash) + CONTAINER_STARTED_FIELD_NUMBER;
        hash = (53 * hash) + getContainerStarted().hashCode();
        break;
      case 23:
        hash = (37 * hash) + CONTAINER_STOPPED_FIELD_NUMBER;
        hash = (53 * hash) + getContainerStopped().hashCode();
        break;
      case 24:
        hash = (37 * hash) + CONTAINER_KILLED_FIELD_NUMBER;
        hash = (53 * hash) + getContainerKilled().hashCode();
        break;
      case 25:
        hash = (37 * hash) + UNEXPECTED_EXIT_STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getUnexpectedExitStatus().hashCode();
        break;
      case 26:
        hash = (37 * hash) + FAILED_FIELD_NUMBER;
        hash = (53 * hash) + getFailed().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Event parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.lifesciences.v2beta.Event prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Carries information about events that occur during pipeline execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.Event}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.Event)
      com.google.cloud.lifesciences.v2beta.EventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Event_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Event_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.Event.class,
              com.google.cloud.lifesciences.v2beta.Event.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.Event.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (timestampBuilder_ == null) {
        timestamp_ = null;
      } else {
        timestamp_ = null;
        timestampBuilder_ = null;
      }
      description_ = "";

      if (delayedBuilder_ != null) {
        delayedBuilder_.clear();
      }
      if (workerAssignedBuilder_ != null) {
        workerAssignedBuilder_.clear();
      }
      if (workerReleasedBuilder_ != null) {
        workerReleasedBuilder_.clear();
      }
      if (pullStartedBuilder_ != null) {
        pullStartedBuilder_.clear();
      }
      if (pullStoppedBuilder_ != null) {
        pullStoppedBuilder_.clear();
      }
      if (containerStartedBuilder_ != null) {
        containerStartedBuilder_.clear();
      }
      if (containerStoppedBuilder_ != null) {
        containerStoppedBuilder_.clear();
      }
      if (containerKilledBuilder_ != null) {
        containerKilledBuilder_.clear();
      }
      if (unexpectedExitStatusBuilder_ != null) {
        unexpectedExitStatusBuilder_.clear();
      }
      if (failedBuilder_ != null) {
        failedBuilder_.clear();
      }
      detailsCase_ = 0;
      details_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Event_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Event getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.Event.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Event build() {
      com.google.cloud.lifesciences.v2beta.Event result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Event buildPartial() {
      com.google.cloud.lifesciences.v2beta.Event result =
          new com.google.cloud.lifesciences.v2beta.Event(this);
      if (timestampBuilder_ == null) {
        result.timestamp_ = timestamp_;
      } else {
        result.timestamp_ = timestampBuilder_.build();
      }
      result.description_ = description_;
      if (detailsCase_ == 17) {
        if (delayedBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = delayedBuilder_.build();
        }
      }
      if (detailsCase_ == 18) {
        if (workerAssignedBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = workerAssignedBuilder_.build();
        }
      }
      if (detailsCase_ == 19) {
        if (workerReleasedBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = workerReleasedBuilder_.build();
        }
      }
      if (detailsCase_ == 20) {
        if (pullStartedBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = pullStartedBuilder_.build();
        }
      }
      if (detailsCase_ == 21) {
        if (pullStoppedBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = pullStoppedBuilder_.build();
        }
      }
      if (detailsCase_ == 22) {
        if (containerStartedBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = containerStartedBuilder_.build();
        }
      }
      if (detailsCase_ == 23) {
        if (containerStoppedBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = containerStoppedBuilder_.build();
        }
      }
      if (detailsCase_ == 24) {
        if (containerKilledBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = containerKilledBuilder_.build();
        }
      }
      if (detailsCase_ == 25) {
        if (unexpectedExitStatusBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = unexpectedExitStatusBuilder_.build();
        }
      }
      if (detailsCase_ == 26) {
        if (failedBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = failedBuilder_.build();
        }
      }
      result.detailsCase_ = detailsCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.Event) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.Event) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.Event other) {
      if (other == com.google.cloud.lifesciences.v2beta.Event.getDefaultInstance()) return this;
      if (other.hasTimestamp()) {
        mergeTimestamp(other.getTimestamp());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      switch (other.getDetailsCase()) {
        case DELAYED:
          {
            mergeDelayed(other.getDelayed());
            break;
          }
        case WORKER_ASSIGNED:
          {
            mergeWorkerAssigned(other.getWorkerAssigned());
            break;
          }
        case WORKER_RELEASED:
          {
            mergeWorkerReleased(other.getWorkerReleased());
            break;
          }
        case PULL_STARTED:
          {
            mergePullStarted(other.getPullStarted());
            break;
          }
        case PULL_STOPPED:
          {
            mergePullStopped(other.getPullStopped());
            break;
          }
        case CONTAINER_STARTED:
          {
            mergeContainerStarted(other.getContainerStarted());
            break;
          }
        case CONTAINER_STOPPED:
          {
            mergeContainerStopped(other.getContainerStopped());
            break;
          }
        case CONTAINER_KILLED:
          {
            mergeContainerKilled(other.getContainerKilled());
            break;
          }
        case UNEXPECTED_EXIT_STATUS:
          {
            mergeUnexpectedExitStatus(other.getUnexpectedExitStatus());
            break;
          }
        case FAILED:
          {
            mergeFailed(other.getFailed());
            break;
          }
        case DETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTimestampFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 138:
              {
                input.readMessage(getDelayedFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getWorkerAssignedFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 18;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(getWorkerReleasedFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 19;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(getPullStartedFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 20;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getPullStoppedFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                input.readMessage(
                    getContainerStartedFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 22;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getContainerStoppedFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 23;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(getContainerKilledFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 24;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(
                    getUnexpectedExitStatusFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 25;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(getFailedFieldBuilder().getBuilder(), extensionRegistry);
                detailsCase_ = 26;
                break;
              } // case 210
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int detailsCase_ = 0;
    private java.lang.Object details_;

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public Builder clearDetails() {
      detailsCase_ = 0;
      details_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp timestamp_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        timestampBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     *
     * @return Whether the timestamp field is set.
     */
    public boolean hasTimestamp() {
      return timestampBuilder_ != null || timestamp_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     *
     * @return The timestamp.
     */
    public com.google.protobuf.Timestamp getTimestamp() {
      if (timestampBuilder_ == null) {
        return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
      } else {
        return timestampBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    public Builder setTimestamp(com.google.protobuf.Timestamp value) {
      if (timestampBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timestamp_ = value;
        onChanged();
      } else {
        timestampBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    public Builder setTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (timestampBuilder_ == null) {
        timestamp_ = builderForValue.build();
        onChanged();
      } else {
        timestampBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    public Builder mergeTimestamp(com.google.protobuf.Timestamp value) {
      if (timestampBuilder_ == null) {
        if (timestamp_ != null) {
          timestamp_ =
              com.google.protobuf.Timestamp.newBuilder(timestamp_).mergeFrom(value).buildPartial();
        } else {
          timestamp_ = value;
        }
        onChanged();
      } else {
        timestampBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    public Builder clearTimestamp() {
      if (timestampBuilder_ == null) {
        timestamp_ = null;
        onChanged();
      } else {
        timestamp_ = null;
        timestampBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getTimestampBuilder() {

      onChanged();
      return getTimestampFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
      if (timestampBuilder_ != null) {
        return timestampBuilder_.getMessageOrBuilder();
      } else {
        return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the event occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTimestampFieldBuilder() {
      if (timestampBuilder_ == null) {
        timestampBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getTimestamp(), getParentForChildren(), isClean());
        timestamp_ = null;
      }
      return timestampBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A human-readable description of the event. Note that these strings can
     * change at any time without notice. Any application logic must use the
     * information in the `details` field.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of the event. Note that these strings can
     * change at any time without notice. Any application logic must use the
     * information in the `details` field.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of the event. Note that these strings can
     * change at any time without notice. Any application logic must use the
     * information in the `details` field.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of the event. Note that these strings can
     * change at any time without notice. Any application logic must use the
     * information in the `details` field.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A human-readable description of the event. Note that these strings can
     * change at any time without notice. Any application logic must use the
     * information in the `details` field.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.DelayedEvent,
            com.google.cloud.lifesciences.v2beta.DelayedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.DelayedEventOrBuilder>
        delayedBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     *
     * @return Whether the delayed field is set.
     */
    @java.lang.Override
    public boolean hasDelayed() {
      return detailsCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     *
     * @return The delayed.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.DelayedEvent getDelayed() {
      if (delayedBuilder_ == null) {
        if (detailsCase_ == 17) {
          return (com.google.cloud.lifesciences.v2beta.DelayedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 17) {
          return delayedBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     */
    public Builder setDelayed(com.google.cloud.lifesciences.v2beta.DelayedEvent value) {
      if (delayedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        delayedBuilder_.setMessage(value);
      }
      detailsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     */
    public Builder setDelayed(
        com.google.cloud.lifesciences.v2beta.DelayedEvent.Builder builderForValue) {
      if (delayedBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        delayedBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     */
    public Builder mergeDelayed(com.google.cloud.lifesciences.v2beta.DelayedEvent value) {
      if (delayedBuilder_ == null) {
        if (detailsCase_ == 17
            && details_ != com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.DelayedEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.DelayedEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 17) {
          delayedBuilder_.mergeFrom(value);
        } else {
          delayedBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     */
    public Builder clearDelayed() {
      if (delayedBuilder_ == null) {
        if (detailsCase_ == 17) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 17) {
          detailsCase_ = 0;
          details_ = null;
        }
        delayedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     */
    public com.google.cloud.lifesciences.v2beta.DelayedEvent.Builder getDelayedBuilder() {
      return getDelayedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.DelayedEventOrBuilder getDelayedOrBuilder() {
      if ((detailsCase_ == 17) && (delayedBuilder_ != null)) {
        return delayedBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 17) {
          return (com.google.cloud.lifesciences.v2beta.DelayedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.DelayedEvent][google.cloud.lifesciences.v2beta.DelayedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.DelayedEvent delayed = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.DelayedEvent,
            com.google.cloud.lifesciences.v2beta.DelayedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.DelayedEventOrBuilder>
        getDelayedFieldBuilder() {
      if (delayedBuilder_ == null) {
        if (!(detailsCase_ == 17)) {
          details_ = com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance();
        }
        delayedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.DelayedEvent,
                com.google.cloud.lifesciences.v2beta.DelayedEvent.Builder,
                com.google.cloud.lifesciences.v2beta.DelayedEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.DelayedEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 17;
      onChanged();
      ;
      return delayedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent,
            com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.WorkerAssignedEventOrBuilder>
        workerAssignedBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     *
     * @return Whether the workerAssigned field is set.
     */
    @java.lang.Override
    public boolean hasWorkerAssigned() {
      return detailsCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     *
     * @return The workerAssigned.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent getWorkerAssigned() {
      if (workerAssignedBuilder_ == null) {
        if (detailsCase_ == 18) {
          return (com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 18) {
          return workerAssignedBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     */
    public Builder setWorkerAssigned(
        com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent value) {
      if (workerAssignedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        workerAssignedBuilder_.setMessage(value);
      }
      detailsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     */
    public Builder setWorkerAssigned(
        com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.Builder builderForValue) {
      if (workerAssignedBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        workerAssignedBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     */
    public Builder mergeWorkerAssigned(
        com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent value) {
      if (workerAssignedBuilder_ == null) {
        if (detailsCase_ == 18
            && details_
                != com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 18) {
          workerAssignedBuilder_.mergeFrom(value);
        } else {
          workerAssignedBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     */
    public Builder clearWorkerAssigned() {
      if (workerAssignedBuilder_ == null) {
        if (detailsCase_ == 18) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 18) {
          detailsCase_ = 0;
          details_ = null;
        }
        workerAssignedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     */
    public com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.Builder
        getWorkerAssignedBuilder() {
      return getWorkerAssignedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.WorkerAssignedEventOrBuilder
        getWorkerAssignedOrBuilder() {
      if ((detailsCase_ == 18) && (workerAssignedBuilder_ != null)) {
        return workerAssignedBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 18) {
          return (com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerAssignedEvent][google.cloud.lifesciences.v2beta.WorkerAssignedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerAssignedEvent worker_assigned = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent,
            com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.WorkerAssignedEventOrBuilder>
        getWorkerAssignedFieldBuilder() {
      if (workerAssignedBuilder_ == null) {
        if (!(detailsCase_ == 18)) {
          details_ = com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.getDefaultInstance();
        }
        workerAssignedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent,
                com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent.Builder,
                com.google.cloud.lifesciences.v2beta.WorkerAssignedEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.WorkerAssignedEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 18;
      onChanged();
      ;
      return workerAssignedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent,
            com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.WorkerReleasedEventOrBuilder>
        workerReleasedBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     *
     * @return Whether the workerReleased field is set.
     */
    @java.lang.Override
    public boolean hasWorkerReleased() {
      return detailsCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     *
     * @return The workerReleased.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent getWorkerReleased() {
      if (workerReleasedBuilder_ == null) {
        if (detailsCase_ == 19) {
          return (com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 19) {
          return workerReleasedBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     */
    public Builder setWorkerReleased(
        com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent value) {
      if (workerReleasedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        workerReleasedBuilder_.setMessage(value);
      }
      detailsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     */
    public Builder setWorkerReleased(
        com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.Builder builderForValue) {
      if (workerReleasedBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        workerReleasedBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     */
    public Builder mergeWorkerReleased(
        com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent value) {
      if (workerReleasedBuilder_ == null) {
        if (detailsCase_ == 19
            && details_
                != com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 19) {
          workerReleasedBuilder_.mergeFrom(value);
        } else {
          workerReleasedBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 19;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     */
    public Builder clearWorkerReleased() {
      if (workerReleasedBuilder_ == null) {
        if (detailsCase_ == 19) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 19) {
          detailsCase_ = 0;
          details_ = null;
        }
        workerReleasedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     */
    public com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.Builder
        getWorkerReleasedBuilder() {
      return getWorkerReleasedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.WorkerReleasedEventOrBuilder
        getWorkerReleasedOrBuilder() {
      if ((detailsCase_ == 19) && (workerReleasedBuilder_ != null)) {
        return workerReleasedBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 19) {
          return (com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.WorkerReleasedEvent][google.cloud.lifesciences.v2beta.WorkerReleasedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.WorkerReleasedEvent worker_released = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent,
            com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.WorkerReleasedEventOrBuilder>
        getWorkerReleasedFieldBuilder() {
      if (workerReleasedBuilder_ == null) {
        if (!(detailsCase_ == 19)) {
          details_ = com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.getDefaultInstance();
        }
        workerReleasedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent,
                com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent.Builder,
                com.google.cloud.lifesciences.v2beta.WorkerReleasedEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.WorkerReleasedEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 19;
      onChanged();
      ;
      return workerReleasedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.PullStartedEvent,
            com.google.cloud.lifesciences.v2beta.PullStartedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.PullStartedEventOrBuilder>
        pullStartedBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     *
     * @return Whether the pullStarted field is set.
     */
    @java.lang.Override
    public boolean hasPullStarted() {
      return detailsCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     *
     * @return The pullStarted.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.PullStartedEvent getPullStarted() {
      if (pullStartedBuilder_ == null) {
        if (detailsCase_ == 20) {
          return (com.google.cloud.lifesciences.v2beta.PullStartedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.PullStartedEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 20) {
          return pullStartedBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.PullStartedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     */
    public Builder setPullStarted(com.google.cloud.lifesciences.v2beta.PullStartedEvent value) {
      if (pullStartedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        pullStartedBuilder_.setMessage(value);
      }
      detailsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     */
    public Builder setPullStarted(
        com.google.cloud.lifesciences.v2beta.PullStartedEvent.Builder builderForValue) {
      if (pullStartedBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        pullStartedBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     */
    public Builder mergePullStarted(com.google.cloud.lifesciences.v2beta.PullStartedEvent value) {
      if (pullStartedBuilder_ == null) {
        if (detailsCase_ == 20
            && details_
                != com.google.cloud.lifesciences.v2beta.PullStartedEvent.getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.PullStartedEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.PullStartedEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 20) {
          pullStartedBuilder_.mergeFrom(value);
        } else {
          pullStartedBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     */
    public Builder clearPullStarted() {
      if (pullStartedBuilder_ == null) {
        if (detailsCase_ == 20) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 20) {
          detailsCase_ = 0;
          details_ = null;
        }
        pullStartedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     */
    public com.google.cloud.lifesciences.v2beta.PullStartedEvent.Builder getPullStartedBuilder() {
      return getPullStartedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.PullStartedEventOrBuilder
        getPullStartedOrBuilder() {
      if ((detailsCase_ == 20) && (pullStartedBuilder_ != null)) {
        return pullStartedBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 20) {
          return (com.google.cloud.lifesciences.v2beta.PullStartedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.PullStartedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStartedEvent][google.cloud.lifesciences.v2beta.PullStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStartedEvent pull_started = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.PullStartedEvent,
            com.google.cloud.lifesciences.v2beta.PullStartedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.PullStartedEventOrBuilder>
        getPullStartedFieldBuilder() {
      if (pullStartedBuilder_ == null) {
        if (!(detailsCase_ == 20)) {
          details_ = com.google.cloud.lifesciences.v2beta.PullStartedEvent.getDefaultInstance();
        }
        pullStartedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.PullStartedEvent,
                com.google.cloud.lifesciences.v2beta.PullStartedEvent.Builder,
                com.google.cloud.lifesciences.v2beta.PullStartedEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.PullStartedEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 20;
      onChanged();
      ;
      return pullStartedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.PullStoppedEvent,
            com.google.cloud.lifesciences.v2beta.PullStoppedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.PullStoppedEventOrBuilder>
        pullStoppedBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     *
     * @return Whether the pullStopped field is set.
     */
    @java.lang.Override
    public boolean hasPullStopped() {
      return detailsCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     *
     * @return The pullStopped.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.PullStoppedEvent getPullStopped() {
      if (pullStoppedBuilder_ == null) {
        if (detailsCase_ == 21) {
          return (com.google.cloud.lifesciences.v2beta.PullStoppedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.PullStoppedEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 21) {
          return pullStoppedBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.PullStoppedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     */
    public Builder setPullStopped(com.google.cloud.lifesciences.v2beta.PullStoppedEvent value) {
      if (pullStoppedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        pullStoppedBuilder_.setMessage(value);
      }
      detailsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     */
    public Builder setPullStopped(
        com.google.cloud.lifesciences.v2beta.PullStoppedEvent.Builder builderForValue) {
      if (pullStoppedBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        pullStoppedBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     */
    public Builder mergePullStopped(com.google.cloud.lifesciences.v2beta.PullStoppedEvent value) {
      if (pullStoppedBuilder_ == null) {
        if (detailsCase_ == 21
            && details_
                != com.google.cloud.lifesciences.v2beta.PullStoppedEvent.getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.PullStoppedEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.PullStoppedEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 21) {
          pullStoppedBuilder_.mergeFrom(value);
        } else {
          pullStoppedBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     */
    public Builder clearPullStopped() {
      if (pullStoppedBuilder_ == null) {
        if (detailsCase_ == 21) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 21) {
          detailsCase_ = 0;
          details_ = null;
        }
        pullStoppedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     */
    public com.google.cloud.lifesciences.v2beta.PullStoppedEvent.Builder getPullStoppedBuilder() {
      return getPullStoppedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.PullStoppedEventOrBuilder
        getPullStoppedOrBuilder() {
      if ((detailsCase_ == 21) && (pullStoppedBuilder_ != null)) {
        return pullStoppedBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 21) {
          return (com.google.cloud.lifesciences.v2beta.PullStoppedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.PullStoppedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.PullStoppedEvent][google.cloud.lifesciences.v2beta.PullStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.PullStoppedEvent pull_stopped = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.PullStoppedEvent,
            com.google.cloud.lifesciences.v2beta.PullStoppedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.PullStoppedEventOrBuilder>
        getPullStoppedFieldBuilder() {
      if (pullStoppedBuilder_ == null) {
        if (!(detailsCase_ == 21)) {
          details_ = com.google.cloud.lifesciences.v2beta.PullStoppedEvent.getDefaultInstance();
        }
        pullStoppedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.PullStoppedEvent,
                com.google.cloud.lifesciences.v2beta.PullStoppedEvent.Builder,
                com.google.cloud.lifesciences.v2beta.PullStoppedEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.PullStoppedEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 21;
      onChanged();
      ;
      return pullStoppedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ContainerStartedEvent,
            com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.ContainerStartedEventOrBuilder>
        containerStartedBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     *
     * @return Whether the containerStarted field is set.
     */
    @java.lang.Override
    public boolean hasContainerStarted() {
      return detailsCase_ == 22;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     *
     * @return The containerStarted.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerStartedEvent getContainerStarted() {
      if (containerStartedBuilder_ == null) {
        if (detailsCase_ == 22) {
          return (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 22) {
          return containerStartedBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     */
    public Builder setContainerStarted(
        com.google.cloud.lifesciences.v2beta.ContainerStartedEvent value) {
      if (containerStartedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        containerStartedBuilder_.setMessage(value);
      }
      detailsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     */
    public Builder setContainerStarted(
        com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.Builder builderForValue) {
      if (containerStartedBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        containerStartedBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     */
    public Builder mergeContainerStarted(
        com.google.cloud.lifesciences.v2beta.ContainerStartedEvent value) {
      if (containerStartedBuilder_ == null) {
        if (detailsCase_ == 22
            && details_
                != com.google.cloud.lifesciences.v2beta.ContainerStartedEvent
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 22) {
          containerStartedBuilder_.mergeFrom(value);
        } else {
          containerStartedBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 22;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     */
    public Builder clearContainerStarted() {
      if (containerStartedBuilder_ == null) {
        if (detailsCase_ == 22) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 22) {
          detailsCase_ = 0;
          details_ = null;
        }
        containerStartedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     */
    public com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.Builder
        getContainerStartedBuilder() {
      return getContainerStartedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerStartedEventOrBuilder
        getContainerStartedOrBuilder() {
      if ((detailsCase_ == 22) && (containerStartedBuilder_ != null)) {
        return containerStartedBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 22) {
          return (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStartedEvent][google.cloud.lifesciences.v2beta.ContainerStartedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStartedEvent container_started = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ContainerStartedEvent,
            com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.ContainerStartedEventOrBuilder>
        getContainerStartedFieldBuilder() {
      if (containerStartedBuilder_ == null) {
        if (!(detailsCase_ == 22)) {
          details_ =
              com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.getDefaultInstance();
        }
        containerStartedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.ContainerStartedEvent,
                com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.Builder,
                com.google.cloud.lifesciences.v2beta.ContainerStartedEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 22;
      onChanged();
      ;
      return containerStartedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent,
            com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.ContainerStoppedEventOrBuilder>
        containerStoppedBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     *
     * @return Whether the containerStopped field is set.
     */
    @java.lang.Override
    public boolean hasContainerStopped() {
      return detailsCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     *
     * @return The containerStopped.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent getContainerStopped() {
      if (containerStoppedBuilder_ == null) {
        if (detailsCase_ == 23) {
          return (com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 23) {
          return containerStoppedBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     */
    public Builder setContainerStopped(
        com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent value) {
      if (containerStoppedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        containerStoppedBuilder_.setMessage(value);
      }
      detailsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     */
    public Builder setContainerStopped(
        com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.Builder builderForValue) {
      if (containerStoppedBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        containerStoppedBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     */
    public Builder mergeContainerStopped(
        com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent value) {
      if (containerStoppedBuilder_ == null) {
        if (detailsCase_ == 23
            && details_
                != com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 23) {
          containerStoppedBuilder_.mergeFrom(value);
        } else {
          containerStoppedBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     */
    public Builder clearContainerStopped() {
      if (containerStoppedBuilder_ == null) {
        if (detailsCase_ == 23) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 23) {
          detailsCase_ = 0;
          details_ = null;
        }
        containerStoppedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     */
    public com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.Builder
        getContainerStoppedBuilder() {
      return getContainerStoppedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerStoppedEventOrBuilder
        getContainerStoppedOrBuilder() {
      if ((detailsCase_ == 23) && (containerStoppedBuilder_ != null)) {
        return containerStoppedBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 23) {
          return (com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerStoppedEvent][google.cloud.lifesciences.v2beta.ContainerStoppedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerStoppedEvent container_stopped = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent,
            com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.ContainerStoppedEventOrBuilder>
        getContainerStoppedFieldBuilder() {
      if (containerStoppedBuilder_ == null) {
        if (!(detailsCase_ == 23)) {
          details_ =
              com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.getDefaultInstance();
        }
        containerStoppedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent,
                com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent.Builder,
                com.google.cloud.lifesciences.v2beta.ContainerStoppedEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.ContainerStoppedEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 23;
      onChanged();
      ;
      return containerStoppedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ContainerKilledEvent,
            com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.Builder,
            com.google.cloud.lifesciences.v2beta.ContainerKilledEventOrBuilder>
        containerKilledBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     *
     * @return Whether the containerKilled field is set.
     */
    @java.lang.Override
    public boolean hasContainerKilled() {
      return detailsCase_ == 24;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     *
     * @return The containerKilled.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerKilledEvent getContainerKilled() {
      if (containerKilledBuilder_ == null) {
        if (detailsCase_ == 24) {
          return (com.google.cloud.lifesciences.v2beta.ContainerKilledEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 24) {
          return containerKilledBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     */
    public Builder setContainerKilled(
        com.google.cloud.lifesciences.v2beta.ContainerKilledEvent value) {
      if (containerKilledBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        containerKilledBuilder_.setMessage(value);
      }
      detailsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     */
    public Builder setContainerKilled(
        com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.Builder builderForValue) {
      if (containerKilledBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        containerKilledBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     */
    public Builder mergeContainerKilled(
        com.google.cloud.lifesciences.v2beta.ContainerKilledEvent value) {
      if (containerKilledBuilder_ == null) {
        if (detailsCase_ == 24
            && details_
                != com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.ContainerKilledEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 24) {
          containerKilledBuilder_.mergeFrom(value);
        } else {
          containerKilledBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 24;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     */
    public Builder clearContainerKilled() {
      if (containerKilledBuilder_ == null) {
        if (detailsCase_ == 24) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 24) {
          detailsCase_ = 0;
          details_ = null;
        }
        containerKilledBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     */
    public com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.Builder
        getContainerKilledBuilder() {
      return getContainerKilledFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerKilledEventOrBuilder
        getContainerKilledOrBuilder() {
      if ((detailsCase_ == 24) && (containerKilledBuilder_ != null)) {
        return containerKilledBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 24) {
          return (com.google.cloud.lifesciences.v2beta.ContainerKilledEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.ContainerKilledEvent][google.cloud.lifesciences.v2beta.ContainerKilledEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.ContainerKilledEvent container_killed = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.ContainerKilledEvent,
            com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.Builder,
            com.google.cloud.lifesciences.v2beta.ContainerKilledEventOrBuilder>
        getContainerKilledFieldBuilder() {
      if (containerKilledBuilder_ == null) {
        if (!(detailsCase_ == 24)) {
          details_ = com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.getDefaultInstance();
        }
        containerKilledBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.ContainerKilledEvent,
                com.google.cloud.lifesciences.v2beta.ContainerKilledEvent.Builder,
                com.google.cloud.lifesciences.v2beta.ContainerKilledEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.ContainerKilledEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 24;
      onChanged();
      ;
      return containerKilledBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent,
            com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.Builder,
            com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEventOrBuilder>
        unexpectedExitStatusBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     *
     * @return Whether the unexpectedExitStatus field is set.
     */
    @java.lang.Override
    public boolean hasUnexpectedExitStatus() {
      return detailsCase_ == 25;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     *
     * @return The unexpectedExitStatus.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent
        getUnexpectedExitStatus() {
      if (unexpectedExitStatusBuilder_ == null) {
        if (detailsCase_ == 25) {
          return (com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 25) {
          return unexpectedExitStatusBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     */
    public Builder setUnexpectedExitStatus(
        com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent value) {
      if (unexpectedExitStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        unexpectedExitStatusBuilder_.setMessage(value);
      }
      detailsCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     */
    public Builder setUnexpectedExitStatus(
        com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.Builder builderForValue) {
      if (unexpectedExitStatusBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        unexpectedExitStatusBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     */
    public Builder mergeUnexpectedExitStatus(
        com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent value) {
      if (unexpectedExitStatusBuilder_ == null) {
        if (detailsCase_ == 25
            && details_
                != com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 25) {
          unexpectedExitStatusBuilder_.mergeFrom(value);
        } else {
          unexpectedExitStatusBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 25;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     */
    public Builder clearUnexpectedExitStatus() {
      if (unexpectedExitStatusBuilder_ == null) {
        if (detailsCase_ == 25) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 25) {
          detailsCase_ = 0;
          details_ = null;
        }
        unexpectedExitStatusBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     */
    public com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.Builder
        getUnexpectedExitStatusBuilder() {
      return getUnexpectedExitStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEventOrBuilder
        getUnexpectedExitStatusOrBuilder() {
      if ((detailsCase_ == 25) && (unexpectedExitStatusBuilder_ != null)) {
        return unexpectedExitStatusBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 25) {
          return (com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent][google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent].
     * </pre>
     *
     * <code>
     * .google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent unexpected_exit_status = 25;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent,
            com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.Builder,
            com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEventOrBuilder>
        getUnexpectedExitStatusFieldBuilder() {
      if (unexpectedExitStatusBuilder_ == null) {
        if (!(detailsCase_ == 25)) {
          details_ =
              com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.getDefaultInstance();
        }
        unexpectedExitStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent,
                com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent.Builder,
                com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.UnexpectedExitStatusEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 25;
      onChanged();
      ;
      return unexpectedExitStatusBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.FailedEvent,
            com.google.cloud.lifesciences.v2beta.FailedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.FailedEventOrBuilder>
        failedBuilder_;
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     *
     * @return Whether the failed field is set.
     */
    @java.lang.Override
    public boolean hasFailed() {
      return detailsCase_ == 26;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     *
     * @return The failed.
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.FailedEvent getFailed() {
      if (failedBuilder_ == null) {
        if (detailsCase_ == 26) {
          return (com.google.cloud.lifesciences.v2beta.FailedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.FailedEvent.getDefaultInstance();
      } else {
        if (detailsCase_ == 26) {
          return failedBuilder_.getMessage();
        }
        return com.google.cloud.lifesciences.v2beta.FailedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     */
    public Builder setFailed(com.google.cloud.lifesciences.v2beta.FailedEvent value) {
      if (failedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        failedBuilder_.setMessage(value);
      }
      detailsCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     */
    public Builder setFailed(
        com.google.cloud.lifesciences.v2beta.FailedEvent.Builder builderForValue) {
      if (failedBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        failedBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     */
    public Builder mergeFailed(com.google.cloud.lifesciences.v2beta.FailedEvent value) {
      if (failedBuilder_ == null) {
        if (detailsCase_ == 26
            && details_ != com.google.cloud.lifesciences.v2beta.FailedEvent.getDefaultInstance()) {
          details_ =
              com.google.cloud.lifesciences.v2beta.FailedEvent.newBuilder(
                      (com.google.cloud.lifesciences.v2beta.FailedEvent) details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 26) {
          failedBuilder_.mergeFrom(value);
        } else {
          failedBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 26;
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     */
    public Builder clearFailed() {
      if (failedBuilder_ == null) {
        if (detailsCase_ == 26) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 26) {
          detailsCase_ = 0;
          details_ = null;
        }
        failedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     */
    public com.google.cloud.lifesciences.v2beta.FailedEvent.Builder getFailedBuilder() {
      return getFailedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     */
    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.FailedEventOrBuilder getFailedOrBuilder() {
      if ((detailsCase_ == 26) && (failedBuilder_ != null)) {
        return failedBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 26) {
          return (com.google.cloud.lifesciences.v2beta.FailedEvent) details_;
        }
        return com.google.cloud.lifesciences.v2beta.FailedEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * See [google.cloud.lifesciences.v2beta.FailedEvent][google.cloud.lifesciences.v2beta.FailedEvent].
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.FailedEvent failed = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.FailedEvent,
            com.google.cloud.lifesciences.v2beta.FailedEvent.Builder,
            com.google.cloud.lifesciences.v2beta.FailedEventOrBuilder>
        getFailedFieldBuilder() {
      if (failedBuilder_ == null) {
        if (!(detailsCase_ == 26)) {
          details_ = com.google.cloud.lifesciences.v2beta.FailedEvent.getDefaultInstance();
        }
        failedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.FailedEvent,
                com.google.cloud.lifesciences.v2beta.FailedEvent.Builder,
                com.google.cloud.lifesciences.v2beta.FailedEventOrBuilder>(
                (com.google.cloud.lifesciences.v2beta.FailedEvent) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 26;
      onChanged();
      ;
      return failedBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.Event)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.Event)
  private static final com.google.cloud.lifesciences.v2beta.Event DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.Event();
  }

  public static com.google.cloud.lifesciences.v2beta.Event getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Event> PARSER =
      new com.google.protobuf.AbstractParser<Event>() {
        @java.lang.Override
        public Event parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Event> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Event> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Event getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
