/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * An event generated whenever a resource limitation or transient error
 * delays execution of a pipeline that was otherwise ready to run.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.DelayedEvent}
 */
public final class DelayedEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.DelayedEvent)
    DelayedEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DelayedEvent.newBuilder() to construct.
  private DelayedEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DelayedEvent() {
    cause_ = "";
    metrics_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DelayedEvent();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_DelayedEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_DelayedEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.DelayedEvent.class,
            com.google.cloud.lifesciences.v2beta.DelayedEvent.Builder.class);
  }

  public static final int CAUSE_FIELD_NUMBER = 1;
  private volatile java.lang.Object cause_;
  /**
   *
   *
   * <pre>
   * A textual description of the cause of the delay. The string can change
   * without notice because it is often generated by another service (such as
   * Compute Engine).
   * </pre>
   *
   * <code>string cause = 1;</code>
   *
   * @return The cause.
   */
  @java.lang.Override
  public java.lang.String getCause() {
    java.lang.Object ref = cause_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cause_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A textual description of the cause of the delay. The string can change
   * without notice because it is often generated by another service (such as
   * Compute Engine).
   * </pre>
   *
   * <code>string cause = 1;</code>
   *
   * @return The bytes for cause.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCauseBytes() {
    java.lang.Object ref = cause_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cause_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRICS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList metrics_;
  /**
   *
   *
   * <pre>
   * If the delay was caused by a resource shortage, this field lists the
   * Compute Engine metrics that are preventing this operation from running
   * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
   * known, a single `UNKNOWN` metric will be present.
   * </pre>
   *
   * <code>repeated string metrics = 2;</code>
   *
   * @return A list containing the metrics.
   */
  public com.google.protobuf.ProtocolStringList getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * If the delay was caused by a resource shortage, this field lists the
   * Compute Engine metrics that are preventing this operation from running
   * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
   * known, a single `UNKNOWN` metric will be present.
   * </pre>
   *
   * <code>repeated string metrics = 2;</code>
   *
   * @return The count of metrics.
   */
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * If the delay was caused by a resource shortage, this field lists the
   * Compute Engine metrics that are preventing this operation from running
   * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
   * known, a single `UNKNOWN` metric will be present.
   * </pre>
   *
   * <code>repeated string metrics = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The metrics at the given index.
   */
  public java.lang.String getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If the delay was caused by a resource shortage, this field lists the
   * Compute Engine metrics that are preventing this operation from running
   * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
   * known, a single `UNKNOWN` metric will be present.
   * </pre>
   *
   * <code>repeated string metrics = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the metrics at the given index.
   */
  public com.google.protobuf.ByteString getMetricsBytes(int index) {
    return metrics_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cause_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cause_);
    }
    for (int i = 0; i < metrics_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metrics_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cause_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cause_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < metrics_.size(); i++) {
        dataSize += computeStringSizeNoTag(metrics_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMetricsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.DelayedEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.DelayedEvent other =
        (com.google.cloud.lifesciences.v2beta.DelayedEvent) obj;

    if (!getCause().equals(other.getCause())) return false;
    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CAUSE_FIELD_NUMBER;
    hash = (53 * hash) + getCause().hashCode();
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.lifesciences.v2beta.DelayedEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An event generated whenever a resource limitation or transient error
   * delays execution of a pipeline that was otherwise ready to run.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.DelayedEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.DelayedEvent)
      com.google.cloud.lifesciences.v2beta.DelayedEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_DelayedEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_DelayedEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.DelayedEvent.class,
              com.google.cloud.lifesciences.v2beta.DelayedEvent.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.DelayedEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      cause_ = "";

      metrics_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_DelayedEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.DelayedEvent getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.DelayedEvent build() {
      com.google.cloud.lifesciences.v2beta.DelayedEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.DelayedEvent buildPartial() {
      com.google.cloud.lifesciences.v2beta.DelayedEvent result =
          new com.google.cloud.lifesciences.v2beta.DelayedEvent(this);
      int from_bitField0_ = bitField0_;
      result.cause_ = cause_;
      if (((bitField0_ & 0x00000001) != 0)) {
        metrics_ = metrics_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.metrics_ = metrics_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.DelayedEvent) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.DelayedEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.DelayedEvent other) {
      if (other == com.google.cloud.lifesciences.v2beta.DelayedEvent.getDefaultInstance())
        return this;
      if (!other.getCause().isEmpty()) {
        cause_ = other.cause_;
        onChanged();
      }
      if (!other.metrics_.isEmpty()) {
        if (metrics_.isEmpty()) {
          metrics_ = other.metrics_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureMetricsIsMutable();
          metrics_.addAll(other.metrics_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                cause_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMetricsIsMutable();
                metrics_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object cause_ = "";
    /**
     *
     *
     * <pre>
     * A textual description of the cause of the delay. The string can change
     * without notice because it is often generated by another service (such as
     * Compute Engine).
     * </pre>
     *
     * <code>string cause = 1;</code>
     *
     * @return The cause.
     */
    public java.lang.String getCause() {
      java.lang.Object ref = cause_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cause_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A textual description of the cause of the delay. The string can change
     * without notice because it is often generated by another service (such as
     * Compute Engine).
     * </pre>
     *
     * <code>string cause = 1;</code>
     *
     * @return The bytes for cause.
     */
    public com.google.protobuf.ByteString getCauseBytes() {
      java.lang.Object ref = cause_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cause_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A textual description of the cause of the delay. The string can change
     * without notice because it is often generated by another service (such as
     * Compute Engine).
     * </pre>
     *
     * <code>string cause = 1;</code>
     *
     * @param value The cause to set.
     * @return This builder for chaining.
     */
    public Builder setCause(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      cause_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A textual description of the cause of the delay. The string can change
     * without notice because it is often generated by another service (such as
     * Compute Engine).
     * </pre>
     *
     * <code>string cause = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCause() {

      cause_ = getDefaultInstance().getCause();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A textual description of the cause of the delay. The string can change
     * without notice because it is often generated by another service (such as
     * Compute Engine).
     * </pre>
     *
     * <code>string cause = 1;</code>
     *
     * @param value The bytes for cause to set.
     * @return This builder for chaining.
     */
    public Builder setCauseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      cause_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList metrics_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        metrics_ = new com.google.protobuf.LazyStringArrayList(metrics_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return A list containing the metrics.
     */
    public com.google.protobuf.ProtocolStringList getMetricsList() {
      return metrics_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return The count of metrics.
     */
    public int getMetricsCount() {
      return metrics_.size();
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The metrics at the given index.
     */
    public java.lang.String getMetrics(int index) {
      return metrics_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metrics at the given index.
     */
    public com.google.protobuf.ByteString getMetricsBytes(int index) {
      return metrics_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The metrics to set.
     * @return This builder for chaining.
     */
    public Builder setMetrics(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetricsIsMutable();
      metrics_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param value The metrics to add.
     * @return This builder for chaining.
     */
    public Builder addMetrics(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetricsIsMutable();
      metrics_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param values The metrics to add.
     * @return This builder for chaining.
     */
    public Builder addAllMetrics(java.lang.Iterable<java.lang.String> values) {
      ensureMetricsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetrics() {
      metrics_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the delay was caused by a resource shortage, this field lists the
     * Compute Engine metrics that are preventing this operation from running
     * (for example, `CPUS` or `INSTANCES`). If the particular metric is not
     * known, a single `UNKNOWN` metric will be present.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param value The bytes of the metrics to add.
     * @return This builder for chaining.
     */
    public Builder addMetricsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMetricsIsMutable();
      metrics_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.DelayedEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.DelayedEvent)
  private static final com.google.cloud.lifesciences.v2beta.DelayedEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.DelayedEvent();
  }

  public static com.google.cloud.lifesciences.v2beta.DelayedEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DelayedEvent> PARSER =
      new com.google.protobuf.AbstractParser<DelayedEvent>() {
        @java.lang.Override
        public DelayedEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DelayedEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DelayedEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.DelayedEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
