/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * An event generated when a container starts.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.ContainerStartedEvent}
 */
public final class ContainerStartedEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.ContainerStartedEvent)
    ContainerStartedEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ContainerStartedEvent.newBuilder() to construct.
  private ContainerStartedEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ContainerStartedEvent() {
    ipAddress_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ContainerStartedEvent();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_ContainerStartedEvent_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetPortMappings();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_ContainerStartedEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.class,
            com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.Builder.class);
  }

  public static final int ACTION_ID_FIELD_NUMBER = 1;
  private int actionId_;
  /**
   *
   *
   * <pre>
   * The numeric ID of the action that started this container.
   * </pre>
   *
   * <code>int32 action_id = 1;</code>
   *
   * @return The actionId.
   */
  @java.lang.Override
  public int getActionId() {
    return actionId_;
  }

  public static final int PORT_MAPPINGS_FIELD_NUMBER = 2;

  private static final class PortMappingsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.Integer, java.lang.Integer>newDefaultInstance(
            com.google.cloud.lifesciences.v2beta.WorkflowsProto
                .internal_static_google_cloud_lifesciences_v2beta_ContainerStartedEvent_PortMappingsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.INT32,
            0,
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer> portMappings_;

  private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer>
      internalGetPortMappings() {
    if (portMappings_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PortMappingsDefaultEntryHolder.defaultEntry);
    }
    return portMappings_;
  }

  public int getPortMappingsCount() {
    return internalGetPortMappings().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The container-to-host port mappings installed for this container. This
   * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
   * as well as any specified in the `Action` definition.
   * </pre>
   *
   * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
   */
  @java.lang.Override
  public boolean containsPortMappings(int key) {

    return internalGetPortMappings().getMap().containsKey(key);
  }
  /** Use {@link #getPortMappingsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.Integer, java.lang.Integer> getPortMappings() {
    return getPortMappingsMap();
  }
  /**
   *
   *
   * <pre>
   * The container-to-host port mappings installed for this container. This
   * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
   * as well as any specified in the `Action` definition.
   * </pre>
   *
   * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.Integer, java.lang.Integer> getPortMappingsMap() {
    return internalGetPortMappings().getMap();
  }
  /**
   *
   *
   * <pre>
   * The container-to-host port mappings installed for this container. This
   * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
   * as well as any specified in the `Action` definition.
   * </pre>
   *
   * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
   */
  @java.lang.Override
  public int getPortMappingsOrDefault(int key, int defaultValue) {

    java.util.Map<java.lang.Integer, java.lang.Integer> map = internalGetPortMappings().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The container-to-host port mappings installed for this container. This
   * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
   * as well as any specified in the `Action` definition.
   * </pre>
   *
   * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
   */
  @java.lang.Override
  public int getPortMappingsOrThrow(int key) {

    java.util.Map<java.lang.Integer, java.lang.Integer> map = internalGetPortMappings().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int IP_ADDRESS_FIELD_NUMBER = 3;
  private volatile java.lang.Object ipAddress_;
  /**
   *
   *
   * <pre>
   * The public IP address that can be used to connect to the container. This
   * field is only populated when at least one port mapping is present. If the
   * instance was created with a private address, this field will be empty even
   * if port mappings exist.
   * </pre>
   *
   * <code>string ip_address = 3;</code>
   *
   * @return The ipAddress.
   */
  @java.lang.Override
  public java.lang.String getIpAddress() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The public IP address that can be used to connect to the container. This
   * field is only populated when at least one port mapping is present. If the
   * instance was created with a private address, this field will be empty even
   * if port mappings exist.
   * </pre>
   *
   * <code>string ip_address = 3;</code>
   *
   * @return The bytes for ipAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpAddressBytes() {
    java.lang.Object ref = ipAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (actionId_ != 0) {
      output.writeInt32(1, actionId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeIntegerMapTo(
        output, internalGetPortMappings(), PortMappingsDefaultEntryHolder.defaultEntry, 2);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ipAddress_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (actionId_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, actionId_);
    }
    for (java.util.Map.Entry<java.lang.Integer, java.lang.Integer> entry :
        internalGetPortMappings().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Integer> portMappings__ =
          PortMappingsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, portMappings__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ipAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, ipAddress_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.ContainerStartedEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.ContainerStartedEvent other =
        (com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) obj;

    if (getActionId() != other.getActionId()) return false;
    if (!internalGetPortMappings().equals(other.internalGetPortMappings())) return false;
    if (!getIpAddress().equals(other.getIpAddress())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACTION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getActionId();
    if (!internalGetPortMappings().getMap().isEmpty()) {
      hash = (37 * hash) + PORT_MAPPINGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPortMappings().hashCode();
    }
    hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getIpAddress().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.lifesciences.v2beta.ContainerStartedEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An event generated when a container starts.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.ContainerStartedEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.ContainerStartedEvent)
      com.google.cloud.lifesciences.v2beta.ContainerStartedEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_ContainerStartedEvent_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetPortMappings();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutablePortMappings();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_ContainerStartedEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.class,
              com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      actionId_ = 0;

      internalGetMutablePortMappings().clear();
      ipAddress_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_ContainerStartedEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerStartedEvent getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerStartedEvent build() {
      com.google.cloud.lifesciences.v2beta.ContainerStartedEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.ContainerStartedEvent buildPartial() {
      com.google.cloud.lifesciences.v2beta.ContainerStartedEvent result =
          new com.google.cloud.lifesciences.v2beta.ContainerStartedEvent(this);
      int from_bitField0_ = bitField0_;
      result.actionId_ = actionId_;
      result.portMappings_ = internalGetPortMappings();
      result.portMappings_.makeImmutable();
      result.ipAddress_ = ipAddress_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.ContainerStartedEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.ContainerStartedEvent other) {
      if (other == com.google.cloud.lifesciences.v2beta.ContainerStartedEvent.getDefaultInstance())
        return this;
      if (other.getActionId() != 0) {
        setActionId(other.getActionId());
      }
      internalGetMutablePortMappings().mergeFrom(other.internalGetPortMappings());
      if (!other.getIpAddress().isEmpty()) {
        ipAddress_ = other.ipAddress_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                actionId_ = input.readInt32();

                break;
              } // case 8
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Integer> portMappings__ =
                    input.readMessage(
                        PortMappingsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutablePortMappings()
                    .getMutableMap()
                    .put(portMappings__.getKey(), portMappings__.getValue());
                break;
              } // case 18
            case 26:
              {
                ipAddress_ = input.readStringRequireUtf8();

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int actionId_;
    /**
     *
     *
     * <pre>
     * The numeric ID of the action that started this container.
     * </pre>
     *
     * <code>int32 action_id = 1;</code>
     *
     * @return The actionId.
     */
    @java.lang.Override
    public int getActionId() {
      return actionId_;
    }
    /**
     *
     *
     * <pre>
     * The numeric ID of the action that started this container.
     * </pre>
     *
     * <code>int32 action_id = 1;</code>
     *
     * @param value The actionId to set.
     * @return This builder for chaining.
     */
    public Builder setActionId(int value) {

      actionId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The numeric ID of the action that started this container.
     * </pre>
     *
     * <code>int32 action_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActionId() {

      actionId_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer> portMappings_;

    private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer>
        internalGetPortMappings() {
      if (portMappings_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PortMappingsDefaultEntryHolder.defaultEntry);
      }
      return portMappings_;
    }

    private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer>
        internalGetMutablePortMappings() {
      onChanged();
      ;
      if (portMappings_ == null) {
        portMappings_ =
            com.google.protobuf.MapField.newMapField(PortMappingsDefaultEntryHolder.defaultEntry);
      }
      if (!portMappings_.isMutable()) {
        portMappings_ = portMappings_.copy();
      }
      return portMappings_;
    }

    public int getPortMappingsCount() {
      return internalGetPortMappings().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The container-to-host port mappings installed for this container. This
     * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
     * as well as any specified in the `Action` definition.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
     */
    @java.lang.Override
    public boolean containsPortMappings(int key) {

      return internalGetPortMappings().getMap().containsKey(key);
    }
    /** Use {@link #getPortMappingsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.Integer, java.lang.Integer> getPortMappings() {
      return getPortMappingsMap();
    }
    /**
     *
     *
     * <pre>
     * The container-to-host port mappings installed for this container. This
     * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
     * as well as any specified in the `Action` definition.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.Integer, java.lang.Integer> getPortMappingsMap() {
      return internalGetPortMappings().getMap();
    }
    /**
     *
     *
     * <pre>
     * The container-to-host port mappings installed for this container. This
     * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
     * as well as any specified in the `Action` definition.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
     */
    @java.lang.Override
    public int getPortMappingsOrDefault(int key, int defaultValue) {

      java.util.Map<java.lang.Integer, java.lang.Integer> map = internalGetPortMappings().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The container-to-host port mappings installed for this container. This
     * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
     * as well as any specified in the `Action` definition.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
     */
    @java.lang.Override
    public int getPortMappingsOrThrow(int key) {

      java.util.Map<java.lang.Integer, java.lang.Integer> map = internalGetPortMappings().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPortMappings() {
      internalGetMutablePortMappings().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The container-to-host port mappings installed for this container. This
     * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
     * as well as any specified in the `Action` definition.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
     */
    public Builder removePortMappings(int key) {

      internalGetMutablePortMappings().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.Integer, java.lang.Integer> getMutablePortMappings() {
      return internalGetMutablePortMappings().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The container-to-host port mappings installed for this container. This
     * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
     * as well as any specified in the `Action` definition.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
     */
    public Builder putPortMappings(int key, int value) {

      internalGetMutablePortMappings().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The container-to-host port mappings installed for this container. This
     * set will contain any ports exposed using the `PUBLISH_EXPOSED_PORTS` flag
     * as well as any specified in the `Action` definition.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 2;</code>
     */
    public Builder putAllPortMappings(java.util.Map<java.lang.Integer, java.lang.Integer> values) {
      internalGetMutablePortMappings().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object ipAddress_ = "";
    /**
     *
     *
     * <pre>
     * The public IP address that can be used to connect to the container. This
     * field is only populated when at least one port mapping is present. If the
     * instance was created with a private address, this field will be empty even
     * if port mappings exist.
     * </pre>
     *
     * <code>string ip_address = 3;</code>
     *
     * @return The ipAddress.
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The public IP address that can be used to connect to the container. This
     * field is only populated when at least one port mapping is present. If the
     * instance was created with a private address, this field will be empty even
     * if port mappings exist.
     * </pre>
     *
     * <code>string ip_address = 3;</code>
     *
     * @return The bytes for ipAddress.
     */
    public com.google.protobuf.ByteString getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The public IP address that can be used to connect to the container. This
     * field is only populated when at least one port mapping is present. If the
     * instance was created with a private address, this field will be empty even
     * if port mappings exist.
     * </pre>
     *
     * <code>string ip_address = 3;</code>
     *
     * @param value The ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      ipAddress_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public IP address that can be used to connect to the container. This
     * field is only populated when at least one port mapping is present. If the
     * instance was created with a private address, this field will be empty even
     * if port mappings exist.
     * </pre>
     *
     * <code>string ip_address = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddress() {

      ipAddress_ = getDefaultInstance().getIpAddress();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public IP address that can be used to connect to the container. This
     * field is only populated when at least one port mapping is present. If the
     * instance was created with a private address, this field will be empty even
     * if port mappings exist.
     * </pre>
     *
     * <code>string ip_address = 3;</code>
     *
     * @param value The bytes for ipAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      ipAddress_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.ContainerStartedEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.ContainerStartedEvent)
  private static final com.google.cloud.lifesciences.v2beta.ContainerStartedEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.ContainerStartedEvent();
  }

  public static com.google.cloud.lifesciences.v2beta.ContainerStartedEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ContainerStartedEvent> PARSER =
      new com.google.protobuf.AbstractParser<ContainerStartedEvent>() {
        @java.lang.Override
        public ContainerStartedEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ContainerStartedEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ContainerStartedEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.ContainerStartedEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
