/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/lifesciences/v2beta/workflows.proto

package com.google.cloud.lifesciences.v2beta;

/**
 *
 *
 * <pre>
 * Specifies a single action that runs a Docker container.
 * </pre>
 *
 * Protobuf type {@code google.cloud.lifesciences.v2beta.Action}
 */
public final class Action extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.lifesciences.v2beta.Action)
    ActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Action.newBuilder() to construct.
  private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Action() {
    containerName_ = "";
    imageUri_ = "";
    commands_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    entrypoint_ = "";
    pidNamespace_ = "";
    mounts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Action();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Action_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetEnvironment();
      case 8:
        return internalGetPortMappings();
      case 10:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.lifesciences.v2beta.WorkflowsProto
        .internal_static_google_cloud_lifesciences_v2beta_Action_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.lifesciences.v2beta.Action.class,
            com.google.cloud.lifesciences.v2beta.Action.Builder.class);
  }

  public static final int CONTAINER_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object containerName_;
  /**
   *
   *
   * <pre>
   * An optional name for the container. The container hostname will be set to
   * this name, making it useful for inter-container communication. The name
   * must contain only upper and lowercase alphanumeric characters and hyphens
   * and cannot start with a hyphen.
   * </pre>
   *
   * <code>string container_name = 1;</code>
   *
   * @return The containerName.
   */
  @java.lang.Override
  public java.lang.String getContainerName() {
    java.lang.Object ref = containerName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      containerName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional name for the container. The container hostname will be set to
   * this name, making it useful for inter-container communication. The name
   * must contain only upper and lowercase alphanumeric characters and hyphens
   * and cannot start with a hyphen.
   * </pre>
   *
   * <code>string container_name = 1;</code>
   *
   * @return The bytes for containerName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerNameBytes() {
    java.lang.Object ref = containerName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      containerName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_URI_FIELD_NUMBER = 2;
  private volatile java.lang.Object imageUri_;
  /**
   *
   *
   * <pre>
   * Required. The URI to pull the container image from. Note that all images referenced
   * by actions in the pipeline are pulled before the first action runs. If
   * multiple actions reference the same image, it is only pulled once,
   * ensuring that the same image is used for all actions in a single pipeline.
   * The image URI can be either a complete host and image specification (e.g.,
   * quay.io/biocontainers/samtools), a library and image name (e.g.,
   * google/cloud-sdk) or a bare image name ('bash') to pull from the default
   * library.  No schema is required in any of these cases.
   * If the specified image is not public, the service account specified for
   * the Virtual Machine must have access to pull the images from GCR, or
   * appropriate credentials must be specified in the
   * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials] field.
   * </pre>
   *
   * <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The imageUri.
   */
  @java.lang.Override
  public java.lang.String getImageUri() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The URI to pull the container image from. Note that all images referenced
   * by actions in the pipeline are pulled before the first action runs. If
   * multiple actions reference the same image, it is only pulled once,
   * ensuring that the same image is used for all actions in a single pipeline.
   * The image URI can be either a complete host and image specification (e.g.,
   * quay.io/biocontainers/samtools), a library and image name (e.g.,
   * google/cloud-sdk) or a bare image name ('bash') to pull from the default
   * library.  No schema is required in any of these cases.
   * If the specified image is not public, the service account specified for
   * the Virtual Machine must have access to pull the images from GCR, or
   * appropriate credentials must be specified in the
   * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials] field.
   * </pre>
   *
   * <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for imageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUriBytes() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMANDS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList commands_;
  /**
   *
   *
   * <pre>
   * If specified, overrides the `CMD` specified in the container. If the
   * container also has an `ENTRYPOINT` the values are used as entrypoint
   * arguments. Otherwise, they are used as a command and arguments to run
   * inside the container.
   * </pre>
   *
   * <code>repeated string commands = 3;</code>
   *
   * @return A list containing the commands.
   */
  public com.google.protobuf.ProtocolStringList getCommandsList() {
    return commands_;
  }
  /**
   *
   *
   * <pre>
   * If specified, overrides the `CMD` specified in the container. If the
   * container also has an `ENTRYPOINT` the values are used as entrypoint
   * arguments. Otherwise, they are used as a command and arguments to run
   * inside the container.
   * </pre>
   *
   * <code>repeated string commands = 3;</code>
   *
   * @return The count of commands.
   */
  public int getCommandsCount() {
    return commands_.size();
  }
  /**
   *
   *
   * <pre>
   * If specified, overrides the `CMD` specified in the container. If the
   * container also has an `ENTRYPOINT` the values are used as entrypoint
   * arguments. Otherwise, they are used as a command and arguments to run
   * inside the container.
   * </pre>
   *
   * <code>repeated string commands = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The commands at the given index.
   */
  public java.lang.String getCommands(int index) {
    return commands_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If specified, overrides the `CMD` specified in the container. If the
   * container also has an `ENTRYPOINT` the values are used as entrypoint
   * arguments. Otherwise, they are used as a command and arguments to run
   * inside the container.
   * </pre>
   *
   * <code>repeated string commands = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the commands at the given index.
   */
  public com.google.protobuf.ByteString getCommandsBytes(int index) {
    return commands_.getByteString(index);
  }

  public static final int ENTRYPOINT_FIELD_NUMBER = 4;
  private volatile java.lang.Object entrypoint_;
  /**
   *
   *
   * <pre>
   * If specified, overrides the `ENTRYPOINT` specified in the container.
   * </pre>
   *
   * <code>string entrypoint = 4;</code>
   *
   * @return The entrypoint.
   */
  @java.lang.Override
  public java.lang.String getEntrypoint() {
    java.lang.Object ref = entrypoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      entrypoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If specified, overrides the `ENTRYPOINT` specified in the container.
   * </pre>
   *
   * <code>string entrypoint = 4;</code>
   *
   * @return The bytes for entrypoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEntrypointBytes() {
    java.lang.Object ref = entrypoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      entrypoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 5;

  private static final class EnvironmentDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.lifesciences.v2beta.WorkflowsProto
                .internal_static_google_cloud_lifesciences_v2beta_Action_EnvironmentEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> environment_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvironment() {
    if (environment_ == null) {
      return com.google.protobuf.MapField.emptyMapField(EnvironmentDefaultEntryHolder.defaultEntry);
    }
    return environment_;
  }

  public int getEnvironmentCount() {
    return internalGetEnvironment().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The environment to pass into the container. This environment is merged
   * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
   * message, overwriting any duplicate values.
   * In addition to the values passed here, a few other values are
   * automatically injected into the environment. These cannot be hidden or
   * overwritten.
   * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
   * because an action has exited with a non-zero status (and did not have the
   * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
   * debug or logging actions should execute.
   * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
   * non-background action that executed. This can be used by workflow engine
   * authors to determine whether an individual action has succeeded or failed.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment = 5;</code>
   */
  @java.lang.Override
  public boolean containsEnvironment(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEnvironment().getMap().containsKey(key);
  }
  /** Use {@link #getEnvironmentMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
    return getEnvironmentMap();
  }
  /**
   *
   *
   * <pre>
   * The environment to pass into the container. This environment is merged
   * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
   * message, overwriting any duplicate values.
   * In addition to the values passed here, a few other values are
   * automatically injected into the environment. These cannot be hidden or
   * overwritten.
   * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
   * because an action has exited with a non-zero status (and did not have the
   * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
   * debug or logging actions should execute.
   * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
   * non-background action that executed. This can be used by workflow engine
   * authors to determine whether an individual action has succeeded or failed.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentMap() {
    return internalGetEnvironment().getMap();
  }
  /**
   *
   *
   * <pre>
   * The environment to pass into the container. This environment is merged
   * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
   * message, overwriting any duplicate values.
   * In addition to the values passed here, a few other values are
   * automatically injected into the environment. These cannot be hidden or
   * overwritten.
   * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
   * because an action has exited with a non-zero status (and did not have the
   * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
   * debug or logging actions should execute.
   * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
   * non-background action that executed. This can be used by workflow engine
   * authors to determine whether an individual action has succeeded or failed.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironment().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The environment to pass into the container. This environment is merged
   * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
   * message, overwriting any duplicate values.
   * In addition to the values passed here, a few other values are
   * automatically injected into the environment. These cannot be hidden or
   * overwritten.
   * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
   * because an action has exited with a non-zero status (and did not have the
   * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
   * debug or logging actions should execute.
   * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
   * non-background action that executed. This can be used by workflow engine
   * authors to determine whether an individual action has succeeded or failed.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironment().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PID_NAMESPACE_FIELD_NUMBER = 6;
  private volatile java.lang.Object pidNamespace_;
  /**
   *
   *
   * <pre>
   * An optional identifier for a PID namespace to run the action inside.
   * Multiple actions should use the same string to share a namespace.  If
   * unspecified, a separate isolated namespace is used.
   * </pre>
   *
   * <code>string pid_namespace = 6;</code>
   *
   * @return The pidNamespace.
   */
  @java.lang.Override
  public java.lang.String getPidNamespace() {
    java.lang.Object ref = pidNamespace_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pidNamespace_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional identifier for a PID namespace to run the action inside.
   * Multiple actions should use the same string to share a namespace.  If
   * unspecified, a separate isolated namespace is used.
   * </pre>
   *
   * <code>string pid_namespace = 6;</code>
   *
   * @return The bytes for pidNamespace.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPidNamespaceBytes() {
    java.lang.Object ref = pidNamespace_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pidNamespace_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_MAPPINGS_FIELD_NUMBER = 8;

  private static final class PortMappingsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.Integer, java.lang.Integer>newDefaultInstance(
            com.google.cloud.lifesciences.v2beta.WorkflowsProto
                .internal_static_google_cloud_lifesciences_v2beta_Action_PortMappingsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.INT32,
            0,
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer> portMappings_;

  private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer>
      internalGetPortMappings() {
    if (portMappings_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PortMappingsDefaultEntryHolder.defaultEntry);
    }
    return portMappings_;
  }

  public int getPortMappingsCount() {
    return internalGetPortMappings().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map of containers to host port mappings for this container. If the
   * container already specifies exposed ports, use the
   * `PUBLISH_EXPOSED_PORTS` flag instead.
   * The host port number must be less than 65536. If it is zero, an unused
   * random port is assigned. To determine the resulting port number, consult
   * the `ContainerStartedEvent` in the operation metadata.
   * </pre>
   *
   * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
   */
  @java.lang.Override
  public boolean containsPortMappings(int key) {

    return internalGetPortMappings().getMap().containsKey(key);
  }
  /** Use {@link #getPortMappingsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.Integer, java.lang.Integer> getPortMappings() {
    return getPortMappingsMap();
  }
  /**
   *
   *
   * <pre>
   * A map of containers to host port mappings for this container. If the
   * container already specifies exposed ports, use the
   * `PUBLISH_EXPOSED_PORTS` flag instead.
   * The host port number must be less than 65536. If it is zero, an unused
   * random port is assigned. To determine the resulting port number, consult
   * the `ContainerStartedEvent` in the operation metadata.
   * </pre>
   *
   * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.Integer, java.lang.Integer> getPortMappingsMap() {
    return internalGetPortMappings().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map of containers to host port mappings for this container. If the
   * container already specifies exposed ports, use the
   * `PUBLISH_EXPOSED_PORTS` flag instead.
   * The host port number must be less than 65536. If it is zero, an unused
   * random port is assigned. To determine the resulting port number, consult
   * the `ContainerStartedEvent` in the operation metadata.
   * </pre>
   *
   * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
   */
  @java.lang.Override
  public int getPortMappingsOrDefault(int key, int defaultValue) {

    java.util.Map<java.lang.Integer, java.lang.Integer> map = internalGetPortMappings().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map of containers to host port mappings for this container. If the
   * container already specifies exposed ports, use the
   * `PUBLISH_EXPOSED_PORTS` flag instead.
   * The host port number must be less than 65536. If it is zero, an unused
   * random port is assigned. To determine the resulting port number, consult
   * the `ContainerStartedEvent` in the operation metadata.
   * </pre>
   *
   * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
   */
  @java.lang.Override
  public int getPortMappingsOrThrow(int key) {

    java.util.Map<java.lang.Integer, java.lang.Integer> map = internalGetPortMappings().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MOUNTS_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.lifesciences.v2beta.Mount> mounts_;
  /**
   *
   *
   * <pre>
   * A list of mounts to make available to the action.
   * In addition to the values specified here, every action has a special
   * virtual disk mounted under `/google` that contains log files and other
   * operational components.
   * &lt;ul&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
   *   standard error of all actions run as part of the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
   *   each individual action's standard output.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
   *   each individual action's standard error output.&lt;/li&gt;
   * &lt;/ul&gt;
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.lifesciences.v2beta.Mount> getMountsList() {
    return mounts_;
  }
  /**
   *
   *
   * <pre>
   * A list of mounts to make available to the action.
   * In addition to the values specified here, every action has a special
   * virtual disk mounted under `/google` that contains log files and other
   * operational components.
   * &lt;ul&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
   *   standard error of all actions run as part of the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
   *   each individual action's standard output.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
   *   each individual action's standard error output.&lt;/li&gt;
   * &lt;/ul&gt;
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.lifesciences.v2beta.MountOrBuilder>
      getMountsOrBuilderList() {
    return mounts_;
  }
  /**
   *
   *
   * <pre>
   * A list of mounts to make available to the action.
   * In addition to the values specified here, every action has a special
   * virtual disk mounted under `/google` that contains log files and other
   * operational components.
   * &lt;ul&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
   *   standard error of all actions run as part of the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
   *   each individual action's standard output.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
   *   each individual action's standard error output.&lt;/li&gt;
   * &lt;/ul&gt;
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
   */
  @java.lang.Override
  public int getMountsCount() {
    return mounts_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of mounts to make available to the action.
   * In addition to the values specified here, every action has a special
   * virtual disk mounted under `/google` that contains log files and other
   * operational components.
   * &lt;ul&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
   *   standard error of all actions run as part of the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
   *   each individual action's standard output.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
   *   each individual action's standard error output.&lt;/li&gt;
   * &lt;/ul&gt;
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Mount getMounts(int index) {
    return mounts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of mounts to make available to the action.
   * In addition to the values specified here, every action has a special
   * virtual disk mounted under `/google` that contains log files and other
   * operational components.
   * &lt;ul&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
   *   standard error of all actions run as part of the pipeline
   *   execution.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
   *   each individual action's standard output.&lt;/li&gt;
   *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
   *   each individual action's standard error output.&lt;/li&gt;
   * &lt;/ul&gt;
   * </pre>
   *
   * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.MountOrBuilder getMountsOrBuilder(int index) {
    return mounts_.get(index);
  }

  public static final int LABELS_FIELD_NUMBER = 10;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.lifesciences.v2beta.WorkflowsProto
                .internal_static_google_cloud_lifesciences_v2beta_Action_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to associate with the action. This field is provided to assist
   * workflow engine authors in identifying actions (for example, to indicate
   * what sort of action they perform, such as localization or debugging).
   * They are returned in the operation metadata, but are otherwise ignored.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to associate with the action. This field is provided to assist
   * workflow engine authors in identifying actions (for example, to indicate
   * what sort of action they perform, such as localization or debugging).
   * They are returned in the operation metadata, but are otherwise ignored.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to associate with the action. This field is provided to assist
   * workflow engine authors in identifying actions (for example, to indicate
   * what sort of action they perform, such as localization or debugging).
   * They are returned in the operation metadata, but are otherwise ignored.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to associate with the action. This field is provided to assist
   * workflow engine authors in identifying actions (for example, to indicate
   * what sort of action they perform, such as localization or debugging).
   * They are returned in the operation metadata, but are otherwise ignored.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREDENTIALS_FIELD_NUMBER = 11;
  private com.google.cloud.lifesciences.v2beta.Secret credentials_;
  /**
   *
   *
   * <pre>
   * If the specified image is hosted on a private registry other than Google
   * Container Registry, the credentials required to pull the image must be
   * specified here as an encrypted secret.
   * The secret must decrypt to a JSON-encoded dictionary containing both
   * `username` and `password` keys.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
   *
   * @return Whether the credentials field is set.
   */
  @java.lang.Override
  public boolean hasCredentials() {
    return credentials_ != null;
  }
  /**
   *
   *
   * <pre>
   * If the specified image is hosted on a private registry other than Google
   * Container Registry, the credentials required to pull the image must be
   * specified here as an encrypted secret.
   * The secret must decrypt to a JSON-encoded dictionary containing both
   * `username` and `password` keys.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
   *
   * @return The credentials.
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Secret getCredentials() {
    return credentials_ == null
        ? com.google.cloud.lifesciences.v2beta.Secret.getDefaultInstance()
        : credentials_;
  }
  /**
   *
   *
   * <pre>
   * If the specified image is hosted on a private registry other than Google
   * Container Registry, the credentials required to pull the image must be
   * specified here as an encrypted secret.
   * The secret must decrypt to a JSON-encoded dictionary containing both
   * `username` and `password` keys.
   * </pre>
   *
   * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.SecretOrBuilder getCredentialsOrBuilder() {
    return getCredentials();
  }

  public static final int TIMEOUT_FIELD_NUMBER = 12;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * The maximum amount of time to give the action to complete. If the action
   * fails to complete before the timeout, it will be terminated and the exit
   * status will be non-zero. The pipeline will continue or terminate based
   * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time to give the action to complete. If the action
   * fails to complete before the timeout, it will be terminated and the exit
   * status will be non-zero. The pipeline will continue or terminate based
   * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time to give the action to complete. If the action
   * fails to complete before the timeout, it will be terminated and the exit
   * status will be non-zero. The pipeline will continue or terminate based
   * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return getTimeout();
  }

  public static final int IGNORE_EXIT_STATUS_FIELD_NUMBER = 13;
  private boolean ignoreExitStatus_;
  /**
   *
   *
   * <pre>
   * Normally, a non-zero exit status causes the pipeline to fail. This flag
   * allows execution of other actions to continue instead.
   * </pre>
   *
   * <code>bool ignore_exit_status = 13;</code>
   *
   * @return The ignoreExitStatus.
   */
  @java.lang.Override
  public boolean getIgnoreExitStatus() {
    return ignoreExitStatus_;
  }

  public static final int RUN_IN_BACKGROUND_FIELD_NUMBER = 14;
  private boolean runInBackground_;
  /**
   *
   *
   * <pre>
   * This flag allows an action to continue running in the background while
   * executing subsequent actions. This is useful to provide services to
   * other actions (or to provide debugging support tools like SSH servers).
   * </pre>
   *
   * <code>bool run_in_background = 14;</code>
   *
   * @return The runInBackground.
   */
  @java.lang.Override
  public boolean getRunInBackground() {
    return runInBackground_;
  }

  public static final int ALWAYS_RUN_FIELD_NUMBER = 15;
  private boolean alwaysRun_;
  /**
   *
   *
   * <pre>
   * By default, after an action fails, no further actions are run. This flag
   * indicates that this action must be run even if the pipeline has already
   * failed. This is useful for actions that copy output files off of the VM
   * or for debugging. Note that no actions will be run if image prefetching
   * fails.
   * </pre>
   *
   * <code>bool always_run = 15;</code>
   *
   * @return The alwaysRun.
   */
  @java.lang.Override
  public boolean getAlwaysRun() {
    return alwaysRun_;
  }

  public static final int ENABLE_FUSE_FIELD_NUMBER = 16;
  private boolean enableFuse_;
  /**
   *
   *
   * <pre>
   * Enable access to the FUSE device for this action. Filesystems can then
   * be mounted into disks shared with other actions. The other actions do
   * not need the `enable_fuse` flag to access the mounted filesystem.
   * This has the effect of causing the container to be executed with
   * `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
   * for containers you trust.
   * </pre>
   *
   * <code>bool enable_fuse = 16;</code>
   *
   * @return The enableFuse.
   */
  @java.lang.Override
  public boolean getEnableFuse() {
    return enableFuse_;
  }

  public static final int PUBLISH_EXPOSED_PORTS_FIELD_NUMBER = 17;
  private boolean publishExposedPorts_;
  /**
   *
   *
   * <pre>
   * Exposes all ports specified by `EXPOSE` statements in the container. To
   * discover the host side port numbers, consult the `ACTION_STARTED` event
   * in the operation metadata.
   * </pre>
   *
   * <code>bool publish_exposed_ports = 17;</code>
   *
   * @return The publishExposedPorts.
   */
  @java.lang.Override
  public boolean getPublishExposedPorts() {
    return publishExposedPorts_;
  }

  public static final int DISABLE_IMAGE_PREFETCH_FIELD_NUMBER = 18;
  private boolean disableImagePrefetch_;
  /**
   *
   *
   * <pre>
   * All container images are typically downloaded before any actions are
   * executed. This helps prevent typos in URIs or issues like lack of disk
   * space from wasting large amounts of compute resources.
   * If set, this flag prevents the worker from downloading the image until
   * just before the action is executed.
   * </pre>
   *
   * <code>bool disable_image_prefetch = 18;</code>
   *
   * @return The disableImagePrefetch.
   */
  @java.lang.Override
  public boolean getDisableImagePrefetch() {
    return disableImagePrefetch_;
  }

  public static final int DISABLE_STANDARD_ERROR_CAPTURE_FIELD_NUMBER = 19;
  private boolean disableStandardErrorCapture_;
  /**
   *
   *
   * <pre>
   * A small portion of the container's standard error stream is typically
   * captured and returned inside the `ContainerStoppedEvent`. Setting this
   * flag disables this functionality.
   * </pre>
   *
   * <code>bool disable_standard_error_capture = 19;</code>
   *
   * @return The disableStandardErrorCapture.
   */
  @java.lang.Override
  public boolean getDisableStandardErrorCapture() {
    return disableStandardErrorCapture_;
  }

  public static final int BLOCK_EXTERNAL_NETWORK_FIELD_NUMBER = 20;
  private boolean blockExternalNetwork_;
  /**
   *
   *
   * <pre>
   * Prevents the container from accessing the external network.
   * </pre>
   *
   * <code>bool block_external_network = 20;</code>
   *
   * @return The blockExternalNetwork.
   */
  @java.lang.Override
  public boolean getBlockExternalNetwork() {
    return blockExternalNetwork_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, containerName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, imageUri_);
    }
    for (int i = 0; i < commands_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, commands_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, entrypoint_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetEnvironment(), EnvironmentDefaultEntryHolder.defaultEntry, 5);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pidNamespace_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, pidNamespace_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeIntegerMapTo(
        output, internalGetPortMappings(), PortMappingsDefaultEntryHolder.defaultEntry, 8);
    for (int i = 0; i < mounts_.size(); i++) {
      output.writeMessage(9, mounts_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 10);
    if (credentials_ != null) {
      output.writeMessage(11, getCredentials());
    }
    if (timeout_ != null) {
      output.writeMessage(12, getTimeout());
    }
    if (ignoreExitStatus_ != false) {
      output.writeBool(13, ignoreExitStatus_);
    }
    if (runInBackground_ != false) {
      output.writeBool(14, runInBackground_);
    }
    if (alwaysRun_ != false) {
      output.writeBool(15, alwaysRun_);
    }
    if (enableFuse_ != false) {
      output.writeBool(16, enableFuse_);
    }
    if (publishExposedPorts_ != false) {
      output.writeBool(17, publishExposedPorts_);
    }
    if (disableImagePrefetch_ != false) {
      output.writeBool(18, disableImagePrefetch_);
    }
    if (disableStandardErrorCapture_ != false) {
      output.writeBool(19, disableStandardErrorCapture_);
    }
    if (blockExternalNetwork_ != false) {
      output.writeBool(20, blockExternalNetwork_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, containerName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, imageUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < commands_.size(); i++) {
        dataSize += computeStringSizeNoTag(commands_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCommandsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, entrypoint_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvironment().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environment__ =
          EnvironmentDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, environment__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pidNamespace_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, pidNamespace_);
    }
    for (java.util.Map.Entry<java.lang.Integer, java.lang.Integer> entry :
        internalGetPortMappings().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Integer> portMappings__ =
          PortMappingsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, portMappings__);
    }
    for (int i = 0; i < mounts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, mounts_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, labels__);
    }
    if (credentials_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCredentials());
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getTimeout());
    }
    if (ignoreExitStatus_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, ignoreExitStatus_);
    }
    if (runInBackground_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, runInBackground_);
    }
    if (alwaysRun_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, alwaysRun_);
    }
    if (enableFuse_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, enableFuse_);
    }
    if (publishExposedPorts_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(17, publishExposedPorts_);
    }
    if (disableImagePrefetch_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, disableImagePrefetch_);
    }
    if (disableStandardErrorCapture_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(19, disableStandardErrorCapture_);
    }
    if (blockExternalNetwork_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, blockExternalNetwork_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.lifesciences.v2beta.Action)) {
      return super.equals(obj);
    }
    com.google.cloud.lifesciences.v2beta.Action other =
        (com.google.cloud.lifesciences.v2beta.Action) obj;

    if (!getContainerName().equals(other.getContainerName())) return false;
    if (!getImageUri().equals(other.getImageUri())) return false;
    if (!getCommandsList().equals(other.getCommandsList())) return false;
    if (!getEntrypoint().equals(other.getEntrypoint())) return false;
    if (!internalGetEnvironment().equals(other.internalGetEnvironment())) return false;
    if (!getPidNamespace().equals(other.getPidNamespace())) return false;
    if (!internalGetPortMappings().equals(other.internalGetPortMappings())) return false;
    if (!getMountsList().equals(other.getMountsList())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCredentials() != other.hasCredentials()) return false;
    if (hasCredentials()) {
      if (!getCredentials().equals(other.getCredentials())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (getIgnoreExitStatus() != other.getIgnoreExitStatus()) return false;
    if (getRunInBackground() != other.getRunInBackground()) return false;
    if (getAlwaysRun() != other.getAlwaysRun()) return false;
    if (getEnableFuse() != other.getEnableFuse()) return false;
    if (getPublishExposedPorts() != other.getPublishExposedPorts()) return false;
    if (getDisableImagePrefetch() != other.getDisableImagePrefetch()) return false;
    if (getDisableStandardErrorCapture() != other.getDisableStandardErrorCapture()) return false;
    if (getBlockExternalNetwork() != other.getBlockExternalNetwork()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONTAINER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getContainerName().hashCode();
    hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImageUri().hashCode();
    if (getCommandsCount() > 0) {
      hash = (37 * hash) + COMMANDS_FIELD_NUMBER;
      hash = (53 * hash) + getCommandsList().hashCode();
    }
    hash = (37 * hash) + ENTRYPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEntrypoint().hashCode();
    if (!internalGetEnvironment().getMap().isEmpty()) {
      hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvironment().hashCode();
    }
    hash = (37 * hash) + PID_NAMESPACE_FIELD_NUMBER;
    hash = (53 * hash) + getPidNamespace().hashCode();
    if (!internalGetPortMappings().getMap().isEmpty()) {
      hash = (37 * hash) + PORT_MAPPINGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPortMappings().hashCode();
    }
    if (getMountsCount() > 0) {
      hash = (37 * hash) + MOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getMountsList().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCredentials()) {
      hash = (37 * hash) + CREDENTIALS_FIELD_NUMBER;
      hash = (53 * hash) + getCredentials().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + IGNORE_EXIT_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreExitStatus());
    hash = (37 * hash) + RUN_IN_BACKGROUND_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunInBackground());
    hash = (37 * hash) + ALWAYS_RUN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAlwaysRun());
    hash = (37 * hash) + ENABLE_FUSE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableFuse());
    hash = (37 * hash) + PUBLISH_EXPOSED_PORTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPublishExposedPorts());
    hash = (37 * hash) + DISABLE_IMAGE_PREFETCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableImagePrefetch());
    hash = (37 * hash) + DISABLE_STANDARD_ERROR_CAPTURE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableStandardErrorCapture());
    hash = (37 * hash) + BLOCK_EXTERNAL_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBlockExternalNetwork());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.lifesciences.v2beta.Action parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.lifesciences.v2beta.Action prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies a single action that runs a Docker container.
   * </pre>
   *
   * Protobuf type {@code google.cloud.lifesciences.v2beta.Action}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.lifesciences.v2beta.Action)
      com.google.cloud.lifesciences.v2beta.ActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Action_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetEnvironment();
        case 8:
          return internalGetPortMappings();
        case 10:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableEnvironment();
        case 8:
          return internalGetMutablePortMappings();
        case 10:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.lifesciences.v2beta.Action.class,
              com.google.cloud.lifesciences.v2beta.Action.Builder.class);
    }

    // Construct using com.google.cloud.lifesciences.v2beta.Action.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      containerName_ = "";

      imageUri_ = "";

      commands_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      entrypoint_ = "";

      internalGetMutableEnvironment().clear();
      pidNamespace_ = "";

      internalGetMutablePortMappings().clear();
      if (mountsBuilder_ == null) {
        mounts_ = java.util.Collections.emptyList();
      } else {
        mounts_ = null;
        mountsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().clear();
      if (credentialsBuilder_ == null) {
        credentials_ = null;
      } else {
        credentials_ = null;
        credentialsBuilder_ = null;
      }
      if (timeoutBuilder_ == null) {
        timeout_ = null;
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }
      ignoreExitStatus_ = false;

      runInBackground_ = false;

      alwaysRun_ = false;

      enableFuse_ = false;

      publishExposedPorts_ = false;

      disableImagePrefetch_ = false;

      disableStandardErrorCapture_ = false;

      blockExternalNetwork_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.lifesciences.v2beta.WorkflowsProto
          .internal_static_google_cloud_lifesciences_v2beta_Action_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Action getDefaultInstanceForType() {
      return com.google.cloud.lifesciences.v2beta.Action.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Action build() {
      com.google.cloud.lifesciences.v2beta.Action result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.lifesciences.v2beta.Action buildPartial() {
      com.google.cloud.lifesciences.v2beta.Action result =
          new com.google.cloud.lifesciences.v2beta.Action(this);
      int from_bitField0_ = bitField0_;
      result.containerName_ = containerName_;
      result.imageUri_ = imageUri_;
      if (((bitField0_ & 0x00000001) != 0)) {
        commands_ = commands_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.commands_ = commands_;
      result.entrypoint_ = entrypoint_;
      result.environment_ = internalGetEnvironment();
      result.environment_.makeImmutable();
      result.pidNamespace_ = pidNamespace_;
      result.portMappings_ = internalGetPortMappings();
      result.portMappings_.makeImmutable();
      if (mountsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          mounts_ = java.util.Collections.unmodifiableList(mounts_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.mounts_ = mounts_;
      } else {
        result.mounts_ = mountsBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (credentialsBuilder_ == null) {
        result.credentials_ = credentials_;
      } else {
        result.credentials_ = credentialsBuilder_.build();
      }
      if (timeoutBuilder_ == null) {
        result.timeout_ = timeout_;
      } else {
        result.timeout_ = timeoutBuilder_.build();
      }
      result.ignoreExitStatus_ = ignoreExitStatus_;
      result.runInBackground_ = runInBackground_;
      result.alwaysRun_ = alwaysRun_;
      result.enableFuse_ = enableFuse_;
      result.publishExposedPorts_ = publishExposedPorts_;
      result.disableImagePrefetch_ = disableImagePrefetch_;
      result.disableStandardErrorCapture_ = disableStandardErrorCapture_;
      result.blockExternalNetwork_ = blockExternalNetwork_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.lifesciences.v2beta.Action) {
        return mergeFrom((com.google.cloud.lifesciences.v2beta.Action) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.lifesciences.v2beta.Action other) {
      if (other == com.google.cloud.lifesciences.v2beta.Action.getDefaultInstance()) return this;
      if (!other.getContainerName().isEmpty()) {
        containerName_ = other.containerName_;
        onChanged();
      }
      if (!other.getImageUri().isEmpty()) {
        imageUri_ = other.imageUri_;
        onChanged();
      }
      if (!other.commands_.isEmpty()) {
        if (commands_.isEmpty()) {
          commands_ = other.commands_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureCommandsIsMutable();
          commands_.addAll(other.commands_);
        }
        onChanged();
      }
      if (!other.getEntrypoint().isEmpty()) {
        entrypoint_ = other.entrypoint_;
        onChanged();
      }
      internalGetMutableEnvironment().mergeFrom(other.internalGetEnvironment());
      if (!other.getPidNamespace().isEmpty()) {
        pidNamespace_ = other.pidNamespace_;
        onChanged();
      }
      internalGetMutablePortMappings().mergeFrom(other.internalGetPortMappings());
      if (mountsBuilder_ == null) {
        if (!other.mounts_.isEmpty()) {
          if (mounts_.isEmpty()) {
            mounts_ = other.mounts_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureMountsIsMutable();
            mounts_.addAll(other.mounts_);
          }
          onChanged();
        }
      } else {
        if (!other.mounts_.isEmpty()) {
          if (mountsBuilder_.isEmpty()) {
            mountsBuilder_.dispose();
            mountsBuilder_ = null;
            mounts_ = other.mounts_;
            bitField0_ = (bitField0_ & ~0x00000008);
            mountsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMountsFieldBuilder()
                    : null;
          } else {
            mountsBuilder_.addAllMessages(other.mounts_);
          }
        }
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasCredentials()) {
        mergeCredentials(other.getCredentials());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getIgnoreExitStatus() != false) {
        setIgnoreExitStatus(other.getIgnoreExitStatus());
      }
      if (other.getRunInBackground() != false) {
        setRunInBackground(other.getRunInBackground());
      }
      if (other.getAlwaysRun() != false) {
        setAlwaysRun(other.getAlwaysRun());
      }
      if (other.getEnableFuse() != false) {
        setEnableFuse(other.getEnableFuse());
      }
      if (other.getPublishExposedPorts() != false) {
        setPublishExposedPorts(other.getPublishExposedPorts());
      }
      if (other.getDisableImagePrefetch() != false) {
        setDisableImagePrefetch(other.getDisableImagePrefetch());
      }
      if (other.getDisableStandardErrorCapture() != false) {
        setDisableStandardErrorCapture(other.getDisableStandardErrorCapture());
      }
      if (other.getBlockExternalNetwork() != false) {
        setBlockExternalNetwork(other.getBlockExternalNetwork());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                containerName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                imageUri_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCommandsIsMutable();
                commands_.add(s);
                break;
              } // case 26
            case 34:
              {
                entrypoint_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environment__ =
                    input.readMessage(
                        EnvironmentDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableEnvironment()
                    .getMutableMap()
                    .put(environment__.getKey(), environment__.getValue());
                break;
              } // case 42
            case 50:
              {
                pidNamespace_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.Integer, java.lang.Integer> portMappings__ =
                    input.readMessage(
                        PortMappingsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutablePortMappings()
                    .getMutableMap()
                    .put(portMappings__.getKey(), portMappings__.getValue());
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.lifesciences.v2beta.Mount m =
                    input.readMessage(
                        com.google.cloud.lifesciences.v2beta.Mount.parser(), extensionRegistry);
                if (mountsBuilder_ == null) {
                  ensureMountsIsMutable();
                  mounts_.add(m);
                } else {
                  mountsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getCredentialsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 90
            case 98:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 104:
              {
                ignoreExitStatus_ = input.readBool();

                break;
              } // case 104
            case 112:
              {
                runInBackground_ = input.readBool();

                break;
              } // case 112
            case 120:
              {
                alwaysRun_ = input.readBool();

                break;
              } // case 120
            case 128:
              {
                enableFuse_ = input.readBool();

                break;
              } // case 128
            case 136:
              {
                publishExposedPorts_ = input.readBool();

                break;
              } // case 136
            case 144:
              {
                disableImagePrefetch_ = input.readBool();

                break;
              } // case 144
            case 152:
              {
                disableStandardErrorCapture_ = input.readBool();

                break;
              } // case 152
            case 160:
              {
                blockExternalNetwork_ = input.readBool();

                break;
              } // case 160
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object containerName_ = "";
    /**
     *
     *
     * <pre>
     * An optional name for the container. The container hostname will be set to
     * this name, making it useful for inter-container communication. The name
     * must contain only upper and lowercase alphanumeric characters and hyphens
     * and cannot start with a hyphen.
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @return The containerName.
     */
    public java.lang.String getContainerName() {
      java.lang.Object ref = containerName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        containerName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional name for the container. The container hostname will be set to
     * this name, making it useful for inter-container communication. The name
     * must contain only upper and lowercase alphanumeric characters and hyphens
     * and cannot start with a hyphen.
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @return The bytes for containerName.
     */
    public com.google.protobuf.ByteString getContainerNameBytes() {
      java.lang.Object ref = containerName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        containerName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional name for the container. The container hostname will be set to
     * this name, making it useful for inter-container communication. The name
     * must contain only upper and lowercase alphanumeric characters and hyphens
     * and cannot start with a hyphen.
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @param value The containerName to set.
     * @return This builder for chaining.
     */
    public Builder setContainerName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      containerName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional name for the container. The container hostname will be set to
     * this name, making it useful for inter-container communication. The name
     * must contain only upper and lowercase alphanumeric characters and hyphens
     * and cannot start with a hyphen.
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerName() {

      containerName_ = getDefaultInstance().getContainerName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional name for the container. The container hostname will be set to
     * this name, making it useful for inter-container communication. The name
     * must contain only upper and lowercase alphanumeric characters and hyphens
     * and cannot start with a hyphen.
     * </pre>
     *
     * <code>string container_name = 1;</code>
     *
     * @param value The bytes for containerName to set.
     * @return This builder for chaining.
     */
    public Builder setContainerNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      containerName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object imageUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from. Note that all images referenced
     * by actions in the pipeline are pulled before the first action runs. If
     * multiple actions reference the same image, it is only pulled once,
     * ensuring that the same image is used for all actions in a single pipeline.
     * The image URI can be either a complete host and image specification (e.g.,
     * quay.io/biocontainers/samtools), a library and image name (e.g.,
     * google/cloud-sdk) or a bare image name ('bash') to pull from the default
     * library.  No schema is required in any of these cases.
     * If the specified image is not public, the service account specified for
     * the Virtual Machine must have access to pull the images from GCR, or
     * appropriate credentials must be specified in the
     * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials] field.
     * </pre>
     *
     * <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The imageUri.
     */
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from. Note that all images referenced
     * by actions in the pipeline are pulled before the first action runs. If
     * multiple actions reference the same image, it is only pulled once,
     * ensuring that the same image is used for all actions in a single pipeline.
     * The image URI can be either a complete host and image specification (e.g.,
     * quay.io/biocontainers/samtools), a library and image name (e.g.,
     * google/cloud-sdk) or a bare image name ('bash') to pull from the default
     * library.  No schema is required in any of these cases.
     * If the specified image is not public, the service account specified for
     * the Virtual Machine must have access to pull the images from GCR, or
     * appropriate credentials must be specified in the
     * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials] field.
     * </pre>
     *
     * <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for imageUri.
     */
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from. Note that all images referenced
     * by actions in the pipeline are pulled before the first action runs. If
     * multiple actions reference the same image, it is only pulled once,
     * ensuring that the same image is used for all actions in a single pipeline.
     * The image URI can be either a complete host and image specification (e.g.,
     * quay.io/biocontainers/samtools), a library and image name (e.g.,
     * google/cloud-sdk) or a bare image name ('bash') to pull from the default
     * library.  No schema is required in any of these cases.
     * If the specified image is not public, the service account specified for
     * the Virtual Machine must have access to pull the images from GCR, or
     * appropriate credentials must be specified in the
     * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials] field.
     * </pre>
     *
     * <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      imageUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from. Note that all images referenced
     * by actions in the pipeline are pulled before the first action runs. If
     * multiple actions reference the same image, it is only pulled once,
     * ensuring that the same image is used for all actions in a single pipeline.
     * The image URI can be either a complete host and image specification (e.g.,
     * quay.io/biocontainers/samtools), a library and image name (e.g.,
     * google/cloud-sdk) or a bare image name ('bash') to pull from the default
     * library.  No schema is required in any of these cases.
     * If the specified image is not public, the service account specified for
     * the Virtual Machine must have access to pull the images from GCR, or
     * appropriate credentials must be specified in the
     * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials] field.
     * </pre>
     *
     * <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUri() {

      imageUri_ = getDefaultInstance().getImageUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from. Note that all images referenced
     * by actions in the pipeline are pulled before the first action runs. If
     * multiple actions reference the same image, it is only pulled once,
     * ensuring that the same image is used for all actions in a single pipeline.
     * The image URI can be either a complete host and image specification (e.g.,
     * quay.io/biocontainers/samtools), a library and image name (e.g.,
     * google/cloud-sdk) or a bare image name ('bash') to pull from the default
     * library.  No schema is required in any of these cases.
     * If the specified image is not public, the service account specified for
     * the Virtual Machine must have access to pull the images from GCR, or
     * appropriate credentials must be specified in the
     * [google.cloud.lifesciences.v2beta.Action.credentials][google.cloud.lifesciences.v2beta.Action.credentials] field.
     * </pre>
     *
     * <code>string image_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      imageUri_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList commands_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureCommandsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        commands_ = new com.google.protobuf.LazyStringArrayList(commands_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @return A list containing the commands.
     */
    public com.google.protobuf.ProtocolStringList getCommandsList() {
      return commands_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @return The count of commands.
     */
    public int getCommandsCount() {
      return commands_.size();
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The commands at the given index.
     */
    public java.lang.String getCommands(int index) {
      return commands_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the commands at the given index.
     */
    public com.google.protobuf.ByteString getCommandsBytes(int index) {
      return commands_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The commands to set.
     * @return This builder for chaining.
     */
    public Builder setCommands(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandsIsMutable();
      commands_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @param value The commands to add.
     * @return This builder for chaining.
     */
    public Builder addCommands(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandsIsMutable();
      commands_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @param values The commands to add.
     * @return This builder for chaining.
     */
    public Builder addAllCommands(java.lang.Iterable<java.lang.String> values) {
      ensureCommandsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, commands_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommands() {
      commands_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `CMD` specified in the container. If the
     * container also has an `ENTRYPOINT` the values are used as entrypoint
     * arguments. Otherwise, they are used as a command and arguments to run
     * inside the container.
     * </pre>
     *
     * <code>repeated string commands = 3;</code>
     *
     * @param value The bytes of the commands to add.
     * @return This builder for chaining.
     */
    public Builder addCommandsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCommandsIsMutable();
      commands_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object entrypoint_ = "";
    /**
     *
     *
     * <pre>
     * If specified, overrides the `ENTRYPOINT` specified in the container.
     * </pre>
     *
     * <code>string entrypoint = 4;</code>
     *
     * @return The entrypoint.
     */
    public java.lang.String getEntrypoint() {
      java.lang.Object ref = entrypoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entrypoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `ENTRYPOINT` specified in the container.
     * </pre>
     *
     * <code>string entrypoint = 4;</code>
     *
     * @return The bytes for entrypoint.
     */
    public com.google.protobuf.ByteString getEntrypointBytes() {
      java.lang.Object ref = entrypoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entrypoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `ENTRYPOINT` specified in the container.
     * </pre>
     *
     * <code>string entrypoint = 4;</code>
     *
     * @param value The entrypoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntrypoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entrypoint_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `ENTRYPOINT` specified in the container.
     * </pre>
     *
     * <code>string entrypoint = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntrypoint() {

      entrypoint_ = getDefaultInstance().getEntrypoint();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, overrides the `ENTRYPOINT` specified in the container.
     * </pre>
     *
     * <code>string entrypoint = 4;</code>
     *
     * @param value The bytes for entrypoint to set.
     * @return This builder for chaining.
     */
    public Builder setEntrypointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      entrypoint_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> environment_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvironment() {
      if (environment_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvironmentDefaultEntryHolder.defaultEntry);
      }
      return environment_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvironment() {
      onChanged();
      ;
      if (environment_ == null) {
        environment_ =
            com.google.protobuf.MapField.newMapField(EnvironmentDefaultEntryHolder.defaultEntry);
      }
      if (!environment_.isMutable()) {
        environment_ = environment_.copy();
      }
      return environment_;
    }

    public int getEnvironmentCount() {
      return internalGetEnvironment().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into the container. This environment is merged
     * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 5;</code>
     */
    @java.lang.Override
    public boolean containsEnvironment(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnvironment().getMap().containsKey(key);
    }
    /** Use {@link #getEnvironmentMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
      return getEnvironmentMap();
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into the container. This environment is merged
     * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentMap() {
      return internalGetEnvironment().getMap();
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into the container. This environment is merged
     * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironment().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into the container. This environment is merged
     * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnvironment().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEnvironment() {
      internalGetMutableEnvironment().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into the container. This environment is merged
     * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 5;</code>
     */
    public Builder removeEnvironment(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEnvironment().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvironment() {
      return internalGetMutableEnvironment().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into the container. This environment is merged
     * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 5;</code>
     */
    public Builder putEnvironment(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableEnvironment().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The environment to pass into the container. This environment is merged
     * with values specified in the [google.cloud.lifesciences.v2beta.Pipeline][google.cloud.lifesciences.v2beta.Pipeline]
     * message, overwriting any duplicate values.
     * In addition to the values passed here, a few other values are
     * automatically injected into the environment. These cannot be hidden or
     * overwritten.
     * `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline failed
     * because an action has exited with a non-zero status (and did not have the
     * `IGNORE_EXIT_STATUS` flag set). This can be used to determine if additional
     * debug or logging actions should execute.
     * `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
     * non-background action that executed. This can be used by workflow engine
     * authors to determine whether an individual action has succeeded or failed.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment = 5;</code>
     */
    public Builder putAllEnvironment(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvironment().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object pidNamespace_ = "";
    /**
     *
     *
     * <pre>
     * An optional identifier for a PID namespace to run the action inside.
     * Multiple actions should use the same string to share a namespace.  If
     * unspecified, a separate isolated namespace is used.
     * </pre>
     *
     * <code>string pid_namespace = 6;</code>
     *
     * @return The pidNamespace.
     */
    public java.lang.String getPidNamespace() {
      java.lang.Object ref = pidNamespace_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pidNamespace_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional identifier for a PID namespace to run the action inside.
     * Multiple actions should use the same string to share a namespace.  If
     * unspecified, a separate isolated namespace is used.
     * </pre>
     *
     * <code>string pid_namespace = 6;</code>
     *
     * @return The bytes for pidNamespace.
     */
    public com.google.protobuf.ByteString getPidNamespaceBytes() {
      java.lang.Object ref = pidNamespace_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pidNamespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional identifier for a PID namespace to run the action inside.
     * Multiple actions should use the same string to share a namespace.  If
     * unspecified, a separate isolated namespace is used.
     * </pre>
     *
     * <code>string pid_namespace = 6;</code>
     *
     * @param value The pidNamespace to set.
     * @return This builder for chaining.
     */
    public Builder setPidNamespace(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pidNamespace_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional identifier for a PID namespace to run the action inside.
     * Multiple actions should use the same string to share a namespace.  If
     * unspecified, a separate isolated namespace is used.
     * </pre>
     *
     * <code>string pid_namespace = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPidNamespace() {

      pidNamespace_ = getDefaultInstance().getPidNamespace();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional identifier for a PID namespace to run the action inside.
     * Multiple actions should use the same string to share a namespace.  If
     * unspecified, a separate isolated namespace is used.
     * </pre>
     *
     * <code>string pid_namespace = 6;</code>
     *
     * @param value The bytes for pidNamespace to set.
     * @return This builder for chaining.
     */
    public Builder setPidNamespaceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pidNamespace_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer> portMappings_;

    private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer>
        internalGetPortMappings() {
      if (portMappings_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PortMappingsDefaultEntryHolder.defaultEntry);
      }
      return portMappings_;
    }

    private com.google.protobuf.MapField<java.lang.Integer, java.lang.Integer>
        internalGetMutablePortMappings() {
      onChanged();
      ;
      if (portMappings_ == null) {
        portMappings_ =
            com.google.protobuf.MapField.newMapField(PortMappingsDefaultEntryHolder.defaultEntry);
      }
      if (!portMappings_.isMutable()) {
        portMappings_ = portMappings_.copy();
      }
      return portMappings_;
    }

    public int getPortMappingsCount() {
      return internalGetPortMappings().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
     */
    @java.lang.Override
    public boolean containsPortMappings(int key) {

      return internalGetPortMappings().getMap().containsKey(key);
    }
    /** Use {@link #getPortMappingsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.Integer, java.lang.Integer> getPortMappings() {
      return getPortMappingsMap();
    }
    /**
     *
     *
     * <pre>
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.Integer, java.lang.Integer> getPortMappingsMap() {
      return internalGetPortMappings().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
     */
    @java.lang.Override
    public int getPortMappingsOrDefault(int key, int defaultValue) {

      java.util.Map<java.lang.Integer, java.lang.Integer> map = internalGetPortMappings().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
     */
    @java.lang.Override
    public int getPortMappingsOrThrow(int key) {

      java.util.Map<java.lang.Integer, java.lang.Integer> map = internalGetPortMappings().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPortMappings() {
      internalGetMutablePortMappings().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
     */
    public Builder removePortMappings(int key) {

      internalGetMutablePortMappings().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.Integer, java.lang.Integer> getMutablePortMappings() {
      return internalGetMutablePortMappings().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
     */
    public Builder putPortMappings(int key, int value) {

      internalGetMutablePortMappings().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map of containers to host port mappings for this container. If the
     * container already specifies exposed ports, use the
     * `PUBLISH_EXPOSED_PORTS` flag instead.
     * The host port number must be less than 65536. If it is zero, an unused
     * random port is assigned. To determine the resulting port number, consult
     * the `ContainerStartedEvent` in the operation metadata.
     * </pre>
     *
     * <code>map&lt;int32, int32&gt; port_mappings = 8;</code>
     */
    public Builder putAllPortMappings(java.util.Map<java.lang.Integer, java.lang.Integer> values) {
      internalGetMutablePortMappings().getMutableMap().putAll(values);
      return this;
    }

    private java.util.List<com.google.cloud.lifesciences.v2beta.Mount> mounts_ =
        java.util.Collections.emptyList();

    private void ensureMountsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        mounts_ = new java.util.ArrayList<com.google.cloud.lifesciences.v2beta.Mount>(mounts_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Mount,
            com.google.cloud.lifesciences.v2beta.Mount.Builder,
            com.google.cloud.lifesciences.v2beta.MountOrBuilder>
        mountsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Mount> getMountsList() {
      if (mountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mounts_);
      } else {
        return mountsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public int getMountsCount() {
      if (mountsBuilder_ == null) {
        return mounts_.size();
      } else {
        return mountsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Mount getMounts(int index) {
      if (mountsBuilder_ == null) {
        return mounts_.get(index);
      } else {
        return mountsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder setMounts(int index, com.google.cloud.lifesciences.v2beta.Mount value) {
      if (mountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMountsIsMutable();
        mounts_.set(index, value);
        onChanged();
      } else {
        mountsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder setMounts(
        int index, com.google.cloud.lifesciences.v2beta.Mount.Builder builderForValue) {
      if (mountsBuilder_ == null) {
        ensureMountsIsMutable();
        mounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        mountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder addMounts(com.google.cloud.lifesciences.v2beta.Mount value) {
      if (mountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMountsIsMutable();
        mounts_.add(value);
        onChanged();
      } else {
        mountsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder addMounts(int index, com.google.cloud.lifesciences.v2beta.Mount value) {
      if (mountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMountsIsMutable();
        mounts_.add(index, value);
        onChanged();
      } else {
        mountsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder addMounts(com.google.cloud.lifesciences.v2beta.Mount.Builder builderForValue) {
      if (mountsBuilder_ == null) {
        ensureMountsIsMutable();
        mounts_.add(builderForValue.build());
        onChanged();
      } else {
        mountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder addMounts(
        int index, com.google.cloud.lifesciences.v2beta.Mount.Builder builderForValue) {
      if (mountsBuilder_ == null) {
        ensureMountsIsMutable();
        mounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        mountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder addAllMounts(
        java.lang.Iterable<? extends com.google.cloud.lifesciences.v2beta.Mount> values) {
      if (mountsBuilder_ == null) {
        ensureMountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mounts_);
        onChanged();
      } else {
        mountsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder clearMounts() {
      if (mountsBuilder_ == null) {
        mounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        mountsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public Builder removeMounts(int index) {
      if (mountsBuilder_ == null) {
        ensureMountsIsMutable();
        mounts_.remove(index);
        onChanged();
      } else {
        mountsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Mount.Builder getMountsBuilder(int index) {
      return getMountsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public com.google.cloud.lifesciences.v2beta.MountOrBuilder getMountsOrBuilder(int index) {
      if (mountsBuilder_ == null) {
        return mounts_.get(index);
      } else {
        return mountsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.lifesciences.v2beta.MountOrBuilder>
        getMountsOrBuilderList() {
      if (mountsBuilder_ != null) {
        return mountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mounts_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Mount.Builder addMountsBuilder() {
      return getMountsFieldBuilder()
          .addBuilder(com.google.cloud.lifesciences.v2beta.Mount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Mount.Builder addMountsBuilder(int index) {
      return getMountsFieldBuilder()
          .addBuilder(index, com.google.cloud.lifesciences.v2beta.Mount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of mounts to make available to the action.
     * In addition to the values specified here, every action has a special
     * virtual disk mounted under `/google` that contains log files and other
     * operational components.
     * &lt;ul&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs&lt;/code&gt; All logs written during the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/output&lt;/code&gt; The combined standard output and
     *   standard error of all actions run as part of the pipeline
     *   execution.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stdout&lt;/code&gt; The complete contents of
     *   each individual action's standard output.&lt;/li&gt;
     *   &lt;li&gt;&lt;code&gt;/google/logs/action/&#42;&#47;stderr&lt;/code&gt; The complete contents of
     *   each individual action's standard error output.&lt;/li&gt;
     * &lt;/ul&gt;
     * </pre>
     *
     * <code>repeated .google.cloud.lifesciences.v2beta.Mount mounts = 9;</code>
     */
    public java.util.List<com.google.cloud.lifesciences.v2beta.Mount.Builder>
        getMountsBuilderList() {
      return getMountsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Mount,
            com.google.cloud.lifesciences.v2beta.Mount.Builder,
            com.google.cloud.lifesciences.v2beta.MountOrBuilder>
        getMountsFieldBuilder() {
      if (mountsBuilder_ == null) {
        mountsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Mount,
                com.google.cloud.lifesciences.v2beta.Mount.Builder,
                com.google.cloud.lifesciences.v2beta.MountOrBuilder>(
                mounts_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        mounts_ = null;
      }
      return mountsBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to associate with the action. This field is provided to assist
     * workflow engine authors in identifying actions (for example, to indicate
     * what sort of action they perform, such as localization or debugging).
     * They are returned in the operation metadata, but are otherwise ignored.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.lifesciences.v2beta.Secret credentials_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Secret,
            com.google.cloud.lifesciences.v2beta.Secret.Builder,
            com.google.cloud.lifesciences.v2beta.SecretOrBuilder>
        credentialsBuilder_;
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     *
     * @return Whether the credentials field is set.
     */
    public boolean hasCredentials() {
      return credentialsBuilder_ != null || credentials_ != null;
    }
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     *
     * @return The credentials.
     */
    public com.google.cloud.lifesciences.v2beta.Secret getCredentials() {
      if (credentialsBuilder_ == null) {
        return credentials_ == null
            ? com.google.cloud.lifesciences.v2beta.Secret.getDefaultInstance()
            : credentials_;
      } else {
        return credentialsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     */
    public Builder setCredentials(com.google.cloud.lifesciences.v2beta.Secret value) {
      if (credentialsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        credentials_ = value;
        onChanged();
      } else {
        credentialsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     */
    public Builder setCredentials(
        com.google.cloud.lifesciences.v2beta.Secret.Builder builderForValue) {
      if (credentialsBuilder_ == null) {
        credentials_ = builderForValue.build();
        onChanged();
      } else {
        credentialsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     */
    public Builder mergeCredentials(com.google.cloud.lifesciences.v2beta.Secret value) {
      if (credentialsBuilder_ == null) {
        if (credentials_ != null) {
          credentials_ =
              com.google.cloud.lifesciences.v2beta.Secret.newBuilder(credentials_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          credentials_ = value;
        }
        onChanged();
      } else {
        credentialsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     */
    public Builder clearCredentials() {
      if (credentialsBuilder_ == null) {
        credentials_ = null;
        onChanged();
      } else {
        credentials_ = null;
        credentialsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     */
    public com.google.cloud.lifesciences.v2beta.Secret.Builder getCredentialsBuilder() {

      onChanged();
      return getCredentialsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     */
    public com.google.cloud.lifesciences.v2beta.SecretOrBuilder getCredentialsOrBuilder() {
      if (credentialsBuilder_ != null) {
        return credentialsBuilder_.getMessageOrBuilder();
      } else {
        return credentials_ == null
            ? com.google.cloud.lifesciences.v2beta.Secret.getDefaultInstance()
            : credentials_;
      }
    }
    /**
     *
     *
     * <pre>
     * If the specified image is hosted on a private registry other than Google
     * Container Registry, the credentials required to pull the image must be
     * specified here as an encrypted secret.
     * The secret must decrypt to a JSON-encoded dictionary containing both
     * `username` and `password` keys.
     * </pre>
     *
     * <code>.google.cloud.lifesciences.v2beta.Secret credentials = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.lifesciences.v2beta.Secret,
            com.google.cloud.lifesciences.v2beta.Secret.Builder,
            com.google.cloud.lifesciences.v2beta.SecretOrBuilder>
        getCredentialsFieldBuilder() {
      if (credentialsBuilder_ == null) {
        credentialsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.lifesciences.v2beta.Secret,
                com.google.cloud.lifesciences.v2beta.Secret.Builder,
                com.google.cloud.lifesciences.v2beta.SecretOrBuilder>(
                getCredentials(), getParentForChildren(), isClean());
        credentials_ = null;
      }
      return credentialsBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return timeoutBuilder_ != null || timeout_ != null;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
        onChanged();
      } else {
        timeoutBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
        onChanged();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (timeout_ != null) {
          timeout_ =
              com.google.protobuf.Duration.newBuilder(timeout_).mergeFrom(value).buildPartial();
        } else {
          timeout_ = value;
        }
        onChanged();
      } else {
        timeoutBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public Builder clearTimeout() {
      if (timeoutBuilder_ == null) {
        timeout_ = null;
        onChanged();
      } else {
        timeout_ = null;
        timeoutBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {

      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time to give the action to complete. If the action
     * fails to complete before the timeout, it will be terminated and the exit
     * status will be non-zero. The pipeline will continue or terminate based
     * on the rules defined by the `ALWAYS_RUN` and `IGNORE_EXIT_STATUS` flags.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private boolean ignoreExitStatus_;
    /**
     *
     *
     * <pre>
     * Normally, a non-zero exit status causes the pipeline to fail. This flag
     * allows execution of other actions to continue instead.
     * </pre>
     *
     * <code>bool ignore_exit_status = 13;</code>
     *
     * @return The ignoreExitStatus.
     */
    @java.lang.Override
    public boolean getIgnoreExitStatus() {
      return ignoreExitStatus_;
    }
    /**
     *
     *
     * <pre>
     * Normally, a non-zero exit status causes the pipeline to fail. This flag
     * allows execution of other actions to continue instead.
     * </pre>
     *
     * <code>bool ignore_exit_status = 13;</code>
     *
     * @param value The ignoreExitStatus to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreExitStatus(boolean value) {

      ignoreExitStatus_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Normally, a non-zero exit status causes the pipeline to fail. This flag
     * allows execution of other actions to continue instead.
     * </pre>
     *
     * <code>bool ignore_exit_status = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreExitStatus() {

      ignoreExitStatus_ = false;
      onChanged();
      return this;
    }

    private boolean runInBackground_;
    /**
     *
     *
     * <pre>
     * This flag allows an action to continue running in the background while
     * executing subsequent actions. This is useful to provide services to
     * other actions (or to provide debugging support tools like SSH servers).
     * </pre>
     *
     * <code>bool run_in_background = 14;</code>
     *
     * @return The runInBackground.
     */
    @java.lang.Override
    public boolean getRunInBackground() {
      return runInBackground_;
    }
    /**
     *
     *
     * <pre>
     * This flag allows an action to continue running in the background while
     * executing subsequent actions. This is useful to provide services to
     * other actions (or to provide debugging support tools like SSH servers).
     * </pre>
     *
     * <code>bool run_in_background = 14;</code>
     *
     * @param value The runInBackground to set.
     * @return This builder for chaining.
     */
    public Builder setRunInBackground(boolean value) {

      runInBackground_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This flag allows an action to continue running in the background while
     * executing subsequent actions. This is useful to provide services to
     * other actions (or to provide debugging support tools like SSH servers).
     * </pre>
     *
     * <code>bool run_in_background = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunInBackground() {

      runInBackground_ = false;
      onChanged();
      return this;
    }

    private boolean alwaysRun_;
    /**
     *
     *
     * <pre>
     * By default, after an action fails, no further actions are run. This flag
     * indicates that this action must be run even if the pipeline has already
     * failed. This is useful for actions that copy output files off of the VM
     * or for debugging. Note that no actions will be run if image prefetching
     * fails.
     * </pre>
     *
     * <code>bool always_run = 15;</code>
     *
     * @return The alwaysRun.
     */
    @java.lang.Override
    public boolean getAlwaysRun() {
      return alwaysRun_;
    }
    /**
     *
     *
     * <pre>
     * By default, after an action fails, no further actions are run. This flag
     * indicates that this action must be run even if the pipeline has already
     * failed. This is useful for actions that copy output files off of the VM
     * or for debugging. Note that no actions will be run if image prefetching
     * fails.
     * </pre>
     *
     * <code>bool always_run = 15;</code>
     *
     * @param value The alwaysRun to set.
     * @return This builder for chaining.
     */
    public Builder setAlwaysRun(boolean value) {

      alwaysRun_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * By default, after an action fails, no further actions are run. This flag
     * indicates that this action must be run even if the pipeline has already
     * failed. This is useful for actions that copy output files off of the VM
     * or for debugging. Note that no actions will be run if image prefetching
     * fails.
     * </pre>
     *
     * <code>bool always_run = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlwaysRun() {

      alwaysRun_ = false;
      onChanged();
      return this;
    }

    private boolean enableFuse_;
    /**
     *
     *
     * <pre>
     * Enable access to the FUSE device for this action. Filesystems can then
     * be mounted into disks shared with other actions. The other actions do
     * not need the `enable_fuse` flag to access the mounted filesystem.
     * This has the effect of causing the container to be executed with
     * `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
     * for containers you trust.
     * </pre>
     *
     * <code>bool enable_fuse = 16;</code>
     *
     * @return The enableFuse.
     */
    @java.lang.Override
    public boolean getEnableFuse() {
      return enableFuse_;
    }
    /**
     *
     *
     * <pre>
     * Enable access to the FUSE device for this action. Filesystems can then
     * be mounted into disks shared with other actions. The other actions do
     * not need the `enable_fuse` flag to access the mounted filesystem.
     * This has the effect of causing the container to be executed with
     * `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
     * for containers you trust.
     * </pre>
     *
     * <code>bool enable_fuse = 16;</code>
     *
     * @param value The enableFuse to set.
     * @return This builder for chaining.
     */
    public Builder setEnableFuse(boolean value) {

      enableFuse_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable access to the FUSE device for this action. Filesystems can then
     * be mounted into disks shared with other actions. The other actions do
     * not need the `enable_fuse` flag to access the mounted filesystem.
     * This has the effect of causing the container to be executed with
     * `CAP_SYS_ADMIN` and exposes `/dev/fuse` to the container, so use it only
     * for containers you trust.
     * </pre>
     *
     * <code>bool enable_fuse = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableFuse() {

      enableFuse_ = false;
      onChanged();
      return this;
    }

    private boolean publishExposedPorts_;
    /**
     *
     *
     * <pre>
     * Exposes all ports specified by `EXPOSE` statements in the container. To
     * discover the host side port numbers, consult the `ACTION_STARTED` event
     * in the operation metadata.
     * </pre>
     *
     * <code>bool publish_exposed_ports = 17;</code>
     *
     * @return The publishExposedPorts.
     */
    @java.lang.Override
    public boolean getPublishExposedPorts() {
      return publishExposedPorts_;
    }
    /**
     *
     *
     * <pre>
     * Exposes all ports specified by `EXPOSE` statements in the container. To
     * discover the host side port numbers, consult the `ACTION_STARTED` event
     * in the operation metadata.
     * </pre>
     *
     * <code>bool publish_exposed_ports = 17;</code>
     *
     * @param value The publishExposedPorts to set.
     * @return This builder for chaining.
     */
    public Builder setPublishExposedPorts(boolean value) {

      publishExposedPorts_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exposes all ports specified by `EXPOSE` statements in the container. To
     * discover the host side port numbers, consult the `ACTION_STARTED` event
     * in the operation metadata.
     * </pre>
     *
     * <code>bool publish_exposed_ports = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublishExposedPorts() {

      publishExposedPorts_ = false;
      onChanged();
      return this;
    }

    private boolean disableImagePrefetch_;
    /**
     *
     *
     * <pre>
     * All container images are typically downloaded before any actions are
     * executed. This helps prevent typos in URIs or issues like lack of disk
     * space from wasting large amounts of compute resources.
     * If set, this flag prevents the worker from downloading the image until
     * just before the action is executed.
     * </pre>
     *
     * <code>bool disable_image_prefetch = 18;</code>
     *
     * @return The disableImagePrefetch.
     */
    @java.lang.Override
    public boolean getDisableImagePrefetch() {
      return disableImagePrefetch_;
    }
    /**
     *
     *
     * <pre>
     * All container images are typically downloaded before any actions are
     * executed. This helps prevent typos in URIs or issues like lack of disk
     * space from wasting large amounts of compute resources.
     * If set, this flag prevents the worker from downloading the image until
     * just before the action is executed.
     * </pre>
     *
     * <code>bool disable_image_prefetch = 18;</code>
     *
     * @param value The disableImagePrefetch to set.
     * @return This builder for chaining.
     */
    public Builder setDisableImagePrefetch(boolean value) {

      disableImagePrefetch_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All container images are typically downloaded before any actions are
     * executed. This helps prevent typos in URIs or issues like lack of disk
     * space from wasting large amounts of compute resources.
     * If set, this flag prevents the worker from downloading the image until
     * just before the action is executed.
     * </pre>
     *
     * <code>bool disable_image_prefetch = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableImagePrefetch() {

      disableImagePrefetch_ = false;
      onChanged();
      return this;
    }

    private boolean disableStandardErrorCapture_;
    /**
     *
     *
     * <pre>
     * A small portion of the container's standard error stream is typically
     * captured and returned inside the `ContainerStoppedEvent`. Setting this
     * flag disables this functionality.
     * </pre>
     *
     * <code>bool disable_standard_error_capture = 19;</code>
     *
     * @return The disableStandardErrorCapture.
     */
    @java.lang.Override
    public boolean getDisableStandardErrorCapture() {
      return disableStandardErrorCapture_;
    }
    /**
     *
     *
     * <pre>
     * A small portion of the container's standard error stream is typically
     * captured and returned inside the `ContainerStoppedEvent`. Setting this
     * flag disables this functionality.
     * </pre>
     *
     * <code>bool disable_standard_error_capture = 19;</code>
     *
     * @param value The disableStandardErrorCapture to set.
     * @return This builder for chaining.
     */
    public Builder setDisableStandardErrorCapture(boolean value) {

      disableStandardErrorCapture_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A small portion of the container's standard error stream is typically
     * captured and returned inside the `ContainerStoppedEvent`. Setting this
     * flag disables this functionality.
     * </pre>
     *
     * <code>bool disable_standard_error_capture = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableStandardErrorCapture() {

      disableStandardErrorCapture_ = false;
      onChanged();
      return this;
    }

    private boolean blockExternalNetwork_;
    /**
     *
     *
     * <pre>
     * Prevents the container from accessing the external network.
     * </pre>
     *
     * <code>bool block_external_network = 20;</code>
     *
     * @return The blockExternalNetwork.
     */
    @java.lang.Override
    public boolean getBlockExternalNetwork() {
      return blockExternalNetwork_;
    }
    /**
     *
     *
     * <pre>
     * Prevents the container from accessing the external network.
     * </pre>
     *
     * <code>bool block_external_network = 20;</code>
     *
     * @param value The blockExternalNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setBlockExternalNetwork(boolean value) {

      blockExternalNetwork_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Prevents the container from accessing the external network.
     * </pre>
     *
     * <code>bool block_external_network = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockExternalNetwork() {

      blockExternalNetwork_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.lifesciences.v2beta.Action)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.lifesciences.v2beta.Action)
  private static final com.google.cloud.lifesciences.v2beta.Action DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.lifesciences.v2beta.Action();
  }

  public static com.google.cloud.lifesciences.v2beta.Action getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Action> PARSER =
      new com.google.protobuf.AbstractParser<Action>() {
        @java.lang.Override
        public Action parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Action> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Action> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.lifesciences.v2beta.Action getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
