/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1/processor.proto

package com.google.cloud.documentai.v1;

/**
 *
 *
 * <pre>
 * A processor version is an implementation of a processor. Each processor
 * can have multiple versions, pre-trained by Google internally or up-trained
 * by the customer. At a time, a processor can only have one default version
 * version. So the processor's behavior (when processing documents) is defined
 * by a default version
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1.ProcessorVersion}
 */
public final class ProcessorVersion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1.ProcessorVersion)
    ProcessorVersionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProcessorVersion.newBuilder() to construct.
  private ProcessorVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProcessorVersion() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    kmsKeyName_ = "";
    kmsKeyVersionName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProcessorVersion();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1.DocumentAiProcessor
        .internal_static_google_cloud_documentai_v1_ProcessorVersion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1.DocumentAiProcessor
        .internal_static_google_cloud_documentai_v1_ProcessorVersion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1.ProcessorVersion.class,
            com.google.cloud.documentai.v1.ProcessorVersion.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The possible states of the processor version.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.documentai.v1.ProcessorVersion.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The processor version is in an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The processor version is deployed and can be used for processing.
     * </pre>
     *
     * <code>DEPLOYED = 1;</code>
     */
    DEPLOYED(1),
    /**
     *
     *
     * <pre>
     * The processor version is being deployed.
     * </pre>
     *
     * <code>DEPLOYING = 2;</code>
     */
    DEPLOYING(2),
    /**
     *
     *
     * <pre>
     * The processor version is not deployed and cannot be used for processing.
     * </pre>
     *
     * <code>UNDEPLOYED = 3;</code>
     */
    UNDEPLOYED(3),
    /**
     *
     *
     * <pre>
     * The processor version is being undeployed.
     * </pre>
     *
     * <code>UNDEPLOYING = 4;</code>
     */
    UNDEPLOYING(4),
    /**
     *
     *
     * <pre>
     * The processor version is being created.
     * </pre>
     *
     * <code>CREATING = 5;</code>
     */
    CREATING(5),
    /**
     *
     *
     * <pre>
     * The processor version is being deleted.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    DELETING(6),
    /**
     *
     *
     * <pre>
     * The processor version failed and is in an indeterminate state.
     * </pre>
     *
     * <code>FAILED = 7;</code>
     */
    FAILED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The processor version is in an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The processor version is deployed and can be used for processing.
     * </pre>
     *
     * <code>DEPLOYED = 1;</code>
     */
    public static final int DEPLOYED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The processor version is being deployed.
     * </pre>
     *
     * <code>DEPLOYING = 2;</code>
     */
    public static final int DEPLOYING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The processor version is not deployed and cannot be used for processing.
     * </pre>
     *
     * <code>UNDEPLOYED = 3;</code>
     */
    public static final int UNDEPLOYED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The processor version is being undeployed.
     * </pre>
     *
     * <code>UNDEPLOYING = 4;</code>
     */
    public static final int UNDEPLOYING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The processor version is being created.
     * </pre>
     *
     * <code>CREATING = 5;</code>
     */
    public static final int CREATING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The processor version is being deleted.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    public static final int DELETING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The processor version failed and is in an indeterminate state.
     * </pre>
     *
     * <code>FAILED = 7;</code>
     */
    public static final int FAILED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return DEPLOYED;
        case 2:
          return DEPLOYING;
        case 3:
          return UNDEPLOYED;
        case 4:
          return UNDEPLOYING;
        case 5:
          return CREATING;
        case 6:
          return DELETING;
        case 7:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.documentai.v1.ProcessorVersion.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1.ProcessorVersion.State)
  }

  public interface DeprecationInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The time at which this processor version will be deprecated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
     *
     * @return Whether the deprecationTime field is set.
     */
    boolean hasDeprecationTime();
    /**
     *
     *
     * <pre>
     * The time at which this processor version will be deprecated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
     *
     * @return The deprecationTime.
     */
    com.google.protobuf.Timestamp getDeprecationTime();
    /**
     *
     *
     * <pre>
     * The time at which this processor version will be deprecated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getDeprecationTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * If set, the processor version that will be used as a replacement.
     * </pre>
     *
     * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The replacementProcessorVersion.
     */
    java.lang.String getReplacementProcessorVersion();
    /**
     *
     *
     * <pre>
     * If set, the processor version that will be used as a replacement.
     * </pre>
     *
     * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for replacementProcessorVersion.
     */
    com.google.protobuf.ByteString getReplacementProcessorVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Information about the upcoming deprecation of this processor version.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo}
   */
  public static final class DeprecationInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo)
      DeprecationInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeprecationInfo.newBuilder() to construct.
    private DeprecationInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeprecationInfo() {
      replacementProcessorVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeprecationInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1.DocumentAiProcessor
          .internal_static_google_cloud_documentai_v1_ProcessorVersion_DeprecationInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1.DocumentAiProcessor
          .internal_static_google_cloud_documentai_v1_ProcessorVersion_DeprecationInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.class,
              com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.Builder.class);
    }

    public static final int DEPRECATION_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp deprecationTime_;
    /**
     *
     *
     * <pre>
     * The time at which this processor version will be deprecated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
     *
     * @return Whether the deprecationTime field is set.
     */
    @java.lang.Override
    public boolean hasDeprecationTime() {
      return deprecationTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which this processor version will be deprecated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
     *
     * @return The deprecationTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getDeprecationTime() {
      return deprecationTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : deprecationTime_;
    }
    /**
     *
     *
     * <pre>
     * The time at which this processor version will be deprecated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getDeprecationTimeOrBuilder() {
      return getDeprecationTime();
    }

    public static final int REPLACEMENT_PROCESSOR_VERSION_FIELD_NUMBER = 2;
    private volatile java.lang.Object replacementProcessorVersion_;
    /**
     *
     *
     * <pre>
     * If set, the processor version that will be used as a replacement.
     * </pre>
     *
     * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The replacementProcessorVersion.
     */
    @java.lang.Override
    public java.lang.String getReplacementProcessorVersion() {
      java.lang.Object ref = replacementProcessorVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        replacementProcessorVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, the processor version that will be used as a replacement.
     * </pre>
     *
     * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for replacementProcessorVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getReplacementProcessorVersionBytes() {
      java.lang.Object ref = replacementProcessorVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        replacementProcessorVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (deprecationTime_ != null) {
        output.writeMessage(1, getDeprecationTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(replacementProcessorVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, replacementProcessorVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (deprecationTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDeprecationTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(replacementProcessorVersion_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(
                2, replacementProcessorVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo other =
          (com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo) obj;

      if (hasDeprecationTime() != other.hasDeprecationTime()) return false;
      if (hasDeprecationTime()) {
        if (!getDeprecationTime().equals(other.getDeprecationTime())) return false;
      }
      if (!getReplacementProcessorVersion().equals(other.getReplacementProcessorVersion()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDeprecationTime()) {
        hash = (37 * hash) + DEPRECATION_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getDeprecationTime().hashCode();
      }
      hash = (37 * hash) + REPLACEMENT_PROCESSOR_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getReplacementProcessorVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information about the upcoming deprecation of this processor version.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo)
        com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1.DocumentAiProcessor
            .internal_static_google_cloud_documentai_v1_ProcessorVersion_DeprecationInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1.DocumentAiProcessor
            .internal_static_google_cloud_documentai_v1_ProcessorVersion_DeprecationInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.class,
                com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (deprecationTimeBuilder_ == null) {
          deprecationTime_ = null;
        } else {
          deprecationTime_ = null;
          deprecationTimeBuilder_ = null;
        }
        replacementProcessorVersion_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1.DocumentAiProcessor
            .internal_static_google_cloud_documentai_v1_ProcessorVersion_DeprecationInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo build() {
        com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo buildPartial() {
        com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo result =
            new com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo(this);
        if (deprecationTimeBuilder_ == null) {
          result.deprecationTime_ = deprecationTime_;
        } else {
          result.deprecationTime_ = deprecationTimeBuilder_.build();
        }
        result.replacementProcessorVersion_ = replacementProcessorVersion_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo) {
          return mergeFrom((com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo other) {
        if (other
            == com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.getDefaultInstance())
          return this;
        if (other.hasDeprecationTime()) {
          mergeDeprecationTime(other.getDeprecationTime());
        }
        if (!other.getReplacementProcessorVersion().isEmpty()) {
          replacementProcessorVersion_ = other.replacementProcessorVersion_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getDeprecationTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  replacementProcessorVersion_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Timestamp deprecationTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          deprecationTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       *
       * @return Whether the deprecationTime field is set.
       */
      public boolean hasDeprecationTime() {
        return deprecationTimeBuilder_ != null || deprecationTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       *
       * @return The deprecationTime.
       */
      public com.google.protobuf.Timestamp getDeprecationTime() {
        if (deprecationTimeBuilder_ == null) {
          return deprecationTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : deprecationTime_;
        } else {
          return deprecationTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       */
      public Builder setDeprecationTime(com.google.protobuf.Timestamp value) {
        if (deprecationTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          deprecationTime_ = value;
          onChanged();
        } else {
          deprecationTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       */
      public Builder setDeprecationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (deprecationTimeBuilder_ == null) {
          deprecationTime_ = builderForValue.build();
          onChanged();
        } else {
          deprecationTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       */
      public Builder mergeDeprecationTime(com.google.protobuf.Timestamp value) {
        if (deprecationTimeBuilder_ == null) {
          if (deprecationTime_ != null) {
            deprecationTime_ =
                com.google.protobuf.Timestamp.newBuilder(deprecationTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            deprecationTime_ = value;
          }
          onChanged();
        } else {
          deprecationTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       */
      public Builder clearDeprecationTime() {
        if (deprecationTimeBuilder_ == null) {
          deprecationTime_ = null;
          onChanged();
        } else {
          deprecationTime_ = null;
          deprecationTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getDeprecationTimeBuilder() {

        onChanged();
        return getDeprecationTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getDeprecationTimeOrBuilder() {
        if (deprecationTimeBuilder_ != null) {
          return deprecationTimeBuilder_.getMessageOrBuilder();
        } else {
          return deprecationTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : deprecationTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time at which this processor version will be deprecated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp deprecation_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getDeprecationTimeFieldBuilder() {
        if (deprecationTimeBuilder_ == null) {
          deprecationTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getDeprecationTime(), getParentForChildren(), isClean());
          deprecationTime_ = null;
        }
        return deprecationTimeBuilder_;
      }

      private java.lang.Object replacementProcessorVersion_ = "";
      /**
       *
       *
       * <pre>
       * If set, the processor version that will be used as a replacement.
       * </pre>
       *
       * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The replacementProcessorVersion.
       */
      public java.lang.String getReplacementProcessorVersion() {
        java.lang.Object ref = replacementProcessorVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          replacementProcessorVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If set, the processor version that will be used as a replacement.
       * </pre>
       *
       * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for replacementProcessorVersion.
       */
      public com.google.protobuf.ByteString getReplacementProcessorVersionBytes() {
        java.lang.Object ref = replacementProcessorVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          replacementProcessorVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * If set, the processor version that will be used as a replacement.
       * </pre>
       *
       * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The replacementProcessorVersion to set.
       * @return This builder for chaining.
       */
      public Builder setReplacementProcessorVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        replacementProcessorVersion_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, the processor version that will be used as a replacement.
       * </pre>
       *
       * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReplacementProcessorVersion() {

        replacementProcessorVersion_ = getDefaultInstance().getReplacementProcessorVersion();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set, the processor version that will be used as a replacement.
       * </pre>
       *
       * <code>string replacement_processor_version = 2 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for replacementProcessorVersion to set.
       * @return This builder for chaining.
       */
      public Builder setReplacementProcessorVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        replacementProcessorVersion_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo)
    private static final com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo();
    }

    public static com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeprecationInfo> PARSER =
        new com.google.protobuf.AbstractParser<DeprecationInfo>() {
          @java.lang.Override
          public DeprecationInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeprecationInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeprecationInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the processor version.
   * Format:
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the processor version.
   * Format:
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The display name of the processor version.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the processor version.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENT_SCHEMA_FIELD_NUMBER = 12;
  private com.google.cloud.documentai.v1.DocumentSchema documentSchema_;
  /**
   *
   *
   * <pre>
   * The schema of the processor version. Describes the output.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
   *
   * @return Whether the documentSchema field is set.
   */
  @java.lang.Override
  public boolean hasDocumentSchema() {
    return documentSchema_ != null;
  }
  /**
   *
   *
   * <pre>
   * The schema of the processor version. Describes the output.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
   *
   * @return The documentSchema.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.DocumentSchema getDocumentSchema() {
    return documentSchema_ == null
        ? com.google.cloud.documentai.v1.DocumentSchema.getDefaultInstance()
        : documentSchema_;
  }
  /**
   *
   *
   * <pre>
   * The schema of the processor version. Describes the output.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.DocumentSchemaOrBuilder getDocumentSchemaOrBuilder() {
    return getDocumentSchema();
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_;
  /**
   *
   *
   * <pre>
   * The state of the processor version.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.ProcessorVersion.State state = 6;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The state of the processor version.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.ProcessorVersion.State state = 6;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.ProcessorVersion.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.documentai.v1.ProcessorVersion.State result =
        com.google.cloud.documentai.v1.ProcessorVersion.State.valueOf(state_);
    return result == null
        ? com.google.cloud.documentai.v1.ProcessorVersion.State.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time the processor version was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time the processor version was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the processor version was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 9;
  private volatile java.lang.Object kmsKeyName_;
  /**
   *
   *
   * <pre>
   * The KMS key name used for encryption.
   * </pre>
   *
   * <code>string kms_key_name = 9;</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The KMS key name used for encryption.
   * </pre>
   *
   * <code>string kms_key_name = 9;</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_VERSION_NAME_FIELD_NUMBER = 10;
  private volatile java.lang.Object kmsKeyVersionName_;
  /**
   *
   *
   * <pre>
   * The KMS key version with which data is encrypted.
   * </pre>
   *
   * <code>string kms_key_version_name = 10;</code>
   *
   * @return The kmsKeyVersionName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyVersionName() {
    java.lang.Object ref = kmsKeyVersionName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyVersionName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The KMS key version with which data is encrypted.
   * </pre>
   *
   * <code>string kms_key_version_name = 10;</code>
   *
   * @return The bytes for kmsKeyVersionName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyVersionNameBytes() {
    java.lang.Object ref = kmsKeyVersionName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyVersionName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GOOGLE_MANAGED_FIELD_NUMBER = 11;
  private boolean googleManaged_;
  /**
   *
   *
   * <pre>
   * Denotes that this ProcessorVersion is managed by google.
   * </pre>
   *
   * <code>bool google_managed = 11;</code>
   *
   * @return The googleManaged.
   */
  @java.lang.Override
  public boolean getGoogleManaged() {
    return googleManaged_;
  }

  public static final int DEPRECATION_INFO_FIELD_NUMBER = 13;
  private com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecationInfo_;
  /**
   *
   *
   * <pre>
   * If set, information about the eventual deprecation of this version.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
   * </code>
   *
   * @return Whether the deprecationInfo field is set.
   */
  @java.lang.Override
  public boolean hasDeprecationInfo() {
    return deprecationInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * If set, information about the eventual deprecation of this version.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
   * </code>
   *
   * @return The deprecationInfo.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo getDeprecationInfo() {
    return deprecationInfo_ == null
        ? com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.getDefaultInstance()
        : deprecationInfo_;
  }
  /**
   *
   *
   * <pre>
   * If set, information about the eventual deprecation of this version.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfoOrBuilder
      getDeprecationInfoOrBuilder() {
    return getDeprecationInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (state_
        != com.google.cloud.documentai.v1.ProcessorVersion.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(7, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersionName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, kmsKeyVersionName_);
    }
    if (googleManaged_ != false) {
      output.writeBool(11, googleManaged_);
    }
    if (documentSchema_ != null) {
      output.writeMessage(12, getDocumentSchema());
    }
    if (deprecationInfo_ != null) {
      output.writeMessage(13, getDeprecationInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (state_
        != com.google.cloud.documentai.v1.ProcessorVersion.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersionName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, kmsKeyVersionName_);
    }
    if (googleManaged_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, googleManaged_);
    }
    if (documentSchema_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDocumentSchema());
    }
    if (deprecationInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getDeprecationInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1.ProcessorVersion)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1.ProcessorVersion other =
        (com.google.cloud.documentai.v1.ProcessorVersion) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasDocumentSchema() != other.hasDocumentSchema()) return false;
    if (hasDocumentSchema()) {
      if (!getDocumentSchema().equals(other.getDocumentSchema())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!getKmsKeyVersionName().equals(other.getKmsKeyVersionName())) return false;
    if (getGoogleManaged() != other.getGoogleManaged()) return false;
    if (hasDeprecationInfo() != other.hasDeprecationInfo()) return false;
    if (hasDeprecationInfo()) {
      if (!getDeprecationInfo().equals(other.getDeprecationInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasDocumentSchema()) {
      hash = (37 * hash) + DOCUMENT_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentSchema().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    hash = (37 * hash) + KMS_KEY_VERSION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyVersionName().hashCode();
    hash = (37 * hash) + GOOGLE_MANAGED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGoogleManaged());
    if (hasDeprecationInfo()) {
      hash = (37 * hash) + DEPRECATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getDeprecationInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1.ProcessorVersion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A processor version is an implementation of a processor. Each processor
   * can have multiple versions, pre-trained by Google internally or up-trained
   * by the customer. At a time, a processor can only have one default version
   * version. So the processor's behavior (when processing documents) is defined
   * by a default version
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1.ProcessorVersion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1.ProcessorVersion)
      com.google.cloud.documentai.v1.ProcessorVersionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1.DocumentAiProcessor
          .internal_static_google_cloud_documentai_v1_ProcessorVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1.DocumentAiProcessor
          .internal_static_google_cloud_documentai_v1_ProcessorVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1.ProcessorVersion.class,
              com.google.cloud.documentai.v1.ProcessorVersion.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1.ProcessorVersion.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (documentSchemaBuilder_ == null) {
        documentSchema_ = null;
      } else {
        documentSchema_ = null;
        documentSchemaBuilder_ = null;
      }
      state_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      kmsKeyName_ = "";

      kmsKeyVersionName_ = "";

      googleManaged_ = false;

      if (deprecationInfoBuilder_ == null) {
        deprecationInfo_ = null;
      } else {
        deprecationInfo_ = null;
        deprecationInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1.DocumentAiProcessor
          .internal_static_google_cloud_documentai_v1_ProcessorVersion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.ProcessorVersion getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1.ProcessorVersion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.ProcessorVersion build() {
      com.google.cloud.documentai.v1.ProcessorVersion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.ProcessorVersion buildPartial() {
      com.google.cloud.documentai.v1.ProcessorVersion result =
          new com.google.cloud.documentai.v1.ProcessorVersion(this);
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (documentSchemaBuilder_ == null) {
        result.documentSchema_ = documentSchema_;
      } else {
        result.documentSchema_ = documentSchemaBuilder_.build();
      }
      result.state_ = state_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      result.kmsKeyName_ = kmsKeyName_;
      result.kmsKeyVersionName_ = kmsKeyVersionName_;
      result.googleManaged_ = googleManaged_;
      if (deprecationInfoBuilder_ == null) {
        result.deprecationInfo_ = deprecationInfo_;
      } else {
        result.deprecationInfo_ = deprecationInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1.ProcessorVersion) {
        return mergeFrom((com.google.cloud.documentai.v1.ProcessorVersion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1.ProcessorVersion other) {
      if (other == com.google.cloud.documentai.v1.ProcessorVersion.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasDocumentSchema()) {
        mergeDocumentSchema(other.getDocumentSchema());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        onChanged();
      }
      if (!other.getKmsKeyVersionName().isEmpty()) {
        kmsKeyVersionName_ = other.kmsKeyVersionName_;
        onChanged();
      }
      if (other.getGoogleManaged() != false) {
        setGoogleManaged(other.getGoogleManaged());
      }
      if (other.hasDeprecationInfo()) {
        mergeDeprecationInfo(other.getDeprecationInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 48:
              {
                state_ = input.readEnum();

                break;
              } // case 48
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 74:
              {
                kmsKeyName_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 82:
              {
                kmsKeyVersionName_ = input.readStringRequireUtf8();

                break;
              } // case 82
            case 88:
              {
                googleManaged_ = input.readBool();

                break;
              } // case 88
            case 98:
              {
                input.readMessage(getDocumentSchemaFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 106:
              {
                input.readMessage(getDeprecationInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the processor version.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the processor version.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the processor version.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the processor version.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the processor version.
     * Format:
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the processor version.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the processor version.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the processor version.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the processor version.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the processor version.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1.DocumentSchema documentSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.DocumentSchema,
            com.google.cloud.documentai.v1.DocumentSchema.Builder,
            com.google.cloud.documentai.v1.DocumentSchemaOrBuilder>
        documentSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     *
     * @return Whether the documentSchema field is set.
     */
    public boolean hasDocumentSchema() {
      return documentSchemaBuilder_ != null || documentSchema_ != null;
    }
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     *
     * @return The documentSchema.
     */
    public com.google.cloud.documentai.v1.DocumentSchema getDocumentSchema() {
      if (documentSchemaBuilder_ == null) {
        return documentSchema_ == null
            ? com.google.cloud.documentai.v1.DocumentSchema.getDefaultInstance()
            : documentSchema_;
      } else {
        return documentSchemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     */
    public Builder setDocumentSchema(com.google.cloud.documentai.v1.DocumentSchema value) {
      if (documentSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentSchema_ = value;
        onChanged();
      } else {
        documentSchemaBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     */
    public Builder setDocumentSchema(
        com.google.cloud.documentai.v1.DocumentSchema.Builder builderForValue) {
      if (documentSchemaBuilder_ == null) {
        documentSchema_ = builderForValue.build();
        onChanged();
      } else {
        documentSchemaBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     */
    public Builder mergeDocumentSchema(com.google.cloud.documentai.v1.DocumentSchema value) {
      if (documentSchemaBuilder_ == null) {
        if (documentSchema_ != null) {
          documentSchema_ =
              com.google.cloud.documentai.v1.DocumentSchema.newBuilder(documentSchema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentSchema_ = value;
        }
        onChanged();
      } else {
        documentSchemaBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     */
    public Builder clearDocumentSchema() {
      if (documentSchemaBuilder_ == null) {
        documentSchema_ = null;
        onChanged();
      } else {
        documentSchema_ = null;
        documentSchemaBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     */
    public com.google.cloud.documentai.v1.DocumentSchema.Builder getDocumentSchemaBuilder() {

      onChanged();
      return getDocumentSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     */
    public com.google.cloud.documentai.v1.DocumentSchemaOrBuilder getDocumentSchemaOrBuilder() {
      if (documentSchemaBuilder_ != null) {
        return documentSchemaBuilder_.getMessageOrBuilder();
      } else {
        return documentSchema_ == null
            ? com.google.cloud.documentai.v1.DocumentSchema.getDefaultInstance()
            : documentSchema_;
      }
    }
    /**
     *
     *
     * <pre>
     * The schema of the processor version. Describes the output.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentSchema document_schema = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.DocumentSchema,
            com.google.cloud.documentai.v1.DocumentSchema.Builder,
            com.google.cloud.documentai.v1.DocumentSchemaOrBuilder>
        getDocumentSchemaFieldBuilder() {
      if (documentSchemaBuilder_ == null) {
        documentSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1.DocumentSchema,
                com.google.cloud.documentai.v1.DocumentSchema.Builder,
                com.google.cloud.documentai.v1.DocumentSchemaOrBuilder>(
                getDocumentSchema(), getParentForChildren(), isClean());
        documentSchema_ = null;
      }
      return documentSchemaBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the processor version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.State state = 6;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of the processor version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.State state = 6;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the processor version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.State state = 6;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1.ProcessorVersion.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.documentai.v1.ProcessorVersion.State result =
          com.google.cloud.documentai.v1.ProcessorVersion.State.valueOf(state_);
      return result == null
          ? com.google.cloud.documentai.v1.ProcessorVersion.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the processor version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.State state = 6;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.documentai.v1.ProcessorVersion.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the processor version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.State state = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the processor version was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 9;</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 9;</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 9;</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      kmsKeyName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {

      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key name used for encryption.
     * </pre>
     *
     * <code>string kms_key_name = 9;</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      kmsKeyName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyVersionName_ = "";
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 10;</code>
     *
     * @return The kmsKeyVersionName.
     */
    public java.lang.String getKmsKeyVersionName() {
      java.lang.Object ref = kmsKeyVersionName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyVersionName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 10;</code>
     *
     * @return The bytes for kmsKeyVersionName.
     */
    public com.google.protobuf.ByteString getKmsKeyVersionNameBytes() {
      java.lang.Object ref = kmsKeyVersionName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyVersionName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 10;</code>
     *
     * @param value The kmsKeyVersionName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      kmsKeyVersionName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyVersionName() {

      kmsKeyVersionName_ = getDefaultInstance().getKmsKeyVersionName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The KMS key version with which data is encrypted.
     * </pre>
     *
     * <code>string kms_key_version_name = 10;</code>
     *
     * @param value The bytes for kmsKeyVersionName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      kmsKeyVersionName_ = value;
      onChanged();
      return this;
    }

    private boolean googleManaged_;
    /**
     *
     *
     * <pre>
     * Denotes that this ProcessorVersion is managed by google.
     * </pre>
     *
     * <code>bool google_managed = 11;</code>
     *
     * @return The googleManaged.
     */
    @java.lang.Override
    public boolean getGoogleManaged() {
      return googleManaged_;
    }
    /**
     *
     *
     * <pre>
     * Denotes that this ProcessorVersion is managed by google.
     * </pre>
     *
     * <code>bool google_managed = 11;</code>
     *
     * @param value The googleManaged to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleManaged(boolean value) {

      googleManaged_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Denotes that this ProcessorVersion is managed by google.
     * </pre>
     *
     * <code>bool google_managed = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoogleManaged() {

      googleManaged_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo,
            com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.Builder,
            com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfoOrBuilder>
        deprecationInfoBuilder_;
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     *
     * @return Whether the deprecationInfo field is set.
     */
    public boolean hasDeprecationInfo() {
      return deprecationInfoBuilder_ != null || deprecationInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     *
     * @return The deprecationInfo.
     */
    public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo getDeprecationInfo() {
      if (deprecationInfoBuilder_ == null) {
        return deprecationInfo_ == null
            ? com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.getDefaultInstance()
            : deprecationInfo_;
      } else {
        return deprecationInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     */
    public Builder setDeprecationInfo(
        com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo value) {
      if (deprecationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deprecationInfo_ = value;
        onChanged();
      } else {
        deprecationInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     */
    public Builder setDeprecationInfo(
        com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.Builder builderForValue) {
      if (deprecationInfoBuilder_ == null) {
        deprecationInfo_ = builderForValue.build();
        onChanged();
      } else {
        deprecationInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     */
    public Builder mergeDeprecationInfo(
        com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo value) {
      if (deprecationInfoBuilder_ == null) {
        if (deprecationInfo_ != null) {
          deprecationInfo_ =
              com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.newBuilder(
                      deprecationInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deprecationInfo_ = value;
        }
        onChanged();
      } else {
        deprecationInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     */
    public Builder clearDeprecationInfo() {
      if (deprecationInfoBuilder_ == null) {
        deprecationInfo_ = null;
        onChanged();
      } else {
        deprecationInfo_ = null;
        deprecationInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     */
    public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.Builder
        getDeprecationInfoBuilder() {

      onChanged();
      return getDeprecationInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     */
    public com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfoOrBuilder
        getDeprecationInfoOrBuilder() {
      if (deprecationInfoBuilder_ != null) {
        return deprecationInfoBuilder_.getMessageOrBuilder();
      } else {
        return deprecationInfo_ == null
            ? com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.getDefaultInstance()
            : deprecationInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, information about the eventual deprecation of this version.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo deprecation_info = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo,
            com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.Builder,
            com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfoOrBuilder>
        getDeprecationInfoFieldBuilder() {
      if (deprecationInfoBuilder_ == null) {
        deprecationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo,
                com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfo.Builder,
                com.google.cloud.documentai.v1.ProcessorVersion.DeprecationInfoOrBuilder>(
                getDeprecationInfo(), getParentForChildren(), isClean());
        deprecationInfo_ = null;
      }
      return deprecationInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1.ProcessorVersion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1.ProcessorVersion)
  private static final com.google.cloud.documentai.v1.ProcessorVersion DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1.ProcessorVersion();
  }

  public static com.google.cloud.documentai.v1.ProcessorVersion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProcessorVersion> PARSER =
      new com.google.protobuf.AbstractParser<ProcessorVersion>() {
        @java.lang.Override
        public ProcessorVersion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProcessorVersion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProcessorVersion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1.ProcessorVersion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
