/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1/processor_type.proto

package com.google.cloud.documentai.v1;

public interface ProcessorTypeOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1.ProcessorType)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The resource name of the processor type.
   * Format: `projects/{project}/processorTypes/{processor_type}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * The resource name of the processor type.
   * Format: `projects/{project}/processorTypes/{processor_type}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The processor type, e.g., `OCR_PROCESSOR`, `INVOICE_PROCESSOR`, etc.
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The type.
   */
  java.lang.String getType();
  /**
   *
   *
   * <pre>
   * The processor type, e.g., `OCR_PROCESSOR`, `INVOICE_PROCESSOR`, etc.
   * </pre>
   *
   * <code>string type = 2;</code>
   *
   * @return The bytes for type.
   */
  com.google.protobuf.ByteString getTypeBytes();

  /**
   *
   *
   * <pre>
   * The processor category, used by UI to group processor types.
   * </pre>
   *
   * <code>string category = 3;</code>
   *
   * @return The category.
   */
  java.lang.String getCategory();
  /**
   *
   *
   * <pre>
   * The processor category, used by UI to group processor types.
   * </pre>
   *
   * <code>string category = 3;</code>
   *
   * @return The bytes for category.
   */
  com.google.protobuf.ByteString getCategoryBytes();

  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  java.util.List<com.google.cloud.documentai.v1.ProcessorType.LocationInfo>
      getAvailableLocationsList();
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  com.google.cloud.documentai.v1.ProcessorType.LocationInfo getAvailableLocations(int index);
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  int getAvailableLocationsCount();
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  java.util.List<? extends com.google.cloud.documentai.v1.ProcessorType.LocationInfoOrBuilder>
      getAvailableLocationsOrBuilderList();
  /**
   *
   *
   * <pre>
   * The locations in which this processor is available.
   * </pre>
   *
   * <code>repeated .google.cloud.documentai.v1.ProcessorType.LocationInfo available_locations = 4;
   * </code>
   */
  com.google.cloud.documentai.v1.ProcessorType.LocationInfoOrBuilder getAvailableLocationsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Whether the processor type allows creation. If true, users can create a
   * processor of this processor type. Otherwise, users need to request access.
   * </pre>
   *
   * <code>bool allow_creation = 6;</code>
   *
   * @return The allowCreation.
   */
  boolean getAllowCreation();

  /**
   *
   *
   * <pre>
   * Launch stage of the processor type
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 8;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  int getLaunchStageValue();
  /**
   *
   *
   * <pre>
   * Launch stage of the processor type
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 8;</code>
   *
   * @return The launchStage.
   */
  com.google.api.LaunchStage getLaunchStage();
}
