/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1/document_io.proto

package com.google.cloud.documentai.v1;

/**
 *
 *
 * <pre>
 * Config that controls the output of documents. All documents will be written
 * as a JSON file.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1.DocumentOutputConfig}
 */
public final class DocumentOutputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1.DocumentOutputConfig)
    DocumentOutputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DocumentOutputConfig.newBuilder() to construct.
  private DocumentOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DocumentOutputConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DocumentOutputConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1.DocumentIoProto
        .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1.DocumentIoProto
        .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1.DocumentOutputConfig.class,
            com.google.cloud.documentai.v1.DocumentOutputConfig.Builder.class);
  }

  public interface GcsOutputConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage uri (a directory) of the output.
     * </pre>
     *
     * <code>string gcs_uri = 1;</code>
     *
     * @return The gcsUri.
     */
    java.lang.String getGcsUri();
    /**
     *
     *
     * <pre>
     * The Cloud Storage uri (a directory) of the output.
     * </pre>
     *
     * <code>string gcs_uri = 1;</code>
     *
     * @return The bytes for gcsUri.
     */
    com.google.protobuf.ByteString getGcsUriBytes();

    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the output documents.
     * Only supports top level document and pages field so it must be in the
     * form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 2;</code>
     *
     * @return Whether the fieldMask field is set.
     */
    boolean hasFieldMask();
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the output documents.
     * Only supports top level document and pages field so it must be in the
     * form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 2;</code>
     *
     * @return The fieldMask.
     */
    com.google.protobuf.FieldMask getFieldMask();
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the output documents.
     * Only supports top level document and pages field so it must be in the
     * form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 2;</code>
     */
    com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The configuration used when outputting documents.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig}
   */
  public static final class GcsOutputConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig)
      GcsOutputConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsOutputConfig.newBuilder() to construct.
    private GcsOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsOutputConfig() {
      gcsUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsOutputConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1.DocumentIoProto
          .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_GcsOutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1.DocumentIoProto
          .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_GcsOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.class,
              com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.Builder.class);
    }

    public static final int GCS_URI_FIELD_NUMBER = 1;
    private volatile java.lang.Object gcsUri_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage uri (a directory) of the output.
     * </pre>
     *
     * <code>string gcs_uri = 1;</code>
     *
     * @return The gcsUri.
     */
    @java.lang.Override
    public java.lang.String getGcsUri() {
      java.lang.Object ref = gcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage uri (a directory) of the output.
     * </pre>
     *
     * <code>string gcs_uri = 1;</code>
     *
     * @return The bytes for gcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsUriBytes() {
      java.lang.Object ref = gcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FIELD_MASK_FIELD_NUMBER = 2;
    private com.google.protobuf.FieldMask fieldMask_;
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the output documents.
     * Only supports top level document and pages field so it must be in the
     * form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 2;</code>
     *
     * @return Whether the fieldMask field is set.
     */
    @java.lang.Override
    public boolean hasFieldMask() {
      return fieldMask_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the output documents.
     * Only supports top level document and pages field so it must be in the
     * form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 2;</code>
     *
     * @return The fieldMask.
     */
    @java.lang.Override
    public com.google.protobuf.FieldMask getFieldMask() {
      return fieldMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fieldMask_;
    }
    /**
     *
     *
     * <pre>
     * Specifies which fields to include in the output documents.
     * Only supports top level document and pages field so it must be in the
     * form of `{document_field_name}` or `pages.{page_field_name}`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask field_mask = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
      return getFieldMask();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsUri_);
      }
      if (fieldMask_ != null) {
        output.writeMessage(2, getFieldMask());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsUri_);
      }
      if (fieldMask_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFieldMask());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig other =
          (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) obj;

      if (!getGcsUri().equals(other.getGcsUri())) return false;
      if (hasFieldMask() != other.hasFieldMask()) return false;
      if (hasFieldMask()) {
        if (!getFieldMask().equals(other.getFieldMask())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getGcsUri().hashCode();
      if (hasFieldMask()) {
        hash = (37 * hash) + FIELD_MASK_FIELD_NUMBER;
        hash = (53 * hash) + getFieldMask().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The configuration used when outputting documents.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig)
        com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1.DocumentIoProto
            .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_GcsOutputConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1.DocumentIoProto
            .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_GcsOutputConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.class,
                com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        gcsUri_ = "";

        if (fieldMaskBuilder_ == null) {
          fieldMask_ = null;
        } else {
          fieldMask_ = null;
          fieldMaskBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1.DocumentIoProto
            .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_GcsOutputConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig build() {
        com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig buildPartial() {
        com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig result =
            new com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig(this);
        result.gcsUri_ = gcsUri_;
        if (fieldMaskBuilder_ == null) {
          result.fieldMask_ = fieldMask_;
        } else {
          result.fieldMask_ = fieldMaskBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) {
          return mergeFrom(
              (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig other) {
        if (other
            == com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
                .getDefaultInstance()) return this;
        if (!other.getGcsUri().isEmpty()) {
          gcsUri_ = other.gcsUri_;
          onChanged();
        }
        if (other.hasFieldMask()) {
          mergeFieldMask(other.getFieldMask());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  gcsUri_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getFieldMaskFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object gcsUri_ = "";
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri (a directory) of the output.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @return The gcsUri.
       */
      public java.lang.String getGcsUri() {
        java.lang.Object ref = gcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri (a directory) of the output.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @return The bytes for gcsUri.
       */
      public com.google.protobuf.ByteString getGcsUriBytes() {
        java.lang.Object ref = gcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri (a directory) of the output.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @param value The gcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        gcsUri_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri (a directory) of the output.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsUri() {

        gcsUri_ = getDefaultInstance().getGcsUri();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage uri (a directory) of the output.
       * </pre>
       *
       * <code>string gcs_uri = 1;</code>
       *
       * @param value The bytes for gcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        gcsUri_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.FieldMask fieldMask_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          fieldMaskBuilder_;
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       *
       * @return Whether the fieldMask field is set.
       */
      public boolean hasFieldMask() {
        return fieldMaskBuilder_ != null || fieldMask_ != null;
      }
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       *
       * @return The fieldMask.
       */
      public com.google.protobuf.FieldMask getFieldMask() {
        if (fieldMaskBuilder_ == null) {
          return fieldMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : fieldMask_;
        } else {
          return fieldMaskBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       */
      public Builder setFieldMask(com.google.protobuf.FieldMask value) {
        if (fieldMaskBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fieldMask_ = value;
          onChanged();
        } else {
          fieldMaskBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       */
      public Builder setFieldMask(com.google.protobuf.FieldMask.Builder builderForValue) {
        if (fieldMaskBuilder_ == null) {
          fieldMask_ = builderForValue.build();
          onChanged();
        } else {
          fieldMaskBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       */
      public Builder mergeFieldMask(com.google.protobuf.FieldMask value) {
        if (fieldMaskBuilder_ == null) {
          if (fieldMask_ != null) {
            fieldMask_ =
                com.google.protobuf.FieldMask.newBuilder(fieldMask_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            fieldMask_ = value;
          }
          onChanged();
        } else {
          fieldMaskBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       */
      public Builder clearFieldMask() {
        if (fieldMaskBuilder_ == null) {
          fieldMask_ = null;
          onChanged();
        } else {
          fieldMask_ = null;
          fieldMaskBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       */
      public com.google.protobuf.FieldMask.Builder getFieldMaskBuilder() {

        onChanged();
        return getFieldMaskFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       */
      public com.google.protobuf.FieldMaskOrBuilder getFieldMaskOrBuilder() {
        if (fieldMaskBuilder_ != null) {
          return fieldMaskBuilder_.getMessageOrBuilder();
        } else {
          return fieldMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : fieldMask_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies which fields to include in the output documents.
       * Only supports top level document and pages field so it must be in the
       * form of `{document_field_name}` or `pages.{page_field_name}`.
       * </pre>
       *
       * <code>.google.protobuf.FieldMask field_mask = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          getFieldMaskFieldBuilder() {
        if (fieldMaskBuilder_ == null) {
          fieldMaskBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FieldMask,
                  com.google.protobuf.FieldMask.Builder,
                  com.google.protobuf.FieldMaskOrBuilder>(
                  getFieldMask(), getParentForChildren(), isClean());
          fieldMask_ = null;
        }
        return fieldMaskBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig)
    private static final com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig();
    }

    public static com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsOutputConfig> PARSER =
        new com.google.protobuf.AbstractParser<GcsOutputConfig>() {
          @java.lang.Override
          public GcsOutputConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GcsOutputConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsOutputConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int destinationCase_ = 0;
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_OUTPUT_CONFIG(1),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_OUTPUT_CONFIG;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int GCS_OUTPUT_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Output config to write the results to Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
   * </code>
   *
   * @return Whether the gcsOutputConfig field is set.
   */
  @java.lang.Override
  public boolean hasGcsOutputConfig() {
    return destinationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Output config to write the results to Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
   * </code>
   *
   * @return The gcsOutputConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig getGcsOutputConfig() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) destination_;
    }
    return com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output config to write the results to Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfigOrBuilder
      getGcsOutputConfigOrBuilder() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) destination_;
    }
    return com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destinationCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) destination_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destinationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) destination_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1.DocumentOutputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1.DocumentOutputConfig other =
        (com.google.cloud.documentai.v1.DocumentOutputConfig) obj;

    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 1:
        if (!getGcsOutputConfig().equals(other.getGcsOutputConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (destinationCase_) {
      case 1:
        hash = (37 * hash) + GCS_OUTPUT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGcsOutputConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1.DocumentOutputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Config that controls the output of documents. All documents will be written
   * as a JSON file.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1.DocumentOutputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1.DocumentOutputConfig)
      com.google.cloud.documentai.v1.DocumentOutputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1.DocumentIoProto
          .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1.DocumentIoProto
          .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1.DocumentOutputConfig.class,
              com.google.cloud.documentai.v1.DocumentOutputConfig.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1.DocumentOutputConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (gcsOutputConfigBuilder_ != null) {
        gcsOutputConfigBuilder_.clear();
      }
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1.DocumentIoProto
          .internal_static_google_cloud_documentai_v1_DocumentOutputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.DocumentOutputConfig getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1.DocumentOutputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.DocumentOutputConfig build() {
      com.google.cloud.documentai.v1.DocumentOutputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.DocumentOutputConfig buildPartial() {
      com.google.cloud.documentai.v1.DocumentOutputConfig result =
          new com.google.cloud.documentai.v1.DocumentOutputConfig(this);
      if (destinationCase_ == 1) {
        if (gcsOutputConfigBuilder_ == null) {
          result.destination_ = destination_;
        } else {
          result.destination_ = gcsOutputConfigBuilder_.build();
        }
      }
      result.destinationCase_ = destinationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1.DocumentOutputConfig) {
        return mergeFrom((com.google.cloud.documentai.v1.DocumentOutputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1.DocumentOutputConfig other) {
      if (other == com.google.cloud.documentai.v1.DocumentOutputConfig.getDefaultInstance())
        return this;
      switch (other.getDestinationCase()) {
        case GCS_OUTPUT_CONFIG:
          {
            mergeGcsOutputConfig(other.getGcsOutputConfig());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGcsOutputConfigFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig,
            com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.Builder,
            com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfigOrBuilder>
        gcsOutputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     *
     * @return Whether the gcsOutputConfig field is set.
     */
    @java.lang.Override
    public boolean hasGcsOutputConfig() {
      return destinationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     *
     * @return The gcsOutputConfig.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
        getGcsOutputConfig() {
      if (gcsOutputConfigBuilder_ == null) {
        if (destinationCase_ == 1) {
          return (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) destination_;
        }
        return com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
            .getDefaultInstance();
      } else {
        if (destinationCase_ == 1) {
          return gcsOutputConfigBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     */
    public Builder setGcsOutputConfig(
        com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig value) {
      if (gcsOutputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsOutputConfigBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     */
    public Builder setGcsOutputConfig(
        com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.Builder
            builderForValue) {
      if (gcsOutputConfigBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsOutputConfigBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     */
    public Builder mergeGcsOutputConfig(
        com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig value) {
      if (gcsOutputConfigBuilder_ == null) {
        if (destinationCase_ == 1
            && destination_
                != com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
                    .getDefaultInstance()) {
          destination_ =
              com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.newBuilder(
                      (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig)
                          destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 1) {
          gcsOutputConfigBuilder_.mergeFrom(value);
        } else {
          gcsOutputConfigBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     */
    public Builder clearGcsOutputConfig() {
      if (gcsOutputConfigBuilder_ == null) {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsOutputConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     */
    public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.Builder
        getGcsOutputConfigBuilder() {
      return getGcsOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfigOrBuilder
        getGcsOutputConfigOrBuilder() {
      if ((destinationCase_ == 1) && (gcsOutputConfigBuilder_ != null)) {
        return gcsOutputConfigBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 1) {
          return (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) destination_;
        }
        return com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output config to write the results to Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig gcs_output_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig,
            com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.Builder,
            com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfigOrBuilder>
        getGcsOutputConfigFieldBuilder() {
      if (gcsOutputConfigBuilder_ == null) {
        if (!(destinationCase_ == 1)) {
          destination_ =
              com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig
                  .getDefaultInstance();
        }
        gcsOutputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig,
                com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig.Builder,
                com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfigOrBuilder>(
                (com.google.cloud.documentai.v1.DocumentOutputConfig.GcsOutputConfig) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 1;
      onChanged();
      ;
      return gcsOutputConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1.DocumentOutputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1.DocumentOutputConfig)
  private static final com.google.cloud.documentai.v1.DocumentOutputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1.DocumentOutputConfig();
  }

  public static com.google.cloud.documentai.v1.DocumentOutputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DocumentOutputConfig> PARSER =
      new com.google.protobuf.AbstractParser<DocumentOutputConfig>() {
        @java.lang.Override
        public DocumentOutputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DocumentOutputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DocumentOutputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1.DocumentOutputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
