/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1/document_processor_service.proto

package com.google.cloud.documentai.v1;

/**
 *
 *
 * <pre>
 * Request message for batch process document method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1.BatchProcessRequest}
 */
public final class BatchProcessRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1.BatchProcessRequest)
    BatchProcessRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchProcessRequest.newBuilder() to construct.
  private BatchProcessRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchProcessRequest() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchProcessRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1_BatchProcessRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1_BatchProcessRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1.BatchProcessRequest.class,
            com.google.cloud.documentai.v1.BatchProcessRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of [Processor][google.cloud.documentai.v1.Processor] or
   * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
   * Format: `projects/{project}/locations/{location}/processors/{processor}`,
   * or
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of [Processor][google.cloud.documentai.v1.Processor] or
   * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
   * Format: `projects/{project}/locations/{location}/processors/{processor}`,
   * or
   * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_DOCUMENTS_FIELD_NUMBER = 5;
  private com.google.cloud.documentai.v1.BatchDocumentsInputConfig inputDocuments_;
  /**
   *
   *
   * <pre>
   * The input documents for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
   *
   * @return Whether the inputDocuments field is set.
   */
  @java.lang.Override
  public boolean hasInputDocuments() {
    return inputDocuments_ != null;
  }
  /**
   *
   *
   * <pre>
   * The input documents for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
   *
   * @return The inputDocuments.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.BatchDocumentsInputConfig getInputDocuments() {
    return inputDocuments_ == null
        ? com.google.cloud.documentai.v1.BatchDocumentsInputConfig.getDefaultInstance()
        : inputDocuments_;
  }
  /**
   *
   *
   * <pre>
   * The input documents for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.BatchDocumentsInputConfigOrBuilder
      getInputDocumentsOrBuilder() {
    return getInputDocuments();
  }

  public static final int DOCUMENT_OUTPUT_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.documentai.v1.DocumentOutputConfig documentOutputConfig_;
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
   *
   * @return Whether the documentOutputConfig field is set.
   */
  @java.lang.Override
  public boolean hasDocumentOutputConfig() {
    return documentOutputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
   *
   * @return The documentOutputConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.DocumentOutputConfig getDocumentOutputConfig() {
    return documentOutputConfig_ == null
        ? com.google.cloud.documentai.v1.DocumentOutputConfig.getDefaultInstance()
        : documentOutputConfig_;
  }
  /**
   *
   *
   * <pre>
   * The overall output config for batch process.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1.DocumentOutputConfigOrBuilder
      getDocumentOutputConfigOrBuilder() {
    return getDocumentOutputConfig();
  }

  public static final int SKIP_HUMAN_REVIEW_FIELD_NUMBER = 4;
  private boolean skipHumanReview_;
  /**
   *
   *
   * <pre>
   * Whether Human Review feature should be skipped for this request. Default to
   * false.
   * </pre>
   *
   * <code>bool skip_human_review = 4;</code>
   *
   * @return The skipHumanReview.
   */
  @java.lang.Override
  public boolean getSkipHumanReview() {
    return skipHumanReview_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (skipHumanReview_ != false) {
      output.writeBool(4, skipHumanReview_);
    }
    if (inputDocuments_ != null) {
      output.writeMessage(5, getInputDocuments());
    }
    if (documentOutputConfig_ != null) {
      output.writeMessage(6, getDocumentOutputConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (skipHumanReview_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, skipHumanReview_);
    }
    if (inputDocuments_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getInputDocuments());
    }
    if (documentOutputConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDocumentOutputConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1.BatchProcessRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1.BatchProcessRequest other =
        (com.google.cloud.documentai.v1.BatchProcessRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasInputDocuments() != other.hasInputDocuments()) return false;
    if (hasInputDocuments()) {
      if (!getInputDocuments().equals(other.getInputDocuments())) return false;
    }
    if (hasDocumentOutputConfig() != other.hasDocumentOutputConfig()) return false;
    if (hasDocumentOutputConfig()) {
      if (!getDocumentOutputConfig().equals(other.getDocumentOutputConfig())) return false;
    }
    if (getSkipHumanReview() != other.getSkipHumanReview()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasInputDocuments()) {
      hash = (37 * hash) + INPUT_DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getInputDocuments().hashCode();
    }
    if (hasDocumentOutputConfig()) {
      hash = (37 * hash) + DOCUMENT_OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentOutputConfig().hashCode();
    }
    hash = (37 * hash) + SKIP_HUMAN_REVIEW_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipHumanReview());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1.BatchProcessRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for batch process document method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1.BatchProcessRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1.BatchProcessRequest)
      com.google.cloud.documentai.v1.BatchProcessRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1_BatchProcessRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1_BatchProcessRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1.BatchProcessRequest.class,
              com.google.cloud.documentai.v1.BatchProcessRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1.BatchProcessRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (inputDocumentsBuilder_ == null) {
        inputDocuments_ = null;
      } else {
        inputDocuments_ = null;
        inputDocumentsBuilder_ = null;
      }
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfig_ = null;
      } else {
        documentOutputConfig_ = null;
        documentOutputConfigBuilder_ = null;
      }
      skipHumanReview_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1_BatchProcessRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.BatchProcessRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1.BatchProcessRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.BatchProcessRequest build() {
      com.google.cloud.documentai.v1.BatchProcessRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1.BatchProcessRequest buildPartial() {
      com.google.cloud.documentai.v1.BatchProcessRequest result =
          new com.google.cloud.documentai.v1.BatchProcessRequest(this);
      result.name_ = name_;
      if (inputDocumentsBuilder_ == null) {
        result.inputDocuments_ = inputDocuments_;
      } else {
        result.inputDocuments_ = inputDocumentsBuilder_.build();
      }
      if (documentOutputConfigBuilder_ == null) {
        result.documentOutputConfig_ = documentOutputConfig_;
      } else {
        result.documentOutputConfig_ = documentOutputConfigBuilder_.build();
      }
      result.skipHumanReview_ = skipHumanReview_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1.BatchProcessRequest) {
        return mergeFrom((com.google.cloud.documentai.v1.BatchProcessRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1.BatchProcessRequest other) {
      if (other == com.google.cloud.documentai.v1.BatchProcessRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasInputDocuments()) {
        mergeInputDocuments(other.getInputDocuments());
      }
      if (other.hasDocumentOutputConfig()) {
        mergeDocumentOutputConfig(other.getDocumentOutputConfig());
      }
      if (other.getSkipHumanReview() != false) {
        setSkipHumanReview(other.getSkipHumanReview());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 32:
              {
                skipHumanReview_ = input.readBool();

                break;
              } // case 32
            case 42:
              {
                input.readMessage(getInputDocumentsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getDocumentOutputConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of [Processor][google.cloud.documentai.v1.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of [Processor][google.cloud.documentai.v1.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of [Processor][google.cloud.documentai.v1.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of [Processor][google.cloud.documentai.v1.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of [Processor][google.cloud.documentai.v1.Processor] or
     * [ProcessorVersion][google.cloud.documentai.v1.ProcessorVersion].
     * Format: `projects/{project}/locations/{location}/processors/{processor}`,
     * or
     * `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1.BatchDocumentsInputConfig inputDocuments_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.BatchDocumentsInputConfig,
            com.google.cloud.documentai.v1.BatchDocumentsInputConfig.Builder,
            com.google.cloud.documentai.v1.BatchDocumentsInputConfigOrBuilder>
        inputDocumentsBuilder_;
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     *
     * @return Whether the inputDocuments field is set.
     */
    public boolean hasInputDocuments() {
      return inputDocumentsBuilder_ != null || inputDocuments_ != null;
    }
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     *
     * @return The inputDocuments.
     */
    public com.google.cloud.documentai.v1.BatchDocumentsInputConfig getInputDocuments() {
      if (inputDocumentsBuilder_ == null) {
        return inputDocuments_ == null
            ? com.google.cloud.documentai.v1.BatchDocumentsInputConfig.getDefaultInstance()
            : inputDocuments_;
      } else {
        return inputDocumentsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public Builder setInputDocuments(
        com.google.cloud.documentai.v1.BatchDocumentsInputConfig value) {
      if (inputDocumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputDocuments_ = value;
        onChanged();
      } else {
        inputDocumentsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public Builder setInputDocuments(
        com.google.cloud.documentai.v1.BatchDocumentsInputConfig.Builder builderForValue) {
      if (inputDocumentsBuilder_ == null) {
        inputDocuments_ = builderForValue.build();
        onChanged();
      } else {
        inputDocumentsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public Builder mergeInputDocuments(
        com.google.cloud.documentai.v1.BatchDocumentsInputConfig value) {
      if (inputDocumentsBuilder_ == null) {
        if (inputDocuments_ != null) {
          inputDocuments_ =
              com.google.cloud.documentai.v1.BatchDocumentsInputConfig.newBuilder(inputDocuments_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inputDocuments_ = value;
        }
        onChanged();
      } else {
        inputDocumentsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public Builder clearInputDocuments() {
      if (inputDocumentsBuilder_ == null) {
        inputDocuments_ = null;
        onChanged();
      } else {
        inputDocuments_ = null;
        inputDocumentsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public com.google.cloud.documentai.v1.BatchDocumentsInputConfig.Builder
        getInputDocumentsBuilder() {

      onChanged();
      return getInputDocumentsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    public com.google.cloud.documentai.v1.BatchDocumentsInputConfigOrBuilder
        getInputDocumentsOrBuilder() {
      if (inputDocumentsBuilder_ != null) {
        return inputDocumentsBuilder_.getMessageOrBuilder();
      } else {
        return inputDocuments_ == null
            ? com.google.cloud.documentai.v1.BatchDocumentsInputConfig.getDefaultInstance()
            : inputDocuments_;
      }
    }
    /**
     *
     *
     * <pre>
     * The input documents for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.BatchDocumentsInputConfig input_documents = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.BatchDocumentsInputConfig,
            com.google.cloud.documentai.v1.BatchDocumentsInputConfig.Builder,
            com.google.cloud.documentai.v1.BatchDocumentsInputConfigOrBuilder>
        getInputDocumentsFieldBuilder() {
      if (inputDocumentsBuilder_ == null) {
        inputDocumentsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1.BatchDocumentsInputConfig,
                com.google.cloud.documentai.v1.BatchDocumentsInputConfig.Builder,
                com.google.cloud.documentai.v1.BatchDocumentsInputConfigOrBuilder>(
                getInputDocuments(), getParentForChildren(), isClean());
        inputDocuments_ = null;
      }
      return inputDocumentsBuilder_;
    }

    private com.google.cloud.documentai.v1.DocumentOutputConfig documentOutputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.DocumentOutputConfig,
            com.google.cloud.documentai.v1.DocumentOutputConfig.Builder,
            com.google.cloud.documentai.v1.DocumentOutputConfigOrBuilder>
        documentOutputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     *
     * @return Whether the documentOutputConfig field is set.
     */
    public boolean hasDocumentOutputConfig() {
      return documentOutputConfigBuilder_ != null || documentOutputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     *
     * @return The documentOutputConfig.
     */
    public com.google.cloud.documentai.v1.DocumentOutputConfig getDocumentOutputConfig() {
      if (documentOutputConfigBuilder_ == null) {
        return documentOutputConfig_ == null
            ? com.google.cloud.documentai.v1.DocumentOutputConfig.getDefaultInstance()
            : documentOutputConfig_;
      } else {
        return documentOutputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     */
    public Builder setDocumentOutputConfig(
        com.google.cloud.documentai.v1.DocumentOutputConfig value) {
      if (documentOutputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentOutputConfig_ = value;
        onChanged();
      } else {
        documentOutputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     */
    public Builder setDocumentOutputConfig(
        com.google.cloud.documentai.v1.DocumentOutputConfig.Builder builderForValue) {
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfig_ = builderForValue.build();
        onChanged();
      } else {
        documentOutputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     */
    public Builder mergeDocumentOutputConfig(
        com.google.cloud.documentai.v1.DocumentOutputConfig value) {
      if (documentOutputConfigBuilder_ == null) {
        if (documentOutputConfig_ != null) {
          documentOutputConfig_ =
              com.google.cloud.documentai.v1.DocumentOutputConfig.newBuilder(documentOutputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentOutputConfig_ = value;
        }
        onChanged();
      } else {
        documentOutputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     */
    public Builder clearDocumentOutputConfig() {
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfig_ = null;
        onChanged();
      } else {
        documentOutputConfig_ = null;
        documentOutputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     */
    public com.google.cloud.documentai.v1.DocumentOutputConfig.Builder
        getDocumentOutputConfigBuilder() {

      onChanged();
      return getDocumentOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     */
    public com.google.cloud.documentai.v1.DocumentOutputConfigOrBuilder
        getDocumentOutputConfigOrBuilder() {
      if (documentOutputConfigBuilder_ != null) {
        return documentOutputConfigBuilder_.getMessageOrBuilder();
      } else {
        return documentOutputConfig_ == null
            ? com.google.cloud.documentai.v1.DocumentOutputConfig.getDefaultInstance()
            : documentOutputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The overall output config for batch process.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1.DocumentOutputConfig document_output_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1.DocumentOutputConfig,
            com.google.cloud.documentai.v1.DocumentOutputConfig.Builder,
            com.google.cloud.documentai.v1.DocumentOutputConfigOrBuilder>
        getDocumentOutputConfigFieldBuilder() {
      if (documentOutputConfigBuilder_ == null) {
        documentOutputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1.DocumentOutputConfig,
                com.google.cloud.documentai.v1.DocumentOutputConfig.Builder,
                com.google.cloud.documentai.v1.DocumentOutputConfigOrBuilder>(
                getDocumentOutputConfig(), getParentForChildren(), isClean());
        documentOutputConfig_ = null;
      }
      return documentOutputConfigBuilder_;
    }

    private boolean skipHumanReview_;
    /**
     *
     *
     * <pre>
     * Whether Human Review feature should be skipped for this request. Default to
     * false.
     * </pre>
     *
     * <code>bool skip_human_review = 4;</code>
     *
     * @return The skipHumanReview.
     */
    @java.lang.Override
    public boolean getSkipHumanReview() {
      return skipHumanReview_;
    }
    /**
     *
     *
     * <pre>
     * Whether Human Review feature should be skipped for this request. Default to
     * false.
     * </pre>
     *
     * <code>bool skip_human_review = 4;</code>
     *
     * @param value The skipHumanReview to set.
     * @return This builder for chaining.
     */
    public Builder setSkipHumanReview(boolean value) {

      skipHumanReview_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether Human Review feature should be skipped for this request. Default to
     * false.
     * </pre>
     *
     * <code>bool skip_human_review = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipHumanReview() {

      skipHumanReview_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1.BatchProcessRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1.BatchProcessRequest)
  private static final com.google.cloud.documentai.v1.BatchProcessRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1.BatchProcessRequest();
  }

  public static com.google.cloud.documentai.v1.BatchProcessRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchProcessRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchProcessRequest>() {
        @java.lang.Override
        public BatchProcessRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchProcessRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchProcessRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1.BatchProcessRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
