/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/user_event.proto

package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * UserEvent captures all metadata information DiscoveryEngine API needs to know
 * about how end users interact with customers' website.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.UserEvent}
 */
public final class UserEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.UserEvent)
    UserEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UserEvent.newBuilder() to construct.
  private UserEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UserEvent() {
    eventType_ = "";
    userPseudoId_ = "";
    sessionId_ = "";
    attributionToken_ = "";
    filter_ = "";
    documents_ = java.util.Collections.emptyList();
    tagIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    promotionIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UserEvent();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1beta_UserEvent_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 17:
        return internalGetAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.UserEventProto
        .internal_static_google_cloud_discoveryengine_v1beta_UserEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.UserEvent.class,
            com.google.cloud.discoveryengine.v1beta.UserEvent.Builder.class);
  }

  public static final int EVENT_TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object eventType_;
  /**
   *
   *
   * <pre>
   * Required. User event type. Allowed values are:
   * Generic values:
   * * `search`: Search for Documents.
   * * `view-item`: Detailed page view of a Document.
   * * `view-item-list`: View of a panel or ordered list of Documents.
   * * `view-home-page`: View of the home page.
   * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
   * Retail-related values:
   * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
   * * `purchase`: Purchase an item(s)
   * Media-related values:
   * * `media-play`: Start/resume watching a video, playing a song, etc.
   * * `media-complete`: Finished or stopped midway through a video, song, etc.
   * </pre>
   *
   * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The eventType.
   */
  @java.lang.Override
  public java.lang.String getEventType() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eventType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. User event type. Allowed values are:
   * Generic values:
   * * `search`: Search for Documents.
   * * `view-item`: Detailed page view of a Document.
   * * `view-item-list`: View of a panel or ordered list of Documents.
   * * `view-home-page`: View of the home page.
   * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
   * Retail-related values:
   * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
   * * `purchase`: Purchase an item(s)
   * Media-related values:
   * * `media-play`: Start/resume watching a video, playing a song, etc.
   * * `media-complete`: Finished or stopped midway through a video, song, etc.
   * </pre>
   *
   * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for eventType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventTypeBytes() {
    java.lang.Object ref = eventType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eventType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_PSEUDO_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object userPseudoId_;
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for tracking visitors.
   * For example, this could be implemented with an HTTP cookie, which should be
   * able to uniquely identify a visitor on a single device. This unique
   * identifier should not change if the visitor log in/out of the website.
   * Do not set the field to the same fixed ID for different users. This mixes
   * the event history of those users together, which results in degraded model
   * quality.
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * The field should not contain PII or user-data. We recommend to use Google
   * Analytics [Client
   * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
   * for this field.
   * </pre>
   *
   * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The userPseudoId.
   */
  @java.lang.Override
  public java.lang.String getUserPseudoId() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userPseudoId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A unique identifier for tracking visitors.
   * For example, this could be implemented with an HTTP cookie, which should be
   * able to uniquely identify a visitor on a single device. This unique
   * identifier should not change if the visitor log in/out of the website.
   * Do not set the field to the same fixed ID for different users. This mixes
   * the event history of those users together, which results in degraded model
   * quality.
   * The field must be a UTF-8 encoded string with a length limit of 128
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * The field should not contain PII or user-data. We recommend to use Google
   * Analytics [Client
   * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
   * for this field.
   * </pre>
   *
   * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for userPseudoId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserPseudoIdBytes() {
    java.lang.Object ref = userPseudoId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userPseudoId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp eventTime_;
  /**
   *
   *
   * <pre>
   * Only required for
   * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
   * method. Timestamp of when the user event happened.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   *
   * @return Whether the eventTime field is set.
   */
  @java.lang.Override
  public boolean hasEventTime() {
    return eventTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Only required for
   * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
   * method. Timestamp of when the user event happened.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   *
   * @return The eventTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEventTime() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }
  /**
   *
   *
   * <pre>
   * Only required for
   * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
   * method. Timestamp of when the user event happened.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
    return getEventTime();
  }

  public static final int USER_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1beta.UserInfo userInfo_;
  /**
   *
   *
   * <pre>
   * Information about the end user.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
   *
   * @return Whether the userInfo field is set.
   */
  @java.lang.Override
  public boolean hasUserInfo() {
    return userInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the end user.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
   *
   * @return The userInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserInfo getUserInfo() {
    return userInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
        : userInfo_;
  }
  /**
   *
   *
   * <pre>
   * Information about the end user.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder getUserInfoOrBuilder() {
    return getUserInfo();
  }

  public static final int DIRECT_USER_REQUEST_FIELD_NUMBER = 5;
  private boolean directUserRequest_;
  /**
   *
   *
   * <pre>
   * Should set to true if the request is made directly from the end user, in
   * which case the
   * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
   * can be populated from the HTTP request.
   * This flag should be set only if the API request is made directly from the
   * end user such as a mobile app (and not if a gateway or a server is
   * processing and pushing the user events).
   * This should not be set when using the JavaScript tag in
   * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1beta.UserEventService.CollectUserEvent].
   * </pre>
   *
   * <code>bool direct_user_request = 5;</code>
   *
   * @return The directUserRequest.
   */
  @java.lang.Override
  public boolean getDirectUserRequest() {
    return directUserRequest_;
  }

  public static final int SESSION_ID_FIELD_NUMBER = 6;
  private volatile java.lang.Object sessionId_;
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking a visitor session with a length limit of
   * 128 bytes. A session is an aggregation of an end user behavior in a time
   * span.
   * A general guideline to populate the sesion_id:
   * 1. If user has no activity for 30 min, a new session_id should be assigned.
   * 2. The session_id should be unique across users, suggest use uuid or add
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * as prefix.
   * </pre>
   *
   * <code>string session_id = 6;</code>
   *
   * @return The sessionId.
   */
  @java.lang.Override
  public java.lang.String getSessionId() {
    java.lang.Object ref = sessionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sessionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for tracking a visitor session with a length limit of
   * 128 bytes. A session is an aggregation of an end user behavior in a time
   * span.
   * A general guideline to populate the sesion_id:
   * 1. If user has no activity for 30 min, a new session_id should be assigned.
   * 2. The session_id should be unique across users, suggest use uuid or add
   * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
   * as prefix.
   * </pre>
   *
   * <code>string session_id = 6;</code>
   *
   * @return The bytes for sessionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionIdBytes() {
    java.lang.Object ref = sessionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sessionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_INFO_FIELD_NUMBER = 7;
  private com.google.cloud.discoveryengine.v1beta.PageInfo pageInfo_;
  /**
   *
   *
   * <pre>
   * Page metadata such as categories and other critical information for certain
   * event types such as `view-category-page`.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
   *
   * @return Whether the pageInfo field is set.
   */
  @java.lang.Override
  public boolean hasPageInfo() {
    return pageInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Page metadata such as categories and other critical information for certain
   * event types such as `view-category-page`.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
   *
   * @return The pageInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.PageInfo getPageInfo() {
    return pageInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.PageInfo.getDefaultInstance()
        : pageInfo_;
  }
  /**
   *
   *
   * <pre>
   * Page metadata such as categories and other critical information for certain
   * event types such as `view-category-page`.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.PageInfoOrBuilder getPageInfoOrBuilder() {
    return getPageInfo();
  }

  public static final int ATTRIBUTION_TOKEN_FIELD_NUMBER = 8;
  private volatile java.lang.Object attributionToken_;
  /**
   *
   *
   * <pre>
   * Token to attribute an API response to user action(s) to trigger the event.
   * Highly recommended for user events that are the result of
   * [PredictionService.Predict][]. This field enables accurate attribution of
   * recommendation model performance.
   * The value must be one of:
   * * [PredictResponse.attribution_token][] for events that are the result of
   * [PredictionService.Predict][].
   * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1beta.SearchResponse.attribution_token] for events that are the result of
   * [SearchService.Search][].
   * * [CompleteQueryResponse.attribution_token][] for events that are the
   * result of [SearchService.CompleteQuery][].
   * This token enables us to accurately attribute page view or conversion
   * completion back to the event and the particular predict response containing
   * this clicked/purchased product. If user clicks on product K in the
   * recommendation results, pass [PredictResponse.attribution_token][] as a URL
   * parameter to product K's page. When recording events on product K's page,
   * log the [PredictResponse.attribution_token][] to this field.
   * </pre>
   *
   * <code>string attribution_token = 8;</code>
   *
   * @return The attributionToken.
   */
  @java.lang.Override
  public java.lang.String getAttributionToken() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attributionToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Token to attribute an API response to user action(s) to trigger the event.
   * Highly recommended for user events that are the result of
   * [PredictionService.Predict][]. This field enables accurate attribution of
   * recommendation model performance.
   * The value must be one of:
   * * [PredictResponse.attribution_token][] for events that are the result of
   * [PredictionService.Predict][].
   * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1beta.SearchResponse.attribution_token] for events that are the result of
   * [SearchService.Search][].
   * * [CompleteQueryResponse.attribution_token][] for events that are the
   * result of [SearchService.CompleteQuery][].
   * This token enables us to accurately attribute page view or conversion
   * completion back to the event and the particular predict response containing
   * this clicked/purchased product. If user clicks on product K in the
   * recommendation results, pass [PredictResponse.attribution_token][] as a URL
   * parameter to product K's page. When recording events on product K's page,
   * log the [PredictResponse.attribution_token][] to this field.
   * </pre>
   *
   * <code>string attribution_token = 8;</code>
   *
   * @return The bytes for attributionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttributionTokenBytes() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attributionToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 9;
  private volatile java.lang.Object filter_;
  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the documents being filtered.
   * One example is for `search` events, the associated
   * [SearchService.SearchRequest][] may contain a filter expression in
   * [SearchService.SearchRequest.filter][] conforming to
   * https://google.aip.dev/160#filtering.
   * Similarly, for `view-item-list` events that are generated from a
   * [PredictionService.PredictRequest][], this field may be populated directly
   * from [PredictionService.PredictRequest.filter][] conforming to
   * https://google.aip.dev/160#filtering.
   * The value must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string filter = 9;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The filter syntax consists of an expression language for constructing a
   * predicate from one or more fields of the documents being filtered.
   * One example is for `search` events, the associated
   * [SearchService.SearchRequest][] may contain a filter expression in
   * [SearchService.SearchRequest.filter][] conforming to
   * https://google.aip.dev/160#filtering.
   * Similarly, for `view-item-list` events that are generated from a
   * [PredictionService.PredictRequest][], this field may be populated directly
   * from [PredictionService.PredictRequest.filter][] conforming to
   * https://google.aip.dev/160#filtering.
   * The value must be a UTF-8 encoded string with a length limit of 1,000
   * characters. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string filter = 9;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTS_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.discoveryengine.v1beta.DocumentInfo> documents_;
  /**
   *
   *
   * <pre>
   * List of Documents associated with this user event.
   * This field is optional except for the following event types:
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1beta.DocumentInfo> getDocumentsList() {
    return documents_;
  }
  /**
   *
   *
   * <pre>
   * List of Documents associated with this user event.
   * This field is optional except for the following event types:
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.DocumentInfoOrBuilder>
      getDocumentsOrBuilderList() {
    return documents_;
  }
  /**
   *
   *
   * <pre>
   * List of Documents associated with this user event.
   * This field is optional except for the following event types:
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public int getDocumentsCount() {
    return documents_.size();
  }
  /**
   *
   *
   * <pre>
   * List of Documents associated with this user event.
   * This field is optional except for the following event types:
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentInfo getDocuments(int index) {
    return documents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of Documents associated with this user event.
   * This field is optional except for the following event types:
   * * `view-item`
   * * `add-to-cart`
   * * `purchase`
   * * `media-play`
   * * `media-complete`
   * In a `search` event, this field represents the documents returned to the
   * end user on the current page (the end user may have not finished browsing
   * the whole page yet). When a new page is returned to the end user, after
   * pagination/filtering/ordering even for the same query, a new `search` event
   * with different
   * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
   * is desired.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.DocumentInfoOrBuilder getDocumentsOrBuilder(
      int index) {
    return documents_.get(index);
  }

  public static final int PANEL_FIELD_NUMBER = 11;
  private com.google.cloud.discoveryengine.v1beta.PanelInfo panel_;
  /**
   *
   *
   * <pre>
   * Panel metadata associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
   *
   * @return Whether the panel field is set.
   */
  @java.lang.Override
  public boolean hasPanel() {
    return panel_ != null;
  }
  /**
   *
   *
   * <pre>
   * Panel metadata associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
   *
   * @return The panel.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.PanelInfo getPanel() {
    return panel_ == null
        ? com.google.cloud.discoveryengine.v1beta.PanelInfo.getDefaultInstance()
        : panel_;
  }
  /**
   *
   *
   * <pre>
   * Panel metadata associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.PanelInfoOrBuilder getPanelOrBuilder() {
    return getPanel();
  }

  public static final int SEARCH_INFO_FIELD_NUMBER = 12;
  private com.google.cloud.discoveryengine.v1beta.SearchInfo searchInfo_;
  /**
   *
   *
   * <pre>
   * Search API details related to the event.
   * This field should be set for `search` event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
   *
   * @return Whether the searchInfo field is set.
   */
  @java.lang.Override
  public boolean hasSearchInfo() {
    return searchInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Search API details related to the event.
   * This field should be set for `search` event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
   *
   * @return The searchInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchInfo getSearchInfo() {
    return searchInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.SearchInfo.getDefaultInstance()
        : searchInfo_;
  }
  /**
   *
   *
   * <pre>
   * Search API details related to the event.
   * This field should be set for `search` event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.SearchInfoOrBuilder getSearchInfoOrBuilder() {
    return getSearchInfo();
  }

  public static final int COMPLETION_INFO_FIELD_NUMBER = 13;
  private com.google.cloud.discoveryengine.v1beta.CompletionInfo completionInfo_;
  /**
   *
   *
   * <pre>
   * CompleteQuery API details related to the event.
   * This field should be set for `search` event when autocomplete function is
   * enabled and the user clicks a suggestion for search.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
   *
   * @return Whether the completionInfo field is set.
   */
  @java.lang.Override
  public boolean hasCompletionInfo() {
    return completionInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * CompleteQuery API details related to the event.
   * This field should be set for `search` event when autocomplete function is
   * enabled and the user clicks a suggestion for search.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
   *
   * @return The completionInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CompletionInfo getCompletionInfo() {
    return completionInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.CompletionInfo.getDefaultInstance()
        : completionInfo_;
  }
  /**
   *
   *
   * <pre>
   * CompleteQuery API details related to the event.
   * This field should be set for `search` event when autocomplete function is
   * enabled and the user clicks a suggestion for search.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CompletionInfoOrBuilder
      getCompletionInfoOrBuilder() {
    return getCompletionInfo();
  }

  public static final int TRANSACTION_INFO_FIELD_NUMBER = 14;
  private com.google.cloud.discoveryengine.v1beta.TransactionInfo transactionInfo_;
  /**
   *
   *
   * <pre>
   * The transaction metadata (if any) associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
   *
   * @return Whether the transactionInfo field is set.
   */
  @java.lang.Override
  public boolean hasTransactionInfo() {
    return transactionInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * The transaction metadata (if any) associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
   *
   * @return The transactionInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TransactionInfo getTransactionInfo() {
    return transactionInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.TransactionInfo.getDefaultInstance()
        : transactionInfo_;
  }
  /**
   *
   *
   * <pre>
   * The transaction metadata (if any) associated with this user event.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.TransactionInfoOrBuilder
      getTransactionInfoOrBuilder() {
    return getTransactionInfo();
  }

  public static final int TAG_IDS_FIELD_NUMBER = 15;
  private com.google.protobuf.LazyStringList tagIds_;
  /**
   *
   *
   * <pre>
   * A list of identifiers for the independent experiment groups this user event
   * belongs to. This is used to distinguish between user events associated with
   * different experiment setups on the customer end.
   * </pre>
   *
   * <code>repeated string tag_ids = 15;</code>
   *
   * @return A list containing the tagIds.
   */
  public com.google.protobuf.ProtocolStringList getTagIdsList() {
    return tagIds_;
  }
  /**
   *
   *
   * <pre>
   * A list of identifiers for the independent experiment groups this user event
   * belongs to. This is used to distinguish between user events associated with
   * different experiment setups on the customer end.
   * </pre>
   *
   * <code>repeated string tag_ids = 15;</code>
   *
   * @return The count of tagIds.
   */
  public int getTagIdsCount() {
    return tagIds_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of identifiers for the independent experiment groups this user event
   * belongs to. This is used to distinguish between user events associated with
   * different experiment setups on the customer end.
   * </pre>
   *
   * <code>repeated string tag_ids = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The tagIds at the given index.
   */
  public java.lang.String getTagIds(int index) {
    return tagIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of identifiers for the independent experiment groups this user event
   * belongs to. This is used to distinguish between user events associated with
   * different experiment setups on the customer end.
   * </pre>
   *
   * <code>repeated string tag_ids = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tagIds at the given index.
   */
  public com.google.protobuf.ByteString getTagIdsBytes(int index) {
    return tagIds_.getByteString(index);
  }

  public static final int PROMOTION_IDS_FIELD_NUMBER = 16;
  private com.google.protobuf.LazyStringList promotionIds_;
  /**
   *
   *
   * <pre>
   * The promotion IDs if this is an event associated with promotions.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 16;</code>
   *
   * @return A list containing the promotionIds.
   */
  public com.google.protobuf.ProtocolStringList getPromotionIdsList() {
    return promotionIds_;
  }
  /**
   *
   *
   * <pre>
   * The promotion IDs if this is an event associated with promotions.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 16;</code>
   *
   * @return The count of promotionIds.
   */
  public int getPromotionIdsCount() {
    return promotionIds_.size();
  }
  /**
   *
   *
   * <pre>
   * The promotion IDs if this is an event associated with promotions.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 16;</code>
   *
   * @param index The index of the element to return.
   * @return The promotionIds at the given index.
   */
  public java.lang.String getPromotionIds(int index) {
    return promotionIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The promotion IDs if this is an event associated with promotions.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 16;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the promotionIds at the given index.
   */
  public com.google.protobuf.ByteString getPromotionIdsBytes(int index) {
    return promotionIds_.getByteString(index);
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 17;

  private static final class AttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
                    newDefaultInstance(
                        com.google.cloud.discoveryengine.v1beta.UserEventProto
                            .internal_static_google_cloud_discoveryengine_v1beta_UserEvent_AttributesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.discoveryengine.v1beta.CustomAttribute
                            .getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
      attributes_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
      internalGetAttributes() {
    if (attributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
    }
    return attributes_;
  }

  public int getAttributesCount() {
    return internalGetAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Extra user event features to include in the recommendation model.
   * These attributes must NOT contain data that needs to be parsed or processed
   * further, e.g. JSON or other encodings.
   * If you provide custom attributes for ingested user events, also include
   * them in the user events that you associate with prediction requests. Custom
   * attribute formatting must be consistent between imported events and events
   * provided with prediction requests. This lets the DiscoveryEngine API use
   * those custom attributes when training models and serving predictions, which
   * helps improve recommendation quality.
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   * * The key must be a UTF-8 encoded string with a length limit of 5,000
   *   characters.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a UTF-8 encoded string with a length limit of
   *   256 characters.
   * * For number attributes, at most 400 values are allowed.
   * For product recommendations, an example of extra user information is
   * traffic_channel, which is how a user arrives at the site. Users can arrive
   * at the site by coming to the site directly, coming through Google
   * search, or in other ways.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
   * </code>
   */
  @java.lang.Override
  public boolean containsAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
      getAttributes() {
    return getAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Extra user event features to include in the recommendation model.
   * These attributes must NOT contain data that needs to be parsed or processed
   * further, e.g. JSON or other encodings.
   * If you provide custom attributes for ingested user events, also include
   * them in the user events that you associate with prediction requests. Custom
   * attribute formatting must be consistent between imported events and events
   * provided with prediction requests. This lets the DiscoveryEngine API use
   * those custom attributes when training models and serving predictions, which
   * helps improve recommendation quality.
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   * * The key must be a UTF-8 encoded string with a length limit of 5,000
   *   characters.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a UTF-8 encoded string with a length limit of
   *   256 characters.
   * * For number attributes, at most 400 values are allowed.
   * For product recommendations, an example of extra user information is
   * traffic_channel, which is how a user arrives at the site. Users can arrive
   * at the site by coming to the site directly, coming through Google
   * search, or in other ways.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
      getAttributesMap() {
    return internalGetAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Extra user event features to include in the recommendation model.
   * These attributes must NOT contain data that needs to be parsed or processed
   * further, e.g. JSON or other encodings.
   * If you provide custom attributes for ingested user events, also include
   * them in the user events that you associate with prediction requests. Custom
   * attribute formatting must be consistent between imported events and events
   * provided with prediction requests. This lets the DiscoveryEngine API use
   * those custom attributes when training models and serving predictions, which
   * helps improve recommendation quality.
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   * * The key must be a UTF-8 encoded string with a length limit of 5,000
   *   characters.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a UTF-8 encoded string with a length limit of
   *   256 characters.
   * * For number attributes, at most 400 values are allowed.
   * For product recommendations, an example of extra user information is
   * traffic_channel, which is how a user arrives at the site. Users can arrive
   * at the site by coming to the site directly, coming through Google
   * search, or in other ways.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CustomAttribute getAttributesOrDefault(
      java.lang.String key, com.google.cloud.discoveryengine.v1beta.CustomAttribute defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute> map =
        internalGetAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Extra user event features to include in the recommendation model.
   * These attributes must NOT contain data that needs to be parsed or processed
   * further, e.g. JSON or other encodings.
   * If you provide custom attributes for ingested user events, also include
   * them in the user events that you associate with prediction requests. Custom
   * attribute formatting must be consistent between imported events and events
   * provided with prediction requests. This lets the DiscoveryEngine API use
   * those custom attributes when training models and serving predictions, which
   * helps improve recommendation quality.
   * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
   * error is returned:
   * * The key must be a UTF-8 encoded string with a length limit of 5,000
   *   characters.
   * * For text attributes, at most 400 values are allowed. Empty values are not
   *   allowed. Each value must be a UTF-8 encoded string with a length limit of
   *   256 characters.
   * * For number attributes, at most 400 values are allowed.
   * For product recommendations, an example of extra user information is
   * traffic_channel, which is how a user arrives at the site. Users can arrive
   * at the site by coming to the site directly, coming through Google
   * search, or in other ways.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.CustomAttribute getAttributesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute> map =
        internalGetAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MEDIA_INFO_FIELD_NUMBER = 18;
  private com.google.cloud.discoveryengine.v1beta.MediaInfo mediaInfo_;
  /**
   *
   *
   * <pre>
   * Media-specific info.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
   *
   * @return Whether the mediaInfo field is set.
   */
  @java.lang.Override
  public boolean hasMediaInfo() {
    return mediaInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Media-specific info.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
   *
   * @return The mediaInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.MediaInfo getMediaInfo() {
    return mediaInfo_ == null
        ? com.google.cloud.discoveryengine.v1beta.MediaInfo.getDefaultInstance()
        : mediaInfo_;
  }
  /**
   *
   *
   * <pre>
   * Media-specific info.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.MediaInfoOrBuilder getMediaInfoOrBuilder() {
    return getMediaInfo();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, eventType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, userPseudoId_);
    }
    if (eventTime_ != null) {
      output.writeMessage(3, getEventTime());
    }
    if (userInfo_ != null) {
      output.writeMessage(4, getUserInfo());
    }
    if (directUserRequest_ != false) {
      output.writeBool(5, directUserRequest_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, sessionId_);
    }
    if (pageInfo_ != null) {
      output.writeMessage(7, getPageInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, attributionToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, filter_);
    }
    for (int i = 0; i < documents_.size(); i++) {
      output.writeMessage(10, documents_.get(i));
    }
    if (panel_ != null) {
      output.writeMessage(11, getPanel());
    }
    if (searchInfo_ != null) {
      output.writeMessage(12, getSearchInfo());
    }
    if (completionInfo_ != null) {
      output.writeMessage(13, getCompletionInfo());
    }
    if (transactionInfo_ != null) {
      output.writeMessage(14, getTransactionInfo());
    }
    for (int i = 0; i < tagIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, tagIds_.getRaw(i));
    }
    for (int i = 0; i < promotionIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, promotionIds_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 17);
    if (mediaInfo_ != null) {
      output.writeMessage(18, getMediaInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, eventType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userPseudoId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, userPseudoId_);
    }
    if (eventTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEventTime());
    }
    if (userInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUserInfo());
    }
    if (directUserRequest_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, directUserRequest_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, sessionId_);
    }
    if (pageInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPageInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, attributionToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, filter_);
    }
    for (int i = 0; i < documents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, documents_.get(i));
    }
    if (panel_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getPanel());
    }
    if (searchInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getSearchInfo());
    }
    if (completionInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCompletionInfo());
    }
    if (transactionInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getTransactionInfo());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tagIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(tagIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagIdsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < promotionIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(promotionIds_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getPromotionIdsList().size();
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
        entry : internalGetAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
          attributes__ =
              AttributesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, attributes__);
    }
    if (mediaInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getMediaInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.UserEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.UserEvent other =
        (com.google.cloud.discoveryengine.v1beta.UserEvent) obj;

    if (!getEventType().equals(other.getEventType())) return false;
    if (!getUserPseudoId().equals(other.getUserPseudoId())) return false;
    if (hasEventTime() != other.hasEventTime()) return false;
    if (hasEventTime()) {
      if (!getEventTime().equals(other.getEventTime())) return false;
    }
    if (hasUserInfo() != other.hasUserInfo()) return false;
    if (hasUserInfo()) {
      if (!getUserInfo().equals(other.getUserInfo())) return false;
    }
    if (getDirectUserRequest() != other.getDirectUserRequest()) return false;
    if (!getSessionId().equals(other.getSessionId())) return false;
    if (hasPageInfo() != other.hasPageInfo()) return false;
    if (hasPageInfo()) {
      if (!getPageInfo().equals(other.getPageInfo())) return false;
    }
    if (!getAttributionToken().equals(other.getAttributionToken())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getDocumentsList().equals(other.getDocumentsList())) return false;
    if (hasPanel() != other.hasPanel()) return false;
    if (hasPanel()) {
      if (!getPanel().equals(other.getPanel())) return false;
    }
    if (hasSearchInfo() != other.hasSearchInfo()) return false;
    if (hasSearchInfo()) {
      if (!getSearchInfo().equals(other.getSearchInfo())) return false;
    }
    if (hasCompletionInfo() != other.hasCompletionInfo()) return false;
    if (hasCompletionInfo()) {
      if (!getCompletionInfo().equals(other.getCompletionInfo())) return false;
    }
    if (hasTransactionInfo() != other.hasTransactionInfo()) return false;
    if (hasTransactionInfo()) {
      if (!getTransactionInfo().equals(other.getTransactionInfo())) return false;
    }
    if (!getTagIdsList().equals(other.getTagIdsList())) return false;
    if (!getPromotionIdsList().equals(other.getPromotionIdsList())) return false;
    if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
    if (hasMediaInfo() != other.hasMediaInfo()) return false;
    if (hasMediaInfo()) {
      if (!getMediaInfo().equals(other.getMediaInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getEventType().hashCode();
    hash = (37 * hash) + USER_PSEUDO_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserPseudoId().hashCode();
    if (hasEventTime()) {
      hash = (37 * hash) + EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEventTime().hashCode();
    }
    if (hasUserInfo()) {
      hash = (37 * hash) + USER_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getUserInfo().hashCode();
    }
    hash = (37 * hash) + DIRECT_USER_REQUEST_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDirectUserRequest());
    hash = (37 * hash) + SESSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSessionId().hashCode();
    if (hasPageInfo()) {
      hash = (37 * hash) + PAGE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPageInfo().hashCode();
    }
    hash = (37 * hash) + ATTRIBUTION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getAttributionToken().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (getDocumentsCount() > 0) {
      hash = (37 * hash) + DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentsList().hashCode();
    }
    if (hasPanel()) {
      hash = (37 * hash) + PANEL_FIELD_NUMBER;
      hash = (53 * hash) + getPanel().hashCode();
    }
    if (hasSearchInfo()) {
      hash = (37 * hash) + SEARCH_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSearchInfo().hashCode();
    }
    if (hasCompletionInfo()) {
      hash = (37 * hash) + COMPLETION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getCompletionInfo().hashCode();
    }
    if (hasTransactionInfo()) {
      hash = (37 * hash) + TRANSACTION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getTransactionInfo().hashCode();
    }
    if (getTagIdsCount() > 0) {
      hash = (37 * hash) + TAG_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getTagIdsList().hashCode();
    }
    if (getPromotionIdsCount() > 0) {
      hash = (37 * hash) + PROMOTION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getPromotionIdsList().hashCode();
    }
    if (!internalGetAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttributes().hashCode();
    }
    if (hasMediaInfo()) {
      hash = (37 * hash) + MEDIA_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getMediaInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1beta.UserEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * UserEvent captures all metadata information DiscoveryEngine API needs to know
   * about how end users interact with customers' website.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.UserEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.UserEvent)
      com.google.cloud.discoveryengine.v1beta.UserEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_UserEvent_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 17:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 17:
          return internalGetMutableAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_UserEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.UserEvent.class,
              com.google.cloud.discoveryengine.v1beta.UserEvent.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.UserEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      eventType_ = "";

      userPseudoId_ = "";

      if (eventTimeBuilder_ == null) {
        eventTime_ = null;
      } else {
        eventTime_ = null;
        eventTimeBuilder_ = null;
      }
      if (userInfoBuilder_ == null) {
        userInfo_ = null;
      } else {
        userInfo_ = null;
        userInfoBuilder_ = null;
      }
      directUserRequest_ = false;

      sessionId_ = "";

      if (pageInfoBuilder_ == null) {
        pageInfo_ = null;
      } else {
        pageInfo_ = null;
        pageInfoBuilder_ = null;
      }
      attributionToken_ = "";

      filter_ = "";

      if (documentsBuilder_ == null) {
        documents_ = java.util.Collections.emptyList();
      } else {
        documents_ = null;
        documentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (panelBuilder_ == null) {
        panel_ = null;
      } else {
        panel_ = null;
        panelBuilder_ = null;
      }
      if (searchInfoBuilder_ == null) {
        searchInfo_ = null;
      } else {
        searchInfo_ = null;
        searchInfoBuilder_ = null;
      }
      if (completionInfoBuilder_ == null) {
        completionInfo_ = null;
      } else {
        completionInfo_ = null;
        completionInfoBuilder_ = null;
      }
      if (transactionInfoBuilder_ == null) {
        transactionInfo_ = null;
      } else {
        transactionInfo_ = null;
        transactionInfoBuilder_ = null;
      }
      tagIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      promotionIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableAttributes().clear();
      if (mediaInfoBuilder_ == null) {
        mediaInfo_ = null;
      } else {
        mediaInfo_ = null;
        mediaInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.UserEventProto
          .internal_static_google_cloud_discoveryengine_v1beta_UserEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.UserEvent getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.UserEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.UserEvent build() {
      com.google.cloud.discoveryengine.v1beta.UserEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.UserEvent buildPartial() {
      com.google.cloud.discoveryengine.v1beta.UserEvent result =
          new com.google.cloud.discoveryengine.v1beta.UserEvent(this);
      int from_bitField0_ = bitField0_;
      result.eventType_ = eventType_;
      result.userPseudoId_ = userPseudoId_;
      if (eventTimeBuilder_ == null) {
        result.eventTime_ = eventTime_;
      } else {
        result.eventTime_ = eventTimeBuilder_.build();
      }
      if (userInfoBuilder_ == null) {
        result.userInfo_ = userInfo_;
      } else {
        result.userInfo_ = userInfoBuilder_.build();
      }
      result.directUserRequest_ = directUserRequest_;
      result.sessionId_ = sessionId_;
      if (pageInfoBuilder_ == null) {
        result.pageInfo_ = pageInfo_;
      } else {
        result.pageInfo_ = pageInfoBuilder_.build();
      }
      result.attributionToken_ = attributionToken_;
      result.filter_ = filter_;
      if (documentsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          documents_ = java.util.Collections.unmodifiableList(documents_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.documents_ = documents_;
      } else {
        result.documents_ = documentsBuilder_.build();
      }
      if (panelBuilder_ == null) {
        result.panel_ = panel_;
      } else {
        result.panel_ = panelBuilder_.build();
      }
      if (searchInfoBuilder_ == null) {
        result.searchInfo_ = searchInfo_;
      } else {
        result.searchInfo_ = searchInfoBuilder_.build();
      }
      if (completionInfoBuilder_ == null) {
        result.completionInfo_ = completionInfo_;
      } else {
        result.completionInfo_ = completionInfoBuilder_.build();
      }
      if (transactionInfoBuilder_ == null) {
        result.transactionInfo_ = transactionInfo_;
      } else {
        result.transactionInfo_ = transactionInfoBuilder_.build();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        tagIds_ = tagIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.tagIds_ = tagIds_;
      if (((bitField0_ & 0x00000004) != 0)) {
        promotionIds_ = promotionIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.promotionIds_ = promotionIds_;
      result.attributes_ = internalGetAttributes();
      result.attributes_.makeImmutable();
      if (mediaInfoBuilder_ == null) {
        result.mediaInfo_ = mediaInfo_;
      } else {
        result.mediaInfo_ = mediaInfoBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.UserEvent) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.UserEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.UserEvent other) {
      if (other == com.google.cloud.discoveryengine.v1beta.UserEvent.getDefaultInstance())
        return this;
      if (!other.getEventType().isEmpty()) {
        eventType_ = other.eventType_;
        onChanged();
      }
      if (!other.getUserPseudoId().isEmpty()) {
        userPseudoId_ = other.userPseudoId_;
        onChanged();
      }
      if (other.hasEventTime()) {
        mergeEventTime(other.getEventTime());
      }
      if (other.hasUserInfo()) {
        mergeUserInfo(other.getUserInfo());
      }
      if (other.getDirectUserRequest() != false) {
        setDirectUserRequest(other.getDirectUserRequest());
      }
      if (!other.getSessionId().isEmpty()) {
        sessionId_ = other.sessionId_;
        onChanged();
      }
      if (other.hasPageInfo()) {
        mergePageInfo(other.getPageInfo());
      }
      if (!other.getAttributionToken().isEmpty()) {
        attributionToken_ = other.attributionToken_;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        onChanged();
      }
      if (documentsBuilder_ == null) {
        if (!other.documents_.isEmpty()) {
          if (documents_.isEmpty()) {
            documents_ = other.documents_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDocumentsIsMutable();
            documents_.addAll(other.documents_);
          }
          onChanged();
        }
      } else {
        if (!other.documents_.isEmpty()) {
          if (documentsBuilder_.isEmpty()) {
            documentsBuilder_.dispose();
            documentsBuilder_ = null;
            documents_ = other.documents_;
            bitField0_ = (bitField0_ & ~0x00000001);
            documentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDocumentsFieldBuilder()
                    : null;
          } else {
            documentsBuilder_.addAllMessages(other.documents_);
          }
        }
      }
      if (other.hasPanel()) {
        mergePanel(other.getPanel());
      }
      if (other.hasSearchInfo()) {
        mergeSearchInfo(other.getSearchInfo());
      }
      if (other.hasCompletionInfo()) {
        mergeCompletionInfo(other.getCompletionInfo());
      }
      if (other.hasTransactionInfo()) {
        mergeTransactionInfo(other.getTransactionInfo());
      }
      if (!other.tagIds_.isEmpty()) {
        if (tagIds_.isEmpty()) {
          tagIds_ = other.tagIds_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureTagIdsIsMutable();
          tagIds_.addAll(other.tagIds_);
        }
        onChanged();
      }
      if (!other.promotionIds_.isEmpty()) {
        if (promotionIds_.isEmpty()) {
          promotionIds_ = other.promotionIds_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensurePromotionIdsIsMutable();
          promotionIds_.addAll(other.promotionIds_);
        }
        onChanged();
      }
      internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
      if (other.hasMediaInfo()) {
        mergeMediaInfo(other.getMediaInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                eventType_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                userPseudoId_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEventTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUserInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 40:
              {
                directUserRequest_ = input.readBool();

                break;
              } // case 40
            case 50:
              {
                sessionId_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPageInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                attributionToken_ = input.readStringRequireUtf8();

                break;
              } // case 66
            case 74:
              {
                filter_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 82:
              {
                com.google.cloud.discoveryengine.v1beta.DocumentInfo m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1beta.DocumentInfo.parser(),
                        extensionRegistry);
                if (documentsBuilder_ == null) {
                  ensureDocumentsIsMutable();
                  documents_.add(m);
                } else {
                  documentsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getPanelFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 90
            case 98:
              {
                input.readMessage(getSearchInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 106:
              {
                input.readMessage(getCompletionInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 106
            case 114:
              {
                input.readMessage(getTransactionInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 114
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagIdsIsMutable();
                tagIds_.add(s);
                break;
              } // case 122
            case 130:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePromotionIdsIsMutable();
                promotionIds_.add(s);
                break;
              } // case 130
            case 138:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
                    attributes__ =
                        input.readMessage(
                            AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableAttributes()
                    .getMutableMap()
                    .put(attributes__.getKey(), attributes__.getValue());
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getMediaInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object eventType_ = "";
    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     * Generic values:
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * Retail-related values:
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     * Media-related values:
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The eventType.
     */
    public java.lang.String getEventType() {
      java.lang.Object ref = eventType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eventType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     * Generic values:
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * Retail-related values:
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     * Media-related values:
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for eventType.
     */
    public com.google.protobuf.ByteString getEventTypeBytes() {
      java.lang.Object ref = eventType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eventType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     * Generic values:
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * Retail-related values:
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     * Media-related values:
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      eventType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     * Generic values:
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * Retail-related values:
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     * Media-related values:
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventType() {

      eventType_ = getDefaultInstance().getEventType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User event type. Allowed values are:
     * Generic values:
     * * `search`: Search for Documents.
     * * `view-item`: Detailed page view of a Document.
     * * `view-item-list`: View of a panel or ordered list of Documents.
     * * `view-home-page`: View of the home page.
     * * `view-category-page`: View of a category page, e.g. Home &gt; Men &gt; Jeans
     * Retail-related values:
     * * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping
     * * `purchase`: Purchase an item(s)
     * Media-related values:
     * * `media-play`: Start/resume watching a video, playing a song, etc.
     * * `media-complete`: Finished or stopped midway through a video, song, etc.
     * </pre>
     *
     * <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      eventType_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object userPseudoId_ = "";
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The userPseudoId.
     */
    public java.lang.String getUserPseudoId() {
      java.lang.Object ref = userPseudoId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userPseudoId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for userPseudoId.
     */
    public com.google.protobuf.ByteString getUserPseudoIdBytes() {
      java.lang.Object ref = userPseudoId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userPseudoId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      userPseudoId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserPseudoId() {

      userPseudoId_ = getDefaultInstance().getUserPseudoId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * Do not set the field to the same fixed ID for different users. This mixes
     * the event history of those users together, which results in degraded model
     * quality.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * The field should not contain PII or user-data. We recommend to use Google
     * Analytics [Client
     * ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
     * for this field.
     * </pre>
     *
     * <code>string user_pseudo_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for userPseudoId to set.
     * @return This builder for chaining.
     */
    public Builder setUserPseudoIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      userPseudoId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp eventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        eventTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     *
     * @return Whether the eventTime field is set.
     */
    public boolean hasEventTime() {
      return eventTimeBuilder_ != null || eventTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     *
     * @return The eventTime.
     */
    public com.google.protobuf.Timestamp getEventTime() {
      if (eventTimeBuilder_ == null) {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      } else {
        return eventTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventTime_ = value;
        onChanged();
      } else {
        eventTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (eventTimeBuilder_ == null) {
        eventTime_ = builderForValue.build();
        onChanged();
      } else {
        eventTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder mergeEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (eventTime_ != null) {
          eventTime_ =
              com.google.protobuf.Timestamp.newBuilder(eventTime_).mergeFrom(value).buildPartial();
        } else {
          eventTime_ = value;
        }
        onChanged();
      } else {
        eventTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public Builder clearEventTime() {
      if (eventTimeBuilder_ == null) {
        eventTime_ = null;
        onChanged();
      } else {
        eventTime_ = null;
        eventTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEventTimeBuilder() {

      onChanged();
      return getEventTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
      if (eventTimeBuilder_ != null) {
        return eventTimeBuilder_.getMessageOrBuilder();
      } else {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.discoveryengine.v1beta.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEventTimeFieldBuilder() {
      if (eventTimeBuilder_ == null) {
        eventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEventTime(), getParentForChildren(), isClean());
        eventTime_ = null;
      }
      return eventTimeBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.UserInfo userInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.UserInfo,
            com.google.cloud.discoveryengine.v1beta.UserInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder>
        userInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     *
     * @return Whether the userInfo field is set.
     */
    public boolean hasUserInfo() {
      return userInfoBuilder_ != null || userInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     *
     * @return The userInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.UserInfo getUserInfo() {
      if (userInfoBuilder_ == null) {
        return userInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
            : userInfo_;
      } else {
        return userInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     */
    public Builder setUserInfo(com.google.cloud.discoveryengine.v1beta.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userInfo_ = value;
        onChanged();
      } else {
        userInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     */
    public Builder setUserInfo(
        com.google.cloud.discoveryengine.v1beta.UserInfo.Builder builderForValue) {
      if (userInfoBuilder_ == null) {
        userInfo_ = builderForValue.build();
        onChanged();
      } else {
        userInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     */
    public Builder mergeUserInfo(com.google.cloud.discoveryengine.v1beta.UserInfo value) {
      if (userInfoBuilder_ == null) {
        if (userInfo_ != null) {
          userInfo_ =
              com.google.cloud.discoveryengine.v1beta.UserInfo.newBuilder(userInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          userInfo_ = value;
        }
        onChanged();
      } else {
        userInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     */
    public Builder clearUserInfo() {
      if (userInfoBuilder_ == null) {
        userInfo_ = null;
        onChanged();
      } else {
        userInfo_ = null;
        userInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.UserInfo.Builder getUserInfoBuilder() {

      onChanged();
      return getUserInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder getUserInfoOrBuilder() {
      if (userInfoBuilder_ != null) {
        return userInfoBuilder_.getMessageOrBuilder();
      } else {
        return userInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.UserInfo.getDefaultInstance()
            : userInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the end user.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.UserInfo user_info = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.UserInfo,
            com.google.cloud.discoveryengine.v1beta.UserInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder>
        getUserInfoFieldBuilder() {
      if (userInfoBuilder_ == null) {
        userInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.UserInfo,
                com.google.cloud.discoveryengine.v1beta.UserInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.UserInfoOrBuilder>(
                getUserInfo(), getParentForChildren(), isClean());
        userInfo_ = null;
      }
      return userInfoBuilder_;
    }

    private boolean directUserRequest_;
    /**
     *
     *
     * <pre>
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
     * can be populated from the HTTP request.
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1beta.UserEventService.CollectUserEvent].
     * </pre>
     *
     * <code>bool direct_user_request = 5;</code>
     *
     * @return The directUserRequest.
     */
    @java.lang.Override
    public boolean getDirectUserRequest() {
      return directUserRequest_;
    }
    /**
     *
     *
     * <pre>
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
     * can be populated from the HTTP request.
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1beta.UserEventService.CollectUserEvent].
     * </pre>
     *
     * <code>bool direct_user_request = 5;</code>
     *
     * @param value The directUserRequest to set.
     * @return This builder for chaining.
     */
    public Builder setDirectUserRequest(boolean value) {

      directUserRequest_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Should set to true if the request is made directly from the end user, in
     * which case the
     * [UserEvent.user_info.user_agent][google.cloud.discoveryengine.v1beta.UserInfo.user_agent]
     * can be populated from the HTTP request.
     * This flag should be set only if the API request is made directly from the
     * end user such as a mobile app (and not if a gateway or a server is
     * processing and pushing the user events).
     * This should not be set when using the JavaScript tag in
     * [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1beta.UserEventService.CollectUserEvent].
     * </pre>
     *
     * <code>bool direct_user_request = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDirectUserRequest() {

      directUserRequest_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object sessionId_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the sesion_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @return The sessionId.
     */
    public java.lang.String getSessionId() {
      java.lang.Object ref = sessionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sessionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the sesion_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @return The bytes for sessionId.
     */
    public com.google.protobuf.ByteString getSessionIdBytes() {
      java.lang.Object ref = sessionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sessionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the sesion_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @param value The sessionId to set.
     * @return This builder for chaining.
     */
    public Builder setSessionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sessionId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the sesion_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSessionId() {

      sessionId_ = getDefaultInstance().getSessionId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for tracking a visitor session with a length limit of
     * 128 bytes. A session is an aggregation of an end user behavior in a time
     * span.
     * A general guideline to populate the sesion_id:
     * 1. If user has no activity for 30 min, a new session_id should be assigned.
     * 2. The session_id should be unique across users, suggest use uuid or add
     * [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
     * as prefix.
     * </pre>
     *
     * <code>string session_id = 6;</code>
     *
     * @param value The bytes for sessionId to set.
     * @return This builder for chaining.
     */
    public Builder setSessionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      sessionId_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.PageInfo pageInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.PageInfo,
            com.google.cloud.discoveryengine.v1beta.PageInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.PageInfoOrBuilder>
        pageInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     *
     * @return Whether the pageInfo field is set.
     */
    public boolean hasPageInfo() {
      return pageInfoBuilder_ != null || pageInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     *
     * @return The pageInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.PageInfo getPageInfo() {
      if (pageInfoBuilder_ == null) {
        return pageInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.PageInfo.getDefaultInstance()
            : pageInfo_;
      } else {
        return pageInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     */
    public Builder setPageInfo(com.google.cloud.discoveryengine.v1beta.PageInfo value) {
      if (pageInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageInfo_ = value;
        onChanged();
      } else {
        pageInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     */
    public Builder setPageInfo(
        com.google.cloud.discoveryengine.v1beta.PageInfo.Builder builderForValue) {
      if (pageInfoBuilder_ == null) {
        pageInfo_ = builderForValue.build();
        onChanged();
      } else {
        pageInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     */
    public Builder mergePageInfo(com.google.cloud.discoveryengine.v1beta.PageInfo value) {
      if (pageInfoBuilder_ == null) {
        if (pageInfo_ != null) {
          pageInfo_ =
              com.google.cloud.discoveryengine.v1beta.PageInfo.newBuilder(pageInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pageInfo_ = value;
        }
        onChanged();
      } else {
        pageInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     */
    public Builder clearPageInfo() {
      if (pageInfoBuilder_ == null) {
        pageInfo_ = null;
        onChanged();
      } else {
        pageInfo_ = null;
        pageInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.PageInfo.Builder getPageInfoBuilder() {

      onChanged();
      return getPageInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.PageInfoOrBuilder getPageInfoOrBuilder() {
      if (pageInfoBuilder_ != null) {
        return pageInfoBuilder_.getMessageOrBuilder();
      } else {
        return pageInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.PageInfo.getDefaultInstance()
            : pageInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Page metadata such as categories and other critical information for certain
     * event types such as `view-category-page`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PageInfo page_info = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.PageInfo,
            com.google.cloud.discoveryengine.v1beta.PageInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.PageInfoOrBuilder>
        getPageInfoFieldBuilder() {
      if (pageInfoBuilder_ == null) {
        pageInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.PageInfo,
                com.google.cloud.discoveryengine.v1beta.PageInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.PageInfoOrBuilder>(
                getPageInfo(), getParentForChildren(), isClean());
        pageInfo_ = null;
      }
      return pageInfoBuilder_;
    }

    private java.lang.Object attributionToken_ = "";
    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][]. This field enables accurate attribution of
     * recommendation model performance.
     * The value must be one of:
     * * [PredictResponse.attribution_token][] for events that are the result of
     * [PredictionService.Predict][].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1beta.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][].
     * * [CompleteQueryResponse.attribution_token][] for events that are the
     * result of [SearchService.CompleteQuery][].
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass [PredictResponse.attribution_token][] as a URL
     * parameter to product K's page. When recording events on product K's page,
     * log the [PredictResponse.attribution_token][] to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @return The attributionToken.
     */
    public java.lang.String getAttributionToken() {
      java.lang.Object ref = attributionToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attributionToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][]. This field enables accurate attribution of
     * recommendation model performance.
     * The value must be one of:
     * * [PredictResponse.attribution_token][] for events that are the result of
     * [PredictionService.Predict][].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1beta.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][].
     * * [CompleteQueryResponse.attribution_token][] for events that are the
     * result of [SearchService.CompleteQuery][].
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass [PredictResponse.attribution_token][] as a URL
     * parameter to product K's page. When recording events on product K's page,
     * log the [PredictResponse.attribution_token][] to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @return The bytes for attributionToken.
     */
    public com.google.protobuf.ByteString getAttributionTokenBytes() {
      java.lang.Object ref = attributionToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attributionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][]. This field enables accurate attribution of
     * recommendation model performance.
     * The value must be one of:
     * * [PredictResponse.attribution_token][] for events that are the result of
     * [PredictionService.Predict][].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1beta.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][].
     * * [CompleteQueryResponse.attribution_token][] for events that are the
     * result of [SearchService.CompleteQuery][].
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass [PredictResponse.attribution_token][] as a URL
     * parameter to product K's page. When recording events on product K's page,
     * log the [PredictResponse.attribution_token][] to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @param value The attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      attributionToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][]. This field enables accurate attribution of
     * recommendation model performance.
     * The value must be one of:
     * * [PredictResponse.attribution_token][] for events that are the result of
     * [PredictionService.Predict][].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1beta.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][].
     * * [CompleteQueryResponse.attribution_token][] for events that are the
     * result of [SearchService.CompleteQuery][].
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass [PredictResponse.attribution_token][] as a URL
     * parameter to product K's page. When recording events on product K's page,
     * log the [PredictResponse.attribution_token][] to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttributionToken() {

      attributionToken_ = getDefaultInstance().getAttributionToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token to attribute an API response to user action(s) to trigger the event.
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][]. This field enables accurate attribution of
     * recommendation model performance.
     * The value must be one of:
     * * [PredictResponse.attribution_token][] for events that are the result of
     * [PredictionService.Predict][].
     * * [SearchResponse.attribution_token][google.cloud.discoveryengine.v1beta.SearchResponse.attribution_token] for events that are the result of
     * [SearchService.Search][].
     * * [CompleteQueryResponse.attribution_token][] for events that are the
     * result of [SearchService.CompleteQuery][].
     * This token enables us to accurately attribute page view or conversion
     * completion back to the event and the particular predict response containing
     * this clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass [PredictResponse.attribution_token][] as a URL
     * parameter to product K's page. When recording events on product K's page,
     * log the [PredictResponse.attribution_token][] to this field.
     * </pre>
     *
     * <code>string attribution_token = 8;</code>
     *
     * @param value The bytes for attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      attributionToken_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     * One example is for `search` events, the associated
     * [SearchService.SearchRequest][] may contain a filter expression in
     * [SearchService.SearchRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * Similarly, for `view-item-list` events that are generated from a
     * [PredictionService.PredictRequest][], this field may be populated directly
     * from [PredictionService.PredictRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     * One example is for `search` events, the associated
     * [SearchService.SearchRequest][] may contain a filter expression in
     * [SearchService.SearchRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * Similarly, for `view-item-list` events that are generated from a
     * [PredictionService.PredictRequest][], this field may be populated directly
     * from [PredictionService.PredictRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     * One example is for `search` events, the associated
     * [SearchService.SearchRequest][] may contain a filter expression in
     * [SearchService.SearchRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * Similarly, for `view-item-list` events that are generated from a
     * [PredictionService.PredictRequest][], this field may be populated directly
     * from [PredictionService.PredictRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     * One example is for `search` events, the associated
     * [SearchService.SearchRequest][] may contain a filter expression in
     * [SearchService.SearchRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * Similarly, for `view-item-list` events that are generated from a
     * [PredictionService.PredictRequest][], this field may be populated directly
     * from [PredictionService.PredictRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {

      filter_ = getDefaultInstance().getFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the documents being filtered.
     * One example is for `search` events, the associated
     * [SearchService.SearchRequest][] may contain a filter expression in
     * [SearchService.SearchRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * Similarly, for `view-item-list` events that are generated from a
     * [PredictionService.PredictRequest][], this field may be populated directly
     * from [PredictionService.PredictRequest.filter][] conforming to
     * https://google.aip.dev/160#filtering.
     * The value must be a UTF-8 encoded string with a length limit of 1,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string filter = 9;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filter_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1beta.DocumentInfo> documents_ =
        java.util.Collections.emptyList();

    private void ensureDocumentsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        documents_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1beta.DocumentInfo>(
                documents_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.DocumentInfo,
            com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.DocumentInfoOrBuilder>
        documentsBuilder_;

    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.DocumentInfo> getDocumentsList() {
      if (documentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(documents_);
      } else {
        return documentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public int getDocumentsCount() {
      if (documentsBuilder_ == null) {
        return documents_.size();
      } else {
        return documentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentInfo getDocuments(int index) {
      if (documentsBuilder_ == null) {
        return documents_.get(index);
      } else {
        return documentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder setDocuments(
        int index, com.google.cloud.discoveryengine.v1beta.DocumentInfo value) {
      if (documentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsIsMutable();
        documents_.set(index, value);
        onChanged();
      } else {
        documentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder setDocuments(
        int index, com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder builderForValue) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        documents_.set(index, builderForValue.build());
        onChanged();
      } else {
        documentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder addDocuments(com.google.cloud.discoveryengine.v1beta.DocumentInfo value) {
      if (documentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsIsMutable();
        documents_.add(value);
        onChanged();
      } else {
        documentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder addDocuments(
        int index, com.google.cloud.discoveryengine.v1beta.DocumentInfo value) {
      if (documentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsIsMutable();
        documents_.add(index, value);
        onChanged();
      } else {
        documentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder addDocuments(
        com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder builderForValue) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        documents_.add(builderForValue.build());
        onChanged();
      } else {
        documentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder addDocuments(
        int index, com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder builderForValue) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        documents_.add(index, builderForValue.build());
        onChanged();
      } else {
        documentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder addAllDocuments(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.DocumentInfo> values) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documents_);
        onChanged();
      } else {
        documentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder clearDocuments() {
      if (documentsBuilder_ == null) {
        documents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        documentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public Builder removeDocuments(int index) {
      if (documentsBuilder_ == null) {
        ensureDocumentsIsMutable();
        documents_.remove(index);
        onChanged();
      } else {
        documentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder getDocumentsBuilder(
        int index) {
      return getDocumentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentInfoOrBuilder getDocumentsOrBuilder(
        int index) {
      if (documentsBuilder_ == null) {
        return documents_.get(index);
      } else {
        return documentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.DocumentInfoOrBuilder>
        getDocumentsOrBuilderList() {
      if (documentsBuilder_ != null) {
        return documentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(documents_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder addDocumentsBuilder() {
      return getDocumentsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1beta.DocumentInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder addDocumentsBuilder(
        int index) {
      return getDocumentsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1beta.DocumentInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of Documents associated with this user event.
     * This field is optional except for the following event types:
     * * `view-item`
     * * `add-to-cart`
     * * `purchase`
     * * `media-play`
     * * `media-complete`
     * In a `search` event, this field represents the documents returned to the
     * end user on the current page (the end user may have not finished browsing
     * the whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [UserEvent.documents][google.cloud.discoveryengine.v1beta.UserEvent.documents]
     * is desired.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1beta.DocumentInfo documents = 10;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder>
        getDocumentsBuilderList() {
      return getDocumentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.DocumentInfo,
            com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.DocumentInfoOrBuilder>
        getDocumentsFieldBuilder() {
      if (documentsBuilder_ == null) {
        documentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.DocumentInfo,
                com.google.cloud.discoveryengine.v1beta.DocumentInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.DocumentInfoOrBuilder>(
                documents_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        documents_ = null;
      }
      return documentsBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.PanelInfo panel_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.PanelInfo,
            com.google.cloud.discoveryengine.v1beta.PanelInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.PanelInfoOrBuilder>
        panelBuilder_;
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     *
     * @return Whether the panel field is set.
     */
    public boolean hasPanel() {
      return panelBuilder_ != null || panel_ != null;
    }
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     *
     * @return The panel.
     */
    public com.google.cloud.discoveryengine.v1beta.PanelInfo getPanel() {
      if (panelBuilder_ == null) {
        return panel_ == null
            ? com.google.cloud.discoveryengine.v1beta.PanelInfo.getDefaultInstance()
            : panel_;
      } else {
        return panelBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     */
    public Builder setPanel(com.google.cloud.discoveryengine.v1beta.PanelInfo value) {
      if (panelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        panel_ = value;
        onChanged();
      } else {
        panelBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     */
    public Builder setPanel(
        com.google.cloud.discoveryengine.v1beta.PanelInfo.Builder builderForValue) {
      if (panelBuilder_ == null) {
        panel_ = builderForValue.build();
        onChanged();
      } else {
        panelBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     */
    public Builder mergePanel(com.google.cloud.discoveryengine.v1beta.PanelInfo value) {
      if (panelBuilder_ == null) {
        if (panel_ != null) {
          panel_ =
              com.google.cloud.discoveryengine.v1beta.PanelInfo.newBuilder(panel_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          panel_ = value;
        }
        onChanged();
      } else {
        panelBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     */
    public Builder clearPanel() {
      if (panelBuilder_ == null) {
        panel_ = null;
        onChanged();
      } else {
        panel_ = null;
        panelBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.PanelInfo.Builder getPanelBuilder() {

      onChanged();
      return getPanelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.PanelInfoOrBuilder getPanelOrBuilder() {
      if (panelBuilder_ != null) {
        return panelBuilder_.getMessageOrBuilder();
      } else {
        return panel_ == null
            ? com.google.cloud.discoveryengine.v1beta.PanelInfo.getDefaultInstance()
            : panel_;
      }
    }
    /**
     *
     *
     * <pre>
     * Panel metadata associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.PanelInfo panel = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.PanelInfo,
            com.google.cloud.discoveryengine.v1beta.PanelInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.PanelInfoOrBuilder>
        getPanelFieldBuilder() {
      if (panelBuilder_ == null) {
        panelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.PanelInfo,
                com.google.cloud.discoveryengine.v1beta.PanelInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.PanelInfoOrBuilder>(
                getPanel(), getParentForChildren(), isClean());
        panel_ = null;
      }
      return panelBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.SearchInfo searchInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.SearchInfo,
            com.google.cloud.discoveryengine.v1beta.SearchInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.SearchInfoOrBuilder>
        searchInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     *
     * @return Whether the searchInfo field is set.
     */
    public boolean hasSearchInfo() {
      return searchInfoBuilder_ != null || searchInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     *
     * @return The searchInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.SearchInfo getSearchInfo() {
      if (searchInfoBuilder_ == null) {
        return searchInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchInfo.getDefaultInstance()
            : searchInfo_;
      } else {
        return searchInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     */
    public Builder setSearchInfo(com.google.cloud.discoveryengine.v1beta.SearchInfo value) {
      if (searchInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        searchInfo_ = value;
        onChanged();
      } else {
        searchInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     */
    public Builder setSearchInfo(
        com.google.cloud.discoveryengine.v1beta.SearchInfo.Builder builderForValue) {
      if (searchInfoBuilder_ == null) {
        searchInfo_ = builderForValue.build();
        onChanged();
      } else {
        searchInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     */
    public Builder mergeSearchInfo(com.google.cloud.discoveryengine.v1beta.SearchInfo value) {
      if (searchInfoBuilder_ == null) {
        if (searchInfo_ != null) {
          searchInfo_ =
              com.google.cloud.discoveryengine.v1beta.SearchInfo.newBuilder(searchInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          searchInfo_ = value;
        }
        onChanged();
      } else {
        searchInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     */
    public Builder clearSearchInfo() {
      if (searchInfoBuilder_ == null) {
        searchInfo_ = null;
        onChanged();
      } else {
        searchInfo_ = null;
        searchInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.SearchInfo.Builder getSearchInfoBuilder() {

      onChanged();
      return getSearchInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.SearchInfoOrBuilder getSearchInfoOrBuilder() {
      if (searchInfoBuilder_ != null) {
        return searchInfoBuilder_.getMessageOrBuilder();
      } else {
        return searchInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.SearchInfo.getDefaultInstance()
            : searchInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Search API details related to the event.
     * This field should be set for `search` event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.SearchInfo search_info = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.SearchInfo,
            com.google.cloud.discoveryengine.v1beta.SearchInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.SearchInfoOrBuilder>
        getSearchInfoFieldBuilder() {
      if (searchInfoBuilder_ == null) {
        searchInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.SearchInfo,
                com.google.cloud.discoveryengine.v1beta.SearchInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.SearchInfoOrBuilder>(
                getSearchInfo(), getParentForChildren(), isClean());
        searchInfo_ = null;
      }
      return searchInfoBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.CompletionInfo completionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.CompletionInfo,
            com.google.cloud.discoveryengine.v1beta.CompletionInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.CompletionInfoOrBuilder>
        completionInfoBuilder_;
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     *
     * @return Whether the completionInfo field is set.
     */
    public boolean hasCompletionInfo() {
      return completionInfoBuilder_ != null || completionInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     *
     * @return The completionInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.CompletionInfo getCompletionInfo() {
      if (completionInfoBuilder_ == null) {
        return completionInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.CompletionInfo.getDefaultInstance()
            : completionInfo_;
      } else {
        return completionInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     */
    public Builder setCompletionInfo(com.google.cloud.discoveryengine.v1beta.CompletionInfo value) {
      if (completionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        completionInfo_ = value;
        onChanged();
      } else {
        completionInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     */
    public Builder setCompletionInfo(
        com.google.cloud.discoveryengine.v1beta.CompletionInfo.Builder builderForValue) {
      if (completionInfoBuilder_ == null) {
        completionInfo_ = builderForValue.build();
        onChanged();
      } else {
        completionInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     */
    public Builder mergeCompletionInfo(
        com.google.cloud.discoveryengine.v1beta.CompletionInfo value) {
      if (completionInfoBuilder_ == null) {
        if (completionInfo_ != null) {
          completionInfo_ =
              com.google.cloud.discoveryengine.v1beta.CompletionInfo.newBuilder(completionInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          completionInfo_ = value;
        }
        onChanged();
      } else {
        completionInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     */
    public Builder clearCompletionInfo() {
      if (completionInfoBuilder_ == null) {
        completionInfo_ = null;
        onChanged();
      } else {
        completionInfo_ = null;
        completionInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.CompletionInfo.Builder
        getCompletionInfoBuilder() {

      onChanged();
      return getCompletionInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.CompletionInfoOrBuilder
        getCompletionInfoOrBuilder() {
      if (completionInfoBuilder_ != null) {
        return completionInfoBuilder_.getMessageOrBuilder();
      } else {
        return completionInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.CompletionInfo.getDefaultInstance()
            : completionInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * CompleteQuery API details related to the event.
     * This field should be set for `search` event when autocomplete function is
     * enabled and the user clicks a suggestion for search.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.CompletionInfo completion_info = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.CompletionInfo,
            com.google.cloud.discoveryengine.v1beta.CompletionInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.CompletionInfoOrBuilder>
        getCompletionInfoFieldBuilder() {
      if (completionInfoBuilder_ == null) {
        completionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.CompletionInfo,
                com.google.cloud.discoveryengine.v1beta.CompletionInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.CompletionInfoOrBuilder>(
                getCompletionInfo(), getParentForChildren(), isClean());
        completionInfo_ = null;
      }
      return completionInfoBuilder_;
    }

    private com.google.cloud.discoveryengine.v1beta.TransactionInfo transactionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.TransactionInfo,
            com.google.cloud.discoveryengine.v1beta.TransactionInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.TransactionInfoOrBuilder>
        transactionInfoBuilder_;
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     *
     * @return Whether the transactionInfo field is set.
     */
    public boolean hasTransactionInfo() {
      return transactionInfoBuilder_ != null || transactionInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     *
     * @return The transactionInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.TransactionInfo getTransactionInfo() {
      if (transactionInfoBuilder_ == null) {
        return transactionInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.TransactionInfo.getDefaultInstance()
            : transactionInfo_;
      } else {
        return transactionInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     */
    public Builder setTransactionInfo(
        com.google.cloud.discoveryengine.v1beta.TransactionInfo value) {
      if (transactionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transactionInfo_ = value;
        onChanged();
      } else {
        transactionInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     */
    public Builder setTransactionInfo(
        com.google.cloud.discoveryengine.v1beta.TransactionInfo.Builder builderForValue) {
      if (transactionInfoBuilder_ == null) {
        transactionInfo_ = builderForValue.build();
        onChanged();
      } else {
        transactionInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     */
    public Builder mergeTransactionInfo(
        com.google.cloud.discoveryengine.v1beta.TransactionInfo value) {
      if (transactionInfoBuilder_ == null) {
        if (transactionInfo_ != null) {
          transactionInfo_ =
              com.google.cloud.discoveryengine.v1beta.TransactionInfo.newBuilder(transactionInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transactionInfo_ = value;
        }
        onChanged();
      } else {
        transactionInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     */
    public Builder clearTransactionInfo() {
      if (transactionInfoBuilder_ == null) {
        transactionInfo_ = null;
        onChanged();
      } else {
        transactionInfo_ = null;
        transactionInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.TransactionInfo.Builder
        getTransactionInfoBuilder() {

      onChanged();
      return getTransactionInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.TransactionInfoOrBuilder
        getTransactionInfoOrBuilder() {
      if (transactionInfoBuilder_ != null) {
        return transactionInfoBuilder_.getMessageOrBuilder();
      } else {
        return transactionInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.TransactionInfo.getDefaultInstance()
            : transactionInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction metadata (if any) associated with this user event.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.TransactionInfo transaction_info = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.TransactionInfo,
            com.google.cloud.discoveryengine.v1beta.TransactionInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.TransactionInfoOrBuilder>
        getTransactionInfoFieldBuilder() {
      if (transactionInfoBuilder_ == null) {
        transactionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.TransactionInfo,
                com.google.cloud.discoveryengine.v1beta.TransactionInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.TransactionInfoOrBuilder>(
                getTransactionInfo(), getParentForChildren(), isClean());
        transactionInfo_ = null;
      }
      return transactionInfoBuilder_;
    }

    private com.google.protobuf.LazyStringList tagIds_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureTagIdsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        tagIds_ = new com.google.protobuf.LazyStringArrayList(tagIds_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @return A list containing the tagIds.
     */
    public com.google.protobuf.ProtocolStringList getTagIdsList() {
      return tagIds_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @return The count of tagIds.
     */
    public int getTagIdsCount() {
      return tagIds_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The tagIds at the given index.
     */
    public java.lang.String getTagIds(int index) {
      return tagIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tagIds at the given index.
     */
    public com.google.protobuf.ByteString getTagIdsBytes(int index) {
      return tagIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The tagIds to set.
     * @return This builder for chaining.
     */
    public Builder setTagIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagIdsIsMutable();
      tagIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param value The tagIds to add.
     * @return This builder for chaining.
     */
    public Builder addTagIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagIdsIsMutable();
      tagIds_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param values The tagIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllTagIds(java.lang.Iterable<java.lang.String> values) {
      ensureTagIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tagIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagIds() {
      tagIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups on the customer end.
     * </pre>
     *
     * <code>repeated string tag_ids = 15;</code>
     *
     * @param value The bytes of the tagIds to add.
     * @return This builder for chaining.
     */
    public Builder addTagIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagIdsIsMutable();
      tagIds_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList promotionIds_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensurePromotionIdsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        promotionIds_ = new com.google.protobuf.LazyStringArrayList(promotionIds_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @return A list containing the promotionIds.
     */
    public com.google.protobuf.ProtocolStringList getPromotionIdsList() {
      return promotionIds_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @return The count of promotionIds.
     */
    public int getPromotionIdsCount() {
      return promotionIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param index The index of the element to return.
     * @return The promotionIds at the given index.
     */
    public java.lang.String getPromotionIds(int index) {
      return promotionIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the promotionIds at the given index.
     */
    public com.google.protobuf.ByteString getPromotionIdsBytes(int index) {
      return promotionIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param index The index to set the value at.
     * @param value The promotionIds to set.
     * @return This builder for chaining.
     */
    public Builder setPromotionIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePromotionIdsIsMutable();
      promotionIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param value The promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addPromotionIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePromotionIdsIsMutable();
      promotionIds_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param values The promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllPromotionIds(java.lang.Iterable<java.lang.String> values) {
      ensurePromotionIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, promotionIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPromotionIds() {
      promotionIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The promotion IDs if this is an event associated with promotions.
     * Currently, this field is restricted to at most one ID.
     * </pre>
     *
     * <code>repeated string promotion_ids = 16;</code>
     *
     * @param value The bytes of the promotionIds to add.
     * @return This builder for chaining.
     */
    public Builder addPromotionIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePromotionIdsIsMutable();
      promotionIds_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
        attributes_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
        internalGetAttributes() {
      if (attributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AttributesDefaultEntryHolder.defaultEntry);
      }
      return attributes_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
        internalGetMutableAttributes() {
      onChanged();
      ;
      if (attributes_ == null) {
        attributes_ =
            com.google.protobuf.MapField.newMapField(AttributesDefaultEntryHolder.defaultEntry);
      }
      if (!attributes_.isMutable()) {
        attributes_ = attributes_.copy();
      }
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the DiscoveryEngine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
        getAttributes() {
      return getAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the DiscoveryEngine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
        getAttributesMap() {
      return internalGetAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the DiscoveryEngine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CustomAttribute getAttributesOrDefault(
        java.lang.String key,
        com.google.cloud.discoveryengine.v1beta.CustomAttribute defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute> map =
          internalGetAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the DiscoveryEngine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.CustomAttribute getAttributesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute> map =
          internalGetAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAttributes() {
      internalGetMutableAttributes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the DiscoveryEngine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    public Builder removeAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttributes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
        getMutableAttributes() {
      return internalGetMutableAttributes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the DiscoveryEngine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    public Builder putAttributes(
        java.lang.String key, com.google.cloud.discoveryengine.v1beta.CustomAttribute value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableAttributes().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Extra user event features to include in the recommendation model.
     * These attributes must NOT contain data that needs to be parsed or processed
     * further, e.g. JSON or other encodings.
     * If you provide custom attributes for ingested user events, also include
     * them in the user events that you associate with prediction requests. Custom
     * attribute formatting must be consistent between imported events and events
     * provided with prediction requests. This lets the DiscoveryEngine API use
     * those custom attributes when training models and serving predictions, which
     * helps improve recommendation quality.
     * This field needs to pass all below criteria, otherwise an INVALID_ARGUMENT
     * error is returned:
     * * The key must be a UTF-8 encoded string with a length limit of 5,000
     *   characters.
     * * For text attributes, at most 400 values are allowed. Empty values are not
     *   allowed. Each value must be a UTF-8 encoded string with a length limit of
     *   256 characters.
     * * For number attributes, at most 400 values are allowed.
     * For product recommendations, an example of extra user information is
     * traffic_channel, which is how a user arrives at the site. Users can arrive
     * at the site by coming to the site directly, coming through Google
     * search, or in other ways.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1beta.CustomAttribute&gt; attributes = 17;
     * </code>
     */
    public Builder putAllAttributes(
        java.util.Map<java.lang.String, com.google.cloud.discoveryengine.v1beta.CustomAttribute>
            values) {
      internalGetMutableAttributes().getMutableMap().putAll(values);
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.MediaInfo mediaInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.MediaInfo,
            com.google.cloud.discoveryengine.v1beta.MediaInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.MediaInfoOrBuilder>
        mediaInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     *
     * @return Whether the mediaInfo field is set.
     */
    public boolean hasMediaInfo() {
      return mediaInfoBuilder_ != null || mediaInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     *
     * @return The mediaInfo.
     */
    public com.google.cloud.discoveryengine.v1beta.MediaInfo getMediaInfo() {
      if (mediaInfoBuilder_ == null) {
        return mediaInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.MediaInfo.getDefaultInstance()
            : mediaInfo_;
      } else {
        return mediaInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     */
    public Builder setMediaInfo(com.google.cloud.discoveryengine.v1beta.MediaInfo value) {
      if (mediaInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mediaInfo_ = value;
        onChanged();
      } else {
        mediaInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     */
    public Builder setMediaInfo(
        com.google.cloud.discoveryengine.v1beta.MediaInfo.Builder builderForValue) {
      if (mediaInfoBuilder_ == null) {
        mediaInfo_ = builderForValue.build();
        onChanged();
      } else {
        mediaInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     */
    public Builder mergeMediaInfo(com.google.cloud.discoveryengine.v1beta.MediaInfo value) {
      if (mediaInfoBuilder_ == null) {
        if (mediaInfo_ != null) {
          mediaInfo_ =
              com.google.cloud.discoveryengine.v1beta.MediaInfo.newBuilder(mediaInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mediaInfo_ = value;
        }
        onChanged();
      } else {
        mediaInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     */
    public Builder clearMediaInfo() {
      if (mediaInfoBuilder_ == null) {
        mediaInfo_ = null;
        onChanged();
      } else {
        mediaInfo_ = null;
        mediaInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.MediaInfo.Builder getMediaInfoBuilder() {

      onChanged();
      return getMediaInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     */
    public com.google.cloud.discoveryengine.v1beta.MediaInfoOrBuilder getMediaInfoOrBuilder() {
      if (mediaInfoBuilder_ != null) {
        return mediaInfoBuilder_.getMessageOrBuilder();
      } else {
        return mediaInfo_ == null
            ? com.google.cloud.discoveryengine.v1beta.MediaInfo.getDefaultInstance()
            : mediaInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Media-specific info.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.MediaInfo media_info = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.MediaInfo,
            com.google.cloud.discoveryengine.v1beta.MediaInfo.Builder,
            com.google.cloud.discoveryengine.v1beta.MediaInfoOrBuilder>
        getMediaInfoFieldBuilder() {
      if (mediaInfoBuilder_ == null) {
        mediaInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.MediaInfo,
                com.google.cloud.discoveryengine.v1beta.MediaInfo.Builder,
                com.google.cloud.discoveryengine.v1beta.MediaInfoOrBuilder>(
                getMediaInfo(), getParentForChildren(), isClean());
        mediaInfo_ = null;
      }
      return mediaInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.UserEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.UserEvent)
  private static final com.google.cloud.discoveryengine.v1beta.UserEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.UserEvent();
  }

  public static com.google.cloud.discoveryengine.v1beta.UserEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserEvent> PARSER =
      new com.google.protobuf.AbstractParser<UserEvent>() {
        @java.lang.Override
        public UserEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UserEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.UserEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
